/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class BranchIff
implements WASMExpression {
    private final LabeledContainer outerBlock;
    private final WASMValue condition;
    private final Expression expression;

    BranchIff(LabeledContainer surroundingBlock, WASMValue condition, Expression expression) {
        this.outerBlock = surroundingBlock;
        this.condition = condition;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("br_if");
        textWriter.space();
        textWriter.writeLabel(this.outerBlock.getLabel());
        textWriter.newLine();
        this.condition.writeTo(textWriter, context);
        textWriter.closing();
        textWriter.newLine();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        this.condition.writeTo(codeWriter, context);
        int relativeDepth = context.owningContainer().relativeDepthTo(this.outerBlock);
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)13);
        codeWriter.writeUnsignedLeb128(relativeDepth);
    }
}

