/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class Branch
implements WASMExpression {
    private final LabeledContainer outerBlock;
    private final Expression expression;

    Branch(LabeledContainer surroundingBlock, Expression expression) {
        this.outerBlock = surroundingBlock;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) {
        textWriter.opening();
        textWriter.write("br");
        textWriter.space();
        textWriter.writeLabel(this.outerBlock.getLabel());
        textWriter.closing();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        int relativeDepth = context.owningContainer().relativeDepthTo(this.outerBlock);
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)12);
        codeWriter.writeUnsignedLeb128(relativeDepth);
    }
}

