/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.SourceMapWriter;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.DebugInformation;
import de.mirkosertic.bytecoder.ssa.DebugPosition;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.Program;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class BinaryWriter
implements AutoCloseable {
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();
    private final SourceMapWriter sourceMapWriter;
    private final List<Writer.DebugInfo> debugInfos;

    private static int writeUnsignedLeb128(int value, OutputStream os) throws IOException {
        int count = 0;
        for (int remaining = value >>> 7; 0 != remaining; remaining >>>= 7) {
            os.write((byte)(value & 0x7F | 0x80));
            ++count;
            value = remaining;
        }
        os.write((byte)(value & 0x7F));
        return ++count;
    }

    private static int writeSignedLeb128(int value, OutputStream os) throws IOException {
        int remaining = value >> 7;
        boolean hasMore = true;
        int end = 0 == (value & Integer.MIN_VALUE) ? 0 : -1;
        int count = 0;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            os.write((byte)(value & 0x7F | (hasMore ? 128 : 0)));
            ++count;
            value = remaining;
            remaining >>= 7;
        }
        return count;
    }

    public BinaryWriter(SourceMapWriter sourceMapWriter) {
        this.sourceMapWriter = sourceMapWriter;
        this.debugInfos = new ArrayList<Writer.DebugInfo>();
    }

    public byte[] toByteArray() throws IOException {
        this.os.flush();
        return this.os.toByteArray();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public void header() throws IOException {
        this.os.write(new byte[]{0, 97, 115, 109, 1, 0, 0, 0});
    }

    public SectionWriter typeSection() {
        return new SectionWriter(1, this.os, this.os.size());
    }

    public SectionWriter importsSection() {
        return new SectionWriter(2, this.os, this.os.size());
    }

    public SectionWriter functionSection() {
        return new SectionWriter(3, this.os, this.os.size());
    }

    public SectionWriter tablesSection() {
        return new SectionWriter(4, this.os, this.os.size());
    }

    public SectionWriter memorySection() {
        return new SectionWriter(5, this.os, this.os.size());
    }

    public SectionWriter globalsSection() {
        return new SectionWriter(6, this.os, this.os.size());
    }

    public SectionWriter exportsSection() {
        return new SectionWriter(7, this.os, this.os.size());
    }

    public SectionWriter elementsSection() {
        return new SectionWriter(9, this.os, this.os.size());
    }

    public SectionWriter codeSection() {
        return new SectionWriter(10, this.os, this.os.size());
    }

    public SectionWriter eventSection() {
        return new SectionWriter(13, this.os, this.os.size());
    }

    public SectionWriter customSection() {
        return new SectionWriter(0, this.os, this.os.size());
    }

    public class SectionWriter
    extends Writer {
        private final byte sectionCode;

        public SectionWriter(byte sectionCode, OutputStream flushTarget, int offset) {
            super(flushTarget, offset);
            this.sectionCode = sectionCode;
        }

        public SectionWriter subSection(byte subSectionCode) {
            return new SectionWriter(subSectionCode, this.bos, this.offset + this.bos.size());
        }

        @Override
        public void close() throws IOException {
            this.bos.flush();
            byte[] data = this.bos.toByteArray();
            int theDelta = this.offset;
            this.flushTarget.write(this.sectionCode);
            ++theDelta;
            theDelta += BinaryWriter.writeUnsignedLeb128(data.length, this.flushTarget);
            this.flushTarget.write(data);
            for (Writer.DebugInfo theInfo : BinaryWriter.this.debugInfos) {
                DebugPosition thePos;
                BytecodeOpcodeAddress theAddress;
                DebugInformation theDebugInformation;
                Program theProgram = theInfo.expression.getProgram();
                if (theProgram == null || (theDebugInformation = theProgram.getDebugInformation()) == null || (theAddress = theInfo.expression.getAddress()) == null || (thePos = theDebugInformation.debugPositionFor(theAddress)) == null) continue;
                int theRealPositionInFile = theDelta + theInfo.binaryPosition;
                BinaryWriter.this.sourceMapWriter.assignDebugPosition(0, theRealPositionInFile, thePos);
            }
        }
    }

    public class BlockWriter
    extends Writer {
        public BlockWriter(OutputStream flushTarget, int offset) {
            super(flushTarget, offset);
        }

        @Override
        public void close() throws IOException {
            this.bos.flush();
            byte[] data = this.bos.toByteArray();
            BinaryWriter.writeUnsignedLeb128(data.length, this.flushTarget);
            this.flushTarget.write(data);
        }
    }

    public abstract class Writer
    implements AutoCloseable {
        protected final OutputStream flushTarget;
        protected final ByteArrayOutputStream bos;
        protected final int offset;

        protected Writer(OutputStream flushTarget, int offset) {
            this.flushTarget = flushTarget;
            this.bos = new ByteArrayOutputStream();
            this.offset = offset;
        }

        public BlockWriter blockWriter() {
            return new BlockWriter(this.bos, this.offset + this.bos.size());
        }

        public void writeByte(byte value) {
            this.bos.write(value);
        }

        public void writeUnsignedLeb128(int value) throws IOException {
            BinaryWriter.writeUnsignedLeb128(value, this.bos);
        }

        public void writeSignedLeb128(int value) throws IOException {
            BinaryWriter.writeSignedLeb128(value, this.bos);
        }

        public void writeUTF8(String value) throws IOException {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            this.writeUnsignedLeb128(bytes.length);
            this.bos.write(bytes);
        }

        public void writeFloat32(float value) {
            this.writeInteger32(Float.floatToRawIntBits(value));
        }

        public void writeInteger32(int value) {
            this.writeByte((byte)value);
            this.writeByte((byte)(value >> 8));
            this.writeByte((byte)(value >> 16));
            this.writeByte((byte)(value >> 24));
        }

        public void registerDebugInformationFor(Expression aExpression) {
            if (aExpression != null) {
                BinaryWriter.this.debugInfos.add(new DebugInfo(this.offset + this.bos.size(), aExpression));
            }
        }

        protected class DebugInfo {
            protected final int binaryPosition;
            protected final Expression expression;

            DebugInfo(int binaryPosition, Expression expression) {
                this.binaryPosition = binaryPosition;
                this.expression = expression;
            }
        }
    }
}

