/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public abstract class BinaryExpression
implements WASMExpression {
    private final WASMValue leftValue;
    private final WASMValue rightValue;
    private final String textCode;
    private final byte binaryCode;
    private final Expression expression;

    protected BinaryExpression(WASMValue leftValue, WASMValue rightValue, String textCode, byte binaryCode, Expression expression) {
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.textCode = textCode;
        this.binaryCode = binaryCode;
        this.expression = expression;
    }

    @Override
    public final void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write(this.textCode);
        textWriter.space();
        this.leftValue.writeTo(textWriter, context);
        textWriter.space();
        this.rightValue.writeTo(textWriter, context);
        textWriter.closing();
    }

    @Override
    public final void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        this.leftValue.writeTo(codeWriter, context);
        this.rightValue.writeTo(codeWriter, context);
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte(this.binaryCode);
    }
}

