/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.ssa.TypeRef;

public class WASMWriterUtils {
    private static String typeRefToString(BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            BytecodePrimitiveTypeRef thePrimitive = (BytecodePrimitiveTypeRef)aTypeRef;
            return thePrimitive.name();
        }
        if (aTypeRef.isArray()) {
            BytecodeArrayTypeRef theRef = (BytecodeArrayTypeRef)aTypeRef;
            return "A" + theRef.getDepth() + WASMWriterUtils.typeRefToString(theRef.getType());
        }
        BytecodeObjectTypeRef theObjectRef = (BytecodeObjectTypeRef)aTypeRef;
        return WASMWriterUtils.toClassName(theObjectRef);
    }

    public static String toMethodName(String aMethodName, BytecodeMethodSignature aSignature) {
        String theName = WASMWriterUtils.typeRefToString(aSignature.getReturnType());
        theName = theName + aMethodName.replace("<", "$").replace(">", "$");
        for (BytecodeTypeRef theTypeRef : aSignature.getArguments()) {
            theName = theName + WASMWriterUtils.typeRefToString(theTypeRef);
        }
        return theName;
    }

    public static String toMethodName(BytecodeObjectTypeRef aClassName, String aMethodName, BytecodeMethodSignature aSignature) {
        return WASMWriterUtils.toClassName(aClassName) + "_" + WASMWriterUtils.toMethodName(aMethodName, aSignature);
    }

    public static String toMethodName(BytecodeObjectTypeRef aClassName, BytecodeUtf8Constant aConstant, BytecodeMethodSignature aSignature) {
        return WASMWriterUtils.toClassName(aClassName) + "_" + WASMWriterUtils.toMethodName(aConstant.stringValue(), aSignature);
    }

    private static String toClassNameInternal(String aClassName) {
        int p = aClassName.lastIndexOf(".");
        String theSimpleName = aClassName.substring(p + 1);
        String thePackageName = aClassName.substring(0, p);
        StringBuilder theResult = new StringBuilder();
        while (thePackageName.length() > 0) {
            theResult.append(Character.toLowerCase(thePackageName.charAt(0)));
            int j = thePackageName.indexOf(".");
            if (j >= 0) {
                thePackageName = thePackageName.substring(j + 1);
                continue;
            }
            thePackageName = "";
        }
        return theResult.append(theSimpleName).toString();
    }

    public static String toClassName(BytecodeObjectTypeRef aTypeRef) {
        if (aTypeRef.name().endsWith(";")) {
            return WASMWriterUtils.toClassName(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
        }
        return WASMWriterUtils.toClassNameInternal(aTypeRef.name());
    }

    public static String toType(TypeRef aType) {
        switch (aType.resolve()) {
            case DOUBLE: {
                return "f32";
            }
            case FLOAT: {
                return "f32";
            }
        }
        return "i32";
    }
}

