/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm;

import de.mirkosertic.bytecoder.allocator.AbstractAllocator;
import de.mirkosertic.bytecoder.allocator.Register;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.NativeMemoryLayouter;
import de.mirkosertic.bytecoder.backend.wasm.WASMWriterUtils;
import de.mirkosertic.bytecoder.backend.wasm.ast.Block;
import de.mirkosertic.bytecoder.backend.wasm.ast.Call;
import de.mirkosertic.bytecoder.backend.wasm.ast.CallIndirect;
import de.mirkosertic.bytecoder.backend.wasm.ast.ConstExpressions;
import de.mirkosertic.bytecoder.backend.wasm.ast.Container;
import de.mirkosertic.bytecoder.backend.wasm.ast.ExportableFunction;
import de.mirkosertic.bytecoder.backend.wasm.ast.Expressions;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.Global;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Add;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Const;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Load;
import de.mirkosertic.bytecoder.backend.wasm.ast.Iff;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.Loop;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.Return;
import de.mirkosertic.bytecoder.backend.wasm.ast.ReturnValue;
import de.mirkosertic.bytecoder.backend.wasm.ast.Try;
import de.mirkosertic.bytecoder.backend.wasm.ast.Unreachable;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.backend.wasm.ast.WeakFunctionReferenceCallable;
import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.classlib.MemoryManager;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import de.mirkosertic.bytecoder.core.BytecodeResolvedMethods;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.core.BytecodeVirtualMethodIdentifier;
import de.mirkosertic.bytecoder.relooper.Relooper;
import de.mirkosertic.bytecoder.ssa.ArrayEntryExpression;
import de.mirkosertic.bytecoder.ssa.ArrayLengthExpression;
import de.mirkosertic.bytecoder.ssa.ArrayStoreExpression;
import de.mirkosertic.bytecoder.ssa.BinaryExpression;
import de.mirkosertic.bytecoder.ssa.BreakExpression;
import de.mirkosertic.bytecoder.ssa.ByteValue;
import de.mirkosertic.bytecoder.ssa.CheckCastExpression;
import de.mirkosertic.bytecoder.ssa.ClassReferenceValue;
import de.mirkosertic.bytecoder.ssa.CompareExpression;
import de.mirkosertic.bytecoder.ssa.ComputedMemoryLocationReadExpression;
import de.mirkosertic.bytecoder.ssa.ComputedMemoryLocationWriteExpression;
import de.mirkosertic.bytecoder.ssa.ContinueExpression;
import de.mirkosertic.bytecoder.ssa.CurrentExceptionExpression;
import de.mirkosertic.bytecoder.ssa.DataEndExpression;
import de.mirkosertic.bytecoder.ssa.DirectInvokeMethodExpression;
import de.mirkosertic.bytecoder.ssa.DoubleValue;
import de.mirkosertic.bytecoder.ssa.EnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.FixedBinaryExpression;
import de.mirkosertic.bytecoder.ssa.FloatValue;
import de.mirkosertic.bytecoder.ssa.FloatingPointCeilExpression;
import de.mirkosertic.bytecoder.ssa.FloatingPointFloorExpression;
import de.mirkosertic.bytecoder.ssa.FloorExpression;
import de.mirkosertic.bytecoder.ssa.GetFieldExpression;
import de.mirkosertic.bytecoder.ssa.GetStaticExpression;
import de.mirkosertic.bytecoder.ssa.GotoExpression;
import de.mirkosertic.bytecoder.ssa.HeapBaseExpression;
import de.mirkosertic.bytecoder.ssa.IFElseExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.InstanceOfExpression;
import de.mirkosertic.bytecoder.ssa.IntegerValue;
import de.mirkosertic.bytecoder.ssa.InvokeStaticMethodExpression;
import de.mirkosertic.bytecoder.ssa.InvokeVirtualMethodExpression;
import de.mirkosertic.bytecoder.ssa.IsNaNExpression;
import de.mirkosertic.bytecoder.ssa.LambdaConstructorReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaInterfaceReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaSpecialReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaVirtualReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaWithStaticImplExpression;
import de.mirkosertic.bytecoder.ssa.LongValue;
import de.mirkosertic.bytecoder.ssa.LookupSwitchExpression;
import de.mirkosertic.bytecoder.ssa.MaxExpression;
import de.mirkosertic.bytecoder.ssa.MemorySizeExpression;
import de.mirkosertic.bytecoder.ssa.MethodHandleExpression;
import de.mirkosertic.bytecoder.ssa.MethodHandlesGeneratedLookupExpression;
import de.mirkosertic.bytecoder.ssa.MethodTypeArgumentCheckExpression;
import de.mirkosertic.bytecoder.ssa.MethodTypeExpression;
import de.mirkosertic.bytecoder.ssa.MinExpression;
import de.mirkosertic.bytecoder.ssa.NegatedExpression;
import de.mirkosertic.bytecoder.ssa.NewArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewInstanceFromDefaultConstructorExpression;
import de.mirkosertic.bytecoder.ssa.NewMultiArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectAndConstructExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectExpression;
import de.mirkosertic.bytecoder.ssa.NullValue;
import de.mirkosertic.bytecoder.ssa.PHIValue;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.PtrOfExpression;
import de.mirkosertic.bytecoder.ssa.PutFieldExpression;
import de.mirkosertic.bytecoder.ssa.PutStaticExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.ResolveCallsiteObjectExpression;
import de.mirkosertic.bytecoder.ssa.ReturnExpression;
import de.mirkosertic.bytecoder.ssa.ReturnValueExpression;
import de.mirkosertic.bytecoder.ssa.SetEnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.SetMemoryLocationExpression;
import de.mirkosertic.bytecoder.ssa.ShortValue;
import de.mirkosertic.bytecoder.ssa.SqrtExpression;
import de.mirkosertic.bytecoder.ssa.StackTopExpression;
import de.mirkosertic.bytecoder.ssa.StringValue;
import de.mirkosertic.bytecoder.ssa.SuperTypeOfExpression;
import de.mirkosertic.bytecoder.ssa.SystemHasStackExpression;
import de.mirkosertic.bytecoder.ssa.TableSwitchExpression;
import de.mirkosertic.bytecoder.ssa.ThrowExpression;
import de.mirkosertic.bytecoder.ssa.TypeConversionExpression;
import de.mirkosertic.bytecoder.ssa.TypeOfExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.UnreachableExpression;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import de.mirkosertic.bytecoder.stackifier.Stackifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class WASMSSAASTWriter {
    private static final String LABEL_LOCAL = "__label__";
    private static final String SP = "SP";
    private static final String OLDSP = "OLDSP";
    public static final String STACKTOP = "STACKTOP";
    public static final int GENERATED_INSTANCEOF_METHOD_ID = -1;
    public static final String VTABLEFUNCTIONSUFFIX = "__resolvevtableindex";
    public static final String RUNTIMECLASSSUFFIX = "__runtimeclass";
    public static final String INSTANCEOFSUFFIX = "__instanceof";
    public static final String EXCEPTION_NAME = "EX";
    public static final String CLASSINITSUFFIX = "__init";
    public static final String NEWINSTANCEHELPER = "NEWINSTANCEHELPER";
    private final Resolver resolver;
    private final BytecodeLinkerContext linkerContext;
    private final ExportableFunction function;
    final Container container;
    final Expressions flow;
    private final Module module;
    private final CompileOptions compileOptions;
    private final List<Register> stackRegister;
    private final NativeMemoryLayouter memoryLayouter;
    private boolean labelRequired;
    final AtomicBoolean stackifierEnabled;
    private final AbstractAllocator allocator;

    public static String registerName(Register r) {
        return "r" + r.getNumber();
    }

    public static PrimitiveType toType(TypeRef aType) {
        switch (aType.resolve()) {
            case DOUBLE: {
                return PrimitiveType.f32;
            }
            case FLOAT: {
                return PrimitiveType.f32;
            }
        }
        return PrimitiveType.i32;
    }

    public WASMSSAASTWriter(Resolver aResolver, BytecodeLinkerContext aLinkerContext, Module aModule, CompileOptions aOptions, Program aProgram, NativeMemoryLayouter aMemoryLayouter, ExportableFunction aFunction, AbstractAllocator aAllocator) {
        this.resolver = aResolver;
        this.linkerContext = aLinkerContext;
        this.function = aFunction;
        this.module = aModule;
        this.compileOptions = aOptions;
        this.stackRegister = new ArrayList<Register>();
        this.memoryLayouter = aMemoryLayouter;
        this.flow = this.function.flow;
        this.container = this.function;
        this.allocator = aAllocator;
        for (Register r : this.allocator.assignedRegister()) {
            if (r.getType().resolve() != TypeRef.Native.REFERENCE) continue;
            this.stackRegister.add(r);
        }
        this.labelRequired = false;
        this.stackifierEnabled = new AtomicBoolean(false);
    }

    private WASMSSAASTWriter(Resolver aResolver, BytecodeLinkerContext aLinkerContext, Module aModule, CompileOptions aOptions, NativeMemoryLayouter aMemoryLayouter, ExportableFunction aFunction, LabeledContainer aContainer, List<Register> aStackRegister, boolean aLabelRequired, Expressions aFlow, AtomicBoolean aStackifierEnabled, AbstractAllocator aAllocator) {
        this.resolver = aResolver;
        this.linkerContext = aLinkerContext;
        this.function = aFunction;
        this.module = aModule;
        this.compileOptions = aOptions;
        this.stackRegister = aStackRegister;
        this.memoryLayouter = aMemoryLayouter;
        this.container = aContainer;
        this.flow = aFlow;
        this.labelRequired = aLabelRequired;
        this.stackifierEnabled = aStackifierEnabled;
        this.allocator = aAllocator;
    }

    private WASMSSAASTWriter block(String label, Expression expression) {
        Block block = this.flow.block(label, expression);
        return new WASMSSAASTWriter(this.resolver, this.linkerContext, this.module, this.compileOptions, this.memoryLayouter, this.function, block, this.stackRegister, this.labelRequired, block.flow, this.stackifierEnabled, this.allocator);
    }

    private WASMSSAASTWriter block(String label, PrimitiveType blockType, Expression expression) {
        Block block = this.flow.block(label, blockType, expression);
        return new WASMSSAASTWriter(this.resolver, this.linkerContext, this.module, this.compileOptions, this.memoryLayouter, this.function, block, this.stackRegister, this.labelRequired, block.flow, this.stackifierEnabled, this.allocator);
    }

    private IFCondition iff(String label, WASMValue condition, Expression expression) {
        Iff block = this.flow.iff(label, condition, expression);
        WASMSSAASTWriter theTrueWriter = new WASMSSAASTWriter(this.resolver, this.linkerContext, this.module, this.compileOptions, this.memoryLayouter, this.function, block, this.stackRegister, this.labelRequired, block.flow, this.stackifierEnabled, this.allocator);
        WASMSSAASTWriter theFalseWriter = new WASMSSAASTWriter(this.resolver, this.linkerContext, this.module, this.compileOptions, this.memoryLayouter, this.function, block, this.stackRegister, this.labelRequired, block.falseFlow, this.stackifierEnabled, this.allocator);
        return new IFCondition(theTrueWriter, theFalseWriter);
    }

    private WASMSSAASTWriter Try(String label, Expression expression) {
        Try block = this.flow.Try(label, expression);
        return new WASMSSAASTWriter(this.resolver, this.linkerContext, this.module, this.compileOptions, this.memoryLayouter, this.function, block, this.stackRegister, this.labelRequired, block.flow, this.stackifierEnabled, this.allocator);
    }

    private WASMSSAASTWriter Try(String label, PrimitiveType blockType, Expression expression) {
        Try block = this.flow.Try(label, blockType, expression);
        return new WASMSSAASTWriter(this.resolver, this.linkerContext, this.module, this.compileOptions, this.memoryLayouter, this.function, block, this.stackRegister, this.labelRequired, block.flow, this.stackifierEnabled, this.allocator);
    }

    private WASMSSAASTWriter loop(String label, Expression expression) {
        Loop loop = this.flow.loop(label, expression);
        return new WASMSSAASTWriter(this.resolver, this.linkerContext, this.module, this.compileOptions, this.memoryLayouter, this.function, loop, this.stackRegister, this.labelRequired, loop.flow, this.stackifierEnabled, this.allocator);
    }

    private int stackSize() {
        return this.stackRegister.size() * 4;
    }

    public boolean isStackVariable(Variable aVariable) {
        if (aVariable.isSynthetic()) {
            return false;
        }
        Register theRegister = this.allocator.registerAssignmentFor(aVariable);
        return this.stackRegister.contains(theRegister);
    }

    private BytecodeResolvedFields.FieldEntry implementingClassForStaticField(BytecodeObjectTypeRef aClass, String aFieldName) {
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(aClass);
        BytecodeResolvedFields theFields = theLinkedClass.resolvedFields();
        return theFields.fieldByName(aFieldName);
    }

    private int stackOffsetFor(Variable aVariable) {
        Register r = this.allocator.registerAssignmentFor(aVariable);
        if (r == null) {
            throw new IllegalStateException("Unknown variable : " + aVariable);
        }
        return this.stackRegister.indexOf(r) * 4;
    }

    public void writeExpressionList(ExpressionList aList) {
        for (Expression theExpression : aList.toList()) {
            this.generateExpressions(theExpression);
        }
    }

    void generateExpressions(Expression aExpression) {
        if (aExpression instanceof CheckCastExpression) {
            return;
        }
        if (aExpression instanceof ReturnExpression) {
            this.generateReturnExpression((ReturnExpression)aExpression);
            return;
        }
        if (aExpression instanceof VariableAssignmentExpression) {
            this.generateInitVariableExpression((VariableAssignmentExpression)aExpression);
            return;
        }
        if (aExpression instanceof DirectInvokeMethodExpression) {
            this.generateDirectMethodInvokeExpression((DirectInvokeMethodExpression)aExpression);
            return;
        }
        if (aExpression instanceof IFExpression) {
            this.generateIFExpression((IFExpression)aExpression);
            return;
        }
        if (aExpression instanceof GotoExpression) {
            this.generateGotoExpression((GotoExpression)aExpression);
            return;
        }
        if (aExpression instanceof ReturnValueExpression) {
            this.generateReturnExpression((ReturnValueExpression)aExpression);
            return;
        }
        if (aExpression instanceof PutFieldExpression) {
            this.generatePutFieldExpression((PutFieldExpression)aExpression);
            return;
        }
        if (aExpression instanceof SetMemoryLocationExpression) {
            this.generateSetMemoryLocationExpression((SetMemoryLocationExpression)aExpression);
            return;
        }
        if (aExpression instanceof PutStaticExpression) {
            this.generatePutStaticExpression((PutStaticExpression)aExpression);
            return;
        }
        if (aExpression instanceof InvokeStaticMethodExpression) {
            this.generateInvokeStaticExpression((InvokeStaticMethodExpression)aExpression);
            return;
        }
        if (aExpression instanceof ThrowExpression) {
            this.generateThrowExpression((ThrowExpression)aExpression);
            return;
        }
        if (aExpression instanceof ArrayStoreExpression) {
            this.generateArrayStoreExpression((ArrayStoreExpression)aExpression);
            return;
        }
        if (aExpression instanceof InvokeVirtualMethodExpression) {
            this.generateInvokeVirtualExpression((InvokeVirtualMethodExpression)aExpression);
            return;
        }
        if (aExpression instanceof TableSwitchExpression) {
            this.generateTableSwitchExpression((TableSwitchExpression)aExpression);
            return;
        }
        if (aExpression instanceof LookupSwitchExpression) {
            this.generateLookupSwitchExpression((LookupSwitchExpression)aExpression);
            return;
        }
        if (aExpression instanceof UnreachableExpression) {
            this.generateUnreachable((UnreachableExpression)aExpression);
            return;
        }
        if (aExpression instanceof BreakExpression) {
            BreakExpression theBreak = (BreakExpression)aExpression;
            if (this.stackifierEnabled.get()) {
                LabeledContainer target = this.container.findByLabelInHierarchy(theBreak.blockToBreak().name());
                this.flow.branch(target, aExpression);
            } else {
                if (theBreak.isSetLabelRequired() && this.labelRequired) {
                    Local label = this.function.localByLabel(LABEL_LOCAL);
                    this.flow.setLocal(label, ConstExpressions.i32.c(theBreak.jumpTarget().getAddress(), aExpression), aExpression);
                }
                if (!theBreak.isSilent()) {
                    LabeledContainer target = this.container.findByLabelInHierarchy(theBreak.blockToBreak().name());
                    this.flow.branch(target, aExpression);
                }
            }
            return;
        }
        if (aExpression instanceof ContinueExpression) {
            ContinueExpression theContinue = (ContinueExpression)aExpression;
            if (this.stackifierEnabled.get()) {
                LabeledContainer target = this.container.findByLabelInHierarchy(theContinue.labelToReturnTo().name() + "_inner");
                this.flow.branch(target, aExpression);
            } else {
                if (this.labelRequired) {
                    Local label = this.function.localByLabel(LABEL_LOCAL);
                    this.flow.setLocal(label, ConstExpressions.i32.c(theContinue.jumpTarget().getAddress(), aExpression), aExpression);
                }
                LabeledContainer target = this.container.findByLabelInHierarchy(theContinue.labelToReturnTo().name() + "_inner");
                this.flow.branch(target, aExpression);
            }
            return;
        }
        if (aExpression instanceof SetEnumConstantsExpression) {
            SetEnumConstantsExpression theSetEnum = (SetEnumConstantsExpression)aExpression;
            this.flow.i32.store(0, ConstExpressions.i32.load(12, this.toValue((Value)theSetEnum.incomingDataFlows().get(0)), null), this.toValue((Value)theSetEnum.incomingDataFlows().get(1)), null);
            return;
        }
        if (aExpression instanceof IFElseExpression) {
            IFElseExpression i = (IFElseExpression)aExpression;
            this.generateIFElseExpression(i);
            return;
        }
        throw new IllegalStateException("Not supported : " + aExpression);
    }

    private void generateUnreachable(UnreachableExpression aExpression) {
        this.flow.unreachable(aExpression);
    }

    private void generateLookupSwitchExpression(LookupSwitchExpression aExpression) {
        WASMSSAASTWriter outer = this.block("outer", aExpression);
        Value theValue = (Value)aExpression.incomingDataFlows().get(0);
        for (Map.Entry<Long, ExpressionList> theEntry : aExpression.getPairs().entrySet()) {
            WASMSSAASTWriter inner = outer.iff("switch_" + theEntry.getKey(), ConstExpressions.i32.eq(ConstExpressions.i32.c(((Number)theEntry.getKey()).intValue(), null), this.toValue(theValue), null), null).trueWriter;
            inner.writeExpressionList(theEntry.getValue());
            inner.flow.branch((LabeledContainer)outer.container, null);
        }
        outer.writeExpressionList(aExpression.getDefaultExpressions());
    }

    private void generateTableSwitchExpression(TableSwitchExpression aExpression) {
        Value theValue = (Value)aExpression.incomingDataFlows().get(0);
        WASMSSAASTWriter theTableSwitch = this.block("tableswitch", aExpression);
        WASMSSAASTWriter theMinCheck = theTableSwitch.block("label0", null);
        theMinCheck.flow.branchIff((LabeledContainer)theMinCheck.container, ConstExpressions.i32.ge_s(this.toValue(theValue), ConstExpressions.i32.c(((Number)aExpression.getLowValue()).intValue(), null), null), null);
        theMinCheck.writeExpressionList(aExpression.getDefaultExpressions());
        theMinCheck.flow.branch((LabeledContainer)theTableSwitch.container, null);
        WASMSSAASTWriter theMaxCheck = theTableSwitch.block("label0", null);
        theMaxCheck.flow.branchIff((LabeledContainer)theMaxCheck.container, ConstExpressions.i32.le_s(this.toValue(theValue), ConstExpressions.i32.c(((Number)aExpression.getHighValue()).intValue(), null), null), null);
        theMaxCheck.writeExpressionList(aExpression.getDefaultExpressions());
        theMaxCheck.flow.branch((LabeledContainer)theTableSwitch.container, null);
        for (Map.Entry<Long, ExpressionList> theEntry : aExpression.getOffsets().entrySet()) {
            WASMSSAASTWriter theSwitch = theTableSwitch.iff("switch_" + theEntry.getKey(), ConstExpressions.i32.eq(ConstExpressions.i32.c(((Number)theEntry.getKey()).intValue(), null), ConstExpressions.i32.sub(this.toValue(theValue), ConstExpressions.i32.c(((Number)aExpression.getLowValue()).intValue(), null), null), null), null).trueWriter;
            theSwitch.writeExpressionList(theEntry.getValue());
            theSwitch.flow.branch((LabeledContainer)theTableSwitch.container, null);
        }
        theTableSwitch.flow.unreachable(null);
    }

    private void generateInvokeVirtualExpression(InvokeVirtualMethodExpression aExpression) {
        if (aExpression.getSignature().getReturnType().isVoid()) {
            this.container.addChild(this.invokeVirtualValue(aExpression));
        } else {
            this.flow.drop(this.invokeVirtualValue(aExpression), aExpression);
        }
    }

    private void generateArrayStoreExpression(ArrayStoreExpression aExpression) {
        List theIncomingData = aExpression.incomingDataFlows();
        Value theArray = (Value)theIncomingData.get(0);
        Value theIndex = (Value)theIncomingData.get(1);
        Value theValue = (Value)theIncomingData.get(2);
        if (theIndex instanceof IntegerValue) {
            int offset = 20 + ((IntegerValue)theIndex).getIntValue() * 8;
            switch (aExpression.getArrayType().resolve()) {
                case DOUBLE: 
                case FLOAT: {
                    this.flow.f32.store(offset, this.toValue(theArray), this.toValue(theValue), aExpression);
                    break;
                }
                default: {
                    this.flow.i32.store(offset, this.toValue(theArray), this.toValue(theValue), aExpression);
                }
            }
            return;
        }
        I32Add thePtr = ConstExpressions.i32.add(this.toValue(theArray), ConstExpressions.i32.mul(this.toValue(theIndex), ConstExpressions.i32.c(8, aExpression), aExpression), aExpression);
        switch (aExpression.getArrayType().resolve()) {
            case DOUBLE: 
            case FLOAT: {
                this.flow.f32.store(20, thePtr, this.toValue(theValue), aExpression);
                break;
            }
            default: {
                this.flow.i32.store(20, thePtr, this.toValue(theValue), aExpression);
            }
        }
    }

    private void generateThrowExpression(ThrowExpression aExpression) {
        if (this.compileOptions.isEnableExceptions()) {
            Value theException = (Value)aExpression.incomingDataFlows().get(0);
            WASMValue theValue = this.toValue(theException);
            this.flow.throwException(this.module.getEvents().eventIndex().byLabel(EXCEPTION_NAME), Collections.singletonList(theValue), aExpression);
        } else {
            this.flow.unreachable(aExpression);
        }
    }

    private void generateInvokeStaticExpression(InvokeStaticMethodExpression aExpression) {
        if (aExpression.getSignature().getReturnType().isVoid()) {
            this.container.addChild(this.invokeStaticValue(aExpression));
        } else {
            this.flow.drop(this.invokeStaticValue(aExpression), aExpression);
        }
    }

    private void generatePutStaticExpression(PutStaticExpression aExpression) {
        BytecodeResolvedFields.FieldEntry theEntry = this.implementingClassForStaticField(BytecodeObjectTypeRef.fromUtf8Constant(aExpression.getField().getClassIndex().getClassConstant().getConstant()), aExpression.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(theEntry.getProvidingClass().getClassName());
        int theMemoryOffset = theLayout.offsetForClassMember(theEntry.getValue().getName().stringValue());
        List theIncomingData = aExpression.incomingDataFlows();
        String theClassName = WASMWriterUtils.toClassName(theEntry.getProvidingClass().getClassName());
        WeakFunctionReferenceCallable theClassInit = ConstExpressions.weakFunctionReference(theClassName + CLASSINITSUFFIX, aExpression);
        switch (((Value)theIncomingData.get(0)).resolveType().resolve()) {
            case DOUBLE: 
            case FLOAT: {
                this.flow.f32.store(theMemoryOffset, ConstExpressions.call(theClassInit, Collections.emptyList(), aExpression), this.toValue((Value)theIncomingData.get(0)), aExpression);
                break;
            }
            default: {
                this.flow.i32.store(theMemoryOffset, ConstExpressions.call(theClassInit, Collections.emptyList(), aExpression), this.toValue((Value)theIncomingData.get(0)), aExpression);
            }
        }
    }

    private void generateSetMemoryLocationExpression(SetMemoryLocationExpression aExpression) {
        List theIncomingData = aExpression.incomingDataFlows();
        this.flow.i32.store(0, this.toValue((Value)theIncomingData.get(0)), this.toValue((Value)theIncomingData.get(1)), aExpression);
    }

    private void generatePutFieldExpression(PutFieldExpression aExpression) {
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(BytecodeObjectTypeRef.fromUtf8Constant(aExpression.getField().getClassIndex().getClassConstant().getConstant()));
        int theMemoryOffset = theLayout.offsetForInstanceMember(aExpression.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(aExpression.getField().getClassIndex().getClassConstant().getConstant()));
        BytecodeResolvedFields theInstanceFields = theLinkedClass.resolvedFields();
        BytecodeResolvedFields.FieldEntry theField = theInstanceFields.fieldByName(aExpression.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        List theIncomingData = aExpression.incomingDataFlows();
        switch (TypeRef.toType(theField.getValue().getTypeRef()).resolve()) {
            case DOUBLE: 
            case FLOAT: {
                this.flow.f32.store(theMemoryOffset, this.toValue((Value)theIncomingData.get(0)), this.toValue((Value)theIncomingData.get(1)), aExpression);
                break;
            }
            default: {
                this.flow.i32.store(theMemoryOffset, this.toValue((Value)theIncomingData.get(0)), this.toValue((Value)theIncomingData.get(1)), aExpression);
            }
        }
    }

    private void generateGotoExpression(GotoExpression aExpression) {
    }

    private void generateIFExpression(IFExpression aExpression) {
        WASMSSAASTWriter iff = this.iff("if_" + aExpression.getAddress().getAddress(), this.toValue((Value)aExpression.incomingDataFlows().get(0)), aExpression).trueWriter;
        iff.writeExpressionList(aExpression.getExpressions());
    }

    private void generateIFElseExpression(IFElseExpression aExpression) {
        IFExpression wrapped = aExpression.getCondition();
        IFCondition c = this.iff("if_" + wrapped.getAddress().getAddress(), this.toValue((Value)wrapped.incomingDataFlows().get(0)), wrapped);
        c.trueWriter.writeExpressionList(wrapped.getExpressions());
        c.falseWriter.writeExpressionList(aExpression.getElsePart());
    }

    private void generateDirectMethodInvokeExpression(DirectInvokeMethodExpression aExpression) {
        if (aExpression.getSignature().getReturnType().isVoid()) {
            this.container.addChild(this.directMethodInvokeValue(aExpression));
        } else {
            this.flow.drop(this.directMethodInvokeValue(aExpression), aExpression);
        }
    }

    private void generateInitVariableExpression(VariableAssignmentExpression aExpression) {
        Local theLocal;
        Variable theVariable = aExpression.getVariable();
        Value theNewValue = (Value)aExpression.incomingDataFlows().get(0);
        if (theVariable.isSynthetic()) {
            theLocal = this.function.localByLabel(theVariable.getName());
        } else {
            Register r = this.allocator.registerAssignmentFor(theVariable);
            theLocal = this.function.localByLabel(WASMSSAASTWriter.registerName(r));
        }
        if (this.isStackVariable(theVariable)) {
            Local sp = this.function.localByLabel(SP);
            int theOffset = this.stackOffsetFor(theVariable);
            switch (theVariable.resolveType().resolve()) {
                case DOUBLE: 
                case FLOAT: {
                    this.flow.f32.store(theOffset, ConstExpressions.getLocal(sp, aExpression), ConstExpressions.teeLocal(theLocal, this.toValue(theNewValue), aExpression), aExpression);
                    break;
                }
                default: {
                    this.flow.i32.store(theOffset, ConstExpressions.getLocal(sp, aExpression), ConstExpressions.teeLocal(theLocal, this.toValue(theNewValue), aExpression), aExpression);
                    break;
                }
            }
        } else {
            this.flow.setLocal(theLocal, this.toValue(theNewValue), aExpression);
        }
    }

    private WASMValue toValue(Value aValue) {
        if (aValue instanceof Variable) {
            return this.variableName((Variable)aValue);
        }
        if (aValue instanceof PHIValue) {
            return this.phiValue((PHIValue)aValue);
        }
        if (aValue instanceof BinaryExpression) {
            return this.binaryValue((BinaryExpression)aValue);
        }
        if (aValue instanceof ByteValue) {
            return this.byteValue((ByteValue)aValue);
        }
        if (aValue instanceof IntegerValue) {
            return this.integerValue((IntegerValue)aValue);
        }
        if (aValue instanceof DirectInvokeMethodExpression) {
            return this.directMethodInvokeValue((DirectInvokeMethodExpression)aValue);
        }
        if (aValue instanceof InvokeStaticMethodExpression) {
            return this.invokeStaticValue((InvokeStaticMethodExpression)aValue);
        }
        if (aValue instanceof GetFieldExpression) {
            return this.getFieldValue((GetFieldExpression)aValue);
        }
        if (aValue instanceof NewObjectExpression) {
            return this.newObjectValue((NewObjectExpression)aValue);
        }
        if (aValue instanceof GetStaticExpression) {
            return this.getStaticValue((GetStaticExpression)aValue);
        }
        if (aValue instanceof LongValue) {
            return this.longValue((LongValue)aValue);
        }
        if (aValue instanceof FixedBinaryExpression) {
            return this.fixedBinaryValue((FixedBinaryExpression)aValue);
        }
        if (aValue instanceof ComputedMemoryLocationReadExpression) {
            return this.computedMemoryLocationValue((ComputedMemoryLocationReadExpression)aValue);
        }
        if (aValue instanceof ComputedMemoryLocationWriteExpression) {
            return this.computedMemoryLocationValue((ComputedMemoryLocationWriteExpression)aValue);
        }
        if (aValue instanceof TypeConversionExpression) {
            return this.typeConversion((TypeConversionExpression)aValue);
        }
        if (aValue instanceof NullValue) {
            return this.nullValue((NullValue)aValue);
        }
        if (aValue instanceof StackTopExpression) {
            return this.stackTopValue((StackTopExpression)aValue);
        }
        if (aValue instanceof MemorySizeExpression) {
            return this.memorySizeValue((MemorySizeExpression)aValue);
        }
        if (aValue instanceof ShortValue) {
            return this.shortValue((ShortValue)aValue);
        }
        if (aValue instanceof FloatValue) {
            return this.floatValue((FloatValue)aValue);
        }
        if (aValue instanceof InvokeVirtualMethodExpression) {
            return this.invokeVirtualValue((InvokeVirtualMethodExpression)aValue);
        }
        if (aValue instanceof FloorExpression) {
            return this.floorValue((FloorExpression)aValue);
        }
        if (aValue instanceof NewArrayExpression) {
            return this.newArrayValue((NewArrayExpression)aValue);
        }
        if (aValue instanceof ArrayLengthExpression) {
            return this.arrayLengthValue((ArrayLengthExpression)aValue);
        }
        if (aValue instanceof StringValue) {
            return this.stringValue((StringValue)aValue);
        }
        if (aValue instanceof ArrayEntryExpression) {
            return this.arrayEntryValue((ArrayEntryExpression)aValue);
        }
        if (aValue instanceof CompareExpression) {
            return this.compareValue((CompareExpression)aValue);
        }
        if (aValue instanceof NegatedExpression) {
            return this.negateValue((NegatedExpression)aValue);
        }
        if (aValue instanceof InstanceOfExpression) {
            return this.instanceOfValue((InstanceOfExpression)aValue);
        }
        if (aValue instanceof DoubleValue) {
            return this.doubleValue((DoubleValue)aValue);
        }
        if (aValue instanceof ResolveCallsiteObjectExpression) {
            return this.resolveCallSiteObjectValue((ResolveCallsiteObjectExpression)aValue);
        }
        if (aValue instanceof MethodHandlesGeneratedLookupExpression) {
            return this.methodHandlesGeneratedLookupValue((MethodHandlesGeneratedLookupExpression)aValue);
        }
        if (aValue instanceof MethodTypeExpression) {
            return this.methodTypeValue((MethodTypeExpression)aValue);
        }
        if (aValue instanceof CurrentExceptionExpression) {
            return this.currentException((CurrentExceptionExpression)aValue);
        }
        if (aValue instanceof ClassReferenceValue) {
            return this.classReferenceValue((ClassReferenceValue)aValue);
        }
        if (aValue instanceof TypeOfExpression) {
            return this.typeOfValue((TypeOfExpression)aValue);
        }
        if (aValue instanceof LambdaWithStaticImplExpression) {
            return this.lambdaWithStaticImplValue((LambdaWithStaticImplExpression)aValue);
        }
        if (aValue instanceof LambdaConstructorReferenceExpression) {
            return this.lambdaConstructorReferenceValue((LambdaConstructorReferenceExpression)aValue);
        }
        if (aValue instanceof LambdaVirtualReferenceExpression) {
            return this.lambdaVirtualReferenceValue((LambdaVirtualReferenceExpression)aValue);
        }
        if (aValue instanceof LambdaInterfaceReferenceExpression) {
            return this.lambdaInterfaceReferenceValue((LambdaInterfaceReferenceExpression)aValue);
        }
        if (aValue instanceof LambdaSpecialReferenceExpression) {
            return this.lambdaSpecialReferenceValue((LambdaSpecialReferenceExpression)aValue);
        }
        if (aValue instanceof MethodHandleExpression) {
            return this.methodHandleValue((MethodHandleExpression)aValue);
        }
        if (aValue instanceof NewMultiArrayExpression) {
            return this.newMultiArrayValue((NewMultiArrayExpression)aValue);
        }
        if (aValue instanceof SqrtExpression) {
            return this.sqrtValue((SqrtExpression)aValue);
        }
        if (aValue instanceof MaxExpression) {
            return this.maxValue((MaxExpression)aValue);
        }
        if (aValue instanceof MinExpression) {
            return this.minValue((MinExpression)aValue);
        }
        if (aValue instanceof FloatingPointFloorExpression) {
            return this.floatingPointFloor((FloatingPointFloorExpression)aValue);
        }
        if (aValue instanceof FloatingPointCeilExpression) {
            return this.floatingPointCeil((FloatingPointCeilExpression)aValue);
        }
        if (aValue instanceof EnumConstantsExpression) {
            return this.enumConstants((EnumConstantsExpression)aValue);
        }
        if (aValue instanceof NewObjectAndConstructExpression) {
            return this.newObjectAndConstruct((NewObjectAndConstructExpression)aValue);
        }
        if (aValue instanceof IsNaNExpression) {
            return this.isNaN((IsNaNExpression)aValue);
        }
        if (aValue instanceof NewInstanceFromDefaultConstructorExpression) {
            return this.newInstanceFromDefaultConstructor((NewInstanceFromDefaultConstructorExpression)aValue);
        }
        if (aValue instanceof PtrOfExpression) {
            return this.ptrOfExpression((PtrOfExpression)aValue);
        }
        if (aValue instanceof MethodTypeArgumentCheckExpression) {
            return this.methodTypeArgumentCheckExpression((MethodTypeArgumentCheckExpression)aValue);
        }
        if (aValue instanceof SuperTypeOfExpression) {
            return this.superTypeOfExpression((SuperTypeOfExpression)aValue);
        }
        if (aValue instanceof HeapBaseExpression) {
            return this.heapBaseExpression((HeapBaseExpression)aValue);
        }
        if (aValue instanceof DataEndExpression) {
            return this.dataEndExpression((DataEndExpression)aValue);
        }
        if (aValue instanceof SystemHasStackExpression) {
            return this.systemmHasStackExpression((SystemHasStackExpression)aValue);
        }
        throw new IllegalStateException("Not supported : " + aValue);
    }

    private WASMValue systemmHasStackExpression(SystemHasStackExpression aValue) {
        return ConstExpressions.i32.c(1, aValue);
    }

    private WASMValue dataEndExpression(DataEndExpression aValue) {
        return ConstExpressions.i32.c(0, aValue);
    }

    private WASMValue heapBaseExpression(HeapBaseExpression aValue) {
        return ConstExpressions.i32.c(0, aValue);
    }

    private WASMValue superTypeOfExpression(SuperTypeOfExpression aValue) {
        Object theResolverFunction = this.module.functionIndex().firstByLabel("superTypeOf");
        return ConstExpressions.call(theResolverFunction, Collections.singletonList(this.toValue((Value)aValue.incomingDataFlows().get(0))), aValue);
    }

    private WASMValue methodTypeValue(MethodTypeExpression aValue) {
        ExportableFunction theFactoryFunction;
        BytecodeMethodSignature theSignature = aValue.getSignature();
        String theMethodTypeFactoryName = WASMWriterUtils.toMethodName("methodTypeFactory", theSignature);
        try {
            theFactoryFunction = (ExportableFunction)this.module.functionIndex().firstByLabel(theMethodTypeFactoryName);
        }
        catch (Exception e) {
            theFactoryFunction = this.module.getFunctions().newFunction(theMethodTypeFactoryName, PrimitiveType.i32);
            Local data = theFactoryFunction.newLocal("data", PrimitiveType.i32);
            int length = 1 + theSignature.getArguments().length;
            theFactoryFunction.flow.setLocal(data, this.newArray(ConstExpressions.i32.c(length, null)), null);
            Expressions f = theFactoryFunction.flow;
            BiFunction<BytecodeTypeRef, Integer, Void> theAdder = (aType, aIndex) -> {
                int offset = 20 + aIndex * 4;
                if (aType.isPrimitive()) {
                    TypeRef.Native theNativeType = (TypeRef.Native)TypeRef.toType(aType);
                    f.i32.store(offset, ConstExpressions.getLocal(data, null), ConstExpressions.i32.c(-theNativeType.ordinal(), null), aValue);
                } else if (aType.isArray()) {
                    BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
                    f.i32.store(offset, ConstExpressions.getLocal(data, null), ConstExpressions.i32.c(theLinkedClass.getUniqueId(), null), aValue);
                } else {
                    BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass((BytecodeObjectTypeRef)aType);
                    f.i32.store(offset, ConstExpressions.getLocal(data, null), ConstExpressions.i32.c(theLinkedClass.getUniqueId(), null), aValue);
                }
                return null;
            };
            theAdder.apply(theSignature.getReturnType(), 0);
            for (int i = 0; i < theSignature.getArguments().length; ++i) {
                BytecodeTypeRef theArgument = theSignature.getArguments()[i];
                theAdder.apply(theArgument, i + 1);
            }
            theFactoryFunction.flow.ret(ConstExpressions.getLocal(data, null), null);
        }
        return ConstExpressions.call(theFactoryFunction, Collections.emptyList(), aValue);
    }

    private WASMValue methodTypeArgumentCheckExpression(MethodTypeArgumentCheckExpression aExpression) {
        TypeRef.Native theExpectedType = aExpression.getExpectedType();
        Value theMethodType = (Value)aExpression.incomingDataFlows().get(0);
        Value theIndex = (Value)aExpression.incomingDataFlows().get(1);
        I32Add thePtr = ConstExpressions.i32.add(this.toValue(theMethodType), ConstExpressions.i32.mul(this.toValue(theIndex), ConstExpressions.i32.c(4, aExpression), aExpression), aExpression);
        I32Const theExpectedValue = ConstExpressions.i32.c(-theExpectedType.ordinal(), null);
        I32Load theRead = ConstExpressions.i32.load(24, thePtr, aExpression);
        return ConstExpressions.i32.eq(theExpectedValue, theRead, aExpression);
    }

    private WASMValue ptrOfExpression(PtrOfExpression aValue) {
        return this.toValue((Value)aValue.incomingDataFlows().get(0));
    }

    private WASMValue newInstanceFromDefaultConstructor(NewInstanceFromDefaultConstructorExpression aValue) {
        Value theClassRef = (Value)aValue.incomingDataFlows().get(0);
        return ConstExpressions.call(ConstExpressions.weakFunctionReference(NEWINSTANCEHELPER, null), Collections.singletonList(this.toValue(theClassRef)), null);
    }

    private WASMValue isNaN(IsNaNExpression aValue) {
        WASMValue theValue = this.toValue((Value)aValue.incomingDataFlows().get(0));
        return ConstExpressions.select(ConstExpressions.i32.c(0, null), ConstExpressions.i32.c(1, null), ConstExpressions.f32.eq(theValue, theValue, null), null);
    }

    private WASMValue newObjectAndConstruct(NewObjectAndConstructExpression aValue) {
        String theMethodName = WASMWriterUtils.toMethodName(aValue.getClazz(), "$newInstance", aValue.getSignature());
        WeakFunctionReferenceCallable theFunction = ConstExpressions.weakFunctionReference(theMethodName, aValue);
        ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
        theArguments.add(ConstExpressions.i32.c(0, null));
        for (Value theValue : aValue.incomingDataFlows()) {
            theArguments.add(this.toValue(theValue));
        }
        return ConstExpressions.call(theFunction, theArguments, aValue);
    }

    private WASMValue enumConstants(EnumConstantsExpression aValue) {
        return ConstExpressions.i32.load(0, ConstExpressions.i32.load(12, this.toValue((Value)aValue.incomingDataFlows().get(0)), null), null);
    }

    private WASMValue floatingPointCeil(FloatingPointCeilExpression aValue) {
        List theArguments = aValue.incomingDataFlows();
        return ConstExpressions.f32.ceil(this.toValue((Value)theArguments.get(0)), aValue);
    }

    private WASMValue floatingPointFloor(FloatingPointFloorExpression aValue) {
        List theArguments = aValue.incomingDataFlows();
        return ConstExpressions.f32.floor(this.toValue((Value)theArguments.get(0)), aValue);
    }

    private WASMValue minValue(MinExpression aValue) {
        List theArguments = aValue.incomingDataFlows();
        switch (aValue.resolveType().resolve()) {
            case DOUBLE: 
            case FLOAT: {
                return ConstExpressions.f32.min(this.toValue((Value)theArguments.get(0)), this.toValue((Value)theArguments.get(1)), aValue);
            }
        }
        WASMValue left = this.toValue((Value)theArguments.get(0));
        WASMValue right = this.toValue((Value)theArguments.get(1));
        return ConstExpressions.select(left, right, ConstExpressions.i32.lt_s(left, right, aValue), aValue);
    }

    private WASMValue maxValue(MaxExpression aValue) {
        List theArguments = aValue.incomingDataFlows();
        switch (aValue.resolveType().resolve()) {
            case DOUBLE: 
            case FLOAT: {
                return ConstExpressions.f32.max(this.toValue((Value)theArguments.get(0)), this.toValue((Value)theArguments.get(1)), aValue);
            }
        }
        WASMValue left = this.toValue((Value)theArguments.get(0));
        WASMValue right = this.toValue((Value)theArguments.get(1));
        return ConstExpressions.select(left, right, ConstExpressions.i32.gt_s(left, right, aValue), aValue);
    }

    private WASMValue sqrtValue(SqrtExpression aValue) {
        return ConstExpressions.f32.sqrt(this.toValue((Value)aValue.incomingDataFlows().get(0)), aValue);
    }

    private WASMValue newMultiArrayValue(NewMultiArrayExpression aValue) {
        String theMethodName;
        List theDimensions = aValue.incomingDataFlows();
        switch (theDimensions.size()) {
            case 1: {
                theMethodName = WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
                break;
            }
            case 2: {
                theMethodName = WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported number of dimensions : " + theDimensions.size());
            }
        }
        String theClassName = WASMWriterUtils.toClassName(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
        WeakFunctionReferenceCallable theClassInit = ConstExpressions.weakFunctionReference(theClassName + CLASSINITSUFFIX, aValue);
        Object theFunction = this.module.functionIndex().firstByLabel(theMethodName);
        ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
        theArguments.add(ConstExpressions.i32.c(0, aValue));
        for (Value theDimension : theDimensions) {
            theArguments.add(this.toValue(theDimension));
        }
        theArguments.add(ConstExpressions.call(theClassInit, Collections.emptyList(), aValue));
        theArguments.add(ConstExpressions.weakFunctionTableReference(theClassName + VTABLEFUNCTIONSUFFIX, aValue));
        return ConstExpressions.call(theFunction, theArguments, aValue);
    }

    private WASMValue methodHandleValue(MethodHandleExpression aValue) {
        if (aValue.getAdapterAnnotation() == null) {
            String theMethodName = WASMWriterUtils.toMethodName(aValue.getClassName(), aValue.getMethodName(), aValue.getImplementationSignature());
            return ConstExpressions.weakFunctionTableReference(theMethodName, aValue);
        }
        return ConstExpressions.weakFunctionTableReference(this.resolver.methodHandleDelegateFor(aValue), aValue);
    }

    private WASMExpression lambdaWithStaticImplValue(LambdaWithStaticImplExpression aValue) {
        Object theNew = this.module.functionIndex().firstByLabel("newLambdaImpl");
        return ConstExpressions.call(theNew, Arrays.asList(this.toValue(aValue.getType()), this.toValue(aValue.getStaticRef()), this.toValue(aValue.getStaticArguments())), aValue);
    }

    private WASMExpression lambdaConstructorReferenceValue(LambdaConstructorReferenceExpression aValue) {
        Object theNew = this.module.functionIndex().firstByLabel("newLambdaImpl");
        return ConstExpressions.call(theNew, Arrays.asList(this.toValue(aValue.getType()), this.toValue(aValue.getConstructorRef()), this.toValue(aValue.getStaticArguments())), aValue);
    }

    private WASMExpression lambdaVirtualReferenceValue(LambdaVirtualReferenceExpression aValue) {
        Object theNew = this.module.functionIndex().firstByLabel("newLambdaImpl");
        return ConstExpressions.call(theNew, Arrays.asList(this.toValue(aValue.getType()), this.toValue(aValue.getVirtualRef()), this.toValue(aValue.getStaticArguments())), aValue);
    }

    private WASMExpression lambdaInterfaceReferenceValue(LambdaInterfaceReferenceExpression aValue) {
        Object theNew = this.module.functionIndex().firstByLabel("newLambdaImpl");
        return ConstExpressions.call(theNew, Arrays.asList(this.toValue(aValue.getType()), this.toValue(aValue.getInterfaceRef()), this.toValue(aValue.getStaticArguments())), aValue);
    }

    private WASMExpression lambdaSpecialReferenceValue(LambdaSpecialReferenceExpression aValue) {
        Object theNew = this.module.functionIndex().firstByLabel("newLambdaImpl");
        return ConstExpressions.call(theNew, Arrays.asList(this.toValue(aValue.getType()), this.toValue(aValue.getSpecialRef()), this.toValue(aValue.getStaticArguments())), aValue);
    }

    private WASMValue typeOfValue(TypeOfExpression aValue) {
        return ConstExpressions.i32.load(0, this.toValue((Value)aValue.incomingDataFlows().get(0)), aValue);
    }

    private WASMValue classReferenceValue(ClassReferenceValue aValue) {
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(aValue.getType());
        WeakFunctionReferenceCallable classInit = ConstExpressions.weakFunctionReference(WASMWriterUtils.toClassName(theLinkedClass.getClassName()) + CLASSINITSUFFIX, null);
        return ConstExpressions.call(classInit, Collections.emptyList(), null);
    }

    private WASMValue currentException(CurrentExceptionExpression aValue) {
        return ConstExpressions.i32.c(0, aValue);
    }

    private WASMValue methodHandlesGeneratedLookupValue(MethodHandlesGeneratedLookupExpression aValue) {
        return ConstExpressions.i32.c(0, aValue);
    }

    private WASMExpression resolveCallSiteObjectValue(ResolveCallsiteObjectExpression aValue) {
        Function theFunction = this.resolver.resolveCallsiteBootstrapFor(aValue.getOwningClass(), aValue.getCallsiteId(), aValue.getProgram(), aValue.getBootstrapMethod());
        return ConstExpressions.call(theFunction, Collections.emptyList(), aValue);
    }

    private WASMValue doubleValue(DoubleValue aValue) {
        return ConstExpressions.f32.c(((Number)aValue.getDoubleValue()).floatValue(), null);
    }

    private WASMValue instanceOfValue(InstanceOfExpression aValue) {
        BytecodeLinkedClass theClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(aValue.getType().getConstant()));
        Object theFunction = this.module.functionIndex().firstByLabel("INSTANCEOF_CHECK");
        return ConstExpressions.call(theFunction, Arrays.asList(this.toValue((Value)aValue.incomingDataFlows().get(0)), ConstExpressions.i32.c(theClass.getUniqueId(), aValue)), aValue);
    }

    private WASMValue negateValue(NegatedExpression aValue) {
        Value theValue = (Value)aValue.incomingDataFlows().get(0);
        switch (theValue.resolveType().resolve()) {
            case DOUBLE: 
            case FLOAT: {
                return ConstExpressions.f32.neg(this.toValue(theValue), aValue);
            }
        }
        return ConstExpressions.i32.mul(ConstExpressions.i32.c(-1, aValue), this.toValue(theValue), aValue);
    }

    private WASMExpression compareValue(CompareExpression aValue) {
        TypeRef.Native theValue2Type;
        List theIncomingFlows = aValue.incomingDataFlows();
        Value theValue1 = (Value)theIncomingFlows.get(0);
        Value theValue2 = (Value)theIncomingFlows.get(1);
        WASMValue left = this.toValue(theValue1);
        WASMValue right = this.toValue(theValue2);
        TypeRef.Native theValue1Type = theValue1.resolveType().resolve();
        if (theValue1Type != (theValue2Type = theValue2.resolveType().resolve())) {
            throw new IllegalStateException("Does not support mixed types : " + theValue1Type + " -> " + theValue2Type);
        }
        switch (theValue1Type) {
            case DOUBLE: 
            case FLOAT: {
                return ConstExpressions.select(ConstExpressions.i32.c(1, aValue), ConstExpressions.select(ConstExpressions.i32.c(-1, aValue), ConstExpressions.i32.c(0, aValue), ConstExpressions.f32.lt(left, right, aValue), aValue), ConstExpressions.f32.gt(left, right, aValue), aValue);
            }
        }
        return ConstExpressions.select(ConstExpressions.i32.c(1, aValue), ConstExpressions.select(ConstExpressions.i32.c(-1, aValue), ConstExpressions.i32.c(0, aValue), ConstExpressions.i32.lt_s(left, right, aValue), aValue), ConstExpressions.i32.gt_s(left, right, aValue), aValue);
    }

    private WASMValue arrayEntryValue(ArrayEntryExpression aValue) {
        List theIncomingFlows = aValue.incomingDataFlows();
        I32Add thePtr = ConstExpressions.i32.add(this.toValue((Value)theIncomingFlows.get(0)), ConstExpressions.i32.mul(this.toValue((Value)theIncomingFlows.get(1)), ConstExpressions.i32.c(8, aValue), aValue), aValue);
        switch (aValue.resolveType().resolve()) {
            case DOUBLE: 
            case FLOAT: {
                return ConstExpressions.f32.load(20, thePtr, aValue);
            }
        }
        return ConstExpressions.i32.load(20, thePtr, aValue);
    }

    private WASMValue stringValue(StringValue aValue) {
        return ConstExpressions.getGlobal(this.resolver.globalForStringFromPool(aValue), null);
    }

    private WASMExpression newArray(WASMValue aValue) {
        String theMethodName = WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        String theClassName = WASMWriterUtils.toClassName(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
        WeakFunctionReferenceCallable theClassInit = ConstExpressions.weakFunctionReference(theClassName + CLASSINITSUFFIX, null);
        Object theFunction = this.module.functionIndex().firstByLabel(theMethodName);
        return ConstExpressions.call(theFunction, Arrays.asList(ConstExpressions.i32.c(0, null), aValue, ConstExpressions.call(theClassInit, Collections.emptyList(), null), ConstExpressions.weakFunctionTableReference(theClassName + VTABLEFUNCTIONSUFFIX, null)), null);
    }

    private WASMExpression newArray(Value aValue) {
        return this.newArray(this.toValue(aValue));
    }

    private WASMValue newArrayValue(NewArrayExpression aValue) {
        return this.newArray((Value)aValue.incomingDataFlows().get(0));
    }

    private WASMValue arrayLengthValue(ArrayLengthExpression aValue) {
        return ConstExpressions.i32.load(16, this.toValue((Value)aValue.incomingDataFlows().get(0)), aValue);
    }

    private WASMValue floorValue(FloorExpression aValue) {
        return ConstExpressions.i32.trunc_sF32(this.toValue((Value)aValue.incomingDataFlows().get(0)), aValue);
    }

    private WASMExpression invokeVirtualValue(InvokeVirtualMethodExpression aValue) {
        BytecodeLinkedClass theInvokedClass;
        List theFlows = aValue.incomingDataFlows();
        Value theTarget = (Value)theFlows.get(0);
        List theVariables = theFlows.subList(1, theFlows.size());
        BytecodeTypeRef theInvokedClassName = aValue.getInvokedClass();
        if (!theInvokedClassName.isPrimitive() && !theInvokedClassName.isArray() && (theInvokedClass = this.linkerContext.resolveClass((BytecodeObjectTypeRef)theInvokedClassName)).isOpaqueType()) {
            BytecodeResolvedMethods theMethods = theInvokedClass.resolvedMethods();
            List theImplMethods = theMethods.stream().filter(t -> t.getValue().getName().stringValue().equals(aValue.getMethodName()) && t.getValue().getSignature().matchesExactlyTo(aValue.getSignature())).collect(Collectors.toList());
            if (theImplMethods.size() != 1) {
                throw new IllegalStateException("Cannot find unique method " + aValue.getMethodName() + " with signature " + aValue.getSignature() + " in " + theInvokedClassName.name());
            }
            BytecodeLinkedClass theImplClass = ((BytecodeResolvedMethods.MethodEntry)theImplMethods.get(0)).getProvidingClass();
            BytecodeMethod theMethod = ((BytecodeResolvedMethods.MethodEntry)theImplMethods.get(0)).getValue();
            if (!theMethod.isConstructor()) {
                WeakFunctionReferenceCallable function = ConstExpressions.weakFunctionReference(WASMWriterUtils.toMethodName(theImplClass.getClassName(), aValue.getMethodName(), aValue.getSignature()), aValue);
                ArrayList<WASMValue> arguments = new ArrayList<WASMValue>();
                arguments.add(this.toValue(theTarget));
                for (Value theValue : theVariables) {
                    arguments.add(this.toValue(theValue));
                }
                return ConstExpressions.call(function, arguments, aValue);
            }
        }
        ArrayList<PrimitiveType> theSignatureParams = new ArrayList<PrimitiveType>();
        theSignatureParams.add(PrimitiveType.i32);
        for (int i = 0; i < aValue.getSignature().getArguments().length; ++i) {
            BytecodeTypeRef theParamType = aValue.getSignature().getArguments()[i];
            theSignatureParams.add(WASMSSAASTWriter.toType(TypeRef.toType(theParamType)));
        }
        WASMType theCalledFunction = !aValue.getSignature().getReturnType().isVoid() ? this.module.getTypes().typeFor(theSignatureParams, WASMSSAASTWriter.toType(TypeRef.toType(aValue.getSignature().getReturnType()))) : this.module.getTypes().typeFor(theSignatureParams);
        ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
        theArguments.add(this.toValue(theTarget));
        for (Value theValue : theVariables) {
            theArguments.add(this.toValue(theValue));
        }
        BytecodeVirtualMethodIdentifier theMethodIdentifier = this.linkerContext.getMethodCollection().identifierFor(aValue.getMethodName(), aValue.getSignature());
        WASMType theResolveType = this.module.getTypes().typeFor(Arrays.asList(PrimitiveType.i32, PrimitiveType.i32), PrimitiveType.i32);
        ArrayList<WASMValue> theResolveArgument = new ArrayList<WASMValue>();
        theResolveArgument.add(this.toValue(theTarget));
        theResolveArgument.add(ConstExpressions.i32.c(theMethodIdentifier.getIdentifier(), aValue));
        CallIndirect theIndex = ConstExpressions.call(theResolveType, theResolveArgument, ConstExpressions.i32.load(4, this.toValue(theTarget), aValue), aValue);
        return ConstExpressions.call(theCalledFunction, theArguments, theIndex, aValue);
    }

    private WASMValue floatValue(FloatValue aValue) {
        return ConstExpressions.f32.c(aValue.getFloatValue(), null);
    }

    private WASMValue shortValue(ShortValue aValue) {
        return ConstExpressions.i32.c(aValue.getShortValue(), null);
    }

    private WASMValue stackTopValue(StackTopExpression aValue) {
        Global stackTop = this.module.globalsIndex().globalByLabel(STACKTOP);
        return ConstExpressions.getGlobal(stackTop, null);
    }

    private WASMValue memorySizeValue(MemorySizeExpression aValue) {
        return ConstExpressions.i32.mul(ConstExpressions.currentMemory(null), ConstExpressions.i32.c(65536, null), null);
    }

    private WASMValue nullValue(NullValue aValue) {
        return ConstExpressions.i32.c(0, null);
    }

    private WASMValue typeConversion(TypeConversionExpression aValue) {
        TypeRef theTargetType = aValue.resolveType();
        Value theSource = (Value)aValue.incomingDataFlows().get(0);
        if (Objects.equals(theTargetType.resolve(), theSource.resolveType().resolve())) {
            return this.toValue(theSource);
        }
        switch (theSource.resolveType().resolve()) {
            case DOUBLE: 
            case FLOAT: {
                switch (aValue.resolveType().resolve()) {
                    case DOUBLE: 
                    case FLOAT: {
                        return this.toValue(theSource);
                    }
                    case INT: 
                    case SHORT: 
                    case BYTE: 
                    case LONG: 
                    case CHAR: {
                        WASMValue theValue = this.toValue(theSource);
                        return ConstExpressions.select(ConstExpressions.i32.trunc_sF32(theValue, aValue), ConstExpressions.i32.c(0, aValue), ConstExpressions.f32.eq(theValue, theValue, aValue), aValue);
                    }
                }
                throw new IllegalStateException("target type " + aValue.resolveType() + " not supported!");
            }
            case INT: 
            case SHORT: 
            case BYTE: 
            case LONG: 
            case CHAR: {
                switch (aValue.resolveType().resolve()) {
                    case DOUBLE: 
                    case FLOAT: {
                        return ConstExpressions.f32.convert_sI32(this.toValue(theSource), aValue);
                    }
                    case INT: 
                    case SHORT: 
                    case BYTE: 
                    case LONG: 
                    case CHAR: {
                        return this.toValue(theSource);
                    }
                }
                throw new IllegalStateException("target type " + aValue.resolveType() + " not supported!");
            }
        }
        throw new IllegalStateException("Conversion of " + theSource.resolveType() + " not supported!");
    }

    private WASMValue computedMemoryLocationValue(ComputedMemoryLocationWriteExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        return ConstExpressions.i32.add(this.toValue((Value)theIncomingData.get(0)), this.toValue((Value)theIncomingData.get(1)), aValue);
    }

    private WASMValue computedMemoryLocationValue(ComputedMemoryLocationReadExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        return ConstExpressions.i32.load(0, ConstExpressions.i32.add(this.toValue((Value)theIncomingData.get(0)), this.toValue((Value)theIncomingData.get(1)), aValue), aValue);
    }

    private WASMValue fixedBinaryValue(FixedBinaryExpression aValue) {
        switch (aValue.getOperator()) {
            case ISNULL: {
                return ConstExpressions.i32.eq(this.toValue((Value)aValue.incomingDataFlows().get(0)), ConstExpressions.i32.c(0, aValue), aValue);
            }
            case ISNONNULL: {
                return ConstExpressions.i32.ne(this.toValue((Value)aValue.incomingDataFlows().get(0)), ConstExpressions.i32.c(0, aValue), aValue);
            }
            case ISZERO: {
                return ConstExpressions.i32.eq(this.toValue((Value)aValue.incomingDataFlows().get(0)), ConstExpressions.i32.c(0, aValue), aValue);
            }
        }
        throw new IllegalStateException("Not supported");
    }

    private WASMValue longValue(LongValue aValue) {
        return ConstExpressions.i32.c(((Number)aValue.getLongValue()).intValue(), null);
    }

    private WASMValue getStaticValue(GetStaticExpression aValue) {
        BytecodeResolvedFields.FieldEntry theEntry = this.implementingClassForStaticField(BytecodeObjectTypeRef.fromUtf8Constant(aValue.getField().getClassIndex().getClassConstant().getConstant()), aValue.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(theEntry.getProvidingClass().getClassName());
        int theMemoryOffset = theLayout.offsetForClassMember(theEntry.getValue().getName().stringValue());
        String theClassName = WASMWriterUtils.toClassName(theEntry.getProvidingClass().getClassName());
        WeakFunctionReferenceCallable theClassInit = ConstExpressions.weakFunctionReference(theClassName + CLASSINITSUFFIX, aValue);
        switch (TypeRef.toType(theEntry.getValue().getTypeRef()).resolve()) {
            case DOUBLE: 
            case FLOAT: {
                return ConstExpressions.f32.load(theMemoryOffset, ConstExpressions.call(theClassInit, Collections.emptyList(), aValue), aValue);
            }
        }
        return ConstExpressions.i32.load(theMemoryOffset, ConstExpressions.call(theClassInit, Collections.emptyList(), aValue), aValue);
    }

    private WASMExpression newObjectValue(NewObjectExpression aValue) {
        BytecodeObjectTypeRef theType = BytecodeObjectTypeRef.fromUtf8Constant(aValue.getType().getConstant());
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(theType);
        String theMethodName = WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newObject", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(theType);
        String theClassName = WASMWriterUtils.toClassName(theLinkedClass.getClassName());
        WeakFunctionReferenceCallable theClassInit = ConstExpressions.weakFunctionReference(theClassName + CLASSINITSUFFIX, aValue);
        Object theFunction = this.module.functionIndex().firstByLabel(theMethodName);
        return ConstExpressions.call(theFunction, Arrays.asList(ConstExpressions.i32.c(0, aValue), ConstExpressions.i32.c(theLayout.instanceSize(), aValue), ConstExpressions.call(theClassInit, Collections.emptyList(), aValue), ConstExpressions.weakFunctionTableReference(theClassName + VTABLEFUNCTIONSUFFIX, aValue)), aValue);
    }

    private WASMValue getFieldValue(GetFieldExpression aValue) {
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(aValue.getField().getClassIndex().getClassConstant().getConstant()));
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(BytecodeObjectTypeRef.fromUtf8Constant(aValue.getField().getClassIndex().getClassConstant().getConstant()));
        int theMemoryOffset = theLayout.offsetForInstanceMember(aValue.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        String theFieldName = aValue.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue();
        BytecodeResolvedFields theInstanceFields = theLinkedClass.resolvedFields();
        BytecodeResolvedFields.FieldEntry theField = theInstanceFields.fieldByName(theFieldName);
        if (theField.getValue().getAccessFlags().isStatic()) {
            throw new IllegalStateException("Field " + theFieldName + " is static!");
        }
        switch (TypeRef.toType(theField.getValue().getTypeRef()).resolve()) {
            case DOUBLE: 
            case FLOAT: {
                return ConstExpressions.f32.load(theMemoryOffset, this.toValue((Value)aValue.incomingDataFlows().get(0)), aValue);
            }
        }
        return ConstExpressions.i32.load(theMemoryOffset, this.toValue((Value)aValue.incomingDataFlows().get(0)), aValue);
    }

    private WASMExpression directMethodInvokeValue(DirectInvokeMethodExpression aValue) {
        BytecodeLinkedClass theTargetClass = this.linkerContext.resolveClass(aValue.getClazz());
        String theMethodName = aValue.getMethodName();
        BytecodeMethodSignature theSignature = aValue.getSignature();
        List theIncomingData = aValue.incomingDataFlows();
        Value theTarget = (Value)theIncomingData.get(0);
        List theArguments = theIncomingData.subList(1, theIncomingData.size());
        if (theTargetClass.isOpaqueType() && !theMethodName.equals("<init>")) {
            Object function = this.module.functionIndex().firstByLabel(WASMWriterUtils.toMethodName(aValue.getClazz(), aValue.getMethodName(), aValue.getSignature()));
            ArrayList<WASMValue> arguments = new ArrayList<WASMValue>();
            arguments.add(this.toValue(theTarget));
            for (Value theValue : theArguments) {
                arguments.add(this.toValue(theValue));
            }
            return ConstExpressions.call(function, arguments, aValue);
        }
        if (theMethodName.equals("<init>")) {
            Object function = this.module.functionIndex().firstByLabel(WASMWriterUtils.toMethodName(aValue.getClazz(), aValue.getMethodName(), aValue.getSignature()));
            ArrayList<WASMValue> arguments = new ArrayList<WASMValue>();
            arguments.add(this.toValue(theTarget));
            for (Value theValue : theArguments) {
                arguments.add(this.toValue(theValue));
            }
            return ConstExpressions.call(function, arguments, aValue);
        }
        BytecodeResolvedMethods theResolvedMethods = theTargetClass.resolvedMethods();
        BytecodeResolvedMethods.MethodEntry theEntry = theResolvedMethods.implementingClassOf(theMethodName, theSignature);
        Object function = this.module.functionIndex().firstByLabel(WASMWriterUtils.toMethodName(theEntry.getProvidingClass().getClassName(), aValue.getMethodName(), aValue.getSignature()));
        ArrayList<WASMValue> arguments = new ArrayList<WASMValue>();
        arguments.add(this.toValue(theTarget));
        for (Value theValue : theArguments) {
            arguments.add(this.toValue(theValue));
        }
        return ConstExpressions.call(function, arguments, aValue);
    }

    private WASMExpression invokeStaticValue(InvokeStaticMethodExpression aValue) {
        WeakFunctionReferenceCallable function = ConstExpressions.weakFunctionReference(WASMWriterUtils.toMethodName(aValue.getClassName(), aValue.getMethodName(), aValue.getSignature()), aValue);
        ArrayList<WASMValue> arguments = new ArrayList<WASMValue>();
        arguments.add(ConstExpressions.i32.c(0, aValue));
        for (Value theValue : aValue.incomingDataFlows()) {
            arguments.add(this.toValue(theValue));
        }
        return ConstExpressions.call(function, arguments, aValue);
    }

    private I32Const byteValue(ByteValue aValue) {
        return ConstExpressions.i32.c(aValue.getByteValue(), null);
    }

    private I32Const integerValue(IntegerValue aValue) {
        return ConstExpressions.i32.c(aValue.getIntValue(), null);
    }

    private WASMValue binaryValueI32(Expression aValue, BinaryExpression.Operator aOperator, Value aValue1, Value aValue2) {
        switch (aOperator) {
            case NOTEQUALS: {
                return ConstExpressions.i32.ne(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case EQUALS: {
                return ConstExpressions.i32.eq(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case LESSTHAN: {
                return ConstExpressions.i32.lt_s(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case LESSTHANOREQUALS: {
                return ConstExpressions.i32.le_s(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case GREATEROREQUALS: {
                return ConstExpressions.i32.ge_s(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case GREATERTHAN: {
                return ConstExpressions.i32.gt_s(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case ADD: {
                return ConstExpressions.i32.add(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case MUL: {
                return ConstExpressions.i32.mul(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case DIV: {
                return ConstExpressions.f32.div(this.toFloatValue(aValue1), this.toFloatValue(aValue2), aValue);
            }
            case REMAINDER: {
                WASMValue a = this.toValue(aValue1);
                WASMValue b = this.toValue(aValue2);
                return ConstExpressions.i32.rem_s(a, b, aValue);
            }
            case SUB: {
                return ConstExpressions.i32.sub(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case BINARYXOR: {
                return ConstExpressions.i32.xor(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case BINARYOR: {
                return ConstExpressions.i32.or(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case BINARYAND: {
                return ConstExpressions.i32.and(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case BINARYSHIFTLEFT: {
                return ConstExpressions.i32.shl(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case BINARYSHIFTRIGHT: {
                return ConstExpressions.i32.shr_s(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case BINARYUNSIGNEDSHIFTRIGHT: {
                return ConstExpressions.i32.shr_u(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
        }
        throw new IllegalStateException("Operator not supported : " + (Object)((Object)aOperator));
    }

    private WASMValue binaryValueF32(Expression aValue, BinaryExpression.Operator aOperator, Value aValue1, Value aValue2) {
        switch (aOperator) {
            case NOTEQUALS: {
                return ConstExpressions.f32.ne(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case EQUALS: {
                return ConstExpressions.f32.eq(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case LESSTHAN: {
                return ConstExpressions.f32.lt(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case LESSTHANOREQUALS: {
                return ConstExpressions.f32.le(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case GREATEROREQUALS: {
                return ConstExpressions.f32.ge(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case GREATERTHAN: {
                return ConstExpressions.f32.gt(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case ADD: {
                return ConstExpressions.f32.add(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case MUL: {
                return ConstExpressions.f32.mul(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case DIV: {
                return ConstExpressions.f32.div(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
            case REMAINDER: {
                WASMValue a = this.toValue(aValue1);
                WASMValue b = this.toValue(aValue2);
                return ConstExpressions.f32.sub(a, ConstExpressions.f32.mul(b, ConstExpressions.f32.trunc(ConstExpressions.f32.div(a, b, aValue), aValue), aValue), aValue);
            }
            case SUB: {
                return ConstExpressions.f32.sub(this.toValue(aValue1), this.toValue(aValue2), aValue);
            }
        }
        throw new IllegalStateException("Operator not supported : " + (Object)((Object)aOperator));
    }

    private WASMValue binaryValue(BinaryExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        Value theValue1 = (Value)theIncomingData.get(0);
        Value theValue2 = (Value)theIncomingData.get(1);
        String theType1 = WASMWriterUtils.toType(theValue1.resolveType());
        String theType2 = WASMWriterUtils.toType(theValue2.resolveType());
        switch (theType1) {
            case "i32": {
                return this.binaryValueI32(aValue, aValue.getOperator(), theValue1, theValue2);
            }
            case "f32": {
                return this.binaryValueF32(aValue, aValue.getOperator(), theValue1, theValue2);
            }
        }
        throw new IllegalArgumentException("Not supported type : " + theType1);
    }

    private void generateReturnExpression(ReturnExpression aExpression) {
        this.stackExit();
        this.flow.ret(aExpression);
    }

    private void generateReturnExpression(ReturnValueExpression aExpression) {
        this.stackExit();
        this.flow.ret(this.toValue((Value)aExpression.incomingDataFlows().get(0)), aExpression);
    }

    private WASMValue toFloatValue(Value aValue) {
        switch (aValue.resolveType().resolve()) {
            case DOUBLE: 
            case FLOAT: {
                return this.toValue(aValue);
            }
        }
        return ConstExpressions.f32.convert_sI32(this.toValue(aValue), null);
    }

    private WASMValue variableName(Variable aVariable) {
        if (aVariable.isSynthetic()) {
            Local local = this.function.localByLabel(aVariable.getName());
            return ConstExpressions.getLocal(local, null);
        }
        Register r = this.allocator.registerAssignmentFor(aVariable);
        Local local = this.function.localByLabel(WASMSSAASTWriter.registerName(r));
        return ConstExpressions.getLocal(local, null);
    }

    private WASMValue phiValue(PHIValue p) {
        Variable v = this.allocator.variableAssignmentFor(p);
        return this.variableName(v);
    }

    public void stackEnter() {
        int theStackSize = this.stackSize();
        if (theStackSize > 0) {
            Global stackTop = this.module.getGlobals().globalsIndex().globalByLabel(STACKTOP);
            Local sp = this.function.newLocal(SP, PrimitiveType.i32);
            Local oldsp = this.function.newLocal(OLDSP, PrimitiveType.i32);
            this.flow.setGlobal(stackTop, ConstExpressions.i32.sub(ConstExpressions.teeLocal(oldsp, ConstExpressions.getGlobal(stackTop, null), null), ConstExpressions.i32.c(theStackSize, null), null), null);
            this.flow.setLocal(sp, ConstExpressions.getGlobal(stackTop, null), null);
        }
    }

    private void stackExit() {
        int theStackSize = this.stackSize();
        if (theStackSize > 0) {
            this.flow.setGlobal(this.module.getGlobals().globalsIndex().globalByLabel(STACKTOP), ConstExpressions.getLocal(this.function.localByLabel(OLDSP), null), null);
        }
    }

    public void writeRelooped(Relooper.Block aBlock) {
        this.stackifierEnabled.set(false);
        this.labelRequired = aBlock.containsMultipleBlock();
        if (this.labelRequired) {
            this.function.newLocal(LABEL_LOCAL, PrimitiveType.i32);
        }
        this.stackEnter();
        if (this.compileOptions.isEnableExceptions() && this.stackSize() > 0) {
            WASMSSAASTWriter theGlobalTry = this.function.getFunctionType().isVoid() ? this.Try("globalTry", null) : this.Try("globalTry", this.function.getFunctionType().getResultType(), null);
            theGlobalTry.writeReloopedInternal(aBlock);
            theGlobalTry.container.flow.unreachable(null);
            Try theGlobal = (Try)theGlobalTry.container;
            int theStackSize = this.stackSize();
            if (theStackSize > 0) {
                theGlobal.catchBlock.flow.setGlobal(this.module.getGlobals().globalsIndex().globalByLabel(STACKTOP), ConstExpressions.getLocal(this.function.localByLabel(OLDSP), null), null);
            }
            theGlobal.catchBlock.flow.rethrowException(null);
        } else {
            WASMExpression theLast;
            this.writeReloopedInternal(aBlock);
            List<WASMExpression> theExpressions = this.container.getChildren();
            if (!theExpressions.isEmpty() && ((theLast = theExpressions.get(theExpressions.size() - 1)) instanceof Return || theLast instanceof ReturnValue || theLast instanceof Unreachable)) {
                return;
            }
            this.flow.unreachable(null);
        }
    }

    private void writeReloopedInternal(Relooper.Block aBlock) {
        if (aBlock == null) {
            return;
        }
        if (aBlock instanceof Relooper.SimpleBlock) {
            this.writeSimpleBlock((Relooper.SimpleBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.LoopBlock) {
            this.writeLoopBlock((Relooper.LoopBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.MultipleBlock) {
            this.writeMultipleBlock((Relooper.MultipleBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.TryBlock) {
            this.writeTryBlock((Relooper.TryBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.IFThenElseBlock) {
            this.writeIfThenElseBlock((Relooper.IFThenElseBlock)aBlock);
            return;
        }
        throw new IllegalStateException("Don't know how to handle : " + aBlock);
    }

    private void writeSimpleBlock(Relooper.SimpleBlock aSimpleBlock) {
        WASMSSAASTWriter theWriter = this;
        if (aSimpleBlock.isLabelRequired()) {
            theWriter = this.block(aSimpleBlock.label().name(), null);
        }
        theWriter.writeExpressionList(aSimpleBlock.expressions());
        this.writeReloopedInternal(aSimpleBlock.next());
    }

    private void writeIfThenElseBlock(Relooper.IFThenElseBlock aIfBlock) {
        this.writeExpressionList(aIfBlock.getPrelude());
        WASMSSAASTWriter theOuter = this.block(aIfBlock.label().name(), null);
        IFCondition theIfCondition = theOuter.iff(aIfBlock.label().name() + "_inner", this.toValue(aIfBlock.getCondition()), null);
        theIfCondition.trueWriter.writeReloopedInternal(aIfBlock.getTrueBlock());
        ((IFCondition)theIfCondition).trueWriter.flow.branch((LabeledContainer)theOuter.container, null);
        theOuter.writeReloopedInternal(aIfBlock.getFalseBlock());
        this.writeReloopedInternal(aIfBlock.next());
    }

    private void writeLoopBlock(Relooper.LoopBlock aLoopBlock) {
        WASMSSAASTWriter theWriter = this;
        if (aLoopBlock.isLabelRequired()) {
            theWriter = this.block(aLoopBlock.label().name(), null);
        }
        WASMSSAASTWriter loop = theWriter.loop(aLoopBlock.label().name() + "_inner", null);
        loop.writeReloopedInternal(aLoopBlock.inner());
        this.writeReloopedInternal(aLoopBlock.next());
    }

    private void writeMultipleBlock(Relooper.MultipleBlock aMultipleBlock) {
        WASMSSAASTWriter theWriter = this;
        if (aMultipleBlock.isLabelRequired()) {
            theWriter = this.block(aMultipleBlock.label().name(), null);
        }
        WASMSSAASTWriter loop = theWriter.loop(aMultipleBlock.label().name() + "_inner", null);
        Local label = this.function.localByLabel(LABEL_LOCAL);
        for (Relooper.Block theHandler : aMultipleBlock.handlers()) {
            for (RegionNode theEntry : theHandler.entries()) {
                int theEntryAddress = theEntry.getStartAddress().getAddress();
                WASMSSAASTWriter block = loop.iff("case_" + theEntryAddress, ConstExpressions.i32.eq(ConstExpressions.getLocal(label, null), ConstExpressions.i32.c(theEntryAddress, null), null), null).trueWriter;
                block.writeReloopedInternal(theHandler);
            }
        }
        this.writeReloopedInternal(aMultipleBlock.next());
    }

    private void writeTryBlock(Relooper.TryBlock aTryBlock) {
        if (this.compileOptions.isEnableExceptions()) {
            WASMSSAASTWriter outer = this.block(aTryBlock.label().name(), null);
            WASMSSAASTWriter handler = outer.block("handler", PrimitiveType.i32, null);
            WASMSSAASTWriter tryblock = handler.Try("inner", null);
            Try t = (Try)tryblock.container;
            tryblock.writeReloopedInternal(aTryBlock.inner());
            t.catchBlock.flow.branchOnException((LabeledContainer)handler.container, this.module.getEvents().eventIndex().byLabel(EXCEPTION_NAME), null);
            t.catchBlock.flow.rethrowException(null);
            handler.flow.branch((LabeledContainer)outer.container, null);
            Local currentVMException = null;
            try {
                currentVMException = this.function.localByLabel("CURRENT_JAVA_EXCEPTION");
            }
            catch (Exception e) {
                currentVMException = this.function.newLocal("CURRENT_JAVA_EXCEPTION", PrimitiveType.i32);
            }
            outer.flow.setLocal(currentVMException, null);
            List<Relooper.TryBlock.CatchBlock> theCatches = aTryBlock.getCatchBlocks();
            for (Relooper.TryBlock.CatchBlock c : theCatches) {
                for (BytecodeUtf8Constant theCatchedException : c.getCaughtExceptions()) {
                    BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theCatchedException));
                    WASMSSAASTWriter catchHandler = outer.block("c" + theLinkedClass.getUniqueId(), null);
                    Object theFunction = this.module.functionIndex().firstByLabel("INSTANCEOF_CHECK");
                    Call theInstanceOfValue = ConstExpressions.call(theFunction, Arrays.asList(ConstExpressions.getLocal(currentVMException, null), ConstExpressions.i32.c(theLinkedClass.getUniqueId(), null)), null);
                    catchHandler.flow.branchIff((LabeledContainer)catchHandler.container, ConstExpressions.i32.ne(ConstExpressions.i32.c(1, null), theInstanceOfValue, null), null);
                    catchHandler.writeReloopedInternal(c.getHandler());
                }
            }
            outer.flow.throwException(this.module.getEvents().eventIndex().byLabel(EXCEPTION_NAME), Collections.singletonList(ConstExpressions.getLocal(currentVMException, null)), null);
            this.writeReloopedInternal(aTryBlock.next());
        } else {
            this.writeReloopedInternal(aTryBlock.inner());
            this.writeReloopedInternal(aTryBlock.next());
        }
    }

    public void writeStackified(Stackifier st) {
        this.stackifierEnabled.set(true);
        final Stack<WASMSSAASTWriter> writerStack = new Stack<WASMSSAASTWriter>();
        writerStack.push(this);
        Stackifier.StackifierStructuredControlFlowWriter stWriter = new Stackifier.StackifierStructuredControlFlowWriter(st){

            @Override
            public void begin() {
                super.begin();
                WASMSSAASTWriter current = (WASMSSAASTWriter)writerStack.peek();
                current.stackEnter();
            }

            @Override
            public void beginLoopFor(de.mirkosertic.bytecoder.stackifier.Block<RegionNode> block) {
                super.beginLoopFor(block);
                WASMSSAASTWriter current = (WASMSSAASTWriter)writerStack.peek();
                WASMSSAASTWriter outerBlock = current.block(block.getLabel().name(), null);
                writerStack.push(outerBlock);
                WASMSSAASTWriter loop = outerBlock.loop(block.getLabel().name() + "_inner", null);
                writerStack.push(loop);
            }

            @Override
            public void beginBlockFor(de.mirkosertic.bytecoder.stackifier.Block<RegionNode> block) {
                super.beginBlockFor(block);
                WASMSSAASTWriter current = (WASMSSAASTWriter)writerStack.peek();
                WASMSSAASTWriter newSimpleBlock = current.block(block.getLabel().name(), null);
                writerStack.push(newSimpleBlock);
            }

            @Override
            public void writeExpression(RegionNode currentNode, Expression e) {
                WASMSSAASTWriter current = (WASMSSAASTWriter)writerStack.peek();
                current.generateExpressions(e);
            }

            @Override
            public void closeBlock() {
                WASMSSAASTWriter current = (WASMSSAASTWriter)writerStack.pop();
                if (current.container instanceof Loop) {
                    WASMSSAASTWriter wASMSSAASTWriter = (WASMSSAASTWriter)writerStack.pop();
                }
                super.closeBlock();
            }

            @Override
            public void end() {
                super.end();
                WASMSSAASTWriter current = (WASMSSAASTWriter)writerStack.peek();
                current.flow.unreachable(null);
            }
        };
        st.writeStructuredControlFlow(stWriter);
    }

    private static class IFCondition {
        private final WASMSSAASTWriter trueWriter;
        private final WASMSSAASTWriter falseWriter;

        public IFCondition(WASMSSAASTWriter trueWriter, WASMSSAASTWriter falseWriter) {
            this.trueWriter = trueWriter;
            this.falseWriter = falseWriter;
        }
    }

    public static interface Resolver {
        public Global runtimeClassFor(BytecodeObjectTypeRef var1);

        public Global globalForStringFromPool(StringValue var1);

        public Function resolveCallsiteBootstrapFor(BytecodeClass var1, String var2, Program var3, RegionNode var4);

        public String methodHandleDelegateFor(MethodHandleExpression var1);
    }
}

