/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm;

import de.mirkosertic.bytecoder.allocator.AbstractAllocator;
import de.mirkosertic.bytecoder.allocator.Register;
import de.mirkosertic.bytecoder.api.EmulatedByRuntime;
import de.mirkosertic.bytecoder.api.Export;
import de.mirkosertic.bytecoder.api.OpaqueIndexed;
import de.mirkosertic.bytecoder.api.OpaqueMethod;
import de.mirkosertic.bytecoder.api.OpaqueProperty;
import de.mirkosertic.bytecoder.api.Substitutes;
import de.mirkosertic.bytecoder.backend.CompileBackend;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.ConstantPool;
import de.mirkosertic.bytecoder.backend.NativeMemoryLayouter;
import de.mirkosertic.bytecoder.backend.wasm.WASMCompileResult;
import de.mirkosertic.bytecoder.backend.wasm.WASMIntrinsics;
import de.mirkosertic.bytecoder.backend.wasm.WASMMinifier;
import de.mirkosertic.bytecoder.backend.wasm.WASMSSAASTWriter;
import de.mirkosertic.bytecoder.backend.wasm.WASMWriterUtils;
import de.mirkosertic.bytecoder.backend.wasm.ast.Block;
import de.mirkosertic.bytecoder.backend.wasm.ast.Call;
import de.mirkosertic.bytecoder.backend.wasm.ast.CallIndirect;
import de.mirkosertic.bytecoder.backend.wasm.ast.Callable;
import de.mirkosertic.bytecoder.backend.wasm.ast.ConstExpressions;
import de.mirkosertic.bytecoder.backend.wasm.ast.ExportableFunction;
import de.mirkosertic.bytecoder.backend.wasm.ast.Exporter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Expressions;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.Global;
import de.mirkosertic.bytecoder.backend.wasm.ast.GlobalsIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Iff;
import de.mirkosertic.bytecoder.backend.wasm.ast.ImportReference;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.Param;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.backend.wasm.ast.WeakFunctionReferenceCallable;
import de.mirkosertic.bytecoder.backend.wasm.ast.WeakFunctionTableReference;
import de.mirkosertic.bytecoder.classlib.Address;
import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.classlib.ExceptionManager;
import de.mirkosertic.bytecoder.classlib.MemoryManager;
import de.mirkosertic.bytecoder.classlib.VM;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeImportedLink;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import de.mirkosertic.bytecoder.core.BytecodeResolvedMethods;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeVirtualMethodIdentifier;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.relooper.Relooper;
import de.mirkosertic.bytecoder.ssa.MethodHandleExpression;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.ProgramGenerator;
import de.mirkosertic.bytecoder.ssa.ProgramGeneratorFactory;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.StringValue;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.stackifier.HeadToHeadControlFlowException;
import de.mirkosertic.bytecoder.stackifier.Stackifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;

public class WASMSSAASTCompilerBackend
implements CompileBackend<WASMCompileResult> {
    private final ProgramGeneratorFactory programGeneratorFactory;

    public WASMSSAASTCompilerBackend(ProgramGeneratorFactory aProgramGeneratorFactory) {
        this.programGeneratorFactory = aProgramGeneratorFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WASMCompileResult generateCodeFor(CompileOptions aOptions, BytecodeLinkerContext aLinkerContext, Class aEntryPointClass, String aEntryPointMethodName, BytecodeMethodSignature aEntryPointSignatue) {
        void var29_35;
        BytecodeLinkedClass theStringClass;
        WASMMinifier theMinifier = new WASMMinifier();
        BytecodeLinkedClass theArrayClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
        BytecodeLinkedClass theMemoryManagerClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class));
        theMemoryManagerClass.resolveStaticMethod("freeMem", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[0]));
        theMemoryManagerClass.resolveStaticMethod("usedMem", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[0]));
        theMemoryManagerClass.resolveStaticMethod("free", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("malloc", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("newObject", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        BytecodeLinkedClass theVMClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(VM.class));
        theVMClass.resolveStaticMethod("newStringUTF8", new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(String.class), new BytecodeTypeRef[]{new BytecodeArrayTypeRef(BytecodePrimitiveTypeRef.BYTE, 1)}));
        theVMClass.resolveStaticMethod("newByteArray", new BytecodeMethodSignature(new BytecodeArrayTypeRef(BytecodePrimitiveTypeRef.BYTE, 1), new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT}));
        theVMClass.resolveStaticMethod("setByteArrayEntry", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{new BytecodeArrayTypeRef(BytecodePrimitiveTypeRef.BYTE, 1), BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.BYTE}));
        aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(String.class)).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{new BytecodeArrayTypeRef(BytecodePrimitiveTypeRef.BYTE, 1), BytecodePrimitiveTypeRef.BYTE}));
        BytecodeMethodSignature pushExceptionSignature = new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(Throwable.class)});
        BytecodeMethodSignature popExceptionSignature = new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(Throwable.class), new BytecodeTypeRef[0]);
        if (aOptions.isEnableExceptions()) {
            BytecodeLinkedClass theExceptionManager = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(ExceptionManager.class));
            theExceptionManager.resolveStaticMethod("push", pushExceptionSignature);
            theExceptionManager.resolveStaticMethod("pop", popExceptionSignature);
            theExceptionManager.resolveStaticMethod("lastExceptionOrNull", popExceptionSignature);
        }
        if (!(theStringClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(String.class))).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{new BytecodeArrayTypeRef(BytecodePrimitiveTypeRef.BYTE, 1)}))) {
            throw new IllegalStateException("No matching constructor!");
        }
        if (!theStringClass.resolveVirtualMethod("equals", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.BOOLEAN, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(Object.class)}))) {
            throw new IllegalStateException("No matching stringequals method!");
        }
        final Module module = new Module("bytecoder", aOptions.getFilenamePrefix() + ".wasm.map");
        if (aOptions.isEnableExceptions()) {
            module.getEvents().newException("EX", Collections.singletonList(PrimitiveType.i32));
        }
        Global stackTop = module.getGlobals().newMutableGlobal("STACKTOP", PrimitiveType.i32, ConstExpressions.i32.c(-1, null));
        ExportableFunction instanceOfCheck = module.getFunctions().newFunction("INSTANCEOF_CHECK", Arrays.asList(ConstExpressions.param("thisRef", PrimitiveType.i32), ConstExpressions.param("type", PrimitiveType.i32)), PrimitiveType.i32);
        Iff nullCheck = instanceOfCheck.flow.iff("nullcheck", ConstExpressions.i32.eq(ConstExpressions.getLocal(instanceOfCheck.localByLabel("thisRef"), null), ConstExpressions.i32.c(0, null), null), null);
        nullCheck.flow.ret(ConstExpressions.i32.c(0, null), null);
        WASMType instanceOfType = module.getTypes().typeFor(Arrays.asList(PrimitiveType.i32, PrimitiveType.i32), PrimitiveType.i32);
        WASMType resolveType = module.getTypes().typeFor(Arrays.asList(PrimitiveType.i32, PrimitiveType.i32), PrimitiveType.i32);
        CallIndirect theIndex = ConstExpressions.call(resolveType, Arrays.asList(ConstExpressions.getLocal(instanceOfCheck.localByLabel("thisRef"), null), ConstExpressions.i32.c(-1, null)), ConstExpressions.i32.load(4, ConstExpressions.getLocal(instanceOfCheck.localByLabel("thisRef"), null), null), null);
        instanceOfCheck.flow.ret(ConstExpressions.call(instanceOfType, Arrays.asList(ConstExpressions.getLocal(instanceOfCheck.localByLabel("thisRef"), null), ConstExpressions.getLocal(instanceOfCheck.localByLabel("type"), null)), theIndex, null), null);
        module.getMems().newMemory(aOptions.getWasmMinimumPageSize(), aOptions.getWasmMaximumPageSize()).exportAs("memory");
        ArrayList opaqueReferenceMethods = new ArrayList();
        aLinkerContext.linkedClasses().forEach(aEntry -> {
            if (((BytecodeLinkedClass)aEntry.targetNode()).getBytecodeClass().getAccessFlags().isInterface() && !((BytecodeLinkedClass)aEntry.targetNode()).isOpaqueType()) {
                return;
            }
            if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                return;
            }
            if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(java.lang.reflect.Array.class))) {
                return;
            }
            BytecodeResolvedMethods theMethodMap = ((BytecodeLinkedClass)aEntry.targetNode()).resolvedMethods();
            theMethodMap.stream().forEach(aMethodMapEntry -> {
                BytecodeLinkedClass theProvidingClass = aMethodMapEntry.getProvidingClass();
                if (theProvidingClass != aEntry.targetNode()) {
                    return;
                }
                BytecodeMethod t = aMethodMapEntry.getValue();
                BytecodeMethodSignature theSignature = t.getSignature();
                if (t.getAccessFlags().isNative() || t.getAccessFlags().isAbstract() && theProvidingClass.isOpaqueType()) {
                    if (theProvidingClass.emulatedByRuntime()) {
                        return;
                    }
                    if (t.emulatedByRuntime()) {
                        return;
                    }
                    if (!t.getAccessFlags().isNative() && theProvidingClass.isOpaqueType()) {
                        opaqueReferenceMethods.add(new OpaqueReferenceMethod(theProvidingClass, t));
                    }
                    BytecodeImportedLink theLink = theProvidingClass.linkFor(t);
                    String methodName = WASMWriterUtils.toMethodName(theProvidingClass.getClassName(), t.getName(), theSignature);
                    ImportReference importReference = new ImportReference(theLink.getModuleName(), theLink.getLinkName());
                    ArrayList<Param> params = new ArrayList<Param>();
                    params.add(ConstExpressions.param("thisRef", WASMSSAASTWriter.toType(TypeRef.Native.REFERENCE)));
                    for (int i = 0; i < theSignature.getArguments().length; ++i) {
                        BytecodeTypeRef theParamType = theSignature.getArguments()[i];
                        params.add(ConstExpressions.param("p" + (i + 1), WASMSSAASTWriter.toType(TypeRef.toType(theParamType))));
                    }
                    if (!theSignature.getReturnType().isVoid()) {
                        module.getImports().importFunction(importReference, methodName, params, WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getReturnType()))).toTable();
                    } else {
                        module.getImports().importFunction(importReference, methodName, params).toTable();
                    }
                }
            });
        });
        ExportableFunction lambdaStaticResolvevtableindex = module.getFunctions().newFunction("LAMBDAWITHSTATICIMPL__resolvevtableindex", Arrays.asList(ConstExpressions.param("thisRef", PrimitiveType.i32), ConstExpressions.param("methodId", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        lambdaStaticResolvevtableindex.flow.ret(ConstExpressions.i32.load(8, ConstExpressions.getLocal(lambdaStaticResolvevtableindex.localByLabel("thisRef"), null), null), null);
        ExportableFunction lambdaConstructorRef = module.getFunctions().newFunction("LAMBDACONSTRUCTORREF__resolvevtableindex", Arrays.asList(ConstExpressions.param("thisRef", PrimitiveType.i32), ConstExpressions.param("methodId", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        lambdaConstructorRef.flow.ret(ConstExpressions.i32.load(8, ConstExpressions.getLocal(lambdaConstructorRef.localByLabel("thisRef"), null), null), null);
        ExportableFunction classGetName = module.getFunctions().newFunction("jlClass_jlStringgetName", Collections.singletonList(ConstExpressions.param("thisRef", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        ArrayList<WASMValue> theGetArguments = new ArrayList<WASMValue>();
        theGetArguments.add(ConstExpressions.i32.load(16, ConstExpressions.getLocal(classGetName.localByLabel("thisRef"), null), null));
        classGetName.flow.ret(ConstExpressions.call(ConstExpressions.weakFunctionReference("STRINGPOOL_GLOBAL_BY_INDEX", null), theGetArguments, null), null);
        ExportableFunction classGetSuperClass = module.getFunctions().newFunction("jlClass_jlClassgetSuperclass", Collections.singletonList(ConstExpressions.param("thisRef", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        ArrayList<WASMValue> theGetArguments2 = new ArrayList<WASMValue>();
        theGetArguments2.add(ConstExpressions.getLocal(classGetSuperClass.localByLabel("thisRef"), null));
        classGetSuperClass.flow.ret(ConstExpressions.call(ConstExpressions.weakFunctionReference("superTypeOf", null), theGetArguments2, null), null);
        final ConstantPool theConstantPool = new ConstantPool();
        final HashMap theCallsites = new HashMap();
        final ArrayList methodHandles = new ArrayList();
        WASMSSAASTWriter.Resolver theResolver = new WASMSSAASTWriter.Resolver(){

            @Override
            public Global runtimeClassFor(BytecodeObjectTypeRef aObjectType) {
                String theGlobalName = WASMWriterUtils.toClassName(aObjectType) + "__runtimeclass";
                try {
                    return module.globalsIndex().globalByLabel(theGlobalName);
                }
                catch (Exception e) {
                    return module.getGlobals().newMutableGlobal(theGlobalName, PrimitiveType.i32, ConstExpressions.i32.c(-1, null));
                }
            }

            @Override
            public Global globalForStringFromPool(StringValue aValue) {
                int thePoolIndex = theConstantPool.register(aValue);
                String theLabel = "stringPool" + thePoolIndex;
                try {
                    return module.getGlobals().globalsIndex().globalByLabel(theLabel);
                }
                catch (IllegalArgumentException e) {
                    return module.getGlobals().newMutableGlobal(theLabel, PrimitiveType.i32, ConstExpressions.i32.c(-1, null));
                }
            }

            @Override
            public Function resolveCallsiteBootstrapFor(BytecodeClass owningClass, String callsiteId, Program program, RegionNode bootstrapMethod) {
                String theID = "callsite_" + callsiteId.replace("/", "_");
                if (!theCallsites.containsKey(theID)) {
                    CallSite theCallsite = new CallSite(program, bootstrapMethod);
                    theCallsites.put(theID, theCallsite);
                    return module.getFunctions().newFunction(theID, PrimitiveType.i32);
                }
                return module.functionIndex().firstByLabel(theID);
            }

            @Override
            public String methodHandleDelegateFor(MethodHandleExpression e) {
                int pos = methodHandles.size();
                methodHandles.add(e);
                return "handle" + pos;
            }
        };
        ExportableFunction superTypeOf = module.getFunctions().newFunction("superTypeOf", Collections.singletonList(ConstExpressions.param("thisRef", PrimitiveType.i32)), PrimitiveType.i32);
        aLinkerContext.linkedClasses().forEach(aEntry -> {
            BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
            if (theLinkedClass.emulatedByRuntime()) {
                return;
            }
            Iff theCheck = superTypeOf.flow.iff(theLinkedClass.getClassName().name(), ConstExpressions.i32.eq(ConstExpressions.getLocal(superTypeOf.localByLabel("thisRef"), null), ConstExpressions.getGlobal(theResolver.runtimeClassFor(theLinkedClass.getClassName()), null), null), null);
            if (!theLinkedClass.getClassName().name().equals(Object.class.getName())) {
                theCheck.flow.ret(ConstExpressions.getGlobal(theResolver.runtimeClassFor(theLinkedClass.getSuperClass().getClassName()), null), null);
            } else {
                theCheck.flow.ret(ConstExpressions.i32.c(0, null), null);
            }
        });
        superTypeOf.flow.ret(ConstExpressions.i32.c(0, null), null);
        ExportableFunction classIsAssignableFrom = module.getFunctions().newFunction("jlClass_BOOLEANisAssignableFromjlClass", Arrays.asList(ConstExpressions.param("thisRef", PrimitiveType.i32), ConstExpressions.param("otherType", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        aLinkerContext.linkedClasses().forEach(aEntry -> {
            BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
            if (theLinkedClass.emulatedByRuntime()) {
                return;
            }
            if (theLinkedClass.getClassName().equals(BytecodeObjectTypeRef.fromRuntimeClass(Class.class))) {
                return;
            }
            String typeLabel = "" + theLinkedClass.getUniqueId();
            Global theRuntimeClass = theResolver.runtimeClassFor(theLinkedClass.getClassName());
            Iff theIff = classIsAssignableFrom.flow.iff(typeLabel, ConstExpressions.i32.eq(ConstExpressions.getGlobal(theRuntimeClass, null), ConstExpressions.getLocal(classIsAssignableFrom.localByLabel("otherType"), null), null), null);
            for (BytecodeLinkedClass theImplType : theLinkedClass.getImplementingTypes()) {
                Iff theInstanceCheckIff = theIff.flow.iff(typeLabel, ConstExpressions.i32.eq(ConstExpressions.i32.c(theImplType.getUniqueId(), null), ConstExpressions.i32.load(20, ConstExpressions.getLocal(classIsAssignableFrom.localByLabel("thisRef"), null), null), null), null);
                theInstanceCheckIff.flow.ret(ConstExpressions.i32.c(1, null), null);
            }
            theIff.flow.ret(ConstExpressions.i32.c(0, null), null);
        });
        classIsAssignableFrom.flow.ret(ConstExpressions.i32.c(0, null), null);
        ExportableFunction theMethod = module.getFunctions().newFunction("jlClass_BOOLEANdesiredAssertionStatus", Collections.singletonList(ConstExpressions.param("thisRef", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        theMethod.flow.ret(ConstExpressions.i32.c(0, null), null);
        theMethod = module.getFunctions().newFunction("jlClass_A1jlObjectgetEnumConstants", Collections.singletonList(ConstExpressions.param("thisRef", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        theMethod.flow.ret(ConstExpressions.i32.c(0, null), null);
        String theWASMMethodName = WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(Class.class), "getClassLoader", BytecodeLinkedClass.GET_CLASSLOADER_SIGNATURE);
        ExportableFunction theMethod2 = module.getFunctions().newFunction(theWASMMethodName, Collections.singletonList(ConstExpressions.param("thisRef", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        theMethod2.flow.ret(ConstExpressions.i32.c(0, null), null);
        ExportableFunction runtimeResolvevtableindex = module.getFunctions().newFunction("RUNTIMECLASS__resolvevtableindex", Arrays.asList(ConstExpressions.param("thisRef", PrimitiveType.i32), ConstExpressions.param("methodId", PrimitiveType.i32)), PrimitiveType.i32).toTable();
        BytecodeLinkedClass theClassLinkedCass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Class.class));
        BytecodeResolvedMethods theRuntimeMethodMap = theClassLinkedCass.resolvedMethods();
        theRuntimeMethodMap.stream().forEach(aMethodMapEntry -> {
            BytecodeMethod theMethod = aMethodMapEntry.getValue();
            if (!theMethod.getAccessFlags().isStatic() && !theMethod.isConstructor() && !theMethod.isClassInitializer() && aMethodMapEntry.getProvidingClass().getClassName().equals(BytecodeObjectTypeRef.fromRuntimeClass(Class.class))) {
                BytecodeVirtualMethodIdentifier theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(theMethod);
                Block block = runtimeResolvevtableindex.flow.block("m" + theMethodIdentifier.getIdentifier(), null);
                block.flow.branchIff(block, ConstExpressions.i32.ne(ConstExpressions.getLocal(runtimeResolvevtableindex.localByLabel("methodId"), null), ConstExpressions.i32.c(theMethodIdentifier.getIdentifier(), null), null), null);
                if (Objects.equals("getClass", theMethod.getName().stringValue())) {
                    block.flow.unreachable(null);
                } else {
                    String theMethodName = WASMWriterUtils.toMethodName(aMethodMapEntry.getProvidingClass().getClassName(), theMethod.getName(), theMethod.getSignature());
                    block.flow.ret(ConstExpressions.weakFunctionTableReference(theMethodName, null), null);
                }
            }
        });
        runtimeResolvevtableindex.flow.unreachable(null);
        ExportableFunction newLambdaImplFunction = module.getFunctions().newFunction("newLambdaImpl", Arrays.asList(ConstExpressions.param("type", PrimitiveType.i32), ConstExpressions.param("implMethodNumber", PrimitiveType.i32), ConstExpressions.param("staticArguments", PrimitiveType.i32)), PrimitiveType.i32);
        aLinkerContext.linkedClasses().forEach(aEntry -> {
            if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                return;
            }
            Global theRuntimeClass = theResolver.runtimeClassFor(((BytecodeLinkedClass)aEntry.targetNode()).getClassName());
            BytecodeResolvedMethods theMethodMap = ((BytecodeLinkedClass)aEntry.targetNode()).resolvedMethods();
            theMethodMap.stream().forEach(aMapEntry -> {
                BytecodeMethod t = aMapEntry.getValue();
                if (null != t.getAttributes().getAnnotationByType(EmulatedByRuntime.class.getName())) {
                    if (aMapEntry.getProvidingClass().getClassName().equals(BytecodeObjectTypeRef.fromRuntimeClass(Class.class)) && t.getName().stringValue().equals("forName") && t.getSignature().matchesExactlyTo(BytecodeLinkedClass.CLASS_FOR_NAME_SIGNATURE)) {
                        String theWASMMethodName = WASMWriterUtils.toMethodName(aMapEntry.getProvidingClass().getClassName(), t.getName().stringValue(), t.getSignature());
                        ExportableFunction forNameMethod = module.getFunctions().newFunction(theWASMMethodName, Arrays.asList(ConstExpressions.param("UNUSED", PrimitiveType.i32), ConstExpressions.param("name", PrimitiveType.i32), ConstExpressions.param("initialize", PrimitiveType.i32), ConstExpressions.param("classloader", PrimitiveType.i32)), PrimitiveType.i32).toTable();
                        String theStringEqualsClass = WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(String.class), "equals", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.BOOLEAN, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(Object.class)}));
                        aLinkerContext.linkedClasses().map(Edge::targetNode).forEach(search -> {
                            if (!search.getBytecodeClass().getAccessFlags().isAbstract() && !search.getBytecodeClass().getAccessFlags().isInterface()) {
                                BytecodeResolvedMethods theResolved = search.resolvedMethods();
                                theResolved.stream().filter(j -> j.getProvidingClass() == search).map(BytecodeResolvedMethods.MethodEntry::getValue).filter(j -> j.isConstructor() && j.getSignature().getArguments().length == 0).forEach(m -> {
                                    Global theGlobal = theResolver.globalForStringFromPool(new StringValue(search.getClassName().name()));
                                    Global theSearchRuntimeClass = theResolver.runtimeClassFor(search.getClassName());
                                    Call stringEqualCall = ConstExpressions.call(ConstExpressions.weakFunctionReference(theStringEqualsClass, null), Arrays.asList(ConstExpressions.getLocal(forNameMethod.localByLabel("name"), null), ConstExpressions.getGlobal(theGlobal, null)), null);
                                    Iff theIff = forNameMethod.flow.iff(search.getClassName().name(), ConstExpressions.i32.eq(stringEqualCall, ConstExpressions.i32.c(1, null), null), null);
                                    theIff.flow.ret(ConstExpressions.getGlobal(theSearchRuntimeClass, null), null);
                                });
                            }
                        });
                        forNameMethod.flow.unreachable(null);
                    }
                    return;
                }
                if (t.getAccessFlags().isAbstract()) {
                    return;
                }
                if (t.isClassInitializer()) {
                    return;
                }
                if (aMapEntry.getProvidingClass() != aEntry.targetNode()) {
                    return;
                }
                if (t.getAccessFlags().isNative()) {
                    return;
                }
                BytecodeMethodSignature theSignature = t.getSignature();
                if (((BytecodeLinkedClass)aEntry.targetNode()).emulatedByRuntime()) {
                    return;
                }
                String theMethodName = WASMWriterUtils.toMethodName(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), t.getName(), theSignature);
                if (!module.functionIndex().hasFunction(theMethodName)) {
                    ArrayList<Param> params = new ArrayList<Param>();
                    params.add(ConstExpressions.param("thisRef", WASMSSAASTWriter.toType(TypeRef.Native.REFERENCE)));
                    for (int i = 0; i < theSignature.getArguments().length; ++i) {
                        BytecodeTypeRef theParamType = theSignature.getArguments()[i];
                        params.add(ConstExpressions.param("p" + (i + 1), WASMSSAASTWriter.toType(TypeRef.toType(theParamType))));
                    }
                    ExportableFunction theFunction = !theSignature.getReturnType().isVoid() ? module.getFunctions().newFunction(theMethodName, params, WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getReturnType()))) : module.getFunctions().newFunction(theMethodName, params);
                    if (!t.isConstructor()) {
                        ((Function)theFunction).toTable();
                    }
                }
            });
        });
        NativeMemoryLayouter theMemoryLayout = new NativeMemoryLayouter(aLinkerContext, 4);
        aLinkerContext.linkedClasses().forEach(aEntry -> {
            BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
            if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                return;
            }
            if (theLinkedClass.emulatedByRuntime()) {
                return;
            }
            BytecodeResolvedMethods theMethodMap = theLinkedClass.resolvedMethods();
            String theClassName = WASMWriterUtils.toClassName(((BytecodeLinkedClass)aEntry.targetNode()).getClassName());
            if (!theLinkedClass.getBytecodeClass().getAccessFlags().isInterface() && !theLinkedClass.getBytecodeClass().getAccessFlags().isAbstract()) {
                ExportableFunction instanceOf = module.getFunctions().newFunction(theClassName + "__instanceof", Arrays.asList(ConstExpressions.param("thisRef", PrimitiveType.i32), ConstExpressions.param("p1", PrimitiveType.i32)), PrimitiveType.i32).toTable();
                for (BytecodeLinkedClass theType : theLinkedClass.getImplementingTypes()) {
                    Iff b = instanceOf.flow.iff("b" + theType.getUniqueId(), ConstExpressions.i32.eq(ConstExpressions.getLocal(instanceOf.localByLabel("p1"), null), ConstExpressions.i32.c(theType.getUniqueId(), null), null), null);
                    b.flow.ret(ConstExpressions.i32.c(1, null), null);
                }
                instanceOf.flow.ret(ConstExpressions.i32.c(0, null), null);
                ExportableFunction resolveTableIndex = module.getFunctions().newFunction(theClassName + "__resolvevtableindex", Arrays.asList(ConstExpressions.param("thisRef", PrimitiveType.i32), ConstExpressions.param("p1", PrimitiveType.i32)), PrimitiveType.i32).toTable();
                HashMap<Integer, WeakFunctionTableReference> theImplementedMethods = new HashMap<Integer, WeakFunctionTableReference>();
                theImplementedMethods.put(-1, ConstExpressions.weakFunctionTableReference(instanceOf.getLabel(), null));
                List theEntries = theMethodMap.stream().collect(Collectors.toList());
                HashSet<BytecodeVirtualMethodIdentifier> theVisitedMethods = new HashSet<BytecodeVirtualMethodIdentifier>();
                for (int i = theEntries.size() - 1; 0 <= i; --i) {
                    BytecodeVirtualMethodIdentifier bytecodeVirtualMethodIdentifier;
                    BytecodeResolvedMethods.MethodEntry aMethodMapEntry2 = (BytecodeResolvedMethods.MethodEntry)theEntries.get(i);
                    BytecodeMethod theMethod = aMethodMapEntry2.getValue();
                    if (theMethod.getAccessFlags().isStatic() || theMethod.isConstructor() || theMethod.getAccessFlags().isAbstract() || "desiredAssertionStatus".equals(theMethod.getName().stringValue()) || "getEnumConstants".equals(theMethod.getName().stringValue()) || theMethod.getAttributes().getAnnotationByType(Substitutes.class.getName()) != null || !theVisitedMethods.add(bytecodeVirtualMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(theMethod))) continue;
                    String theFullMethodName = WASMWriterUtils.toMethodName(aMethodMapEntry2.getProvidingClass().getClassName(), theMethod.getName(), theMethod.getSignature());
                    theImplementedMethods.put(bytecodeVirtualMethodIdentifier.getIdentifier(), ConstExpressions.weakFunctionTableReference(theFullMethodName, null));
                }
                int binary_search_threshold = 8;
                if (theImplementedMethods.size() < 8) {
                    Expressions theContainerToAdd = resolveTableIndex.flow;
                    for (Map.Entry entry : theImplementedMethods.entrySet()) {
                        Iff iff = theContainerToAdd.iff("b" + entry.getKey(), ConstExpressions.i32.eq(ConstExpressions.getLocal(resolveTableIndex.localByLabel("p1"), null), ConstExpressions.i32.c((Integer)entry.getKey(), null), null), null);
                        iff.flow.ret((WASMValue)entry.getValue(), null);
                        theContainerToAdd = iff.falseFlow;
                    }
                } else {
                    List theSorted = theImplementedMethods.keySet().stream().sorted().collect(Collectors.toList());
                    Stack theWorkList = new Stack();
                    theWorkList.push(theSorted);
                    Stack<Expressions> stack = new Stack<Expressions>();
                    stack.push(resolveTableIndex.flow);
                    int stepCounter = 1;
                    while (!theWorkList.isEmpty()) {
                        List theStackTop = (List)theWorkList.pop();
                        Expressions theContainerToAdd = (Expressions)stack.pop();
                        if (theStackTop.size() < 8) {
                            Iterator iterator = theStackTop.iterator();
                            while (iterator.hasNext()) {
                                int theMethodIdentifier = (Integer)iterator.next();
                                WeakFunctionTableReference theEntry = (WeakFunctionTableReference)theImplementedMethods.get(theMethodIdentifier);
                                Iff iff = theContainerToAdd.iff("b" + stepCounter++, ConstExpressions.i32.eq(ConstExpressions.getLocal(resolveTableIndex.localByLabel("p1"), null), ConstExpressions.i32.c(theMethodIdentifier, null), null), null);
                                iff.flow.ret(theEntry, null);
                                theContainerToAdd = iff.falseFlow;
                            }
                            theContainerToAdd.unreachable(null);
                            continue;
                        }
                        int half = theStackTop.size() / 2;
                        int theSplitPoint = (Integer)theStackTop.get(half);
                        List theLowerBound = theStackTop.subList(0, half);
                        List theUpperBound = theStackTop.subList(half, theStackTop.size());
                        Iff iff = theContainerToAdd.iff("b" + stepCounter++, ConstExpressions.i32.lt_s(ConstExpressions.getLocal(resolveTableIndex.localByLabel("p1"), null), ConstExpressions.i32.c(theSplitPoint, null), null), null);
                        theWorkList.push(theUpperBound);
                        stack.push(iff.falseFlow);
                        theWorkList.push(theLowerBound);
                        stack.push(iff.flow);
                    }
                }
                resolveTableIndex.flow.unreachable(null);
            }
            theMethodMap.stream().forEach(aMethodMapEntry -> {
                ExportableFunction instanceFunction;
                BytecodeMethod theMethod = aMethodMapEntry.getValue();
                BytecodeMethodSignature theSignature = theMethod.getSignature();
                if (null != theMethod.getAttributes().getAnnotationByType(EmulatedByRuntime.class.getName())) {
                    return;
                }
                if (theMethod.getAccessFlags().isAbstract()) {
                    return;
                }
                if (theMethod.getAccessFlags().isNative()) {
                    return;
                }
                if (aMethodMapEntry.getProvidingClass() != theLinkedClass) {
                    if (aMethodMapEntry.getValue().getAccessFlags().isStatic() && !aMethodMapEntry.getValue().isClassInitializer() && !theMethodMap.isImplementedBy(aMethodMapEntry.getValue(), theLinkedClass)) {
                        ArrayList<Param> params = new ArrayList<Param>();
                        params.add(ConstExpressions.param("UNUSED", WASMSSAASTWriter.toType(TypeRef.Native.REFERENCE)));
                        for (int i = 0; i < theSignature.getArguments().length; ++i) {
                            params.add(ConstExpressions.param("p" + i, WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getArguments()[i]))));
                        }
                        if (!theSignature.getReturnType().isVoid()) {
                            PrimitiveType returnType = WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getReturnType()));
                            ExportableFunction function = module.getFunctions().newFunction(WASMWriterUtils.toMethodName(theLinkedClass.getClassName(), theMethod.getName(), theSignature), params, returnType);
                            WeakFunctionReferenceCallable theImplementation = ConstExpressions.weakFunctionReference(WASMWriterUtils.toMethodName(aMethodMapEntry.getProvidingClass().getClassName(), theMethod.getName(), theSignature), null);
                            ArrayList<WASMValue> callValues = new ArrayList<WASMValue>();
                            for (Param p : params) {
                                callValues.add(ConstExpressions.getLocal(p, null));
                            }
                            function.flow.ret(ConstExpressions.call(theImplementation, callValues, null), null);
                        } else {
                            ExportableFunction function = module.getFunctions().newFunction(WASMWriterUtils.toMethodName(theLinkedClass.getClassName(), theMethod.getName(), theSignature), params);
                            WeakFunctionReferenceCallable theImplementation = ConstExpressions.weakFunctionReference(WASMWriterUtils.toMethodName(aMethodMapEntry.getProvidingClass().getClassName(), theMethod.getName(), theSignature), null);
                            ArrayList<WASMValue> callValues = new ArrayList<WASMValue>();
                            for (Param p : params) {
                                callValues.add(ConstExpressions.getLocal(p, null));
                            }
                            function.flow.voidCall(theImplementation, callValues, null);
                        }
                    }
                    return;
                }
                if (theMethod.isConstructor() && !theLinkedClass.getBytecodeClass().getAccessFlags().isAbstract() && !theLinkedClass.getBytecodeClass().getAccessFlags().isInterface()) {
                    String theMethodName = WASMWriterUtils.toMethodName(theLinkedClass.getClassName(), "$newInstance", theMethod.getSignature());
                    ArrayList<Param> theParams = new ArrayList<Param>();
                    theParams.add(ConstExpressions.param("thisRef", PrimitiveType.i32));
                    for (int i = 0; i < theMethod.getSignature().getArguments().length; ++i) {
                        theParams.add(ConstExpressions.param("p" + i, WASMSSAASTWriter.toType(TypeRef.toType(theMethod.getSignature().getArguments()[i]))));
                    }
                    ExportableFunction theCreateFunction = module.getFunctions().newFunction(theMethodName, theParams, PrimitiveType.i32);
                    theCreateFunction.exportAs(theMethodName);
                    Local newInstance = theCreateFunction.newLocal("newInstance", PrimitiveType.i32);
                    NativeMemoryLayouter.MemoryLayout theLayout = theMemoryLayout.layoutFor(theLinkedClass.getClassName());
                    String theNewObjectMethodName = WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newObject", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
                    String theClassNameToCreate = WASMWriterUtils.toClassName(theLinkedClass.getClassName());
                    WeakFunctionReferenceCallable theClassInit = ConstExpressions.weakFunctionReference(theClassNameToCreate + "__init", null);
                    WeakFunctionReferenceCallable theFunction = ConstExpressions.weakFunctionReference(theNewObjectMethodName, null);
                    theCreateFunction.flow.setLocal(newInstance, ConstExpressions.call(theFunction, Arrays.asList(ConstExpressions.i32.c(0, null), ConstExpressions.i32.c(theLayout.instanceSize(), null), ConstExpressions.call(theClassInit, Collections.emptyList(), null), ConstExpressions.weakFunctionTableReference(theClassName + "__resolvevtableindex", null)), null), null);
                    String theConstructorMethod = WASMWriterUtils.toMethodName(theLinkedClass.getClassName(), theMethod.getName(), theMethod.getSignature());
                    WeakFunctionReferenceCallable theConsRef = ConstExpressions.weakFunctionReference(theConstructorMethod, null);
                    ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
                    theArguments.add(ConstExpressions.getLocal(newInstance, null));
                    for (int i = 0; i < theMethod.getSignature().getArguments().length; ++i) {
                        theArguments.add(ConstExpressions.getLocal(theCreateFunction.localByLabel("p" + i), null));
                    }
                    theCreateFunction.flow.voidCall(theConsRef, theArguments, null);
                    theCreateFunction.flow.ret(ConstExpressions.getLocal(newInstance, null), null);
                    theCreateFunction.toTable();
                }
                ProgramGenerator theGenerator = this.programGeneratorFactory.createFor(aLinkerContext, new WASMIntrinsics());
                Program theSSAProgram = theGenerator.generateFrom(aMethodMapEntry.getProvidingClass().getBytecodeClass(), theMethod);
                aOptions.getOptimizer().optimize(theSSAProgram.getControlFlowGraph(), aLinkerContext);
                AbstractAllocator theAllocator = aOptions.getAllocator().allocate(theSSAProgram, variable -> {
                    switch (variable.resolveType().resolve()) {
                        case INT: 
                        case LONG: 
                        case BYTE: 
                        case SHORT: 
                        case BOOLEAN: 
                        case CHAR: {
                            return TypeRef.Native.INT;
                        }
                        case DOUBLE: 
                        case FLOAT: {
                            return TypeRef.Native.FLOAT;
                        }
                        case REFERENCE: {
                            return TypeRef.Native.REFERENCE;
                        }
                    }
                    throw new IllegalArgumentException("Not supported type : " + variable.resolveType().resolve());
                }, aLinkerContext);
                ArrayList<Param> params = new ArrayList<Param>();
                if (theMethod.getAccessFlags().isStatic()) {
                    params.add(ConstExpressions.param("UNUSED", WASMSSAASTWriter.toType(TypeRef.Native.REFERENCE)));
                }
                for (Variable theVariable : theSSAProgram.getArguments()) {
                    params.add(ConstExpressions.param(theVariable.getName(), WASMSSAASTWriter.toType(theVariable.resolveType())));
                }
                String theFunctionLabel = WASMWriterUtils.toMethodName(theLinkedClass.getClassName(), theMethod.getName(), theSignature);
                if (!module.functionIndex().hasFunction(theFunctionLabel)) {
                    if (theSignature.getReturnType().isVoid()) {
                        instanceFunction = module.getFunctions().newFunction(WASMWriterUtils.toMethodName(theLinkedClass.getClassName(), theMethod.getName(), theSignature), params);
                    } else {
                        PrimitiveType returnType = WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getReturnType()));
                        instanceFunction = module.getFunctions().newFunction(WASMWriterUtils.toMethodName(theLinkedClass.getClassName(), theMethod.getName(), theSignature), params, returnType);
                    }
                } else {
                    instanceFunction = (ExportableFunction)module.functionIndex().firstByLabel(theFunctionLabel);
                }
                BytecodeAnnotation theExport = theMethod.getAttributes().getAnnotationByType(Export.class.getName());
                if (null != theExport) {
                    instanceFunction.exportAs(theExport.getElementValueByName("value").stringValue());
                }
                try {
                    List<Register> theRegister = theAllocator.assignedRegister();
                    for (Register r : theRegister) {
                        instanceFunction.newLocal(WASMSSAASTWriter.registerName(r), WASMSSAASTWriter.toType(r.getType()));
                    }
                    int paramIndex = -1;
                    if (theMethod.getAccessFlags().isStatic()) {
                        Param theParam = instanceFunction.getParams().get(++paramIndex);
                        theParam.renameTo("UNUSED");
                    }
                    for (Variable theVariable : theSSAProgram.getArguments()) {
                        Param theParam = instanceFunction.getParams().get(++paramIndex);
                        theParam.renameTo(theVariable.getName());
                    }
                    WASMSSAASTWriter writer = new WASMSSAASTWriter(theResolver, aLinkerContext, module, aOptions, theSSAProgram, theMemoryLayout, instanceFunction, theAllocator);
                    if (aOptions.isPreferStackifier()) {
                        try {
                            Stackifier st = new Stackifier(theSSAProgram.getControlFlowGraph());
                            writer.writeStackified(st);
                            aOptions.getLogger().debug("Method {}.{} successfully stackified ", new Object[]{theLinkedClass.getClassName().name(), theMethod.getName().stringValue()});
                        }
                        catch (HeadToHeadControlFlowException e) {
                            aOptions.getLogger().warn("Method {}.{} could not be stackified, using Relooper instead", new Object[]{theLinkedClass.getClassName().name(), theMethod.getName().stringValue()});
                            Relooper theRelooper = new Relooper(aOptions);
                            Relooper.Block theReloopedBlock = theRelooper.reloop(theSSAProgram.getControlFlowGraph());
                            writer.writeRelooped(theReloopedBlock);
                        }
                    } else {
                        Relooper theRelooper = new Relooper(aOptions);
                        Relooper.Block theReloopedBlock = theRelooper.reloop(theSSAProgram.getControlFlowGraph());
                        writer.writeRelooped(theReloopedBlock);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error relooping cfg for " + aMethodMapEntry.getProvidingClass().getBytecodeClass().getThisInfo().getConstant().stringValue() + "." + theMethod.getName().stringValue() + " " + theMethod.getSignature(), e);
                }
            });
        });
        ExportableFunction theInstanceOfHelper = module.getFunctions().newFunction("NEWINSTANCEHELPER", Collections.singletonList(ConstExpressions.param("runtimeClass", PrimitiveType.i32)), PrimitiveType.i32);
        aLinkerContext.linkedClasses().map(Edge::targetNode).forEach(search -> {
            if (!(search.getBytecodeClass().getAccessFlags().isAbstract() || search.getBytecodeClass().getAccessFlags().isInterface() || search.emulatedByRuntime())) {
                BytecodeResolvedMethods theResolved = search.resolvedMethods();
                theResolved.stream().filter(j -> j.getProvidingClass() == search).map(BytecodeResolvedMethods.MethodEntry::getValue).filter(j -> j.isConstructor() && j.getSignature().getArguments().length == 0).forEach(m -> {
                    Global theGlobal = theResolver.runtimeClassFor(search.getClassName());
                    String theNewInstanceMethodName = WASMWriterUtils.toMethodName(search.getClassName(), "$newInstance", m.getSignature());
                    Iff theIff = theInstanceOfHelper.flow.iff(search.getClassName().name(), ConstExpressions.i32.eq(ConstExpressions.getGlobal(theGlobal, null), ConstExpressions.getLocal(theInstanceOfHelper.localByLabel("runtimeClass"), null), null), null);
                    theIff.flow.ret(ConstExpressions.call(ConstExpressions.weakFunctionReference(theNewInstanceMethodName, null), Collections.singletonList(ConstExpressions.i32.c(0, null)), null), null);
                });
            }
        });
        theInstanceOfHelper.flow.unreachable(null);
        for (Map.Entry entry : theCallsites.entrySet()) {
            ExportableFunction theFunction = (ExportableFunction)module.functionIndex().firstByLabel((String)entry.getKey());
            Program theSSAProgram = ((CallSite)entry.getValue()).program;
            AbstractAllocator theAllocator = aOptions.getAllocator().allocate(theSSAProgram, variable -> {
                switch (variable.resolveType().resolve()) {
                    case INT: 
                    case LONG: 
                    case BYTE: 
                    case SHORT: 
                    case BOOLEAN: 
                    case CHAR: {
                        return TypeRef.Native.INT;
                    }
                    case DOUBLE: 
                    case FLOAT: {
                        return TypeRef.Native.FLOAT;
                    }
                    case REFERENCE: {
                        return TypeRef.Native.REFERENCE;
                    }
                }
                throw new IllegalArgumentException("Not supported type : " + variable.resolveType().resolve());
            }, aLinkerContext);
            for (Register r : theAllocator.assignedRegister()) {
                theFunction.newLocal(WASMSSAASTWriter.registerName(r), WASMSSAASTWriter.toType(r.getType()));
            }
            WASMSSAASTWriter writer = new WASMSSAASTWriter(theResolver, aLinkerContext, module, aOptions, theSSAProgram, theMemoryLayout, theFunction, theAllocator);
            writer.stackEnter();
            writer.writeExpressionList(((CallSite)entry.getValue()).bootstrapMethod.getExpressions());
        }
        String string = WASMWriterUtils.toClassName(theMemoryManagerClass.getClassName()) + "_INTnewObjectINTINTINT";
        ExportableFunction newRuntimeClassFunction = module.getFunctions().newFunction("newRuntimeClass", Arrays.asList(ConstExpressions.param("type", PrimitiveType.i32), ConstExpressions.param("staticSize", PrimitiveType.i32), ConstExpressions.param("enumValuesOffset", PrimitiveType.i32), ConstExpressions.param("nameStringPoolIndex", PrimitiveType.i32)), PrimitiveType.i32);
        Local newRef = newRuntimeClassFunction.newLocal("newRef", PrimitiveType.i32);
        newRuntimeClassFunction.flow.setLocal(newRef, ConstExpressions.call(module.functionIndex().firstByLabel(string), Arrays.asList(ConstExpressions.i32.c(0, null), ConstExpressions.getLocal(newRuntimeClassFunction.localByLabel("staticSize"), null), ConstExpressions.i32.c(-1, null), ConstExpressions.i32.c(module.getTables().funcTable().indexOf(runtimeResolvevtableindex), null)), null), null);
        newRuntimeClassFunction.flow.i32.store(12, ConstExpressions.getLocal(newRef, null), ConstExpressions.i32.add(ConstExpressions.getLocal(newRef, null), ConstExpressions.getLocal(newRuntimeClassFunction.localByLabel("enumValuesOffset"), null), null), null);
        newRuntimeClassFunction.flow.i32.store(16, ConstExpressions.getLocal(newRef, null), ConstExpressions.getLocal(newRuntimeClassFunction.localByLabel("nameStringPoolIndex"), null), null);
        newRuntimeClassFunction.flow.i32.store(20, ConstExpressions.getLocal(newRef, null), ConstExpressions.getLocal(newRuntimeClassFunction.localByLabel("type"), null), null);
        newRuntimeClassFunction.flow.ret(ConstExpressions.getLocal(newRef, null), null);
        ExportableFunction exportableFunction = module.getFunctions().newFunction("bootstrap", Collections.emptyList());
        exportableFunction.flow.setGlobal(stackTop, ConstExpressions.i32.sub(ConstExpressions.i32.mul(ConstExpressions.currentMemory(null), ConstExpressions.i32.c(65536, null), null), ConstExpressions.i32.c(1, null), null), null);
        aLinkerContext.linkedClasses().forEach(aEntry -> {
            BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
            if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                return;
            }
            if (theLinkedClass.emulatedByRuntime()) {
                return;
            }
            Global runtimeClassGlobal = module.globalsIndex().globalByLabel(WASMWriterUtils.toClassName(((BytecodeLinkedClass)aEntry.targetNode()).getClassName()) + "__runtimeclass");
            ArrayList<WASMValue> initArguments = new ArrayList<WASMValue>();
            initArguments.add(ConstExpressions.i32.c(theLinkedClass.getUniqueId(), null));
            NativeMemoryLayouter.MemoryLayout theLayout = theMemoryLayout.layoutFor(((BytecodeLinkedClass)aEntry.targetNode()).getClassName());
            initArguments.add(ConstExpressions.i32.c(theLayout.classSize(), null));
            BytecodeResolvedFields theStaticFields = theLinkedClass.resolvedFields();
            if (null != theStaticFields.fieldByName("$VALUES")) {
                initArguments.add(ConstExpressions.i32.c(theLayout.offsetForClassMember("$VALUES"), null));
            } else {
                initArguments.add(ConstExpressions.i32.c(-1, null));
            }
            StringValue theName = new StringValue(theLinkedClass.getClassName().name());
            Global theGlobal = theResolver.globalForStringFromPool(theName);
            initArguments.add(ConstExpressions.i32.c(theConstantPool.register(theName), null));
            bootstrap.flow.setGlobal(runtimeClassGlobal, ConstExpressions.call(newRuntimeClassFunction, initArguments, null), null);
        });
        NativeMemoryLayouter.MemoryLayout theStringMemoryLayout = theMemoryLayout.layoutFor(theStringClass.getClassName());
        List<StringValue> thePoolValues = theConstantPool.stringValues();
        for (int i = 0; i < thePoolValues.size(); ++i) {
            StringValue theConstantInPool = thePoolValues.get(i);
            String theData = theConstantInPool.getStringValue();
            int l = theData.length();
            int[] theDataCharacters = new int[l];
            for (int j = 0; j < l; ++j) {
                theDataCharacters[j] = theData.charAt(j);
            }
            Global theStringPool = module.getGlobals().globalsIndex().globalByLabel("stringPool" + i);
            Global theStringPoolData = module.getGlobals().newMutableGlobal("stringPool" + i + "__array", PrimitiveType.i32, ConstExpressions.i32.c(-1, null));
            String theMethodName = WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
            ArrayList<WASMValue> theMallocArguments = new ArrayList<WASMValue>();
            theMallocArguments.add(ConstExpressions.i32.c(0, null));
            theMallocArguments.add(ConstExpressions.i32.c(theDataCharacters.length, null));
            theMallocArguments.add(ConstExpressions.call(ConstExpressions.weakFunctionReference(WASMWriterUtils.toClassName(theArrayClass.getClassName()) + "__init", null), Collections.emptyList(), null));
            Object theVtableFunction = module.functionIndex().firstByLabel(WASMWriterUtils.toClassName(theArrayClass.getClassName()) + "__resolvevtableindex");
            theMallocArguments.add(ConstExpressions.i32.c(module.getTables().funcTable().indexOf((Function)theVtableFunction), null));
            exportableFunction.flow.setGlobal(theStringPoolData, ConstExpressions.call(module.functionIndex().firstByLabel(theMethodName), theMallocArguments, null), null);
            for (int j = 0; j < theDataCharacters.length; ++j) {
                int offset = 20 + j * 8;
                exportableFunction.flow.i32.store(offset, ConstExpressions.getGlobal(theStringPoolData, null), ConstExpressions.i32.c(theDataCharacters[j], null), null);
            }
            Object theMallocFunction = module.functionIndex().firstByLabel(WASMWriterUtils.toClassName(theMemoryManagerClass.getClassName()) + "_INTnewObjectINTINTINT");
            Object theStringVTable = module.functionIndex().firstByLabel(WASMWriterUtils.toClassName(theStringClass.getClassName()) + "__resolvevtableindex");
            exportableFunction.flow.setGlobal(theStringPool, ConstExpressions.call(theMallocFunction, Arrays.asList(ConstExpressions.i32.c(0, null), ConstExpressions.i32.c(theStringMemoryLayout.instanceSize(), null), ConstExpressions.i32.c(theStringClass.getUniqueId(), null), ConstExpressions.i32.c(module.getTables().funcTable().indexOf((Function)theStringVTable), null)), null), null);
            Object theStringConstructor = module.functionIndex().firstByLabel(WASMWriterUtils.toClassName(theStringClass.getClassName()) + "_VOID$init$A1BYTEBYTE");
            exportableFunction.flow.voidCall((Callable)theStringConstructor, Arrays.asList(ConstExpressions.getGlobal(theStringPool, null), ConstExpressions.getGlobal(theStringPoolData, null), ConstExpressions.i32.c(0, null)), null);
        }
        ExportableFunction theGet = module.getFunctions().newFunction("STRINGPOOL_GLOBAL_BY_INDEX", Collections.singletonList(ConstExpressions.param("index", PrimitiveType.i32)), PrimitiveType.i32);
        for (int i = 0; i < thePoolValues.size(); ++i) {
            Global theStringPool = module.getGlobals().globalsIndex().globalByLabel("stringPool" + i);
            Iff theIff = theGet.flow.iff("g" + i, ConstExpressions.i32.eq(ConstExpressions.getLocal(theGet.localByLabel("index"), null), ConstExpressions.i32.c(i, null), null), null);
            theIff.flow.ret(ConstExpressions.getGlobal(theStringPool, null), null);
        }
        theGet.flow.unreachable(null);
        aLinkerContext.linkedClasses().forEach(aEntry -> {
            if (((BytecodeLinkedClass)aEntry.targetNode()).emulatedByRuntime()) {
                return;
            }
            if (!Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
                String theClassName = WASMWriterUtils.toClassName(((BytecodeLinkedClass)aEntry.targetNode()).getClassName());
                Global theGlobal = module.globalsIndex().globalByLabel(theClassName + "__runtimeclass");
                ExportableFunction theClassInitFunction = module.getFunctions().newFunction(theClassName + "__init", PrimitiveType.i32);
                Iff check = theClassInitFunction.flow.iff("check", ConstExpressions.i32.ne(ConstExpressions.i32.load(8, ConstExpressions.getGlobal(theGlobal, null), null), ConstExpressions.i32.c(1, null), null), null);
                check.flow.i32.store(8, ConstExpressions.getGlobal(theGlobal, null), ConstExpressions.i32.c(1, null), null);
                if (!theLinkedClass.getClassName().name().equals(Object.class.getName())) {
                    BytecodeLinkedClass theSuper = theLinkedClass.getSuperClass();
                    String theSuperWASMName = WASMWriterUtils.toClassName(theSuper.getClassName());
                    check.flow.drop(ConstExpressions.call(ConstExpressions.weakFunctionReference(theSuperWASMName + "__init", null), Collections.emptyList(), null), null);
                }
                if (((BytecodeLinkedClass)aEntry.targetNode()).hasClassInitializer()) {
                    check.flow.voidCall(ConstExpressions.weakFunctionReference(theClassName + "_VOID$clinit$", null), Collections.singletonList(ConstExpressions.i32.c(-1, null)), null);
                }
                theClassInitFunction.flow.ret(ConstExpressions.getGlobal(theGlobal, null), null);
            }
        });
        GlobalsIndex globalIndex = module.globalsIndex();
        exportableFunction.flow.setGlobal(stackTop, ConstExpressions.i32.sub(ConstExpressions.getGlobal(stackTop, null), ConstExpressions.i32.c(globalIndex.size() * 4, null), null), null);
        for (int i = 0; i < globalIndex.size(); ++i) {
            Global global = globalIndex.get(i);
            exportableFunction.flow.i32.store(i * 4, ConstExpressions.getGlobal(stackTop, null), ConstExpressions.getGlobal(global, null), null);
        }
        exportableFunction.exportAs("bootstrap");
        String string2 = WASMWriterUtils.toClassName(theMemoryManagerClass.getClassName()) + "_INTnewObjectINTINTINT";
        newRef = newLambdaImplFunction.newLocal("newRef", PrimitiveType.i32);
        newLambdaImplFunction.flow.setLocal(newRef, ConstExpressions.call(module.functionIndex().firstByLabel(string2), Arrays.asList(ConstExpressions.i32.c(0, null), ConstExpressions.i32.c(16, null), ConstExpressions.getLocal(newLambdaImplFunction.localByLabel("type"), null), ConstExpressions.i32.c(module.getTables().funcTable().indexOf(lambdaStaticResolvevtableindex), null)), null), null);
        newLambdaImplFunction.flow.i32.store(8, ConstExpressions.getLocal(newRef, null), ConstExpressions.getLocal(newLambdaImplFunction.localByLabel("implMethodNumber"), null), null);
        newLambdaImplFunction.flow.i32.store(12, ConstExpressions.getLocal(newRef, null), ConstExpressions.getLocal(newLambdaImplFunction.localByLabel("staticArguments"), null), null);
        newLambdaImplFunction.flow.ret(ConstExpressions.getLocal(newRef, null), null);
        ExportableFunction exportableFunction2 = (ExportableFunction)module.functionIndex().firstByLabel(WASMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(aEntryPointClass), aEntryPointMethodName, aEntryPointSignatue));
        exportableFunction2.exportAs("main");
        boolean bl = false;
        while (var29_35 < methodHandles.size()) {
            MethodHandleExpression theMethodHandle = (MethodHandleExpression)methodHandles.get((int)var29_35);
            String theDelegateMethodName = "handle" + (int)var29_35;
            switch (theMethodHandle.getReferenceKind()) {
                case REF_invokeStatic: {
                    this.writeMethodHandleDelegateInvokeStatic(aLinkerContext, theMethodHandle, theDelegateMethodName, module);
                    break;
                }
                case REF_invokeVirtual: {
                    this.writeMethodHandleDelegateInvokeVirtual(aLinkerContext, theMethodHandle, theDelegateMethodName, module);
                    break;
                }
                case REF_invokeInterface: {
                    this.writeMethodHandleDelegateInvokeInterface(aLinkerContext, theMethodHandle, theDelegateMethodName, module);
                    break;
                }
                case REF_invokeSpecial: {
                    this.writeMethodHandleDelegateInvokeSpecial(aLinkerContext, theMethodHandle, theDelegateMethodName, module);
                    break;
                }
                case REF_newInvokeSpecial: {
                    this.writeMethodHandleDelegateNewInvokeSpecial(aLinkerContext, theMethodHandle, theDelegateMethodName, module);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not supported refkind for method handle " + (Object)((Object)theMethodHandle.getReferenceKind()));
                }
            }
            ++var29_35;
        }
        aLinkerContext.linkedClasses().map(Edge::targetNode).filter(t -> t.isCallback() && t.getBytecodeClass().getAccessFlags().isInterface()).forEach(t -> {
            BytecodeResolvedMethods theMethods = t.resolvedMethods();
            List availableCallbacks = theMethods.stream().filter(x -> !x.getValue().isConstructor() && !x.getValue().isClassInitializer() && x.getProvidingClass() == t).map(BytecodeResolvedMethods.MethodEntry::getValue).collect(Collectors.toList());
            if (availableCallbacks.size() > 0) {
                if (availableCallbacks.size() != 1) {
                    throw new IllegalStateException("Invalid number of callback methods available for type " + t.getClassName().name() + ", expected 1, got " + availableCallbacks.size());
                }
                BytecodeMethod theDelegateMethod = (BytecodeMethod)availableCallbacks.get(0);
                ArrayList<PrimitiveType> theSignatureParams = new ArrayList<PrimitiveType>();
                ArrayList<Param> theArguments = new ArrayList<Param>();
                theSignatureParams.add(PrimitiveType.i32);
                theArguments.add(ConstExpressions.param("target", PrimitiveType.i32));
                BytecodeTypeRef[] theSignatureArguments = theDelegateMethod.getSignature().getArguments();
                for (int i = 0; i < theSignatureArguments.length; ++i) {
                    PrimitiveType theSignatureType = WASMSSAASTWriter.toType(TypeRef.toType(theSignatureArguments[i]));
                    theArguments.add(ConstExpressions.param("param" + i, theSignatureType));
                    theSignatureParams.add(theSignatureType);
                }
                WASMType theCalledFunction = module.getTypes().typeFor(theSignatureParams);
                BytecodeVirtualMethodIdentifier theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(theDelegateMethod);
                String theFunctionName = WASMWriterUtils.toMethodName(t.getClassName(), theDelegateMethod.getName(), theDelegateMethod.getSignature());
                ExportableFunction theFunction = module.getFunctions().newFunction(theFunctionName, theArguments);
                WASMType theResolveType = module.getTypes().typeFor(Arrays.asList(PrimitiveType.i32, PrimitiveType.i32), PrimitiveType.i32);
                ArrayList<WASMValue> theResolveArgument = new ArrayList<WASMValue>();
                theResolveArgument.add(ConstExpressions.getLocal(theFunction.localByLabel("target"), null));
                theResolveArgument.add(ConstExpressions.i32.c(theMethodIdentifier.getIdentifier(), null));
                CallIndirect theIndex = ConstExpressions.call(theResolveType, theResolveArgument, ConstExpressions.i32.load(4, ConstExpressions.getLocal(theFunction.localByLabel("target"), null), null), null);
                ArrayList<WASMValue> theOtherArguments = new ArrayList<WASMValue>();
                theOtherArguments.add(ConstExpressions.getLocal(theFunction.localByLabel("target"), null));
                for (int i = 0; i < theSignatureArguments.length; ++i) {
                    theOtherArguments.add(ConstExpressions.getLocal(theFunction.localByLabel("param" + i), null));
                }
                theFunction.flow.voidCallIndirect(theCalledFunction, theOtherArguments, theIndex, null);
                theFunction.exportAs(theFunctionName);
            }
        });
        StringWriter stringWriter = new StringWriter();
        ByteArrayOutputStream theBinaryOutput = new ByteArrayOutputStream();
        StringWriter theBinarySourceMap = new StringWriter();
        try {
            PrintWriter theWriter = new PrintWriter(stringWriter);
            Exporter exporter = new Exporter(aOptions);
            exporter.export(module, theWriter);
            exporter.export(module, theBinaryOutput, theBinarySourceMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StringWriter theJSCode = new StringWriter();
        try (PrintWriter theWriter = new PrintWriter(theJSCode);){
            theWriter.println("var bytecoder = {");
            theWriter.println();
            theWriter.println("     runningInstance: undefined,");
            theWriter.println("     runningInstanceMemory: undefined,");
            theWriter.println("     exports: undefined,");
            theWriter.println("     referenceTable: ['EMPTY'],");
            theWriter.println("     callbacks: [],");
            theWriter.println("     filehandles: [],");
            theWriter.println();
            theWriter.println("     openForRead: function(path) {");
            theWriter.println("         try {");
            theWriter.println("             var request = new XMLHttpRequest();");
            theWriter.println("             request.open('GET',path,false);");
            theWriter.println("             request.overrideMimeType('text\\/plain; charset=x-user-defined');");
            theWriter.println("             request.send(null);");
            theWriter.println("             if (request.status == 200) {");
            theWriter.println("                var length = request.getResponseHeader('content-length');");
            theWriter.println("                var responsetext = request.response;");
            theWriter.println("                var buf = new ArrayBuffer(responsetext.length);");
            theWriter.println("                var bufView = new Uint8Array(buf);");
            theWriter.println("                for (var i=0, strLen=responsetext.length; i<strLen; i++) {");
            theWriter.println("                    bufView[i] = responsetext.charCodeAt(i) & 0xff;");
            theWriter.println("                }");
            theWriter.println("                var handle = bytecoder.filehandles.length;");
            theWriter.println("                bytecoder.filehandles[handle] = {");
            theWriter.println("                    currentpos: 0,");
            theWriter.println("                    data: bufView,");
            theWriter.println("                    size: length,");
            theWriter.println("                    skip0INTINT: function(handle,amount) {");
            theWriter.println("                        var remaining = this.size - this.currentpos;");
            theWriter.println("                        var possible = Math.min(remaining, amount);");
            theWriter.println("                        this.currentpos+=possible;");
            theWriter.println("                        return possible;");
            theWriter.println("                    },");
            theWriter.println("                    available0INT: function(handle) {");
            theWriter.println("                        return this.size - this.currentpos;");
            theWriter.println("                    },");
            theWriter.println("                    read0INT: function(handle) {");
            theWriter.println("                        return this.data[this.currentpos++];");
            theWriter.println("                    },");
            theWriter.println("                    readBytesINTL1BYTEINTINT: function(handle,target,offset,length) {");
            theWriter.println("                        if (length === 0) {");
            theWriter.println("                            return 0;");
            theWriter.println("                        }");
            theWriter.println("                        var remaining = this.size - this.currentpos;");
            theWriter.println("                        var possible = Math.min(remaining, length);");
            theWriter.println("                        if (possible === 0) {");
            theWriter.println("                            return -1;");
            theWriter.println("                        }");
            theWriter.println("                        for (var j=0;j<possible;j++) {");
            theWriter.println("                            bytecoder.runningInstanceMemory[target + 20 + offset * 8]=this.data[this.currentpos++];");
            theWriter.println("                            offset++;");
            theWriter.println("                        }");
            theWriter.println("                        return possible;");
            theWriter.println("                    }");
            theWriter.println("                };");
            theWriter.println("                return handle;");
            theWriter.println("            }");
            theWriter.println("            return -1;");
            theWriter.println("         } catch(e) {");
            theWriter.println("             return -1;");
            theWriter.println("         }");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     init: function(instance) {");
            theWriter.println("         bytecoder.runningInstance = instance;");
            theWriter.println("         bytecoder.runningInstanceMemory = new Uint8Array(instance.exports.memory.buffer);");
            theWriter.println("         bytecoder.exports = instance.exports;");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     initializeFileIO: function() {");
            theWriter.println("         var stddin = {");
            theWriter.println("         };");
            theWriter.println("         var stdout = {");
            theWriter.println("             buffer: \"\",");
            theWriter.println("             writeBytesINTL1BYTEINTINT: function(handle, data, offset, length) {");
            theWriter.println("                 if (length > 0) {");
            theWriter.println("                     var array = new Uint8Array(length);");
            theWriter.println("                     data+=20;");
            theWriter.println("                     for (var i = 0; i < length; i++) {");
            theWriter.println("                         array[i] = bytecoder.intInMemory(data);");
            theWriter.println("                         data+=8;");
            theWriter.println("                     }");
            theWriter.println("                     var asstring = String.fromCharCode.apply(null, array);");
            theWriter.println("                     for (var i=0;i<asstring.length;i++) {");
            theWriter.println("                         var c = asstring.charAt(i);");
            theWriter.println("                         if (c == '\\n') {");
            theWriter.println("                             console.log(stdout.buffer);");
            theWriter.println("                             stdout.buffer=\"\";");
            theWriter.println("                         } else {");
            theWriter.println("                             stdout.buffer = stdout.buffer.concat(c);");
            theWriter.println("                         }");
            theWriter.println("                     }");
            theWriter.println("                 }");
            theWriter.println("             },");
            theWriter.println("             close0INT: function(handle) {");
            theWriter.println("             },");
            theWriter.println("             writeIntINTINT: function(handle,value) {");
            theWriter.println("                 var c = String.fromCharCode(value);");
            theWriter.println("                 if (c == '\\n') {");
            theWriter.println("                     console.log(stdout.buffer);");
            theWriter.println("                     stdout.buffer=\"\";");
            theWriter.println("                 } else {");
            theWriter.println("                     stdout.buffer = stdout.buffer.concat(c);");
            theWriter.println("                 }");
            theWriter.println("             }");
            theWriter.println("         };");
            theWriter.println("         bytecoder.filehandles[0] = stddin;");
            theWriter.println("         bytecoder.filehandles[1] = stdout;");
            theWriter.println("         bytecoder.filehandles[2] = stdout;");
            theWriter.println("         bytecoder.exports.initDefaultFileHandles(-1,0,1,2);");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     intInMemory: function(value) {");
            theWriter.println("         return bytecoder.runningInstanceMemory[value]");
            theWriter.println("                + (bytecoder.runningInstanceMemory[value + 1] * 256)");
            theWriter.println("                + (bytecoder.runningInstanceMemory[value + 2] * 256 * 256)");
            theWriter.println("                + (bytecoder.runningInstanceMemory[value + 3] * 256 * 256 * 256);");
            theWriter.println("     },");
            int theStringDataOffset = theMemoryLayout.layoutFor(theStringClass.getClassName()).offsetForInstanceMember("value");
            theWriter.println();
            theWriter.println("     toJSString: function(value) {");
            theWriter.println("         var theByteArray = bytecoder.intInMemory(value + " + theStringDataOffset + ");");
            theWriter.println("         var theData = bytecoder.byteArraytoJSString(theByteArray);");
            theWriter.println("         return theData;");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     byteArraytoJSString: function(value) {");
            theWriter.println("         var theLength = bytecoder.intInMemory(value + 16);");
            theWriter.println("         var theData = '';");
            theWriter.println("         value = value + 20;");
            theWriter.println("         for (var i=0;i<theLength;i++) {");
            theWriter.println("             var theCharCode = bytecoder.intInMemory(value);");
            theWriter.println("             value = value + 8;");
            theWriter.println("             theData+= String.fromCharCode(theCharCode);");
            theWriter.println("         }");
            theWriter.println("         return theData;");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     toBytecoderReference: function(value) {");
            theWriter.println("         var index = bytecoder.referenceTable.indexOf(value);");
            theWriter.println("         if (index>=0) {");
            theWriter.println("             return index;");
            theWriter.println("         }");
            theWriter.println("         bytecoder.referenceTable.push(value);");
            theWriter.println("         return bytecoder.referenceTable.length - 1;");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     toJSReference: function(value) {");
            theWriter.println("         return bytecoder.referenceTable[value];");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     toBytecoderString: function(value) {");
            theWriter.println("         var newArray = bytecoder.exports.newByteArray(0, value.length);");
            theWriter.println("         for (var i=0;i<value.length;i++) {");
            theWriter.println("             bytecoder.exports.setByteArrayEntry(0,newArray,i,value.charCodeAt(i));");
            theWriter.println("         }");
            theWriter.println("         return bytecoder.exports.newStringUTF8(0, newArray);");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     registerCallback: function(ptr,callback) {");
            theWriter.println("         bytecoder.callbacks.push(ptr);");
            theWriter.println("         return callback;");
            theWriter.println("     },");
            theWriter.println();
            theWriter.println("     imports: {");
            theWriter.println("         stringutf16: {");
            theWriter.println("             isBigEndian: function() {return 1;},");
            theWriter.println("         },");
            theWriter.println("         system: {");
            theWriter.println("             currentTimeMillis: function() {return Date.now();},");
            theWriter.println("             nanoTime: function() {return Date.now() * 1000000;},");
            theWriter.println("         },");
            theWriter.println("         vm: {");
            theWriter.println("             newLambdaStaticInvocationStringMethodTypeMethodHandleObject: function() {},");
            theWriter.println("             newLambdaConstructorInvocationMethodTypeMethodHandleObject: function() {},");
            theWriter.println("             newLambdaInterfaceInvocationMethodTypeMethodHandleObject: function() {},");
            theWriter.println("             newLambdaVirtualInvocationMethodTypeMethodHandleObject: function() {},");
            theWriter.println("             newLambdaSpecialInvocationMethodTypeMethodHandleObject: function() {},");
            theWriter.println("         },");
            theWriter.println("         memorymanager: {");
            theWriter.println("             isUsedAsCallbackINT : function(thisref, ptr) {");
            theWriter.println("                 return bytecoder.callbacks.includes(ptr);");
            theWriter.println("             },");
            theWriter.println("             printObjectDebugInternalObjectINTINTBOOLEANBOOLEAN: function(thisref, ptr, indexAlloc, indexFree, usedByStack, usedByHeap) {");
            theWriter.println("                 console.log('Memory debug for ' + ptr);");
            theWriter.println("                 var theAllocatedBlock = ptr - 12;");
            theWriter.println("                 var theSize = bytecoder.intInMemory(theAllocatedBlock);");
            theWriter.println("                 var theNext = bytecoder.intInMemory(theAllocatedBlock +  4);");
            theWriter.println("                 var theSurvivorCount = bytecoder.intInMemory(theAllocatedBlock +  8);");
            theWriter.println("                 console.log(' Allocation starts at '+ theAllocatedBlock);");
            theWriter.println("                 console.log(' Size = ' + theSize + ', Next = ' + theNext);");
            theWriter.println("                 console.log(' GC survivor count        : ' + theSurvivorCount);");
            theWriter.println("                 console.log(' Index in allocation list : ' + indexAlloc);");
            theWriter.println("                 console.log(' Index in free list       : ' + indexFree);");
            theWriter.println("                 console.log(' Used by STACK            : ' + usedByStack);");
            theWriter.println("                 console.log(' Used by HEAP             : ' + usedByHeap);");
            theWriter.println("                 for (var i=0;i<theSize;i+=4) {");
            theWriter.println("                     console.log(' Memory offset +' + i + ' = ' + bytecoder.intInMemory( theAllocatedBlock + i));");
            theWriter.println("                 }");
            theWriter.println("             }");
            theWriter.println("         },");
            theWriter.println("         opaquearrays : {");
            theWriter.println("             createIntArrayINT: function(thisref, p1) {");
            theWriter.println("                 return bytecoder.toBytecoderReference(new Int32Array(p1));");
            theWriter.println("             },");
            theWriter.println("             createFloatArrayINT: function(thisref, p1) {");
            theWriter.println("                 return bytecoder.toBytecoderReference(new Float32Array(p1));");
            theWriter.println("             },");
            theWriter.println("             createObjectArray: function(thisref) {");
            theWriter.println("                 return bytecoder.toBytecoderReference([]);");
            theWriter.println("             },");
            theWriter.println("             createInt8ArrayINT: function(thisref, p1) {");
            theWriter.println("                 return bytecoder.toBytecoderReference(new Int8Array(p1));");
            theWriter.println("             },");
            theWriter.println("         },");
            theWriter.println("         float : {");
            theWriter.println("             floatToRawIntBitsFLOAT : function(thisref,value) {");
            theWriter.println("                 var fl = new Float32Array(1);");
            theWriter.println("                 fl[0] = value;");
            theWriter.println("                 var br = new Int32Array(fl.buffer);");
            theWriter.println("                 return br[0];");
            theWriter.println("             },");
            theWriter.println("             intBitsToFloatINT : function(thisref,value) {");
            theWriter.println("                 var fl = new Int32Array(1);");
            theWriter.println("                 fl[0] = value;");
            theWriter.println("                 var br = new Float32Array(fl.buffer);");
            theWriter.println("                 return br[0];");
            theWriter.println("             },");
            theWriter.println("         },");
            theWriter.println("         double : {");
            theWriter.println("             doubleToRawLongBitsDOUBLE : function(thisref, value) {");
            theWriter.println("                 var fl = new Float64Array(1);");
            theWriter.println("                 fl[0] = value;");
            theWriter.println("                 var br = new BigInt64Array(fl.buffer);");
            theWriter.println("                 return br[0];");
            theWriter.println("             },");
            theWriter.println("             longBitsToDoubleLONG : function(thisref, value) {");
            theWriter.println("                 var fl = new BigInt64Array(1);");
            theWriter.println("                 fl[0] = value;");
            theWriter.println("                 var br = new Float64Array(fl.buffer);");
            theWriter.println("                 return br[0];");
            theWriter.println("             },");
            theWriter.println("         },");
            theWriter.println("         math: {");
            theWriter.println("             floorDOUBLE: function (thisref, p1) {return Math.floor(p1);},");
            theWriter.println("             ceilDOUBLE: function (thisref, p1) {return Math.ceil(p1);},");
            theWriter.println("             sinDOUBLE: function (thisref, p1) {return Math.sin(p1);},");
            theWriter.println("             cosDOUBLE: function  (thisref, p1) {return Math.cos(p1);},");
            theWriter.println("             tanDOUBLE: function  (thisref, p1) {return Math.tan(p1);},");
            theWriter.println("             roundDOUBLE: function  (thisref, p1) {return Math.round(p1);},");
            theWriter.println("             sqrtDOUBLE: function(thisref, p1) {return Math.sqrt(p1);},");
            theWriter.println("             cbrtDOUBLE: function(thisref, p1) {return Math.cbrt(p1);},");
            theWriter.println("             add: function(thisref, p1, p2) {return p1 + p2;},");
            theWriter.println("             maxLONGLONG: function(thisref, p1, p2) { return Math.max(p1, p2);},");
            theWriter.println("             maxDOUBLEDOUBLE: function(thisref, p1, p2) { return Math.max(p1, p2);},");
            theWriter.println("             maxINTINT: function(thisref, p1, p2) { return Math.max(p1, p2);},");
            theWriter.println("             maxFLOATFLOAT: function(thisref, p1, p2) { return Math.max(p1, p2);},");
            theWriter.println("             minFLOATFLOAT: function(thisref, p1, p2) { return Math.min(p1, p2);},");
            theWriter.println("             minINTINT: function(thisref, p1, p2) { return Math.min(p1, p2);},");
            theWriter.println("             minLONGLONG: function(thisref, p1, p2) { return Math.min(p1, p2);},");
            theWriter.println("             minDOUBLEDOUBLE: function(thisref, p1, p2) { return Math.min(p1, p2);},");
            theWriter.println("             toRadiansDOUBLE: function(thisref, p1) {");
            theWriter.println("                 return p1 * (Math.PI / 180);");
            theWriter.println("             },");
            theWriter.println("             toDegreesDOUBLE: function(thisref, p1) {");
            theWriter.println("                 return p1 * (180 / Math.PI);");
            theWriter.println("             },");
            theWriter.println("             random: function(thisref) { return Math.random();},");
            theWriter.println("             logDOUBLE: function (thisref, p1) {return Math.log(p1);},");
            theWriter.println("             powDOUBLEDOUBLE: function (thisref, p1, p2) {return Math.pow(p1, p2);},");
            theWriter.println("             acosDOUBLE: function (thisref, p1, p2) {return Math.acos(p1);},");
            theWriter.println("             atan2DOUBLE: function (thisref, p1, p2) {return Math.atan2(p1);},");
            theWriter.println("         },");
            theWriter.println("         strictmath: {");
            theWriter.println("             floorDOUBLE: function (thisref, p1) {return Math.floor(p1);},");
            theWriter.println("             ceilDOUBLE: function (thisref, p1) {return Math.ceil(p1);},");
            theWriter.println("             sinDOUBLE: function (thisref, p1) {return Math.sin(p1);},");
            theWriter.println("             cosDOUBLE: function  (thisref, p1) {return Math.cos(p1);},");
            theWriter.println("             roundFLOAT: function  (thisref, p1) {return Math.round(p1);},");
            theWriter.println("             sqrtDOUBLE: function(thisref, p1) {return Math.sqrt(p1);},");
            theWriter.println("             atan2DOUBLEDOUBLE: function(thisref, p1) {return Math.sqrt(p1);},");
            theWriter.println("         },");
            theWriter.println("         runtime: {");
            theWriter.println("             nativewindow: function(caller) {return bytecoder.toBytecoderReference(window);},");
            theWriter.println("             nativeconsole: function(caller) {return bytecoder.toBytecoderReference(console);},");
            theWriter.println("         },");
            theWriter.println("         unixfilesystem :{");
            theWriter.println("             getBooleanAttributes0String : function(thisref,path) {");
            theWriter.println("                 var jsPath = bytecoder.toJSString(path);");
            theWriter.println("                 try {");
            theWriter.println("                     var request = new XMLHttpRequest();");
            theWriter.println("                     request.open('HEAD',jsPath,false);");
            theWriter.println("                     request.send(null);");
            theWriter.println("                     if (request.status == 200) {");
            theWriter.println("                         var length = request.getResponseHeader('content-length');");
            theWriter.println("                         return 0x01;");
            theWriter.println("                     }");
            theWriter.println("                     return 0;");
            theWriter.println("                 } catch(e) {");
            theWriter.println("                     return 0;");
            theWriter.println("                 }");
            theWriter.println("             },");
            theWriter.println("         },");
            theWriter.println("         nullpointerexception : {");
            theWriter.println("             getExtendedNPEMessage : function(thisref) {");
            theWriter.println("                 return 0;");
            theWriter.println("             },");
            theWriter.println("         },");
            theWriter.println("         fileoutputstream : {");
            theWriter.println("             writeBytesINTL1BYTEINTINT : function(thisref, handle, data, offset, length) {");
            theWriter.println("                 bytecoder.filehandles[handle].writeBytesINTL1BYTEINTINT(handle,data,offset,length);");
            theWriter.println("             },");
            theWriter.println("             writeIntINTINT : function(thisref, handle, intvalue) {");
            theWriter.println("                 bytecoder.filehandles[handle].writeIntINTINT(handle,intvalue);");
            theWriter.println("             },");
            theWriter.println("             close0INT : function(thisref,handle) {");
            theWriter.println("                 bytecoder.filehandles[handle].close0INT(handle);");
            theWriter.println("             },");
            theWriter.println("         },");
            theWriter.println("         fileinputstream : {");
            theWriter.println("             open0String : function(thisref,name) {");
            theWriter.println("                 return bytecoder.openForRead(bytecoder.toJSString(name));");
            theWriter.println("             },");
            theWriter.println("             read0INT : function(thisref,handle) {");
            theWriter.println("                 return bytecoder.filehandles[handle].read0INT(handle);");
            theWriter.println("             },");
            theWriter.println("             readBytesINTL1BYTEINTINT : function(thisref,handle,data,offset,length) {");
            theWriter.println("                 return bytecoder.filehandles[handle].readBytesINTL1BYTEINTINT(handle,data,offset,length);");
            theWriter.println("             },");
            theWriter.println("             skip0INTINT : function(thisref,handle,amount) {");
            theWriter.println("                 return bytecoder.filehandles[handle].skip0INTINT(handle,amount);");
            theWriter.println("             },");
            theWriter.println("             available0INT : function(thisref,handle) {");
            theWriter.println("                 return bytecoder.filehandles[handle].available0INT(handle);");
            theWriter.println("             },");
            theWriter.println("             close0INT : function(thisref,handle) {");
            theWriter.println("                 bytecoder.filehandles[handle].close0INT(handle);");
            theWriter.println("             },");
            theWriter.println("         },");
            theWriter.println("         inflater : {");
            theWriter.println("             initIDs : function(thisref) {");
            theWriter.println("             },");
            theWriter.println("             initBOOLEAN : function(thisref,nowrap) {");
            theWriter.println("             },");
            theWriter.println("             inflateBytesBytesLONGL1BYTEINTINTL1BYTEINTINT : function(thisref,addr,inputArray,inputOff,inputLen,outputArray,outputOff,outputLen) {");
            theWriter.println("             },");
            theWriter.println("             inflateBufferBytesLONGLONGINTL1BYTEINTINT : function(thisref,addr,inputAddress,inputLen,outputArray,outputOff,outputLen) {");
            theWriter.println("             },");
            theWriter.println("             endLONG : function(thisref,addr) {");
            theWriter.println("             },");
            theWriter.println("         },");
            Map<String, List<OpaqueReferenceMethod>> theMethods = opaqueReferenceMethods.stream().collect(Collectors.groupingBy(opaqueReferenceMethod -> ((OpaqueReferenceMethod)opaqueReferenceMethod).linkedClass.linkFor(opaqueReferenceMethod.getMethod()).getModuleName()));
            for (Map.Entry<String, List<OpaqueReferenceMethod>> theEntry : theMethods.entrySet()) {
                theWriter.print("         ");
                theWriter.print(theEntry.getKey());
                theWriter.println(": {");
                for (OpaqueReferenceMethod theMethod3 : theEntry.getValue()) {
                    String theConversionFunction;
                    BytecodeMethod theBytecdeMethod = theMethod3.getMethod();
                    BytecodeImportedLink theImportedLink = theMethod3.getLinkedClass().linkFor(theBytecdeMethod);
                    theWriter.print("             ");
                    theWriter.print(theImportedLink.getLinkName());
                    theWriter.print(": function(");
                    theWriter.print("target");
                    BytecodeMethodSignature theSignature = theBytecdeMethod.getSignature();
                    for (int i = 0; i < theSignature.getArguments().length; ++i) {
                        theWriter.print(",arg");
                        theWriter.print(i);
                    }
                    theWriter.println(") {");
                    String theMethodName = theBytecdeMethod.getName().stringValue();
                    BytecodeAnnotation theOpaqueProperty = theBytecdeMethod.getAttributes().getAnnotationByType(OpaqueProperty.class.getName());
                    BytecodeAnnotation theOpaqueIndex = theBytecdeMethod.getAttributes().getAnnotationByType(OpaqueIndexed.class.getName());
                    if (theOpaqueIndex != null) {
                        if (theSignature.getReturnType().isVoid()) {
                            theWriter.print("               ");
                            theWriter.print("bytecoder.referenceTable[target]");
                            theWriter.print("[arg0]");
                            String theConversionFunction2 = this.conversionFunctionToJSForOpaqueType(aLinkerContext, theSignature.getArguments()[1]);
                            if (theConversionFunction2 != null) {
                                theWriter.print("=");
                                theWriter.print(theConversionFunction2);
                                theWriter.println("(arg1);");
                            } else {
                                theWriter.println("=arg1;");
                            }
                        } else {
                            theWriter.print("               return ");
                            boolean theWriteClosingBraces = false;
                            String theConversionFunction3 = this.conversionFunctionToWASMForOpaqueType(aLinkerContext, theSignature.getReturnType());
                            if (theConversionFunction3 != null) {
                                theWriter.print(theConversionFunction3);
                                theWriter.print("(");
                                theWriteClosingBraces = true;
                            }
                            theWriter.print("bytecoder.referenceTable[target][arg0]");
                            if (theWriteClosingBraces) {
                                theWriter.print(")");
                            }
                            theWriter.println(";");
                        }
                    } else if (theOpaqueProperty != null) {
                        String theOpaquePropertyName;
                        BytecodeAnnotation.ElementValue theValue = theOpaqueProperty.getElementValueByName("value");
                        if (theValue == null) {
                            if (theMethodName.startsWith("get")) {
                                theOpaquePropertyName = theMethodName.substring(3);
                                theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                            } else if (theMethodName.startsWith("is")) {
                                theOpaquePropertyName = theMethodName.substring(2);
                                theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                            } else if (theMethodName.startsWith("set")) {
                                theOpaquePropertyName = theMethodName.substring(3);
                                theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                            } else {
                                theOpaquePropertyName = theMethodName;
                            }
                        } else {
                            theOpaquePropertyName = theValue.stringValue();
                        }
                        if (theSignature.getReturnType().isVoid()) {
                            theWriter.print("               ");
                            theWriter.print("bytecoder.referenceTable[target].");
                            theWriter.print(theOpaquePropertyName);
                            theConversionFunction = this.conversionFunctionToJSForOpaqueType(aLinkerContext, theSignature.getArguments()[0]);
                            if (theConversionFunction != null) {
                                theWriter.print("=");
                                theWriter.print(theConversionFunction);
                                theWriter.println("(arg0);");
                            } else {
                                theWriter.println("=arg0;");
                            }
                        } else {
                            theWriter.print("               return ");
                            boolean theWriteClosingBraces = false;
                            String theConversionFunction4 = this.conversionFunctionToWASMForOpaqueType(aLinkerContext, theSignature.getReturnType());
                            if (theConversionFunction4 != null) {
                                theWriter.print(theConversionFunction4);
                                theWriter.print("(");
                                theWriteClosingBraces = true;
                            }
                            theWriter.print("bytecoder.referenceTable[target].");
                            theWriter.print(theOpaquePropertyName);
                            if (theWriteClosingBraces) {
                                theWriter.print(")");
                            }
                            theWriter.println(";");
                        }
                    } else {
                        BytecodeAnnotation theMethodAnnotation = theBytecdeMethod.getAttributes().getAnnotationByType(OpaqueMethod.class.getName());
                        if (theMethodAnnotation != null) {
                            theMethodName = theMethodAnnotation.getElementValueByName("value").stringValue();
                        }
                        boolean theWriteClosingBraces = false;
                        if (!theSignature.getReturnType().isVoid()) {
                            theWriter.print("               return ");
                            theConversionFunction = this.conversionFunctionToWASMForOpaqueType(aLinkerContext, theSignature.getReturnType());
                            if (theConversionFunction != null) {
                                theWriter.print(theConversionFunction);
                                theWriter.print("(");
                                theWriteClosingBraces = true;
                            }
                        } else {
                            theWriter.print("               ");
                        }
                        theWriter.print("bytecoder.referenceTable[target].");
                        theWriter.print(theMethodName);
                        theWriter.print("(");
                        for (int i = 0; i < theSignature.getArguments().length; ++i) {
                            BytecodeTypeRef theRef;
                            if (i > 0) {
                                theWriter.print(",");
                            }
                            if ((theRef = theSignature.getArguments()[i]).isPrimitive()) {
                                theWriter.print("arg");
                                theWriter.print(i);
                                continue;
                            }
                            if (theRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
                                theWriter.print("bytecoder.toJSString(");
                                theWriter.print("arg");
                                theWriter.print(i);
                                theWriter.print(")");
                                continue;
                            }
                            BytecodeObjectTypeRef theObjectType = (BytecodeObjectTypeRef)theRef;
                            BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(theObjectType);
                            if (theLinkedClass.isOpaqueType()) {
                                theWriter.print("bytecoder.toJSReference(");
                                theWriter.print("arg");
                                theWriter.print(i);
                                theWriter.print(")");
                                continue;
                            }
                            if (theLinkedClass.isCallback()) {
                                int j;
                                List theCallbackMethods = theLinkedClass.resolvedMethods().stream().filter(x -> x.getProvidingClass() == theLinkedClass).map(BytecodeResolvedMethods.MethodEntry::getValue).collect(Collectors.toList());
                                if (theCallbackMethods.size() != 1) {
                                    throw new IllegalStateException("Wrong number of callback methods in " + theLinkedClass.getClassName().name() + ", expected 1, got " + theCallbackMethods.size());
                                }
                                BytecodeMethod theImpl = (BytecodeMethod)theCallbackMethods.get(0);
                                theWriter.print("bytecoder.registerCallback(arg");
                                theWriter.print(i);
                                theWriter.print(",function (");
                                for (int j2 = 0; j2 < theImpl.getSignature().getArguments().length; ++j2) {
                                    if (j2 > 0) {
                                        theWriter.print(",");
                                    }
                                    theWriter.print("farg");
                                    theWriter.print(j2);
                                }
                                theWriter.print(") {");
                                for (int j2 = 0; j2 < theImpl.getSignature().getArguments().length; ++j2) {
                                    theWriter.print("var marg");
                                    theWriter.print(j2);
                                    theWriter.print("=");
                                    BytecodeTypeRef theTypeRef = theImpl.getSignature().getArguments()[j2];
                                    if (theTypeRef.isPrimitive()) {
                                        theWriter.print("farg");
                                        theWriter.print(j2);
                                    } else {
                                        if (theTypeRef.isArray()) {
                                            throw new IllegalStateException("Type conversion to " + theTypeRef.name() + " is not supported!");
                                        }
                                        if (theTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
                                            theWriter.print("bytecoder.toBytecoderString(");
                                            theWriter.print("farg");
                                            theWriter.print(j2);
                                            theWriter.print(")");
                                        } else {
                                            BytecodeObjectTypeRef theArgObjectType = (BytecodeObjectTypeRef)theTypeRef;
                                            BytecodeLinkedClass theArgLinkedClass = aLinkerContext.resolveClass(theArgObjectType);
                                            if (!theArgLinkedClass.isOpaqueType()) {
                                                throw new IllegalStateException("Type conversion from " + theTypeRef.name() + " is not supported!");
                                            }
                                            theWriter.print("bytecoder.toBytecoderReference(");
                                            theWriter.print("farg");
                                            theWriter.print(j2);
                                            theWriter.print(")");
                                        }
                                    }
                                    theWriter.print(";");
                                }
                                String theCallbackMethod = WASMWriterUtils.toMethodName(theLinkedClass.getClassName(), theImpl.getName(), theImpl.getSignature());
                                theWriter.print("bytecoder.exports.");
                                theWriter.print(theCallbackMethod);
                                theWriter.print("(arg");
                                theWriter.print(i);
                                for (j = 0; j < theImpl.getSignature().getArguments().length; ++j) {
                                    theWriter.print(",");
                                    theWriter.print("marg");
                                    theWriter.print(j);
                                }
                                theWriter.print(");");
                                for (j = 0; j < theImpl.getSignature().getArguments().length; ++j) {
                                    BytecodeLinkedClass theLinkedType;
                                    BytecodeTypeRef theTypeRef = theImpl.getSignature().getArguments()[j];
                                    if (theTypeRef.isPrimitive() || theTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class)) || !(theLinkedType = aLinkerContext.resolveClass((BytecodeObjectTypeRef)theTypeRef)).isEvent()) continue;
                                    theWriter.print("delete bytecoder.referenceTable[marg");
                                    theWriter.print(j);
                                    theWriter.print("];");
                                }
                                theWriter.print("})");
                                continue;
                            }
                            throw new IllegalStateException("Type conversion from " + theRef.name() + " is not supported!");
                        }
                        if (theWriteClosingBraces) {
                            theWriter.print(")");
                        }
                        theWriter.println(");");
                    }
                    theWriter.println("             },");
                }
                theWriter.println("         },");
            }
            theWriter.println("     },");
            theWriter.println("};");
        }
        return new WASMCompileResult(theMinifier, new WASMCompileResult.WASMTextualCompileResult(stringWriter.toString(), aOptions.getFilenamePrefix()), new WASMCompileResult.WASMBinaryCompileResult(theBinaryOutput.toByteArray(), aOptions.getFilenamePrefix()), new WASMCompileResult.WASMTextualJSCompileResult(theJSCode.toString(), aOptions.getFilenamePrefix()), new WASMCompileResult.WASMSourcemapCompileResult(theBinarySourceMap.toString(), aOptions.getFilenamePrefix()));
    }

    private String conversionFunctionToJSForOpaqueType(BytecodeLinkerContext alinkerContext, BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            return null;
        }
        if (aTypeRef.isArray()) {
            throw new IllegalStateException("Type conversion to " + aTypeRef.name() + " is not supported!");
        }
        if (aTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
            return "bytecoder.toJSString";
        }
        BytecodeObjectTypeRef theObjectType = (BytecodeObjectTypeRef)aTypeRef;
        BytecodeLinkedClass theLinkedClass = alinkerContext.resolveClass(theObjectType);
        if (theLinkedClass.isOpaqueType()) {
            return "bytecoder.toJSReference";
        }
        throw new IllegalStateException("Type conversion from " + aTypeRef.name() + " is not supported!");
    }

    private String conversionFunctionToWASMForOpaqueType(BytecodeLinkerContext alinkerContext, BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            return null;
        }
        if (aTypeRef.isArray()) {
            throw new IllegalStateException("Type conversion to " + aTypeRef.name() + " is not supported!");
        }
        if (aTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
            return "bytecoder.toBytecoderString";
        }
        BytecodeObjectTypeRef theObjectType = (BytecodeObjectTypeRef)aTypeRef;
        BytecodeLinkedClass theLinkedClass = alinkerContext.resolveClass(theObjectType);
        if (theLinkedClass.isOpaqueType()) {
            return "bytecoder.toBytecoderReference";
        }
        throw new IllegalStateException("Type conversion from " + aTypeRef.name() + " is not supported!");
    }

    private void writeMethodHandleDelegateInvokeStatic(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, Module aModule) {
        String theArgName;
        int k;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        ArrayList<Param> theArgs = new ArrayList<Param>();
        theArgs.add(ConstExpressions.param("lambdaRef", PrimitiveType.i32));
        for (int k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            String theArgName2 = "captureArg" + k2;
            PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]));
            theArgs.add(ConstExpressions.param(theArgName2, theType));
        }
        ExportableFunction theAdapter = theSignature.getReturnType().isVoid() ? aModule.getFunctions().newFunction(aDelegateMethodName, theArgs).toTable() : aModule.getFunctions().newFunction(aDelegateMethodName, theArgs, WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getReturnType()))).toTable();
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            Local theStaticData = theAdapter.newLocal("staticData", PrimitiveType.i32);
            theAdapter.flow.setLocal(theStaticData, ConstExpressions.i32.load(12, ConstExpressions.getLocal(theAdapter.localByLabel("lambdaRef"), null), null), null);
            block5: for (int k3 = 0; k3 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k3) {
                String theArgName3 = "linkArg" + k3;
                PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k3]));
                Local theLocal = theAdapter.newLocal(theArgName3, theType);
                switch (theType) {
                    case f32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.f32.load(20 + k3 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    case i32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.i32.load(20 + k3 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Not supported type for link arg " + (Object)((Object)theType));
                    }
                }
            }
        }
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getLinkageSignature().getArguments()));
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getCaptureSignature().getArguments()));
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
        theArguments.add(ConstExpressions.i32.c(0, null));
        for (k = 0; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        Object theCallee = aModule.functionIndex().firstByLabel(WASMWriterUtils.toMethodName(aMethodHandle.getClassName(), aMethodHandle.getMethodName(), theEffectiveSignature));
        if (theSignature.getReturnType().isVoid()) {
            theAdapter.flow.voidCall((Callable)theCallee, (List<WASMValue>)theArguments, null);
        } else {
            theAdapter.flow.ret(ConstExpressions.call(theCallee, theArguments, null), null);
        }
    }

    private void writeMethodHandleDelegateInvokeVirtual(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, Module aModule) {
        String theArgName;
        int k;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        ArrayList<Param> theArgs = new ArrayList<Param>();
        theArgs.add(ConstExpressions.param("lambdaRef", PrimitiveType.i32));
        for (int k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            String theArgName2 = "captureArg" + k2;
            PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]));
            theArgs.add(ConstExpressions.param(theArgName2, theType));
        }
        ExportableFunction theAdapter = theSignature.getReturnType().isVoid() ? aModule.getFunctions().newFunction(aDelegateMethodName, theArgs).toTable() : aModule.getFunctions().newFunction(aDelegateMethodName, theArgs, WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getReturnType()))).toTable();
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            Local theStaticData = theAdapter.newLocal("staticData", PrimitiveType.i32);
            theAdapter.flow.setLocal(theStaticData, ConstExpressions.i32.load(12, ConstExpressions.getLocal(theAdapter.localByLabel("lambdaRef"), null), null), null);
            block5: for (int k3 = 0; k3 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k3) {
                String theArgName3 = "linkArg" + k3;
                PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k3]));
                Local theLocal = theAdapter.newLocal(theArgName3, theType);
                switch (theType) {
                    case f32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.f32.load(20 + k3 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    case i32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.i32.load(20 + k3 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Not supported type for link arg " + (Object)((Object)theType));
                    }
                }
            }
        }
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        for (int k4 = 1; k4 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k4) {
            theEffectiveSignatureArguments.add(theAdapterAnnotation.getLinkageSignature().getArguments()[k4]);
        }
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getCaptureSignature().getArguments()));
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        BytecodeVirtualMethodIdentifier theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(aMethodHandle.getMethodName(), theEffectiveSignature);
        ArrayList<PrimitiveType> theSignatureParams = new ArrayList<PrimitiveType>();
        theSignatureParams.add(PrimitiveType.i32);
        for (int i = 0; i < theEffectiveSignature.getArguments().length; ++i) {
            BytecodeTypeRef theParamType = theEffectiveSignature.getArguments()[i];
            theSignatureParams.add(WASMSSAASTWriter.toType(TypeRef.toType(theParamType)));
        }
        WASMType theCalledFunctionType = !theEffectiveSignature.getReturnType().isVoid() ? aModule.getTypes().typeFor(theSignatureParams, WASMSSAASTWriter.toType(TypeRef.toType(theEffectiveSignature.getReturnType()))) : aModule.getTypes().typeFor(theSignatureParams);
        WASMType theResolveType = aModule.getTypes().typeFor(Arrays.asList(PrimitiveType.i32, PrimitiveType.i32), PrimitiveType.i32);
        ArrayList<WASMValue> theResolveArgument = new ArrayList<WASMValue>();
        Local theTarget = theAdapter.localByLabel("linkArg0");
        theResolveArgument.add(ConstExpressions.getLocal(theTarget, null));
        theResolveArgument.add(ConstExpressions.i32.c(theMethodIdentifier.getIdentifier(), null));
        CallIndirect theIndex = ConstExpressions.call(theResolveType, theResolveArgument, ConstExpressions.i32.load(4, ConstExpressions.getLocal(theTarget, null), null), null);
        ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
        theArguments.add(ConstExpressions.getLocal(theTarget, null));
        for (k = 1; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        if (theSignature.getReturnType().isVoid()) {
            theAdapter.flow.voidCallIndirect(theCalledFunctionType, theArguments, theIndex, null);
        } else {
            theAdapter.flow.ret(ConstExpressions.call(theCalledFunctionType, theArguments, theIndex, null), null);
        }
    }

    private void writeMethodHandleDelegateNewInvokeSpecial(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, Module aModule) {
        String theArgName;
        int k;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        ArrayList<Param> theArgs = new ArrayList<Param>();
        theArgs.add(ConstExpressions.param("lambdaRef", PrimitiveType.i32));
        for (int k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            String theArgName2 = "captureArg" + k2;
            PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]));
            theArgs.add(ConstExpressions.param(theArgName2, theType));
        }
        ExportableFunction theAdapter = aModule.getFunctions().newFunction(aDelegateMethodName, theArgs, PrimitiveType.i32).toTable();
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            Local theStaticData = theAdapter.newLocal("staticData", PrimitiveType.i32);
            theAdapter.flow.setLocal(theStaticData, ConstExpressions.i32.load(12, ConstExpressions.getLocal(theAdapter.localByLabel("lambdaRef"), null), null), null);
            block5: for (int k3 = 0; k3 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k3) {
                String theArgName3 = "linkArg" + k3;
                PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k3]));
                Local theLocal = theAdapter.newLocal(theArgName3, theType);
                switch (theType) {
                    case f32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.f32.load(20 + k3 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    case i32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.i32.load(20 + k3 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Not supported type for link arg " + (Object)((Object)theType));
                    }
                }
            }
        }
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getLinkageSignature().getArguments()));
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getCaptureSignature().getArguments()));
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(Object.class), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
        theArguments.add(ConstExpressions.i32.c(0, null));
        for (k = 0; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        Object theCallee = aModule.functionIndex().firstByLabel(WASMWriterUtils.toMethodName(aMethodHandle.getClassName(), "$newInstance", new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignature.getArguments())));
        theAdapter.flow.ret(ConstExpressions.call(theCallee, theArguments, null), null);
    }

    private void writeMethodHandleDelegateInvokeSpecial(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, Module aModule) {
        String theArgName;
        int k;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        ArrayList<Param> theArgs = new ArrayList<Param>();
        theArgs.add(ConstExpressions.param("lambdaRef", PrimitiveType.i32));
        for (int k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            String theArgName2 = "captureArg" + k2;
            PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]));
            theArgs.add(ConstExpressions.param(theArgName2, theType));
        }
        ExportableFunction theAdapter = theSignature.getReturnType().isVoid() ? aModule.getFunctions().newFunction(aDelegateMethodName, theArgs).toTable() : aModule.getFunctions().newFunction(aDelegateMethodName, theArgs, WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getReturnType()))).toTable();
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            Local theStaticData = theAdapter.newLocal("staticData", PrimitiveType.i32);
            theAdapter.flow.setLocal(theStaticData, ConstExpressions.i32.load(12, ConstExpressions.getLocal(theAdapter.localByLabel("lambdaRef"), null), null), null);
            block5: for (int k3 = 0; k3 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k3) {
                String theArgName3 = "linkArg" + k3;
                PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k3]));
                Local theLocal = theAdapter.newLocal(theArgName3, theType);
                switch (theType) {
                    case f32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.f32.load(20 + k3 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    case i32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.i32.load(20 + k3 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Not supported type for link arg " + (Object)((Object)theType));
                    }
                }
            }
        }
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        for (int k4 = 1; k4 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k4) {
            theEffectiveSignatureArguments.add(theAdapterAnnotation.getLinkageSignature().getArguments()[k4]);
        }
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getCaptureSignature().getArguments()));
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        Object theFunction = aModule.functionIndex().firstByLabel(WASMWriterUtils.toMethodName(aMethodHandle.getClassName(), aMethodHandle.getMethodName(), theEffectiveSignature));
        Local theTarget = theAdapter.localByLabel("linkArg0");
        ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
        theArguments.add(ConstExpressions.getLocal(theTarget, null));
        for (k = 1; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        if (theSignature.getReturnType().isVoid()) {
            theAdapter.flow.voidCall((Callable)theFunction, (List<WASMValue>)theArguments, null);
        } else {
            theAdapter.flow.ret(ConstExpressions.call(theFunction, theArguments, null), null);
        }
    }

    private void writeMethodHandleDelegateInvokeInterface(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, Module aModule) {
        String theArgName;
        int k;
        int k2;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        ArrayList<Param> theArgs = new ArrayList<Param>();
        theArgs.add(ConstExpressions.param("lambdaRef", PrimitiveType.i32));
        for (int k3 = 0; k3 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k3) {
            String theArgName2 = "captureArg" + k3;
            PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k3]));
            theArgs.add(ConstExpressions.param(theArgName2, theType));
        }
        ExportableFunction theAdapter = theSignature.getReturnType().isVoid() ? aModule.getFunctions().newFunction(aDelegateMethodName, theArgs).toTable() : aModule.getFunctions().newFunction(aDelegateMethodName, theArgs, WASMSSAASTWriter.toType(TypeRef.toType(theSignature.getReturnType()))).toTable();
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            Local theStaticData = theAdapter.newLocal("staticData", PrimitiveType.i32);
            theAdapter.flow.setLocal(theStaticData, ConstExpressions.i32.load(12, ConstExpressions.getLocal(theAdapter.localByLabel("lambdaRef"), null), null), null);
            block5: for (int k4 = 0; k4 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k4) {
                String theArgName3 = "linkArg" + k4;
                PrimitiveType theType = WASMSSAASTWriter.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k4]));
                Local theLocal = theAdapter.newLocal(theArgName3, theType);
                switch (theType) {
                    case f32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.f32.load(20 + k4 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    case i32: {
                        theAdapter.flow.setLocal(theLocal, ConstExpressions.i32.load(20 + k4 * 8, ConstExpressions.getLocal(theStaticData, null), null), null);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Not supported type for link arg " + (Object)((Object)theType));
                    }
                }
            }
        }
        String theTargetName = null;
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        for (k2 = 0; k2 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k2) {
            if (theTargetName == null) {
                theTargetName = "linkArg" + k2;
                continue;
            }
            theEffectiveSignatureArguments.add(theAdapterAnnotation.getLinkageSignature().getArguments()[k2]);
        }
        for (k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            if (theTargetName == null) {
                theTargetName = "captureArg" + k2;
                continue;
            }
            theEffectiveSignatureArguments.add(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]);
        }
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        BytecodeVirtualMethodIdentifier theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(aMethodHandle.getMethodName(), theEffectiveSignature);
        ArrayList<PrimitiveType> theSignatureParams = new ArrayList<PrimitiveType>();
        theSignatureParams.add(PrimitiveType.i32);
        for (int i = 0; i < theEffectiveSignature.getArguments().length; ++i) {
            BytecodeTypeRef theParamType = theEffectiveSignature.getArguments()[i];
            theSignatureParams.add(WASMSSAASTWriter.toType(TypeRef.toType(theParamType)));
        }
        WASMType theCalledFunction = !theEffectiveSignature.getReturnType().isVoid() ? aModule.getTypes().typeFor(theSignatureParams, WASMSSAASTWriter.toType(TypeRef.toType(theEffectiveSignature.getReturnType()))) : aModule.getTypes().typeFor(theSignatureParams);
        WASMType theResolveType = aModule.getTypes().typeFor(Arrays.asList(PrimitiveType.i32, PrimitiveType.i32), PrimitiveType.i32);
        ArrayList<WASMValue> theResolveArgument = new ArrayList<WASMValue>();
        Local theTarget = theAdapter.localByLabel(theTargetName);
        theResolveArgument.add(ConstExpressions.getLocal(theTarget, null));
        theResolveArgument.add(ConstExpressions.i32.c(theMethodIdentifier.getIdentifier(), null));
        CallIndirect theIndex = ConstExpressions.call(theResolveType, theResolveArgument, ConstExpressions.i32.load(4, ConstExpressions.getLocal(theTarget, null), null), null);
        ArrayList<WASMValue> theArguments = new ArrayList<WASMValue>();
        theArguments.add(ConstExpressions.getLocal(theTarget, null));
        for (k = 0; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            if (theArgName.equals(theTargetName)) continue;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            if (theArgName.equals(theTargetName)) continue;
            theArguments.add(ConstExpressions.getLocal(theAdapter.localByLabel(theArgName), null));
        }
        if (theSignature.getReturnType().isVoid()) {
            theAdapter.flow.voidCallIndirect(theCalledFunction, theArguments, theIndex, null);
        } else {
            theAdapter.flow.ret(ConstExpressions.call(theCalledFunction, theArguments, theIndex, null), null);
        }
    }

    private static class OpaqueReferenceMethod {
        private final BytecodeLinkedClass linkedClass;
        private final BytecodeMethod method;

        public OpaqueReferenceMethod(BytecodeLinkedClass linkedClass, BytecodeMethod method) {
            this.linkedClass = linkedClass;
            this.method = method;
        }

        public BytecodeLinkedClass getLinkedClass() {
            return this.linkedClass;
        }

        public BytecodeMethod getMethod() {
            return this.method;
        }
    }

    private static class CallSite {
        private final Program program;
        private final RegionNode bootstrapMethod;

        private CallSite(Program aProgram, RegionNode aBootstrapMethod) {
            this.program = aProgram;
            this.bootstrapMethod = aBootstrapMethod;
        }
    }
}

