/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm;

import de.mirkosertic.bytecoder.backend.CompileResult;
import de.mirkosertic.bytecoder.backend.wasm.WASMMinifier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class WASMCompileResult
extends CompileResult<String> {
    private final WASMMinifier minifier;

    public WASMCompileResult(WASMMinifier minifier, WASMCompileContent ... content) {
        this.minifier = minifier;
        for (WASMCompileContent c : content) {
            this.add(c);
        }
    }

    public WASMMinifier getMinifier() {
        return this.minifier;
    }

    public static class WASMBinaryCompileResult
    extends WASMCompileContent {
        private final byte[] data;
        private final String filenamePrefix;

        public WASMBinaryCompileResult(byte[] data, String filenamePrefix) {
            this.data = data;
            this.filenamePrefix = filenamePrefix;
        }

        @Override
        public String getFileName() {
            return this.filenamePrefix + ".wasm";
        }

        @Override
        public void writeTo(OutputStream stream) throws IOException {
            stream.write(this.data);
        }
    }

    public static class WASMSourcemapCompileResult
    extends WASMCompileContent {
        private final String data;
        private final String filenamePrefix;

        public WASMSourcemapCompileResult(String data, String afilenamePrefix) {
            this.data = data;
            this.filenamePrefix = afilenamePrefix;
        }

        @Override
        public String getFileName() {
            return this.filenamePrefix + ".wasm.map";
        }

        @Override
        public void writeTo(OutputStream stream) {
            try (PrintStream ps = new PrintStream(stream);){
                ps.print(this.data);
            }
        }
    }

    public static class WASMTextualJSCompileResult
    extends WASMCompileContent {
        private final String data;
        private final String filenamePrefix;

        public WASMTextualJSCompileResult(String data, String afilenamePrefix) {
            this.data = data;
            this.filenamePrefix = afilenamePrefix;
        }

        @Override
        public String getFileName() {
            return this.filenamePrefix + ".js";
        }

        @Override
        public void writeTo(OutputStream stream) {
            try (PrintStream ps = new PrintStream(stream);){
                ps.print(this.data);
            }
        }
    }

    public static class WASMTextualCompileResult
    extends WASMCompileContent {
        private final String data;
        private final String filenamePrefix;

        public WASMTextualCompileResult(String data, String afilenamePrefix) {
            this.data = data;
            this.filenamePrefix = afilenamePrefix;
        }

        @Override
        public String getFileName() {
            return this.filenamePrefix + ".wat";
        }

        @Override
        public void writeTo(OutputStream stream) {
            try (PrintStream ps = new PrintStream(stream);){
                ps.print(this.data);
            }
        }
    }

    public static abstract class WASMCompileContent
    implements CompileResult.Content {
    }
}

