/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.opencl;

import de.mirkosertic.bytecoder.allocator.AbstractAllocator;
import de.mirkosertic.bytecoder.allocator.Register;
import de.mirkosertic.bytecoder.api.opencl.OpenCLFunction;
import de.mirkosertic.bytecoder.api.opencl.OpenCLType;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.IndentSSAWriter;
import de.mirkosertic.bytecoder.backend.opencl.OpenCLInputOutputs;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeFieldRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedMethods;
import de.mirkosertic.bytecoder.relooper.Relooper;
import de.mirkosertic.bytecoder.ssa.ArrayEntryExpression;
import de.mirkosertic.bytecoder.ssa.ArrayStoreExpression;
import de.mirkosertic.bytecoder.ssa.BinaryExpression;
import de.mirkosertic.bytecoder.ssa.BreakExpression;
import de.mirkosertic.bytecoder.ssa.CompareExpression;
import de.mirkosertic.bytecoder.ssa.ContinueExpression;
import de.mirkosertic.bytecoder.ssa.DirectInvokeMethodExpression;
import de.mirkosertic.bytecoder.ssa.DoubleValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.FloatValue;
import de.mirkosertic.bytecoder.ssa.FloorExpression;
import de.mirkosertic.bytecoder.ssa.GetFieldExpression;
import de.mirkosertic.bytecoder.ssa.IFElseExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.IntegerValue;
import de.mirkosertic.bytecoder.ssa.InvokeStaticMethodExpression;
import de.mirkosertic.bytecoder.ssa.InvokeVirtualMethodExpression;
import de.mirkosertic.bytecoder.ssa.Label;
import de.mirkosertic.bytecoder.ssa.LongValue;
import de.mirkosertic.bytecoder.ssa.PHIValue;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.PutFieldExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.ReturnExpression;
import de.mirkosertic.bytecoder.ssa.ReturnValueExpression;
import de.mirkosertic.bytecoder.ssa.TypeConversionExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import de.mirkosertic.bytecoder.stackifier.Block;
import de.mirkosertic.bytecoder.stackifier.Stackifier;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;

public class OpenCLWriter
extends IndentSSAWriter {
    private final OpenCLInputOutputs inputOutputs;
    private final BytecodeLinkedClass kernelClass;
    private final AtomicBoolean stackifierOutout;
    private final Set<Label> recordedNextLabels;
    private AbstractAllocator allocator;

    public OpenCLWriter(BytecodeLinkedClass aKernelClass, CompileOptions aOptions, Program aProgram, PrintWriter aWriter, BytecodeLinkerContext aLinkerContext, OpenCLInputOutputs aInputOutputs) {
        this(aKernelClass, aOptions, aProgram, "", aWriter, aLinkerContext, aInputOutputs, new AtomicBoolean(false), new HashSet<Label>(), null);
    }

    private OpenCLWriter(BytecodeLinkedClass aKernelClass, CompileOptions aOptions, Program aProgram, String aIndent, PrintWriter aWriter, BytecodeLinkerContext aLinkerContext, OpenCLInputOutputs aInputOutputs, AtomicBoolean aStackifierOutout, Set<Label> aRecordedNextLabels, AbstractAllocator aRegisterAllocator) {
        super(aOptions, aProgram, aIndent, aWriter, aLinkerContext);
        this.inputOutputs = aInputOutputs;
        this.kernelClass = aKernelClass;
        this.stackifierOutout = aStackifierOutout;
        this.recordedNextLabels = aRecordedNextLabels;
        this.allocator = aRegisterAllocator;
    }

    public void printReloopedKernel(Relooper.Block aBlock, AbstractAllocator registerAllocator) {
        this.stackifierOutout.set(false);
        this.allocator = registerAllocator;
        this.print("__kernel void BytecoderKernel(");
        this.printInputOutputArgs(this.inputOutputs.arguments());
        this.println(") {");
        OpenCLWriter theDeeper = this.withDeeperIndent();
        theDeeper.println("int $__label__ = 0;");
        this.printProgramVariablesDeclaration(this.program);
        theDeeper.print(aBlock);
        this.println("}");
    }

    public void printReloopedInline(BytecodeMethod aMethod, Program aProgram, Relooper.Block aBlock, AbstractAllocator registerAllocator) {
        this.stackifierOutout.set(false);
        this.allocator = registerAllocator;
        BytecodeMethodSignature theSignature = aMethod.getSignature();
        this.print("__inline ");
        this.print(this.toType(TypeRef.toType(theSignature.getReturnType())));
        this.print(" ");
        this.print(aMethod.getName().stringValue());
        this.print("(");
        this.printInputOutputArgs(this.inputOutputs.arguments());
        boolean theFirst = this.inputOutputs.arguments().isEmpty();
        List<Variable> theProgramArguments = aProgram.getArguments();
        for (int i = 1; i < theProgramArguments.size(); ++i) {
            Variable theVariable = theProgramArguments.get(i);
            if (theFirst) {
                theFirst = false;
            } else {
                this.print(", ");
            }
            this.print(this.toType(theVariable.resolveType()));
            this.print(" ");
            this.print(theVariable.getName());
        }
        this.println(") {");
        OpenCLWriter theDeeper = this.withDeeperIndent();
        theDeeper.println("int $__label__ = 0;");
        this.printProgramVariablesDeclaration(this.program);
        theDeeper.print(aBlock);
        this.println("}");
    }

    private void print(Relooper.Block aBlock) {
        if (aBlock == null) {
            return;
        }
        if (aBlock instanceof Relooper.SimpleBlock) {
            this.print((Relooper.SimpleBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.LoopBlock) {
            this.print((Relooper.LoopBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.MultipleBlock) {
            this.print((Relooper.MultipleBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.IFThenElseBlock) {
            this.print((Relooper.IFThenElseBlock)aBlock);
            return;
        }
        throw new IllegalStateException("Not implemented : " + aBlock);
    }

    private void print(Relooper.SimpleBlock aSimpleBlock) {
        OpenCLWriter theWriter = this;
        if (aSimpleBlock.isLabelRequired()) {
            this.print("$");
            this.print(aSimpleBlock.label().name());
            this.println(" :");
            theWriter = theWriter.withDeeperIndent();
        }
        theWriter.writeExpressions(aSimpleBlock.expressions());
        if (aSimpleBlock.next() != null) {
            this.print("$");
            this.print(aSimpleBlock.label().name());
            this.println("_next:");
            this.print(aSimpleBlock.next());
        }
    }

    private void print(Relooper.IFThenElseBlock aIfThenElseBlock) {
        OpenCLWriter theWriter = this;
        if (aIfThenElseBlock.isLabelRequired()) {
            this.print("$");
            this.print(aIfThenElseBlock.label().name());
            this.println(" :");
            theWriter = theWriter.withDeeperIndent();
        }
        theWriter.writeExpressions(aIfThenElseBlock.getPrelude());
        theWriter.print("if (");
        theWriter.printValue(aIfThenElseBlock.getCondition());
        theWriter.println(") {");
        theWriter.withDeeperIndent().print(aIfThenElseBlock.getTrueBlock());
        theWriter.println("} else {");
        theWriter.withDeeperIndent().print(aIfThenElseBlock.getFalseBlock());
        theWriter.println("}");
        if (aIfThenElseBlock.next() != null) {
            this.print("$");
            this.print(aIfThenElseBlock.label().name());
            this.println("_next:");
            this.print(aIfThenElseBlock.next());
        }
    }

    private void print(Relooper.LoopBlock aLoopBlock) {
        OpenCLWriter theWriter = this;
        if (aLoopBlock.isLabelRequired()) {
            this.print("$");
            this.print(aLoopBlock.label().name());
            this.println(" : ");
            theWriter = theWriter.withDeeperIndent();
        }
        theWriter.print(aLoopBlock.inner());
        if (aLoopBlock.next() != null) {
            this.print("$");
            this.print(aLoopBlock.label().name());
            this.println("_next:");
            this.print(aLoopBlock.next());
        }
    }

    private void print(Relooper.MultipleBlock aMultiple) {
        OpenCLWriter theWriter = this;
        if (aMultiple.isLabelRequired()) {
            this.print("$");
            this.print(aMultiple.label().name());
            this.print(" : ");
            theWriter = theWriter.withDeeperIndent();
        }
        this.println("switch ($__label__) {");
        for (Relooper.Block theHandler : aMultiple.handlers()) {
            for (RegionNode theEntry : theHandler.entries()) {
                theWriter.print("case ");
                theWriter.print(theEntry.getStartAddress().getAddress());
                theWriter.println(" : ");
            }
            OpenCLWriter theHandlerWriter = theWriter.withDeeperIndent();
            theHandlerWriter.print(theHandler);
        }
        this.println("}");
        if (aMultiple.next() != null) {
            this.print("$");
            this.print(aMultiple.label().name());
            this.println("_next:");
            this.print(aMultiple.next());
        }
    }

    private OpenCLWriter withDeeperIndent() {
        return new OpenCLWriter(this.kernelClass, this.options, this.program, this.indent + "    ", this.writer, this.linkerContext, this.inputOutputs, this.stackifierOutout, this.recordedNextLabels, this.allocator);
    }

    private void printInstanceFieldReference(BytecodeFieldRefConstant aField) {
        this.print(".");
        this.print(aField.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
    }

    private void writeExpression(Expression expression) {
        Expression theE;
        String theComment;
        if (this.options.isDebugOutput() && (theComment = expression.getComment()) != null && !theComment.isEmpty()) {
            this.print("// ");
            this.println(theComment);
        }
        if (expression instanceof VariableAssignmentExpression) {
            VariableAssignmentExpression theInit = (VariableAssignmentExpression)expression;
            Variable theVariable = theInit.getVariable();
            Register r = this.allocator.registerAssignmentFor(theVariable);
            Value theValue = (Value)theInit.incomingDataFlows().get(0);
            this.print(this.registerName(r));
            this.print(" = ");
            this.printValue(theValue);
            this.println(";");
        } else if (expression instanceof ArrayStoreExpression) {
            ArrayStoreExpression theStore = (ArrayStoreExpression)expression;
            List theIncomingData = theStore.incomingDataFlows();
            Value theArray = (Value)theIncomingData.get(0);
            Value theIndex = (Value)theIncomingData.get(1);
            Value theValue = (Value)theIncomingData.get(2);
            this.printValue(theArray);
            this.print("[");
            this.printValue(theIndex);
            this.print("] = ");
            this.printValue(theValue);
            this.println(";");
        } else if (expression instanceof IFExpression) {
            theE = (IFExpression)expression;
            this.print("if ");
            this.printValue((Value)theE.incomingDataFlows().get(0));
            this.println(" {");
            this.withDeeperIndent().writeExpressions(((IFExpression)theE).getExpressions());
            this.println("}");
        } else if (expression instanceof BreakExpression) {
            BreakExpression theBreak = (BreakExpression)expression;
            if (theBreak.isSetLabelRequired() && !this.stackifierOutout.get()) {
                this.print("$__label__ = ");
                this.print(theBreak.jumpTarget().getAddress());
                this.println(";");
            }
            if (!theBreak.isSilent()) {
                this.print("goto $");
                this.print(theBreak.blockToBreak().name());
                this.println("_next;");
                this.recordedNextLabels.add(theBreak.blockToBreak());
            }
        } else if (expression instanceof ContinueExpression) {
            ContinueExpression theContinue = (ContinueExpression)expression;
            if (!this.stackifierOutout.get()) {
                this.print("$__label__ = ");
                this.print(theContinue.jumpTarget().getAddress());
                this.println(";");
            }
            this.print("goto $");
            this.print(theContinue.labelToReturnTo().name());
            this.println(";");
        } else if (expression instanceof ReturnExpression) {
            this.println("return;");
        } else if (expression instanceof PutFieldExpression) {
            PutFieldExpression thePutField = (PutFieldExpression)expression;
            List theIncomingData = thePutField.incomingDataFlows();
            Value theTarget = (Value)theIncomingData.get(0);
            BytecodeFieldRefConstant theField = thePutField.getField();
            Value thevalue = (Value)theIncomingData.get(1);
            this.printValue(theTarget);
            this.printInstanceFieldReference(theField);
            this.print(" = ");
            this.printValue(thevalue);
            this.println(";");
        } else if (expression instanceof ReturnValueExpression) {
            ReturnValueExpression theReturn = (ReturnValueExpression)expression;
            List theIncomingData = theReturn.incomingDataFlows();
            this.print("return ");
            this.printValue((Value)theIncomingData.get(0));
            this.println(";");
        } else if (expression instanceof IFElseExpression) {
            theE = (IFElseExpression)expression;
            IFExpression wrapped = ((IFElseExpression)theE).getCondition();
            this.print("if ");
            this.printValue((Value)wrapped.incomingDataFlows().get(0));
            this.println(" {");
            this.withDeeperIndent().writeExpressions(wrapped.getExpressions());
            this.println("} else {");
            this.withDeeperIndent().writeExpressions(((IFElseExpression)theE).getElsePart());
            this.println("}");
        } else {
            throw new IllegalArgumentException("Not supported. " + expression);
        }
    }

    private void writeExpressions(ExpressionList aList) {
        for (Expression theExpression : aList.toList()) {
            this.writeExpression(theExpression);
        }
    }

    private String toStructName(BytecodeObjectTypeRef aObjectType) {
        if (this.kernelClass.getClassName().equals(aObjectType)) {
            return "int";
        }
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(aObjectType);
        BytecodeClass theBytecodeClass = theLinkedClass.getBytecodeClass();
        BytecodeAnnotation theAnnotation = theBytecodeClass.getAttributes().getAnnotationByType(OpenCLType.class.getName());
        if (theAnnotation == null) {
            throw new IllegalArgumentException("No @OpenCLType found for " + aObjectType.name());
        }
        return theAnnotation.getElementValueByName("name").stringValue();
    }

    private String toType(TypeRef aType) {
        if (aType.isArray()) {
            TypeRef.ArrayTypeRef theArray = (TypeRef.ArrayTypeRef)aType;
            return this.toType(TypeRef.toType(theArray.arrayType().getType()));
        }
        if (aType instanceof TypeRef.ObjectTypeRef) {
            TypeRef.ObjectTypeRef theObject = (TypeRef.ObjectTypeRef)aType;
            return this.toStructName(theObject.objectType());
        }
        switch (aType.resolve()) {
            case INT: {
                return "int";
            }
            case FLOAT: {
                return "float";
            }
            case LONG: {
                return "long";
            }
            case DOUBLE: {
                return "double";
            }
            case REFERENCE: {
                return "void*";
            }
        }
        throw new IllegalArgumentException("Not supported : " + aType.resolve());
    }

    private void printValue(Value aValue) {
        if (aValue instanceof Variable) {
            Variable theVariable = (Variable)aValue;
            if (!theVariable.isSynthetic()) {
                Register r = this.allocator.registerAssignmentFor(theVariable);
                this.print(this.registerName(r));
            } else if ("__tr".equalsIgnoreCase(theVariable.getName())) {
                this.print(0);
            } else {
                this.print(theVariable.getName());
            }
        } else if (aValue instanceof InvokeVirtualMethodExpression) {
            this.printInvokeVirtual((InvokeVirtualMethodExpression)aValue);
        } else if (aValue instanceof InvokeStaticMethodExpression) {
            this.printInvokeStatic((InvokeStaticMethodExpression)aValue);
        } else if (aValue instanceof GetFieldExpression) {
            this.printGetFieldValue((GetFieldExpression)aValue);
        } else if (aValue instanceof ArrayEntryExpression) {
            this.printArrayEntryValue((ArrayEntryExpression)aValue);
        } else if (aValue instanceof BinaryExpression) {
            this.printBinaryValue((BinaryExpression)aValue);
        } else if (aValue instanceof IntegerValue) {
            this.printIntegerValue((IntegerValue)aValue);
        } else if (aValue instanceof LongValue) {
            this.printLongValue((LongValue)aValue);
        } else if (aValue instanceof FloatValue) {
            this.printFloatValue((FloatValue)aValue);
        } else if (aValue instanceof DoubleValue) {
            this.printDoubleValue((DoubleValue)aValue);
        } else if (aValue instanceof TypeConversionExpression) {
            this.printTypeConversionValue((TypeConversionExpression)aValue);
        } else if (aValue instanceof CompareExpression) {
            this.printCompareExpression((CompareExpression)aValue);
        } else if (aValue instanceof DirectInvokeMethodExpression) {
            this.printDirectInvokeMethodExpression((DirectInvokeMethodExpression)aValue);
        } else if (aValue instanceof FloorExpression) {
            this.printFloorExpression((FloorExpression)aValue);
        } else if (aValue instanceof PHIValue) {
            Variable v = this.allocator.variableAssignmentFor((PHIValue)aValue);
            if (v.isSynthetic()) {
                this.print(v.getName());
            } else {
                Register r = this.allocator.registerAssignmentFor(v);
                this.print(this.registerName(r));
            }
        } else {
            throw new IllegalArgumentException("Not supported : " + aValue);
        }
    }

    private void printFloorExpression(FloorExpression e) {
        this.print("floor((float)(");
        Value v = (Value)e.incomingDataFlows().get(0);
        this.printValue(v);
        this.print("))");
    }

    private void printDirectInvokeMethodExpression(DirectInvokeMethodExpression aExpression) {
        this.print(aExpression.getMethodName());
        this.print("(");
        List<OpenCLInputOutputs.KernelArgument> theArguments = this.inputOutputs.arguments();
        boolean theFirst = true;
        for (int i = 0; i < theArguments.size(); ++i) {
            theFirst = false;
            if (i > 0) {
                this.print(", ");
            }
            OpenCLInputOutputs.KernelArgument theArgument = theArguments.get(i);
            this.print(theArgument.getField().getValue().getName().stringValue());
        }
        BytecodeMethodSignature theSignature = aExpression.getSignature();
        List theMethodArguments = aExpression.incomingDataFlows();
        for (int i = 1; i < theMethodArguments.size(); ++i) {
            Value theValue = (Value)theMethodArguments.get(i);
            if (theFirst) {
                theFirst = false;
            } else {
                this.print(",");
            }
            if (!theSignature.getArguments()[i - 1].isPrimitive()) {
                this.print("&");
            }
            this.printValue(theValue);
        }
        this.print(")");
    }

    private void printCompareExpression(CompareExpression aExpression) {
        List theIncomingData = aExpression.incomingDataFlows();
        Value theVariable1 = (Value)theIncomingData.get(0);
        Value theVariable2 = (Value)theIncomingData.get(1);
        this.print("(");
        this.printValue(theVariable1);
        this.print(" > ");
        this.printValue(theVariable2);
        this.print(" ? 1 ");
        this.print(" : (");
        this.printValue(theVariable1);
        this.print(" < ");
        this.printValue(theVariable2);
        this.print(" ? -1 : 0))");
    }

    private void printTypeConversionValue(TypeConversionExpression aValue) {
        this.print("((");
        this.print(this.toType(aValue.resolveType()));
        this.print(") ");
        this.printValue((Value)aValue.incomingDataFlows().get(0));
        this.print(")");
    }

    private void printDoubleValue(DoubleValue aValue) {
        this.print(aValue.getDoubleValue());
    }

    private void printFloatValue(FloatValue aValue) {
        this.print(aValue.getFloatValue());
    }

    private void printLongValue(LongValue aValue) {
        this.print(aValue.getLongValue());
    }

    private void printIntegerValue(IntegerValue aValue) {
        this.print(aValue.getIntValue());
    }

    private void printBinaryValue(BinaryExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        this.print("(");
        this.printValue((Value)theIncomingData.get(0));
        switch (aValue.getOperator()) {
            case ADD: {
                this.print(" + ");
                break;
            }
            case DIV: {
                this.print(" / ");
                break;
            }
            case MUL: {
                this.print(" * ");
                break;
            }
            case SUB: {
                this.print(" - ");
                break;
            }
            case EQUALS: {
                this.print(" == ");
                break;
            }
            case BINARYOR: {
                this.print(" | ");
                break;
            }
            case LESSTHAN: {
                this.print(" < ");
                break;
            }
            case BINARYAND: {
                this.print(" & ");
                break;
            }
            case BINARYXOR: {
                this.print(" ^ ");
                break;
            }
            case NOTEQUALS: {
                this.print(" != ");
                break;
            }
            case REMAINDER: {
                this.print(" % ");
                break;
            }
            case GREATERTHAN: {
                this.print(" > ");
                break;
            }
            case BINARYSHIFTLEFT: {
                this.print(" << ");
                break;
            }
            case GREATEROREQUALS: {
                this.print(" >= ");
                break;
            }
            case BINARYSHIFTRIGHT: {
                this.print(" >> ");
                break;
            }
            case LESSTHANOREQUALS: {
                this.print(" <= ");
                break;
            }
            case BINARYUNSIGNEDSHIFTRIGHT: {
                this.print(" >>> ");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operator : " + (Object)((Object)aValue.getOperator()));
            }
        }
        this.printValue((Value)theIncomingData.get(1));
        this.print(")");
    }

    private void printGetFieldValue(GetFieldExpression aValue) {
        if (this.kernelClass.getClassName().equals(BytecodeObjectTypeRef.fromUtf8Constant(aValue.getField().getClassIndex().getClassConstant().getConstant()))) {
            this.print(aValue.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        } else {
            Value theValue = (Value)aValue.incomingDataFlows().get(0);
            if (theValue instanceof Variable && ((Variable)theValue).isSynthetic()) {
                this.print(aValue.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
            } else {
                this.printValue(theValue);
                this.printInstanceFieldReference(aValue.getField());
            }
        }
    }

    private void printArrayEntryValue(ArrayEntryExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        Value theArray = (Value)theIncomingData.get(0);
        Value theIndex = (Value)theIncomingData.get(1);
        this.printValue(theArray);
        this.print("[");
        this.printValue(theIndex);
        this.print("]");
    }

    private void printInvokeVirtual(InvokeVirtualMethodExpression aExpression) {
        if (this.kernelClass.getClassName().equals(aExpression.getInvokedClass())) {
            this.print(aExpression.getMethodName());
            this.print("(");
            List<OpenCLInputOutputs.KernelArgument> theArguments = this.inputOutputs.arguments();
            boolean theFirst = true;
            for (int i = 0; i < theArguments.size(); ++i) {
                theFirst = false;
                if (i > 0) {
                    this.print(", ");
                }
                OpenCLInputOutputs.KernelArgument theArgument = theArguments.get(i);
                this.print(theArgument.getField().getValue().getName().stringValue());
            }
            BytecodeMethodSignature theSignature = aExpression.getSignature();
            List theMethodArguments = aExpression.incomingDataFlows();
            for (int i = 1; i < theMethodArguments.size(); ++i) {
                Value theValue = (Value)theMethodArguments.get(i);
                if (theFirst) {
                    theFirst = false;
                } else {
                    this.print(",");
                }
                if (!theSignature.getArguments()[i - 1].isPrimitive()) {
                    this.print("&");
                }
                this.printValue(theValue);
            }
            this.print(")");
            return;
        }
        throw new IllegalArgumentException("Not supported virtual method invocation : " + aExpression.getMethodName());
    }

    private void printInvokeStatic(InvokeStaticMethodExpression aValue) {
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(aValue.getClassName());
        BytecodeResolvedMethods theMethods = theLinkedClass.resolvedMethods();
        AtomicBoolean theFound = new AtomicBoolean(false);
        theMethods.stream().forEach(aMethodMapsEntry -> {
            BytecodeMethod theMethod = aMethodMapsEntry.getValue();
            if (Objects.equals(theMethod.getName().stringValue(), aValue.getMethodName()) && theMethod.getSignature().matchesExactlyTo(aValue.getSignature())) {
                BytecodeAnnotation theAnnotation = theMethod.getAttributes().getAnnotationByType(OpenCLFunction.class.getName());
                if (theAnnotation == null) {
                    throw new IllegalArgumentException("Annotation @OpenCLFunction required for static method " + aValue.getMethodName());
                }
                String theMethodName = theAnnotation.getElementValueByName("value").stringValue();
                BytecodeAnnotation.ElementValue literalValue = theAnnotation.getElementValueByName("literal");
                if (literalValue != null && "true".equals(literalValue.stringValue())) {
                    this.print("(");
                    this.print(theMethodName);
                    this.print(")");
                } else {
                    this.print(theMethodName);
                }
                this.print("(");
                List theArguments = aValue.incomingDataFlows();
                for (int i = 0; i < theArguments.size(); ++i) {
                    if (i > 0) {
                        this.print(",");
                    }
                    this.printValue((Value)theArguments.get(i));
                }
                this.print(")");
                theFound.set(true);
            }
        });
        if (!theFound.get()) {
            throw new IllegalArgumentException("Not supported method : " + aValue.getMethodName());
        }
    }

    private void printInputOutputArgs(List<OpenCLInputOutputs.KernelArgument> arguments) {
        block4: for (int i = 0; i < arguments.size(); ++i) {
            OpenCLInputOutputs.KernelArgument theArgument;
            TypeRef theTypeRef;
            if (i > 0) {
                this.print(", ");
            }
            if ((theTypeRef = TypeRef.toType((theArgument = arguments.get(i)).getField().getValue().getTypeRef())).isObject() || theTypeRef.isArray()) {
                this.print("__global ");
            }
            switch (theArgument.getType()) {
                case INPUT: {
                    this.print("const ");
                    this.print(this.toType(theTypeRef));
                    if (theTypeRef.isArray()) {
                        this.print("*");
                    }
                    this.print(" ");
                    this.print(theArgument.getField().getValue().getName().stringValue());
                    continue block4;
                }
                case OUTPUT: 
                case INPUTOUTPUT: {
                    this.print(this.toType(theTypeRef));
                    if (theTypeRef.isArray()) {
                        this.print("*");
                    }
                    this.print(" ");
                    this.print(theArgument.getField().getValue().getName().stringValue());
                }
            }
        }
    }

    private String registerName(Register r) {
        if (r == null) {
            throw new IllegalStateException();
        }
        return "r" + r.getNumber();
    }

    private void printProgramVariablesDeclaration(Program program) {
        List<Register> theRegisters = this.allocator.assignedRegister();
        for (Register r : theRegisters) {
            TypeRef theVarType = r.getType();
            if (theVarType.isArray()) {
                this.print("__global ");
                this.print(this.toType(theVarType));
                this.print("* ");
                this.print(this.registerName(r));
                this.println(";");
                continue;
            }
            this.print(this.toType(theVarType));
            this.print(" ");
            this.print(this.registerName(r));
            this.println(";");
        }
    }

    public void writeStackifiedKernel(Program program, Stackifier stackifier, AbstractAllocator registerAllocator) {
        this.stackifierOutout.set(true);
        this.recordedNextLabels.clear();
        this.allocator = registerAllocator;
        this.print("__kernel void BytecoderKernel(");
        this.printInputOutputArgs(this.inputOutputs.arguments());
        this.println(") {");
        OpenCLWriter theDeeper = this.withDeeperIndent();
        theDeeper.printProgramVariablesDeclaration(program);
        final Stack<OpenCLWriter> writerStack = new Stack<OpenCLWriter>();
        final Stack labels = new Stack();
        writerStack.push(theDeeper);
        stackifier.writeStructuredControlFlow(new Stackifier.StackifierStructuredControlFlowWriter(stackifier){

            @Override
            public void beginLoopFor(Block<RegionNode> block) {
                super.beginLoopFor(block);
                OpenCLWriter current = (OpenCLWriter)writerStack.peek();
                current.print("$");
                current.print(block.getLabel().name());
                current.println(":");
                writerStack.push(current.withDeeperIndent());
                labels.push(block.getLabel());
            }

            @Override
            public void beginBlockFor(Block<RegionNode> block) {
                super.beginBlockFor(block);
                OpenCLWriter current = (OpenCLWriter)writerStack.peek();
                current.print("$");
                current.print(block.getLabel().name());
                current.println(":");
                writerStack.push(current.withDeeperIndent());
                labels.push(block.getLabel());
            }

            @Override
            public void writeExpression(RegionNode currentNode, Expression e) {
                ((OpenCLWriter)writerStack.peek()).writeExpression(e);
            }

            @Override
            public void closeBlock() {
                writerStack.pop();
                OpenCLWriter current = (OpenCLWriter)writerStack.peek();
                Label currentLabel = (Label)labels.pop();
                if (OpenCLWriter.this.recordedNextLabels.contains(currentLabel)) {
                    current.print("$");
                    current.print(currentLabel.name());
                    current.println("_next:");
                }
                super.closeBlock();
            }
        });
        this.println("}");
    }

    public void writeStackifiedInline(BytecodeMethod method, Program program, Stackifier stackifier, AbstractAllocator registerAllocator) {
        this.stackifierOutout.set(true);
        this.recordedNextLabels.clear();
        this.allocator = registerAllocator;
        BytecodeMethodSignature theSignature = method.getSignature();
        this.print("__inline ");
        this.print(this.toType(TypeRef.toType(theSignature.getReturnType())));
        this.print(" ");
        this.print(method.getName().stringValue());
        this.print("(");
        this.printInputOutputArgs(this.inputOutputs.arguments());
        boolean theFirst = this.inputOutputs.arguments().isEmpty();
        List<Variable> theProgramArguments = program.getArguments();
        for (int i = 1; i < theProgramArguments.size(); ++i) {
            Variable theVariable = theProgramArguments.get(i);
            if (theFirst) {
                theFirst = false;
            } else {
                this.print(", ");
            }
            this.print(this.toType(theVariable.resolveType()));
            this.print(" ");
            this.print(theVariable.getName());
        }
        this.println(") {");
        OpenCLWriter theDeeper = this.withDeeperIndent();
        this.printProgramVariablesDeclaration(program);
        final Stack<OpenCLWriter> writerStack = new Stack<OpenCLWriter>();
        final Stack labels = new Stack();
        writerStack.push(theDeeper);
        stackifier.writeStructuredControlFlow(new Stackifier.StackifierStructuredControlFlowWriter(stackifier){

            @Override
            public void beginLoopFor(Block<RegionNode> block) {
                super.beginLoopFor(block);
                OpenCLWriter current = (OpenCLWriter)writerStack.peek();
                current.print("$");
                current.print(block.getLabel().name());
                current.println(":");
                writerStack.push(current.withDeeperIndent());
                labels.push(block.getLabel());
            }

            @Override
            public void beginBlockFor(Block<RegionNode> block) {
                super.beginBlockFor(block);
                OpenCLWriter current = (OpenCLWriter)writerStack.peek();
                current.print("$");
                current.print(block.getLabel().name());
                current.println(":");
                writerStack.push(current.withDeeperIndent());
                labels.push(block.getLabel());
            }

            @Override
            public void writeExpression(RegionNode currentNode, Expression e) {
                ((OpenCLWriter)writerStack.peek()).writeExpression(e);
            }

            @Override
            public void closeBlock() {
                writerStack.pop();
                OpenCLWriter current = (OpenCLWriter)writerStack.peek();
                Label currentLabel = (Label)labels.pop();
                if (OpenCLWriter.this.recordedNextLabels.contains(currentLabel)) {
                    current.print("$");
                    current.print(currentLabel.name());
                    current.println("_next:");
                }
                super.closeBlock();
            }
        });
        this.println("}");
    }
}

