/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.opencl;

import de.mirkosertic.bytecoder.api.Logger;
import de.mirkosertic.bytecoder.api.opencl.Context;
import de.mirkosertic.bytecoder.api.opencl.DeviceProperties;
import de.mirkosertic.bytecoder.api.opencl.OpenCLOptions;
import de.mirkosertic.bytecoder.api.opencl.PlatformProperties;
import de.mirkosertic.bytecoder.backend.opencl.OpenCLContext;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jocl.CL;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_device_id;
import org.jocl.cl_platform_id;

public class OpenCLPlatform
implements de.mirkosertic.bytecoder.api.opencl.Platform {
    final Platform selectedPlatform;
    final Device selectedDevice;
    private final Logger logger;
    private final OpenCLOptions openCLOptions;

    public OpenCLPlatform(Logger aLogger, OpenCLOptions aOptions) {
        this.logger = aLogger;
        this.openCLOptions = aOptions;
        ArrayList<Platform> thePlatforms = new ArrayList<Platform>();
        CL.setExceptionsEnabled((boolean)true);
        int[] theNumPlatforms = new int[1];
        CL.clGetPlatformIDs((int)theNumPlatforms.length, null, (int[])theNumPlatforms);
        if (theNumPlatforms[0] == 0) {
            throw new IllegalArgumentException("No OpenCL Platform found!");
        }
        cl_platform_id[] thePlattforms = new cl_platform_id[theNumPlatforms[0]];
        CL.clGetPlatformIDs((int)thePlattforms.length, (cl_platform_id[])thePlattforms, null);
        for (int i = 0; i < theNumPlatforms[0]; ++i) {
            cl_platform_id theSelectedPlatform = thePlattforms[i];
            try {
                Platform thePlatform = new Platform(theSelectedPlatform, () -> OpenCLPlatform.getString(theSelectedPlatform, 2306));
                this.logger.info("Platform with id {} is {}", new Object[]{i, thePlatform.platformProperties.getName()});
                int[] numDevicesArray = new int[1];
                CL.clGetDeviceIDs((cl_platform_id)theSelectedPlatform, (long)-1L, (int)0, null, (int[])numDevicesArray);
                int numDevices = numDevicesArray[0];
                cl_device_id[] devices = new cl_device_id[numDevices];
                CL.clGetDeviceIDs((cl_platform_id)theSelectedPlatform, (long)-1L, (int)numDevices, (cl_device_id[])devices, null);
                for (final cl_device_id theDevice : devices) {
                    DeviceProperties theDeviceProperties = new DeviceProperties(){

                        public String getName() {
                            return OpenCLPlatform.getString(theDevice, 4139);
                        }

                        public int getNumberOfComputeUnits() {
                            return OpenCLPlatform.getInt(theDevice, 4098);
                        }

                        public long[] getMaxWorkItemSizes() {
                            return OpenCLPlatform.getSizes(theDevice, 4101, 3);
                        }

                        public long getMaxWorkGroupSize() {
                            return OpenCLPlatform.getSize(theDevice, 4100);
                        }

                        public long getClockFrequency() {
                            return OpenCLPlatform.getLong(theDevice, 4108);
                        }
                    };
                    this.logger.info("Found device {} with #CU {} and max workgroup size {} " + theDeviceProperties.getName(), new Object[]{theDeviceProperties.getNumberOfComputeUnits(), theDeviceProperties.getMaxWorkGroupSize()});
                    thePlatform.deviceList.add(new Device(theDevice, theDeviceProperties));
                }
                thePlatforms.add(thePlatform);
                continue;
            }
            catch (Exception e) {
                this.logger.warn("Error processing device {}", new Object[]{i});
            }
        }
        if (thePlatforms.isEmpty()) {
            throw new IllegalStateException("No OpenCL platform detected");
        }
        int thePlatformID = thePlatforms.size() - 1;
        String theOverriddenPlatform = System.getProperty("OPENCL_PLATFORM");
        if (theOverriddenPlatform != null && theOverriddenPlatform.length() > 0) {
            thePlatformID = Integer.parseInt(theOverriddenPlatform);
        }
        int theDeviceID = 0;
        String theOverriddenDevice = System.getProperty("OPENCL_DEVICE");
        if (theOverriddenDevice != null && theOverriddenDevice.length() > 0) {
            theDeviceID = Integer.parseInt(theOverriddenDevice);
        }
        this.selectedPlatform = (Platform)thePlatforms.get(thePlatformID);
        this.logger.info("Device detection done, platform {} selected", new Object[]{thePlatformID});
        this.selectedDevice = (Device)this.selectedPlatform.deviceList.get(theDeviceID);
    }

    public PlatformProperties getPlatformProperties() {
        return this.selectedPlatform.platformProperties;
    }

    public DeviceProperties getDeviceProperties() {
        return this.selectedDevice.deviceProperties;
    }

    public Context createContext() {
        return new OpenCLContext(this, this.logger, this.openCLOptions);
    }

    private static String getString(cl_platform_id platform, int paramName) {
        long[] size = new long[1];
        CL.clGetPlatformInfo((cl_platform_id)platform, (int)paramName, (long)0L, null, (long[])size);
        byte[] buffer = new byte[(int)size[0]];
        CL.clGetPlatformInfo((cl_platform_id)platform, (int)paramName, (long)buffer.length, (Pointer)Pointer.to((byte[])buffer), null);
        return new String(buffer, 0, buffer.length - 1);
    }

    private static String getString(cl_device_id device, int paramName) {
        long[] size = new long[1];
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)0L, null, (long[])size);
        byte[] buffer = new byte[(int)size[0]];
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)buffer.length, (Pointer)Pointer.to((byte[])buffer), null);
        return new String(buffer, 0, buffer.length - 1);
    }

    private static long getSize(cl_device_id device, int paramName) {
        return OpenCLPlatform.getSizes(device, paramName, 1)[0];
    }

    private static long[] getSizes(cl_device_id device, int paramName, int numValues) {
        ByteBuffer buffer = ByteBuffer.allocate(numValues * Sizeof.size_t).order(ByteOrder.nativeOrder());
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)(Sizeof.size_t * numValues), (Pointer)Pointer.to((Buffer)buffer), null);
        long[] values = new long[numValues];
        if (Sizeof.size_t == 4) {
            for (int i = 0; i < numValues; ++i) {
                values[i] = buffer.getInt(i * Sizeof.size_t);
            }
        } else {
            for (int i = 0; i < numValues; ++i) {
                values[i] = buffer.getLong(i * Sizeof.size_t);
            }
        }
        return values;
    }

    private static long getLong(cl_device_id device, int paramName) {
        return OpenCLPlatform.getLongs(device, paramName, 1)[0];
    }

    private static long[] getLongs(cl_device_id device, int paramName, int numValues) {
        long[] values = new long[numValues];
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)(8 * numValues), (Pointer)Pointer.to((long[])values), null);
        return values;
    }

    private static int getInt(cl_device_id device, int paramName) {
        return OpenCLPlatform.getInts(device, paramName, 1)[0];
    }

    private static int[] getInts(cl_device_id device, int paramName, int numValues) {
        int[] values = new int[numValues];
        CL.clGetDeviceInfo((cl_device_id)device, (int)paramName, (long)(4 * numValues), (Pointer)Pointer.to((int[])values), null);
        return values;
    }

    static class Platform {
        final cl_platform_id id;
        private final PlatformProperties platformProperties;
        private final List<Device> deviceList;

        Platform(cl_platform_id aId, PlatformProperties aPlatformProperties) {
            this.id = aId;
            this.platformProperties = aPlatformProperties;
            this.deviceList = new ArrayList<Device>();
        }
    }

    static class Device {
        final cl_device_id id;
        private final DeviceProperties deviceProperties;

        Device(cl_device_id aId, DeviceProperties aDeviceProperties) {
            this.id = aId;
            this.deviceProperties = aDeviceProperties;
        }
    }
}

