/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.opencl;

import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenCLInputOutputs {
    private final Map<String, KernelArgument> values = new HashMap<String, KernelArgument>();

    public void registerReadFrom(BytecodeResolvedFields.FieldEntry aLinkedField) {
        this.values.computeIfAbsent(aLinkedField.getValue().getName().stringValue(), k -> new KernelArgument(aLinkedField, KernelArgument.Type.INPUT));
    }

    public void registerWriteTo(BytecodeResolvedFields.FieldEntry aLinkedField) {
        KernelArgument theArgument = this.values.get(aLinkedField.getValue().getName().stringValue());
        if (theArgument == null) {
            theArgument = new KernelArgument(aLinkedField, KernelArgument.Type.OUTPUT);
            this.values.put(aLinkedField.getValue().getName().stringValue(), theArgument);
        } else if (theArgument.type == KernelArgument.Type.INPUT) {
            theArgument = new KernelArgument(aLinkedField, KernelArgument.Type.INPUTOUTPUT);
            this.values.put(aLinkedField.getValue().getName().stringValue(), theArgument);
        }
    }

    public List<KernelArgument> arguments() {
        ArrayList<KernelArgument> theResult = new ArrayList<KernelArgument>(this.values.values());
        theResult.sort(Comparator.comparing(o -> ((KernelArgument)o).field.getValue().getName().stringValue()));
        return theResult;
    }

    public static class KernelArgument {
        private final BytecodeResolvedFields.FieldEntry field;
        private final Type type;

        KernelArgument(BytecodeResolvedFields.FieldEntry aField, Type aType) {
            this.field = aField;
            this.type = aType;
        }

        public BytecodeResolvedFields.FieldEntry getField() {
            return this.field;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            INPUT,
            OUTPUT,
            INPUTOUTPUT;

        }
    }
}

