/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.opencl;

import de.mirkosertic.bytecoder.backend.CompileResult;
import de.mirkosertic.bytecoder.backend.opencl.OpenCLInputOutputs;
import java.io.OutputStream;
import java.io.PrintStream;

public class OpenCLCompileResult
extends CompileResult<String> {
    public OpenCLCompileResult(OpenCLContent ... content) {
        for (OpenCLContent c : content) {
            this.add(c);
        }
    }

    public static class OpenCLContent
    implements CompileResult.Content {
        private final OpenCLInputOutputs inputOutputs;
        private final String kernelSource;

        public OpenCLContent(OpenCLInputOutputs inputOutputs, String kernelSource) {
            this.inputOutputs = inputOutputs;
            this.kernelSource = kernelSource;
        }

        public OpenCLInputOutputs getInputOutputs() {
            return this.inputOutputs;
        }

        @Override
        public String getFileName() {
            return "BytecoderKernel";
        }

        @Override
        public void writeTo(OutputStream stream) {
            try (PrintStream ps = new PrintStream(stream);){
                ps.print(this.kernelSource);
            }
        }
    }
}

