/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.opencl;

import de.mirkosertic.bytecoder.allocator.AbstractAllocator;
import de.mirkosertic.bytecoder.backend.CompileBackend;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.opencl.OpenCLCompileResult;
import de.mirkosertic.bytecoder.backend.opencl.OpenCLInputOutputs;
import de.mirkosertic.bytecoder.backend.opencl.OpenCLIntrinsics;
import de.mirkosertic.bytecoder.backend.opencl.OpenCLWriter;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeLoader;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import de.mirkosertic.bytecoder.core.BytecodeResolvedMethods;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.relooper.Relooper;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.NaiveProgramGenerator;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.ProgramGenerator;
import de.mirkosertic.bytecoder.ssa.ProgramGeneratorFactory;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.stackifier.HeadToHeadControlFlowException;
import de.mirkosertic.bytecoder.stackifier.Stackifier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;

public class OpenCLCompileBackend
implements CompileBackend<OpenCLCompileResult> {
    private final BytecodeLoader loader = new BytecodeLoader(this.getClass().getClassLoader());
    private final ProgramGeneratorFactory programGeneratorFactory = NaiveProgramGenerator.FACTORY;

    public BytecodeMethodSignature signatureFrom(Method aMethod) {
        return this.loader.getSignatureParser().toMethodSignature(aMethod);
    }

    @Override
    public OpenCLCompileResult generateCodeFor(CompileOptions aOptions, BytecodeLinkerContext aLinkerContext, Class aEntryPointClass, String aEntryPointMethodName, BytecodeMethodSignature aEntryPointSignatue) {
        OpenCLInputOutputs theInputOutputs;
        BytecodeLinkerContext theLinkerContext = new BytecodeLinkerContext(this.loader, aOptions.getLogger());
        BytecodeLinkedClass theKernelClass = theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(aEntryPointClass));
        theKernelClass.resolveVirtualMethod(aEntryPointMethodName, aEntryPointSignatue);
        BytecodeResolvedMethods theMethodMap = theKernelClass.resolvedMethods();
        StringWriter theStrWriter = new StringWriter();
        BytecodeMethod theKernelMethod = theKernelClass.getBytecodeClass().methodByNameAndSignatureOrNull("processWorkItem", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
        ProgramGenerator theGenerator = this.programGeneratorFactory.createFor(aLinkerContext, new OpenCLIntrinsics());
        Program theSSAProgram = theGenerator.generateFrom(theKernelClass.getBytecodeClass(), theKernelMethod);
        aOptions.getOptimizer().optimize(theSSAProgram.getControlFlowGraph(), aLinkerContext);
        AbstractAllocator theKernelAllocator = aOptions.getAllocator().allocate(theSSAProgram, t -> t.resolveType(), aLinkerContext);
        try {
            theInputOutputs = this.inputOutputsFor(theLinkerContext, theKernelClass, theSSAProgram);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        OpenCLWriter theSSAWriter = new OpenCLWriter(theKernelClass, aOptions, theSSAProgram, new PrintWriter(theStrWriter), aLinkerContext, theInputOutputs);
        theMethodMap.stream().forEach(aMethodMapEntry -> {
            BytecodeMethod theMethod = aMethodMapEntry.getValue();
            if (theMethod.isConstructor()) {
                return;
            }
            if (theKernelClass != aMethodMapEntry.getProvidingClass()) {
                return;
            }
            if (theMethod != theKernelMethod) {
                Program theSSAProgram1 = theGenerator.generateFrom(aMethodMapEntry.getProvidingClass().getBytecodeClass(), theMethod);
                aOptions.getOptimizer().optimize(theSSAProgram1.getControlFlowGraph(), aLinkerContext);
                AbstractAllocator theAllocator = aOptions.getAllocator().allocate(theSSAProgram1, t -> t.resolveType(), aLinkerContext);
                try {
                    if (aOptions.isPreferStackifier()) {
                        try {
                            Stackifier stackifier = new Stackifier(theSSAProgram1.getControlFlowGraph());
                            theSSAWriter.writeStackifiedInline(theMethod, theSSAProgram1, stackifier, theAllocator);
                        }
                        catch (HeadToHeadControlFlowException e) {
                            aOptions.getLogger().warn("Method {}.{} could not be stackified, using Relooper instead", new Object[]{aMethodMapEntry.getProvidingClass().getClassName().name(), aMethodMapEntry.getValue().getName().stringValue()});
                            Relooper theRelooper = new Relooper(aOptions);
                            Relooper.Block theReloopedBlock = theRelooper.reloop(theSSAProgram.getControlFlowGraph());
                            theSSAWriter.printReloopedInline(theMethod, theSSAProgram1, theReloopedBlock, theAllocator);
                        }
                    } else {
                        Relooper theRelooper = new Relooper(aOptions);
                        Relooper.Block theReloopedBlock = theRelooper.reloop(theSSAProgram.getControlFlowGraph());
                        theSSAWriter.printReloopedInline(theMethod, theSSAProgram1, theReloopedBlock, theAllocator);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error relooping cfg", e);
                }
            }
        });
        try {
            if (aOptions.isPreferStackifier()) {
                try {
                    Stackifier stackifier = new Stackifier(theSSAProgram.getControlFlowGraph());
                    theSSAWriter.writeStackifiedKernel(theSSAProgram, stackifier, theKernelAllocator);
                }
                catch (HeadToHeadControlFlowException e) {
                    aOptions.getLogger().warn("Method %s could not be stackified, using Relooper instead", new Object[]{theKernelClass.getClassName().name() + "." + theKernelMethod.getName().stringValue()});
                    Relooper theRelooper = new Relooper(aOptions);
                    Relooper.Block theReloopedBlock = theRelooper.reloop(theSSAProgram.getControlFlowGraph());
                    theSSAWriter.printReloopedKernel(theReloopedBlock, theKernelAllocator);
                }
            } else {
                Relooper theRelooper = new Relooper(aOptions);
                Relooper.Block theReloopedBlock = theRelooper.reloop(theSSAProgram.getControlFlowGraph());
                theSSAWriter.printReloopedKernel(theReloopedBlock, theKernelAllocator);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error relooping cfg", e);
        }
        return new OpenCLCompileResult(new OpenCLCompileResult.OpenCLContent(theInputOutputs, theStrWriter.toString()));
    }

    private OpenCLInputOutputs inputOutputsFor(BytecodeLinkerContext aLinkerContext, BytecodeLinkedClass aKernelClass, Program aProgram) {
        OpenCLInputOutputs theResult = new OpenCLInputOutputs();
        for (RegionNode theNode : aProgram.getControlFlowGraph().dominators().getPreOrder()) {
            this.fillInputOutputs(aLinkerContext, aKernelClass, theNode.getExpressions(), theResult);
        }
        return theResult;
    }

    private void fillInputOutputs(BytecodeLinkerContext aContext, BytecodeLinkedClass aKernelClass, ExpressionList aExpressionList, OpenCLInputOutputs aInputOutputs) {
        BytecodeResolvedFields theInstanceFields = aKernelClass.resolvedFields();
        theInstanceFields.streamForInstanceFields().forEach(aEntry -> {
            aInputOutputs.registerReadFrom((BytecodeResolvedFields.FieldEntry)aEntry);
            aInputOutputs.registerWriteTo((BytecodeResolvedFields.FieldEntry)aEntry);
        });
    }
}

