/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.opencl;

import de.mirkosertic.bytecoder.api.Logger;
import de.mirkosertic.bytecoder.api.opencl.Context;
import de.mirkosertic.bytecoder.api.opencl.DeviceProperties;
import de.mirkosertic.bytecoder.api.opencl.Platform;
import de.mirkosertic.bytecoder.api.opencl.PlatformProperties;
import de.mirkosertic.bytecoder.backend.opencl.CPUContext;

public class CPUPlatform
implements Platform {
    private final PlatformProperties platformProperties;
    private final DeviceProperties deviceProperties;
    private final Logger logger;

    public CPUPlatform(Logger aLogger) {
        this.logger = aLogger;
        this.platformProperties = () -> "JVM Emulation";
        this.deviceProperties = new DeviceProperties(){

            public String getName() {
                return "System CPU";
            }

            public int getNumberOfComputeUnits() {
                return Runtime.getRuntime().availableProcessors();
            }

            public long[] getMaxWorkItemSizes() {
                return new long[]{-1L, -1L, -1L};
            }

            public long getMaxWorkGroupSize() {
                return -1L;
            }

            public long getClockFrequency() {
                return 1L;
            }
        };
    }

    public Context createContext() {
        return new CPUContext(this.logger);
    }

    public PlatformProperties getPlatformProperties() {
        return this.platformProperties;
    }

    public DeviceProperties getDeviceProperties() {
        return this.deviceProperties;
    }
}

