/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.opencl;

import de.mirkosertic.bytecoder.api.Logger;
import de.mirkosertic.bytecoder.api.opencl.Context;
import de.mirkosertic.bytecoder.api.opencl.GlobalFunctions;
import de.mirkosertic.bytecoder.api.opencl.Kernel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class CPUContext
implements Context {
    private final ExecutorService executorService;
    private final Logger logger;

    public CPUContext(Logger aLogger) {
        this.logger = aLogger;
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
            int counter = 0;

            @Override
            public Thread newThread(Runnable aRunnable) {
                return new Thread(aRunnable, "OpenCL-CPU#" + this.counter++);
            }
        });
    }

    public void compute(int aNumberOfStreams, Kernel aKernel) {
        CountDownLatch theLatch = new CountDownLatch(aNumberOfStreams);
        int i = 0;
        while (i < aNumberOfStreams) {
            int theWorkItemId = i++;
            this.executorService.submit(() -> {
                try {
                    GlobalFunctions.set_global_id((int)0, (int)theWorkItemId);
                    GlobalFunctions.set_global_size((int)0, (int)aNumberOfStreams);
                    aKernel.processWorkItem();
                }
                finally {
                    theLatch.countDown();
                }
            });
        }
        try {
            theLatch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Something went wrong", e);
        }
    }

    public void close() {
        this.executorService.shutdownNow();
    }
}

