/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.llvm;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.ssa.TypeRef;

public class LLVMWriterUtils {
    public static String toMethodName(String aMethodName, BytecodeMethodSignature aSignature) {
        StringBuilder theName = new StringBuilder(LLVMWriterUtils.typeRefToString(aSignature.getReturnType()));
        theName.append(aMethodName.replace("<", "$").replace(">", "$").replace("/", "_"));
        for (BytecodeTypeRef theTypeRef : aSignature.getArguments()) {
            theName.append(LLVMWriterUtils.typeRefToString(theTypeRef));
        }
        return theName.toString();
    }

    public static String toMethodName(BytecodeObjectTypeRef aClassName, String aMethodName, BytecodeMethodSignature aSignature) {
        return LLVMWriterUtils.toClassName(aClassName) + "_" + LLVMWriterUtils.toMethodName(aMethodName, aSignature);
    }

    public static String toMethodName(BytecodeObjectTypeRef aClassName, BytecodeUtf8Constant aConstant, BytecodeMethodSignature aSignature) {
        return LLVMWriterUtils.toClassName(aClassName) + "_" + LLVMWriterUtils.toMethodName(aConstant.stringValue(), aSignature);
    }

    public static String toClassName(BytecodeObjectTypeRef aTypeRef) {
        if (aTypeRef.name().endsWith(";")) {
            return LLVMWriterUtils.toClassName(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
        }
        return LLVMWriterUtils.toClassNameInternal(aTypeRef.name());
    }

    private static String toClassNameInternal(String aClassName) {
        int p = aClassName.lastIndexOf(".");
        String theSimpleName = aClassName.substring(p + 1);
        String thePackageName = aClassName.substring(0, p);
        StringBuilder theResult = new StringBuilder();
        while (thePackageName.length() > 0) {
            theResult.append(Character.toLowerCase(thePackageName.charAt(0)));
            int j = thePackageName.indexOf(".");
            if (j >= 0) {
                thePackageName = thePackageName.substring(j + 1);
                continue;
            }
            thePackageName = "";
        }
        return theResult.append(theSimpleName).toString();
    }

    private static String typeRefToString(BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            BytecodePrimitiveTypeRef thePrimitive = (BytecodePrimitiveTypeRef)aTypeRef;
            return thePrimitive.name();
        }
        if (aTypeRef.isArray()) {
            BytecodeArrayTypeRef theRef = (BytecodeArrayTypeRef)aTypeRef;
            return "A" + theRef.getDepth() + LLVMWriterUtils.typeRefToString(theRef.getType());
        }
        BytecodeObjectTypeRef theObjectRef = (BytecodeObjectTypeRef)aTypeRef;
        return LLVMWriterUtils.toClassName(theObjectRef);
    }

    public static String toType(TypeRef aType) {
        switch (aType.resolve()) {
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case VOID: {
                return "void";
            }
            case LONG: {
                return "i64";
            }
        }
        return "i32";
    }

    public static String toSignature(BytecodeMethodSignature signature) {
        StringBuilder theResult = new StringBuilder();
        theResult.append(LLVMWriterUtils.toType(TypeRef.toType(signature.getReturnType())));
        theResult.append("(");
        theResult.append("i32");
        for (int i = 0; i < signature.getArguments().length; ++i) {
            BytecodeTypeRef theParamType = signature.getArguments()[i];
            theResult.append(",");
            theResult.append(LLVMWriterUtils.toType(TypeRef.toType(theParamType)));
        }
        theResult.append(")");
        return theResult.toString();
    }

    public static boolean filteredForTest(BytecodeLinkedClass aClass) {
        return true;
    }

    public static String runtimeClassVariableName(BytecodeObjectTypeRef aType) {
        return "runtimeclass_" + aType.name().replace('.', '_').replace('$', '_');
    }
}

