/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.llvm;

import de.mirkosertic.bytecoder.backend.NativeMemoryLayouter;
import de.mirkosertic.bytecoder.backend.llvm.LLVMDebugInformation;
import de.mirkosertic.bytecoder.backend.llvm.LLVMWriterUtils;
import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.classlib.MemoryManager;
import de.mirkosertic.bytecoder.classlib.VM;
import de.mirkosertic.bytecoder.classlib.java.util.Quicksort;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import de.mirkosertic.bytecoder.core.BytecodeResolvedMethods;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeVTable;
import de.mirkosertic.bytecoder.core.BytecodeVirtualMethodIdentifier;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.graph.GraphDFSOrder;
import de.mirkosertic.bytecoder.graph.Node;
import de.mirkosertic.bytecoder.ssa.ArrayEntryExpression;
import de.mirkosertic.bytecoder.ssa.ArrayLengthExpression;
import de.mirkosertic.bytecoder.ssa.ArrayStoreExpression;
import de.mirkosertic.bytecoder.ssa.BinaryExpression;
import de.mirkosertic.bytecoder.ssa.BlockState;
import de.mirkosertic.bytecoder.ssa.ByteValue;
import de.mirkosertic.bytecoder.ssa.ClassReferenceValue;
import de.mirkosertic.bytecoder.ssa.CompareExpression;
import de.mirkosertic.bytecoder.ssa.ComputedMemoryLocationReadExpression;
import de.mirkosertic.bytecoder.ssa.ComputedMemoryLocationWriteExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.DataEndExpression;
import de.mirkosertic.bytecoder.ssa.DirectInvokeMethodExpression;
import de.mirkosertic.bytecoder.ssa.DoubleValue;
import de.mirkosertic.bytecoder.ssa.EnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.FixedBinaryExpression;
import de.mirkosertic.bytecoder.ssa.FloatValue;
import de.mirkosertic.bytecoder.ssa.FloatingPointCeilExpression;
import de.mirkosertic.bytecoder.ssa.FloatingPointFloorExpression;
import de.mirkosertic.bytecoder.ssa.FloorExpression;
import de.mirkosertic.bytecoder.ssa.GetFieldExpression;
import de.mirkosertic.bytecoder.ssa.GetStaticExpression;
import de.mirkosertic.bytecoder.ssa.GotoExpression;
import de.mirkosertic.bytecoder.ssa.HeapBaseExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.InstanceOfExpression;
import de.mirkosertic.bytecoder.ssa.IntegerValue;
import de.mirkosertic.bytecoder.ssa.InvokeStaticMethodExpression;
import de.mirkosertic.bytecoder.ssa.InvokeVirtualMethodExpression;
import de.mirkosertic.bytecoder.ssa.IsNaNExpression;
import de.mirkosertic.bytecoder.ssa.LambdaConstructorReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaInterfaceReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaSpecialReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaVirtualReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaWithStaticImplExpression;
import de.mirkosertic.bytecoder.ssa.LongValue;
import de.mirkosertic.bytecoder.ssa.LookupSwitchExpression;
import de.mirkosertic.bytecoder.ssa.MaxExpression;
import de.mirkosertic.bytecoder.ssa.MemorySizeExpression;
import de.mirkosertic.bytecoder.ssa.MethodHandleExpression;
import de.mirkosertic.bytecoder.ssa.MethodHandlesGeneratedLookupExpression;
import de.mirkosertic.bytecoder.ssa.MethodTypeArgumentCheckExpression;
import de.mirkosertic.bytecoder.ssa.MethodTypeExpression;
import de.mirkosertic.bytecoder.ssa.MinExpression;
import de.mirkosertic.bytecoder.ssa.NegatedExpression;
import de.mirkosertic.bytecoder.ssa.NewArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewInstanceFromDefaultConstructorExpression;
import de.mirkosertic.bytecoder.ssa.NewMultiArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectAndConstructExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectExpression;
import de.mirkosertic.bytecoder.ssa.NullValue;
import de.mirkosertic.bytecoder.ssa.PHIValue;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.PtrOfExpression;
import de.mirkosertic.bytecoder.ssa.PutFieldExpression;
import de.mirkosertic.bytecoder.ssa.PutStaticExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.ResolveCallsiteObjectExpression;
import de.mirkosertic.bytecoder.ssa.ReturnExpression;
import de.mirkosertic.bytecoder.ssa.ReturnValueExpression;
import de.mirkosertic.bytecoder.ssa.SetEnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.SetMemoryLocationExpression;
import de.mirkosertic.bytecoder.ssa.ShortValue;
import de.mirkosertic.bytecoder.ssa.SqrtExpression;
import de.mirkosertic.bytecoder.ssa.StackTopExpression;
import de.mirkosertic.bytecoder.ssa.StaticDependencies;
import de.mirkosertic.bytecoder.ssa.StringValue;
import de.mirkosertic.bytecoder.ssa.SuperTypeOfExpression;
import de.mirkosertic.bytecoder.ssa.SystemHasStackExpression;
import de.mirkosertic.bytecoder.ssa.TableSwitchExpression;
import de.mirkosertic.bytecoder.ssa.ThrowExpression;
import de.mirkosertic.bytecoder.ssa.TypeConversionExpression;
import de.mirkosertic.bytecoder.ssa.TypeOfExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.UnreachableExpression;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import de.mirkosertic.bytecoder.ssa.VariableDescription;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LLVMWriter
implements AutoCloseable {
    public static final String INSTANCEOFSUFFIX = "__instanceof";
    public static final String RUNTIMECLASSSUFFIX = "__runtimeclass";
    public static final String RUNTIMECLASSINITSTATUSSUFFIX = "__runtimeclassinitstatus";
    public static final String NEWINSTANCE_METHOD_NAME = "$newInstance";
    public static final String CLASSINITSUFFIX = "__init";
    public static final String VTABLESUFFIX = "__vtable";
    public static final String VTABLETYPESUFFIX = "__vtable__type";
    public static final String NEWINSTANCEHELPER = "bytecoder.newinstancehelper";
    public static final String INTERFACEDISPATCHSUFFIX = "__interfacedispatch";
    private final PrintWriter target;
    private RegionNode currentNode;
    private LLVMDebugInformation.SubProgram currentSubProgram;
    private final NativeMemoryLayouter memoryLayouter;
    private final BytecodeLinkerContext linkerContext;
    private final SymbolResolver symbolResolver;

    public LLVMWriter(PrintWriter output, NativeMemoryLayouter memoryLayouter, BytecodeLinkerContext linkerContext, SymbolResolver symbolResolver) {
        this.target = output;
        this.memoryLayouter = memoryLayouter;
        this.linkerContext = linkerContext;
        this.symbolResolver = symbolResolver;
    }

    @Override
    public void close() {
    }

    private String toTempSymbol(Value v, String suffix) {
        return "t_" + System.identityHashCode(v) + "_" + suffix + "_";
    }

    private BytecodeResolvedFields.FieldEntry implementingClassForStaticField(BytecodeObjectTypeRef aClass, String aFieldName) {
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(aClass);
        BytecodeResolvedFields theFields = theLinkedClass.resolvedFields();
        return theFields.fieldByName(aFieldName);
    }

    private List<PHIValuePair> phiValuePairFor(RegionNode aTarget, PHIValue aPHI, Set<RegionNode> aPreds, List<RegionNode> aRegularFlow) {
        ArrayList<PHIValuePair> theResult = new ArrayList<PHIValuePair>();
        for (RegionNode thePredecessor : aPreds) {
            if (!aRegularFlow.contains(thePredecessor)) continue;
            Value theOut = thePredecessor.liveOut().getPorts().get(aPHI.getDescription());
            theResult.add(new PHIValuePair("block" + thePredecessor.getStartAddress().getAddress(), theOut));
            for (Expression e : thePredecessor.getExpressions().toList()) {
                if (!(e instanceof TableSwitchExpression)) continue;
                TableSwitchExpression ts = (TableSwitchExpression)e;
                for (Map.Entry<Long, ExpressionList> theOffset : ts.getOffsets().entrySet()) {
                    for (Expression e2 : theOffset.getValue().toList()) {
                        GotoExpression theGoto;
                        if (!(e2 instanceof GotoExpression) || !(theGoto = (GotoExpression)e2).jumpTarget().equals(aTarget.getStartAddress())) continue;
                        theResult.add(new PHIValuePair(this.toTempSymbol(e, "else"), theOut));
                    }
                }
            }
        }
        return theResult;
    }

    public void write(BytecodeLinkedClass aOwningClass, Program aProgram, LLVMDebugInformation.SubProgram aSubProgram) {
        ControlFlowGraph theGraph = aProgram.getControlFlowGraph();
        RegionNode theStart = theGraph.startNode();
        GraphDFSOrder<RegionNode> order = new GraphDFSOrder<RegionNode>(theStart, RegionNode.NODE_COMPARATOR, RegionNode.FORWARD_EDGE_FILTER_REGULAR_FLOW_ONLY);
        List<RegionNode> theRegularFlow = order.getNodesInOrder();
        HashSet<String> theAlreadySeenPHIs = new HashSet<String>();
        this.currentSubProgram = aSubProgram;
        this.target.println("entry:");
        StaticDependencies staticDependencies = new StaticDependencies(aProgram);
        for (BytecodeLinkedClass theClass : staticDependencies.list()) {
            if (theClass.getClassName().name().equals(MemoryManager.class.getName())) continue;
            this.target.print("    %");
            this.target.print(LLVMWriterUtils.runtimeClassVariableName(theClass.getClassName()));
            if (theClass.getClassName().name().equals(String.class.getName()) || theClass.getClassName().name().equals(Array.class.getName()) || theClass.getClassName().name().equals(VM.class.getName()) || theClass.getClassName().name().equals(Quicksort.class.getName())) {
                aProgram.getLinkerContext().getStatistics().context("ClassInitialization").counter("Avoided initializations").increment();
                this.target.print(" = load i32, i32* @");
                this.target.print(LLVMWriterUtils.toClassName(theClass.getClassName()));
                this.target.println(RUNTIMECLASSSUFFIX);
                continue;
            }
            this.target.print(" = call i32 @");
            this.target.print(LLVMWriterUtils.toClassName(theClass.getClassName()));
            this.target.print(CLASSINITSUFFIX);
            this.target.println("()");
        }
        this.target.println("    br label %block0");
        Iterator<Node> iterator = theRegularFlow.iterator();
        while (iterator.hasNext()) {
            RegionNode theBlock;
            this.currentNode = theBlock = (RegionNode)iterator.next();
            BytecodeOpcodeAddress theBlockStart = theBlock.getStartAddress();
            this.target.print("block");
            this.target.print(theBlockStart.getAddress());
            this.target.println(":");
            BlockState theLiveIn = theBlock.liveIn();
            for (Map.Entry<VariableDescription, Value> theEntry : theLiveIn.getPorts().entrySet()) {
                if (!(theEntry.getValue() instanceof PHIValue)) continue;
                PHIValue phi = (PHIValue)theEntry.getValue();
                String thePHITempName = this.toTempSymbol(phi, "phi");
                Set<RegionNode> thePreds = this.currentNode.getPredecessors();
                List<PHIValuePair> theIncoming = this.phiValuePairFor(this.currentNode, phi, thePreds, theRegularFlow);
                Set theIncomingValues = theIncoming.stream().map(t -> ((PHIValuePair)t).phiValue).collect(Collectors.toSet());
                if ((thePreds.size() <= 1 || theIncomingValues.size() <= 1) && (theIncomingValues.size() != 1 || theIncomingValues.contains(phi))) continue;
                if (theAlreadySeenPHIs.add(thePHITempName)) {
                    this.target.print("    %");
                    this.target.print(thePHITempName);
                    this.target.print(" = phi ");
                    this.target.print(LLVMWriterUtils.toType(phi.resolveType()));
                    this.target.print(" ");
                    boolean first = true;
                    for (PHIValuePair theIncomingEntry : theIncoming) {
                        Value theOut = theIncomingEntry.phiValue;
                        if (theOut instanceof Variable) {
                            if (first) {
                                first = false;
                            } else {
                                this.target.print(",");
                            }
                            this.target.print("[");
                            this.target.print("%");
                            this.target.print(((Variable)theOut).getName());
                            this.target.print("_");
                            this.target.print(",%");
                            this.target.print(theIncomingEntry.nodeLabel);
                            this.target.print("]");
                            continue;
                        }
                        if (theOut instanceof PHIValue) {
                            if (first) {
                                first = false;
                            } else {
                                this.target.print(",");
                            }
                            this.target.print("[");
                            this.target.print("%");
                            this.target.print(this.toTempSymbol(theOut, "phi"));
                            this.target.print(",%");
                            this.target.print(theIncomingEntry.nodeLabel);
                            this.target.print("]");
                            continue;
                        }
                        throw new RuntimeException("Unhandled type for PHI input : " + theOut.getClass());
                    }
                }
                this.target.println();
            }
            this.write(theBlock);
        }
    }

    private void write(RegionNode block) {
        this.write(block.getExpressions());
    }

    private void tempify(InvokeVirtualMethodExpression e) {
        boolean fallbackToInterfaceInvocation;
        BytecodeVTable.Slot slot;
        BytecodeVTable table;
        BytecodeLinkedClass theLinkedClass;
        BytecodeLinkedClass theInvokedClass;
        BytecodeTypeRef theInvokedClassName = e.getInvokedClass();
        if (!theInvokedClassName.isPrimitive() && !theInvokedClassName.isArray() && (theInvokedClass = this.linkerContext.resolveClass((BytecodeObjectTypeRef)theInvokedClassName)).isOpaqueType()) {
            BytecodeResolvedMethods theMethods = theInvokedClass.resolvedMethods();
            List theImplMethods = theMethods.stream().filter(t -> t.getValue().getName().stringValue().equals(e.getMethodName()) && t.getValue().getSignature().matchesExactlyTo(e.getSignature())).collect(Collectors.toList());
            if (theImplMethods.size() != 1) {
                throw new IllegalStateException("Cannot find unique method " + e.getMethodName() + " with signature " + e.getSignature() + " in " + theInvokedClassName.name());
            }
            BytecodeMethod theMethod = ((BytecodeResolvedMethods.MethodEntry)theImplMethods.get(0)).getValue();
            if (!theMethod.isConstructor()) {
                return;
            }
        }
        Value value = (Value)e.incomingDataFlows().get(0);
        if (e.getInvokedClass().isArray()) {
            theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
            this.target.println("    ;; vtable of " + theLinkedClass.getClassName().name());
            table = this.symbolResolver.vtableFor(theLinkedClass);
        } else {
            theLinkedClass = this.linkerContext.resolveClass((BytecodeObjectTypeRef)e.getInvokedClass());
            this.target.println("    ;; vtable of " + theLinkedClass.getClassName().name());
            table = this.symbolResolver.vtableFor(theLinkedClass);
        }
        try {
            slot = table.slotOf(e.getMethodName(), e.getSignature());
            fallbackToInterfaceInvocation = false;
        }
        catch (IllegalArgumentException ex) {
            fallbackToInterfaceInvocation = true;
            slot = null;
        }
        if (e.isInterfaceInvocation() || fallbackToInterfaceInvocation) {
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "ptr"));
            this.target.print(" = ");
            this.target.print("add i32 ");
            this.write(value, true);
            this.target.print(", 4");
            this.target.println();
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "vtableptr"));
            this.target.print(" = inttoptr i32 %");
            this.target.print(this.toTempSymbol(e, "ptr"));
            this.target.println(" to i32*");
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "vtableref"));
            this.target.print(" = load i32, i32* %");
            this.target.println(this.toTempSymbol(e, "vtableptr"));
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "vtableref_offset"));
            this.target.print(" = add i32 %");
            this.target.print(this.toTempSymbol(e, "vtableref"));
            this.target.println(", 4");
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "vtableref_offset_ptr"));
            this.target.print(" = inttoptr i32 %");
            this.target.print(this.toTempSymbol(e, "vtableref_offset"));
            this.target.println(" to i32*");
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "dispatcher"));
            this.target.print(" = load i32, i32* %");
            this.target.println(this.toTempSymbol(e, "vtableref_offset_ptr"));
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "vtable"));
            this.target.print(" = inttoptr i32 %");
            this.target.print(this.toTempSymbol(e, "dispatcher"));
            this.target.println(" to i32(i32,i32)*");
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "resolved"));
            this.target.print(" = call i32(i32,i32) %");
            this.target.print(this.toTempSymbol(e, "vtable"));
            this.target.print("(i32 ");
            this.write(value, true);
            this.target.print(",");
            BytecodeVirtualMethodIdentifier theMethodIdentifier = this.linkerContext.getMethodCollection().identifierFor(e.getMethodName(), e.getSignature());
            this.target.print("i32 ");
            this.target.print(theMethodIdentifier.getIdentifier());
            this.target.println(")");
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "resolved_ptr"));
            this.target.print(" = inttoptr i32 %");
            this.target.print(this.toTempSymbol(e, "resolved"));
            this.target.print(" to ");
            this.target.print(LLVMWriterUtils.toSignature(e.getSignature()));
            this.target.println("*");
            return;
        }
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = ");
        this.target.print("add i32 ");
        this.write(value, true);
        this.target.print(", 4");
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "vtableptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.println(" to i32*");
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "vtableref"));
        this.target.print(" = load i32, i32* %");
        this.target.println(this.toTempSymbol(e, "vtableptr"));
        this.target.println("    ;; slot " + slot.getPos() + "," + e.getMethodName() + ", " + e.getSignature());
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "vtable"));
        this.target.print(" = add i32 %");
        this.target.print(this.toTempSymbol(e, "vtableref"));
        this.target.print(", ");
        this.target.println(8 + 4 * slot.getPos());
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "vtablefunptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "vtable"));
        this.target.println(" to i32 *");
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "resolved"));
        this.target.print("= load i32, i32* %");
        this.target.println(this.toTempSymbol(e, "vtablefunptr"));
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "resolved_ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "resolved"));
        this.target.print(" to ");
        this.target.print(LLVMWriterUtils.toSignature(e.getSignature()));
        this.target.println("*");
    }

    private void tempify(ArrayLengthExpression e) {
        Value value = (Value)e.incomingDataFlows().get(0);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" = ");
        this.target.print("add i32 ");
        this.write(value, true);
        this.target.print(", 16");
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.println(" to i32*");
    }

    private void tempify(NewMultiArrayExpression e) {
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "vtable"));
        this.target.println(" = ptrtoint %dmbcArray__vtable__type* @dmbcArray__vtable to i32");
    }

    private void tempify(ArrayEntryExpression e) {
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "index"));
        this.target.print(" = mul i32 8,");
        this.write((Value)e.incomingDataFlows().get(1), true);
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "index2"));
        this.target.print(" = add i32 ");
        this.write((Value)e.incomingDataFlows().get(0), true);
        this.target.print(", %");
        this.target.print(this.toTempSymbol(e, "index"));
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = add i32 20, %");
        this.target.println(this.toTempSymbol(e, "index2"));
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptrptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" to ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        this.target.println("*");
    }

    private void tempify(NewObjectExpression e) {
        String theClassName = LLVMWriterUtils.toClassName(BytecodeObjectTypeRef.fromUtf8Constant(e.getType().getConstant()));
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "vtable"));
        this.target.print(" = ptrtoint %");
        this.target.print(theClassName);
        this.target.print(VTABLETYPESUFFIX);
        this.target.print("* @");
        this.target.print(theClassName);
        this.target.print(VTABLESUFFIX);
        this.target.println(" to i32");
    }

    private void tempify(NewObjectAndConstructExpression e) {
        if (!e.isEscaping()) {
            int i;
            String theClassName = LLVMWriterUtils.toClassName(e.getClazz());
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "vtable"));
            this.target.print(" = ptrtoint %");
            this.target.print(theClassName);
            this.target.print(VTABLETYPESUFFIX);
            this.target.print("* @");
            this.target.print(theClassName);
            this.target.print(VTABLESUFFIX);
            this.target.println(" to i32");
            NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(e.getClazz());
            int theInstanceSize = theLayout.instanceSize();
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "alloc"));
            this.target.print(" = alloca i32, i32 ");
            this.target.println(theInstanceSize / 4);
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "alloc_int"));
            this.target.print(" = ptrtoint i32* %");
            this.target.print(this.toTempSymbol(e, "alloc"));
            this.target.println(" to i32");
            BytecodeObjectTypeRef theMemoryManagerClass = BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class);
            this.target.print("    call void(i32,i32,i32,i32,i32) @");
            this.target.print(LLVMWriterUtils.toMethodName(theMemoryManagerClass, "initStackObject", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT})));
            this.target.print("(");
            this.target.print("i32 0, i32 %");
            this.target.print(this.toTempSymbol(e, "alloc_int"));
            this.target.print(",i32 ");
            this.target.print(theLayout.instanceSize());
            this.target.print(", i32 %");
            this.target.print(LLVMWriterUtils.runtimeClassVariableName(e.getClazz()));
            this.target.print(",i32 %");
            this.target.print(this.toTempSymbol(e, "vtable"));
            this.target.print(")");
            this.currentSubProgram.writeDebugSuffixFor(e, this.target);
            this.target.println();
            this.target.print("    call void (i32");
            for (i = 0; i < e.getSignature().getArguments().length; ++i) {
                this.target.print(",");
                this.target.print(LLVMWriterUtils.toType(TypeRef.toType(e.getSignature().getArguments()[i])));
            }
            this.target.print(") @");
            this.target.print(LLVMWriterUtils.toMethodName(e.getClazz(), "<init>", e.getSignature()));
            this.target.print("(i32 %");
            this.target.print(this.toTempSymbol(e, "alloc_int"));
            for (i = 0; i < e.incomingDataFlows().size(); ++i) {
                this.target.print(",");
                this.target.print(LLVMWriterUtils.toType(TypeRef.toType(e.getSignature().getArguments()[i])));
                this.target.print(" ");
                this.writeResolved((Value)e.incomingDataFlows().get(i));
            }
            this.target.print(")");
            this.currentSubProgram.writeDebugSuffixFor(e, this.target);
            this.target.println();
        }
    }

    private void tempify(NewArrayExpression e) {
        BytecodeObjectTypeRef theArrayClass = BytecodeObjectTypeRef.fromRuntimeClass(Array.class);
        String theClassName = LLVMWriterUtils.toClassName(theArrayClass);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "vtable"));
        this.target.print(" = ptrtoint %");
        this.target.print(theClassName);
        this.target.print(VTABLETYPESUFFIX);
        this.target.print("* @");
        this.target.print(theClassName);
        this.target.print(VTABLESUFFIX);
        this.target.println(" to i32");
        if (!e.isEscaping()) {
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "size"));
            this.target.print(" = ");
            this.writeSameAssignmentHack(TypeRef.Native.INT, (Value)e.incomingDataFlows().get(0));
            this.target.println();
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "size2"));
            this.target.print(" = mul i32 8, %");
            this.target.print(this.toTempSymbol(e, "size"));
            this.target.println();
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "size3"));
            this.target.print(" = add i32 20, %");
            this.target.print(this.toTempSymbol(e, "size2"));
            this.target.println();
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "alloc"));
            this.target.print(" = alloca i32, i32 %");
            this.target.print(this.toTempSymbol(e, "size3"));
            this.target.println();
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "alloc_int"));
            this.target.print(" = ptrtoint i32* %");
            this.target.print(this.toTempSymbol(e, "alloc"));
            this.target.println(" to i32");
            BytecodeObjectTypeRef theMemoryManagerClass = BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class);
            this.target.print("    call void(i32,i32,i32,i32,i32) @");
            this.target.print(LLVMWriterUtils.toMethodName(theMemoryManagerClass, "initStackArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT})));
            this.target.print("(");
            this.target.print("i32 0, i32 %");
            this.target.print(this.toTempSymbol(e, "alloc_int"));
            this.target.print(",i32 %");
            this.target.print(this.toTempSymbol(e, "size"));
            this.target.print(", i32 %");
            this.target.print(LLVMWriterUtils.runtimeClassVariableName(theArrayClass));
            this.target.print(",i32 %");
            this.target.print(this.toTempSymbol(e, "vtable"));
            this.target.print(")");
            this.currentSubProgram.writeDebugSuffixFor(e, this.target);
            this.target.println();
        }
    }

    private void tempify(TypeOfExpression e) {
        Value value = (Value)e.incomingDataFlows().get(0);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = ");
        this.target.print("inttoptr i32 ");
        this.write(value, true);
        this.target.println(" to i32*");
    }

    private void tempify(ComputedMemoryLocationReadExpression e) {
        Value origin = (Value)e.incomingDataFlows().get(0);
        Value offset = (Value)e.incomingDataFlows().get(1);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" = ");
        this.target.print("add i32 ");
        this.write(origin, true);
        this.target.print(", ");
        this.write(offset, true);
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.println(" to i32*");
    }

    private void tempify(ComputedMemoryLocationWriteExpression e) {
        Value origin = (Value)e.incomingDataFlows().get(0);
        Value offset = (Value)e.incomingDataFlows().get(1);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" = ");
        this.target.print("add i32 ");
        this.write(origin, true);
        this.target.print(", ");
        this.write(offset, true);
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.println(" to i32*");
    }

    private void tempify(MemorySizeExpression e) {
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "raw"));
        this.target.println(" = call i32 @llvm.wasm.memory.size.i32(i32 0)");
    }

    private void tempify(GetFieldExpression e) {
        BytecodeObjectTypeRef theClass = BytecodeObjectTypeRef.fromUtf8Constant(e.getField().getClassIndex().getClassConstant().getConstant());
        Value object = (Value)e.incomingDataFlows().get(0);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" = add i32 ");
        this.write(object, true);
        this.target.print(",");
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(theClass);
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(theClass);
        BytecodeResolvedFields theInstanceFields = theLinkedClass.resolvedFields();
        BytecodeResolvedFields.FieldEntry theField = theInstanceFields.fieldByName(e.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        this.target.print(theLayout.offsetForInstanceMember(theField.getValue().getName().stringValue()));
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" to ");
        this.target.print(LLVMWriterUtils.toType(TypeRef.toType(theField.getValue().getTypeRef())));
        this.target.println("*");
    }

    private void tempify(GetStaticExpression e) {
        BytecodeResolvedFields.FieldEntry theEntry = this.implementingClassForStaticField(BytecodeObjectTypeRef.fromUtf8Constant(e.getField().getClassIndex().getClassConstant().getConstant()), e.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        BytecodeObjectTypeRef theClass = theEntry.getProvidingClass().getClassName();
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(theClass);
        int theStaticOffset = theLayout.offsetForClassMember(theEntry.getValue().getName().stringValue());
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" = add i32 %");
        this.target.print(LLVMWriterUtils.runtimeClassVariableName(theClass));
        this.target.print(",");
        this.target.println(theStaticOffset);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" to ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        this.target.println("*");
    }

    private void tempify(FloorExpression e) {
        Value value = (Value)e.incomingDataFlows().get(0);
        this.target.println(";; flooring to " + e.resolveType().resolve() + " from type " + value.resolveType().resolve());
        if (value instanceof BinaryExpression) {
            this.tempify((BinaryExpression)value);
        }
        this.target.print("    %");
        this.target.print(this.toTempSymbol(value, "exp"));
        this.target.print(" = ");
        this.write(value, true);
        this.target.println();
    }

    private void tempify(EnumConstantsExpression e) {
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "runtimeclass"));
        this.target.print(" = ");
        Value theClassRef = (Value)e.incomingDataFlows().get(0);
        if (theClassRef instanceof Variable) {
            this.writeSameAssignmentHack(TypeRef.Native.REFERENCE, theClassRef);
        } else {
            this.write(theClassRef, true);
        }
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" = add i32 12, %");
        this.target.println(this.toTempSymbol(e, "runtimeclass"));
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.println(" to i32*");
    }

    private void tempify(IFExpression e) {
        Value v;
        Value value = (Value)e.incomingDataFlows().get(0);
        if (value instanceof FixedBinaryExpression && (v = (Value)value.incomingDataFlows().get(0)) instanceof Expression) {
            this.tempifyValue(v);
            this.target.print("    ");
            this.target.print("%");
            this.target.print(this.toTempSymbol(v, "exp"));
            this.target.print(" = ");
            this.write(v, true);
            this.target.println();
        }
        if (value instanceof BinaryExpression) {
            Value v2;
            Value v1 = (Value)value.incomingDataFlows().get(0);
            if (v1 instanceof Expression) {
                this.tempifyValue(v1);
                this.target.print("    ");
                this.target.print("%");
                this.target.print(this.toTempSymbol(v1, "exp"));
                this.target.print(" = ");
                this.write(v1, true);
                this.target.println();
            }
            if ((v2 = (Value)value.incomingDataFlows().get(1)) instanceof Expression) {
                this.tempifyValue(v2);
                this.target.print("    ");
                this.target.print("%");
                this.target.print(this.toTempSymbol(v2, "exp"));
                this.target.print(" = ");
                this.write(v2, true);
                this.target.println();
            }
        }
        this.target.print("    %");
        this.target.print(this.toTempSymbol(value, "exp"));
        this.target.print(" = ");
        this.write(value, true);
        this.target.println();
    }

    private void tempify(BinaryExpression e) {
        Value v1 = (Value)e.incomingDataFlows().get(0);
        Value v2 = (Value)e.incomingDataFlows().get(1);
        if ((e.getOperator() == BinaryExpression.Operator.BINARYSHIFTLEFT || e.getOperator() == BinaryExpression.Operator.BINARYSHIFTRIGHT || e.getOperator() == BinaryExpression.Operator.BINARYUNSIGNEDSHIFTRIGHT) && v1.resolveType().resolve() == TypeRef.Native.LONG) {
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "v2_ext"));
            this.target.print(" = sext i32 ");
            this.writeResolved(v2);
            this.target.println(" to i64");
            return;
        }
        if (e.getOperator() == BinaryExpression.Operator.DIV) {
            this.target.println(";; division with target type " + e.resolveType().resolve());
            switch (v1.resolveType().resolve()) {
                case FLOAT: 
                case DOUBLE: {
                    return;
                }
                case LONG: {
                    this.target.print("    %");
                    this.target.print(this.toTempSymbol(e, "v1"));
                    this.target.print(" = sitofp i64 ");
                    this.write(v1, true);
                    this.target.println(" to double");
                    this.target.print("    %");
                    this.target.print(this.toTempSymbol(e, "v2"));
                    this.target.print(" = sitofp i64 ");
                    this.write(v2, true);
                    this.target.println(" to double");
                    return;
                }
            }
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "v1"));
            this.target.print(" = sitofp i32 ");
            this.write(v1, true);
            this.target.println(" to float");
            this.target.print("    %");
            this.target.print(this.toTempSymbol(e, "v2"));
            this.target.print(" = sitofp i32 ");
            this.write(v2, true);
            this.target.println(" to float");
        }
    }

    private void tempifyValue(Value v) {
        if (v instanceof ComputedMemoryLocationReadExpression) {
            this.tempify((ComputedMemoryLocationReadExpression)v);
        } else if (v instanceof ComputedMemoryLocationWriteExpression) {
            this.tempify((ComputedMemoryLocationWriteExpression)v);
        } else if (v instanceof GetFieldExpression) {
            this.tempify((GetFieldExpression)v);
        } else if (v instanceof EnumConstantsExpression) {
            this.tempify((EnumConstantsExpression)v);
        } else if (v instanceof ArrayLengthExpression) {
            this.tempify((ArrayLengthExpression)v);
        } else if (v instanceof BinaryExpression) {
            this.tempify((BinaryExpression)v);
        } else if (v instanceof TypeOfExpression) {
            this.tempify((TypeOfExpression)v);
        } else if (v instanceof NewObjectExpression) {
            this.tempify((NewObjectExpression)v);
        } else if (v instanceof NewObjectAndConstructExpression) {
            this.tempify((NewObjectAndConstructExpression)v);
        } else if (v instanceof NewArrayExpression) {
            this.tempify((NewArrayExpression)v);
        } else if (v instanceof NewMultiArrayExpression) {
            this.tempify((NewMultiArrayExpression)v);
        } else if (v instanceof ArrayEntryExpression) {
            this.tempify((ArrayEntryExpression)v);
        } else if (v instanceof InvokeVirtualMethodExpression) {
            this.tempify((InvokeVirtualMethodExpression)v);
        } else if (v instanceof MemorySizeExpression) {
            this.tempify((MemorySizeExpression)v);
        } else if (v instanceof GetStaticExpression) {
            this.tempify((GetStaticExpression)v);
        } else if (v instanceof FloorExpression) {
            this.tempify((FloorExpression)v);
        } else if (v instanceof DirectInvokeMethodExpression || v instanceof CompareExpression || v instanceof NewInstanceFromDefaultConstructorExpression || v instanceof NewObjectAndConstructExpression) {
            // empty if block
        }
    }

    private void tempify(Expression e) {
        if (e instanceof InvokeVirtualMethodExpression) {
            this.tempify((InvokeVirtualMethodExpression)e);
        }
        if (e instanceof IFExpression) {
            this.tempify((IFExpression)e);
        }
        for (Value v : e.incomingDataFlows()) {
            this.tempifyValue(v);
        }
    }

    private void write(ExpressionList list) {
        for (Expression e : list.toList()) {
            this.tempify(e);
            if (e instanceof ReturnExpression) {
                this.write((ReturnExpression)e);
                continue;
            }
            if (e instanceof VariableAssignmentExpression) {
                this.write((VariableAssignmentExpression)e);
                continue;
            }
            if (e instanceof ReturnValueExpression) {
                this.write((ReturnValueExpression)e);
                continue;
            }
            if (e instanceof GotoExpression) {
                this.write((GotoExpression)e);
                continue;
            }
            if (e instanceof IFExpression) {
                this.write((IFExpression)e);
                return;
            }
            if (e instanceof InvokeStaticMethodExpression) {
                this.target.print("    ");
                this.write((InvokeStaticMethodExpression)e);
                this.target.println();
                continue;
            }
            if (e instanceof SetMemoryLocationExpression) {
                this.write((SetMemoryLocationExpression)e);
                continue;
            }
            if (e instanceof UnreachableExpression) {
                this.write((UnreachableExpression)e);
                continue;
            }
            if (e instanceof PutFieldExpression) {
                this.write((PutFieldExpression)e);
                continue;
            }
            if (e instanceof DirectInvokeMethodExpression) {
                this.target.print("    ");
                this.write((DirectInvokeMethodExpression)e);
                continue;
            }
            if (e instanceof InvokeVirtualMethodExpression) {
                this.target.print("    ");
                this.write((InvokeVirtualMethodExpression)e);
                this.target.println();
                continue;
            }
            if (e instanceof PutStaticExpression) {
                this.write((PutStaticExpression)e);
                continue;
            }
            if (e instanceof ThrowExpression) {
                this.write((ThrowExpression)e);
                continue;
            }
            if (e instanceof ArrayStoreExpression) {
                this.write((ArrayStoreExpression)e);
                continue;
            }
            if (e instanceof TableSwitchExpression) {
                this.write((TableSwitchExpression)e);
                continue;
            }
            if (e instanceof SetEnumConstantsExpression) {
                this.write((SetEnumConstantsExpression)e);
                continue;
            }
            if (e instanceof LookupSwitchExpression) {
                this.write((LookupSwitchExpression)e);
                continue;
            }
            throw new IllegalStateException("Not implemented : " + e.getClass());
        }
    }

    private void write(SetEnumConstantsExpression e) {
        Value classptr = (Value)e.incomingDataFlows().get(0);
        Value value = (Value)e.incomingDataFlows().get(1);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "runtimeclass"));
        this.target.print(" = ");
        this.writeResolved(classptr);
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" = ");
        this.target.print("add i32 %");
        this.target.print(this.toTempSymbol(e, "runtimeclass"));
        this.target.print(", 12");
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.println(" to i32*");
        this.target.print("    store i32 ");
        this.writeResolved(value);
        this.target.print(", i32* %");
        this.target.println(this.toTempSymbol(e, "ptr"));
    }

    private void write(LookupSwitchExpression e) {
        this.target.print("    switch i32 ");
        this.writeResolved((Value)e.incomingDataFlows().get(0));
        this.target.print(", label %block");
        this.target.print(e.getDefaultJumpTarget().getAddress());
        this.target.println(" [");
        for (Map.Entry<Long, ExpressionList> theEntry : e.getPairs().entrySet()) {
            this.target.print("       i32 ");
            this.target.print(theEntry.getKey());
            this.target.print(",");
            for (Expression ex : theEntry.getValue().toList()) {
                if (!(ex instanceof GotoExpression)) continue;
                GotoExpression g = (GotoExpression)ex;
                this.target.print(" label %block");
                this.target.println(g.jumpTarget().getAddress());
            }
        }
        this.target.print("    ]");
        this.currentSubProgram.writeDebugSuffixFor(e, this.target);
        this.target.println();
    }

    private void write(TableSwitchExpression e) {
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "value"));
        this.target.print(" = add i32 0,");
        this.writeResolved((Value)e.incomingDataFlows().get(0));
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "cond"));
        this.target.print(" = call i1 @bytecoder.exceedsrange(i32 %");
        this.target.print(this.toTempSymbol(e, "value"));
        this.target.print(", i32 ");
        this.target.print(e.getLowValue());
        this.target.print(", i32 ");
        this.target.print(e.getHighValue());
        this.target.println(")");
        this.target.print("    br i1 %");
        this.target.print(this.toTempSymbol(e, "cond"));
        this.target.print(", label %block");
        this.target.print(e.getDefaultJumpTarget().getAddress());
        this.target.print(", label %");
        this.target.println(this.toTempSymbol(e, "else"));
        this.target.print(this.toTempSymbol(e, "else"));
        this.target.println(":");
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "sub"));
        this.target.print(" = sub i32 %");
        this.target.print(this.toTempSymbol(e, "value"));
        this.target.print(", ");
        this.target.println(e.getLowValue());
        this.target.print("    switch i32 %");
        this.target.print(this.toTempSymbol(e, "sub"));
        this.target.print(", label %");
        this.target.print(this.toTempSymbol(e, "trap"));
        this.target.println(" [");
        for (Map.Entry<Long, ExpressionList> theEntry : e.getOffsets().entrySet()) {
            this.target.print("       i32 ");
            this.target.print(theEntry.getKey());
            this.target.print(",");
            for (Expression ex : theEntry.getValue().toList()) {
                if (!(ex instanceof GotoExpression)) continue;
                GotoExpression g = (GotoExpression)ex;
                this.target.print(" label %block");
                this.target.println(g.jumpTarget().getAddress());
            }
        }
        this.target.print("    ]");
        this.currentSubProgram.writeDebugSuffixFor(e, this.target);
        this.target.println();
        this.target.print(this.toTempSymbol(e, "trap"));
        this.target.println(":");
        this.target.println("    call void @llvm.trap()");
        this.target.println("    unreachable");
    }

    private void write(ArrayStoreExpression e) {
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "index"));
        this.target.print(" = mul i32 8,");
        this.writeResolved((Value)e.incomingDataFlows().get(1));
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "index2"));
        this.target.print(" = add i32 ");
        this.writeResolved((Value)e.incomingDataFlows().get(0));
        this.target.print(", %");
        this.target.print(this.toTempSymbol(e, "index"));
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = add i32 20, %");
        this.target.println(this.toTempSymbol(e, "index2"));
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptrptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" to ");
        this.target.print(LLVMWriterUtils.toType(e.getArrayType()));
        this.target.println("*");
        this.target.print("    store ");
        this.target.print(LLVMWriterUtils.toType(e.getArrayType()));
        this.target.print(" ");
        this.writeResolved((Value)e.incomingDataFlows().get(2));
        this.target.print(", ");
        this.target.print(LLVMWriterUtils.toType(e.getArrayType()));
        this.target.print("* %");
        this.target.print(this.toTempSymbol(e, "ptrptr"));
        this.currentSubProgram.writeDebugSuffixFor(e, this.target);
        this.target.println();
    }

    private void write(NewArrayExpression e) {
        if (e.isEscaping()) {
            this.linkerContext.getStatistics().context("Codegenerator").counter("ArrayOnHeapAllocations").increment();
            String theMethodName = LLVMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
            this.target.print("call i32 @");
            this.target.print(theMethodName);
            this.target.print("(i32 0,i32 ");
            this.writeResolved((Value)e.incomingDataFlows().get(0));
            this.target.print(",i32 %");
            this.target.print(LLVMWriterUtils.runtimeClassVariableName(BytecodeObjectTypeRef.fromRuntimeClass(Array.class)));
            this.target.print(",i32 %");
            this.target.print(this.toTempSymbol(e, "vtable"));
            this.target.print(")");
            this.currentSubProgram.writeDebugSuffixFor(e, this.target);
        } else {
            this.linkerContext.getStatistics().context("Codegenerator").counter("ArrayOnStackAllocations").increment();
            this.target.print("add i32 0, %");
            this.target.print(this.toTempSymbol(e, "alloc_int"));
            this.target.println(";; does not escape, please verify");
        }
    }

    private void write(ThrowExpression e) {
        this.target.println("    call void @llvm.trap()");
        this.target.println("    unreachable");
    }

    private void write(PutStaticExpression e) {
        BytecodeResolvedFields.FieldEntry theEntry = this.implementingClassForStaticField(BytecodeObjectTypeRef.fromUtf8Constant(e.getField().getClassIndex().getClassConstant().getConstant()), e.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        BytecodeObjectTypeRef theClass = theEntry.getProvidingClass().getClassName();
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(theClass);
        int theStaticOffset = theLayout.offsetForClassMember(theEntry.getValue().getName().stringValue());
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(theClass);
        BytecodeResolvedFields theStaticFields = theLinkedClass.resolvedFields();
        BytecodeResolvedFields.FieldEntry theField = theStaticFields.fieldByName(e.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" = add i32 %");
        this.target.print(LLVMWriterUtils.runtimeClassVariableName(theLinkedClass.getClassName()));
        this.target.print(",");
        this.target.println(theStaticOffset);
        this.target.print("    %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(e, "offset"));
        this.target.print(" to ");
        this.target.print(LLVMWriterUtils.toType(TypeRef.toType(theField.getValue().getTypeRef())));
        this.target.println("*");
        this.target.print("    store ");
        this.target.print(LLVMWriterUtils.toType(TypeRef.toType(theField.getValue().getTypeRef())));
        this.target.print(" ");
        this.writeResolved((Value)e.incomingDataFlows().get(0));
        this.target.print(",");
        this.target.print(LLVMWriterUtils.toType(TypeRef.toType(theField.getValue().getTypeRef())));
        this.target.print("* %");
        this.target.print(this.toTempSymbol(e, "ptr"));
        this.currentSubProgram.writeDebugSuffixFor(e, this.target);
        this.target.println();
    }

    private void write(InvokeVirtualMethodExpression e) {
        BytecodeLinkedClass theInvokedClass;
        Value invocationTarget = (Value)e.incomingDataFlows().get(0);
        BytecodeTypeRef theInvokedClassName = e.getInvokedClass();
        if (!theInvokedClassName.isPrimitive() && !theInvokedClassName.isArray() && (theInvokedClass = this.linkerContext.resolveClass((BytecodeObjectTypeRef)theInvokedClassName)).isOpaqueType()) {
            BytecodeResolvedMethods theMethods = theInvokedClass.resolvedMethods();
            List theImplMethods = theMethods.stream().filter(t -> t.getValue().getName().stringValue().equals(e.getMethodName()) && t.getValue().getSignature().matchesExactlyTo(e.getSignature())).collect(Collectors.toList());
            if (theImplMethods.size() != 1) {
                throw new IllegalStateException("Cannot find unique method " + e.getMethodName() + " with signature " + e.getSignature() + " in " + theInvokedClassName.name());
            }
            BytecodeLinkedClass theImplClass = ((BytecodeResolvedMethods.MethodEntry)theImplMethods.get(0)).getProvidingClass();
            BytecodeMethod theMethod = ((BytecodeResolvedMethods.MethodEntry)theImplMethods.get(0)).getValue();
            if (!theMethod.isConstructor()) {
                this.target.print("call ");
                this.target.print(LLVMWriterUtils.toSignature(e.getSignature()));
                this.target.print(" @");
                this.target.print(LLVMWriterUtils.toMethodName(theImplClass.getClassName(), e.getMethodName(), e.getSignature()));
                this.target.print(" (i32 ");
                this.writeResolved(invocationTarget);
                for (int i = 0; i < e.getSignature().getArguments().length; ++i) {
                    this.target.print(",");
                    this.target.print(LLVMWriterUtils.toType(TypeRef.toType(e.getSignature().getArguments()[i])));
                    this.target.print(" ");
                    this.writeResolved((Value)e.incomingDataFlows().get(i + 1));
                }
                this.target.print(")");
                this.currentSubProgram.writeDebugSuffixFor(e, this.target);
                return;
            }
        }
        this.target.print("call ");
        this.target.print(LLVMWriterUtils.toSignature(e.getSignature()));
        this.target.print(" %");
        this.target.print(this.toTempSymbol(e, "resolved_ptr"));
        this.target.print(" (i32 ");
        this.writeResolved(invocationTarget);
        for (int i = 0; i < e.getSignature().getArguments().length; ++i) {
            this.target.print(",");
            this.target.print(LLVMWriterUtils.toType(TypeRef.toType(e.getSignature().getArguments()[i])));
            this.target.print(" ");
            this.writeResolved((Value)e.incomingDataFlows().get(i + 1));
        }
        this.target.print(")");
        this.currentSubProgram.writeDebugSuffixFor(e, this.target);
    }

    private void write(DirectInvokeMethodExpression e) {
        BytecodeLinkedClass theTargetClass = this.linkerContext.resolveClass(e.getClazz());
        String theMethodName = e.getMethodName();
        BytecodeMethodSignature theSignature = e.getSignature();
        if (theTargetClass.isOpaqueType() && !theMethodName.equals("<init>")) {
            this.target.print("call ");
            this.target.print(LLVMWriterUtils.toSignature(theSignature));
            this.target.print(" @");
            this.target.print(LLVMWriterUtils.toMethodName(theTargetClass.getClassName(), theMethodName, theSignature));
            this.target.print("(");
            List theValues = e.incomingDataFlows();
            for (int i = 0; i < theValues.size(); ++i) {
                if (i > 0) {
                    this.target.print(",");
                }
                if (i == 0) {
                    this.target.print("i32");
                } else {
                    this.target.print(LLVMWriterUtils.toType(TypeRef.toType(e.getSignature().getArguments()[i - 1])));
                }
                this.target.print(" ");
                this.writeResolved((Value)theValues.get(i));
            }
            this.target.print(")");
            return;
        }
        this.target.print("call ");
        this.target.print(LLVMWriterUtils.toSignature(theSignature));
        this.target.print(" @");
        if (!e.getMethodName().equals("<init>")) {
            BytecodeResolvedMethods theResolvedMethods = theTargetClass.resolvedMethods();
            BytecodeResolvedMethods.MethodEntry theEntry = theResolvedMethods.implementingClassOf(theMethodName, theSignature);
            this.target.print(LLVMWriterUtils.toMethodName(theEntry.getProvidingClass().getClassName(), theMethodName, theSignature));
        } else {
            this.target.print(LLVMWriterUtils.toMethodName(e.getClazz(), theMethodName, theSignature));
        }
        this.target.print("(");
        List theValues = e.incomingDataFlows();
        for (int i = 0; i < theValues.size(); ++i) {
            if (i > 0) {
                this.target.print(",");
            }
            if (i == 0) {
                this.target.print("i32");
            } else {
                this.target.print(LLVMWriterUtils.toType(TypeRef.toType(e.getSignature().getArguments()[i - 1])));
            }
            this.target.print(" ");
            this.writeResolved((Value)theValues.get(i));
        }
        this.target.print(")");
        this.currentSubProgram.writeDebugSuffixFor(e, this.target);
        this.target.println();
    }

    private void write(PutFieldExpression expression) {
        Value object = (Value)expression.incomingDataFlows().get(0);
        Value value = (Value)expression.incomingDataFlows().get(1);
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(expression.getField().getClassIndex().getClassConstant().getConstant()));
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(theLinkedClass.getClassName());
        BytecodeResolvedFields theInstanceFields = theLinkedClass.resolvedFields();
        BytecodeResolvedFields.FieldEntry theField = theInstanceFields.fieldByName(expression.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        this.target.print("    %");
        this.target.print(this.toTempSymbol(expression, "offset"));
        this.target.print(" = add i32 ");
        this.writeResolved(object);
        this.target.print(",");
        this.target.print(theLayout.offsetForInstanceMember(theField.getValue().getName().stringValue()));
        this.target.println();
        this.target.print("    %");
        this.target.print(this.toTempSymbol(expression, "ptr"));
        this.target.print(" = inttoptr i32 %");
        this.target.print(this.toTempSymbol(expression, "offset"));
        this.target.print(" to ");
        this.target.print(LLVMWriterUtils.toType(TypeRef.toType(theField.getValue().getTypeRef())));
        this.target.println("*");
        this.target.print("    store ");
        this.target.print(LLVMWriterUtils.toType(TypeRef.toType(theField.getValue().getTypeRef())));
        this.target.print(" ");
        this.writeResolved(value);
        this.target.print(",");
        this.target.print(LLVMWriterUtils.toType(TypeRef.toType(theField.getValue().getTypeRef())));
        this.target.print("* %");
        this.target.print(this.toTempSymbol(expression, "ptr"));
        this.currentSubProgram.writeDebugSuffixFor(expression, this.target);
        this.target.println();
    }

    private void write(UnreachableExpression expression) {
        this.target.println("    call void @llvm.trap()");
        this.target.println("    unreachable");
    }

    private void write(SetMemoryLocationExpression expression) {
        Value location = (Value)expression.incomingDataFlows().get(0);
        Value value = (Value)expression.incomingDataFlows().get(1);
        this.target.print("    store i32 ");
        this.writeResolved(value);
        this.target.print(", ");
        this.writeResolved(location);
        this.target.println();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(IFExpression expression) {
        Set forwardNodes = this.currentNode.outgoingEdges().filter(edge -> RegionNode.ALL_SUCCCESSORS_REGULAR_FLOW_ONLY.test((Edge)edge)).map(t -> ((RegionNode)t.targetNode()).getStartAddress()).collect(Collectors.toSet());
        if (forwardNodes.size() == 2) {
            this.target.print("    br i1 ");
            this.writeResolved((Value)expression.incomingDataFlows().get(0));
            this.target.print(", label %block");
            this.target.print(expression.getGotoAddress().getAddress());
            forwardNodes.remove(expression.getGotoAddress());
            if (forwardNodes.size() != 1) throw new IllegalArgumentException("Expected one node for else branch of if statement, got " + forwardNodes);
            BytecodeOpcodeAddress theElse = (BytecodeOpcodeAddress)forwardNodes.iterator().next();
            this.target.print(", label %block");
            this.target.print(theElse.getAddress());
            this.currentSubProgram.writeDebugSuffixFor(expression, this.target);
            this.target.println();
            return;
        } else {
            if (forwardNodes.size() != 1) throw new IllegalArgumentException("Expected one node for else branch of if statement, got " + forwardNodes);
            this.target.print("    br i1 ");
            this.writeResolved((Value)expression.incomingDataFlows().get(0));
            this.target.print(", label %block");
            this.target.print(expression.getGotoAddress().getAddress());
            this.target.print(", label %block");
            this.target.print(expression.getGotoAddress().getAddress());
            this.currentSubProgram.writeDebugSuffixFor(expression, this.target);
            this.target.println();
        }
    }

    private void write(GotoExpression expression) {
        this.target.print("    br label %");
        BytecodeOpcodeAddress jumpTo = expression.jumpTarget();
        this.target.print("block");
        this.target.println(jumpTo.getAddress());
    }

    private void write(ReturnExpression expression) {
        this.target.print("    ");
        this.target.print("ret void");
        this.currentSubProgram.writeDebugSuffixFor(expression, this.target);
        this.target.println();
    }

    private void write(ReturnValueExpression expression) {
        Value result = (Value)expression.incomingDataFlows().get(0);
        this.target.print("    ");
        this.target.print("ret ");
        this.target.print(LLVMWriterUtils.toType(result.resolveType()));
        this.target.print(" ");
        this.writeResolved(result);
        this.currentSubProgram.writeDebugSuffixFor(expression, this.target);
        this.target.println();
    }

    private void write(VariableAssignmentExpression expression) {
        Value value = (Value)expression.incomingDataFlows().get(0);
        if (value instanceof TypeConversionExpression) {
            this.target.println("    ; converting from " + ((Value)value.incomingDataFlows().get(0)).resolveType().resolve() + " to " + expression.getVariable().resolveType().resolve());
        }
        this.target.print("    ");
        this.target.print("%");
        this.target.print(expression.getVariable().getName());
        this.target.print("_ = ");
        if (value instanceof Variable) {
            switch (value.resolveType().resolve()) {
                case DOUBLE: {
                    this.target.print("fadd double %");
                    this.target.print(((Variable)value).getName());
                    this.target.print("_, 0.0");
                    break;
                }
                case FLOAT: {
                    this.target.print("fadd float %");
                    this.target.print(((Variable)value).getName());
                    this.target.print("_, 0.0");
                    break;
                }
                case LONG: {
                    this.target.print("add i64 %");
                    this.target.print(((Variable)value).getName());
                    this.target.print("_, 0");
                    break;
                }
                default: {
                    this.target.print("add i32 %");
                    this.target.print(((Variable)value).getName());
                    this.target.print("_, 0");
                    break;
                }
            }
        } else {
            if (value instanceof DoubleValue) {
                this.target.print("fadd double 0.0,");
            }
            if (value instanceof FloatValue) {
                this.target.print("fadd float 0.0,");
            }
            if (value instanceof IntegerValue) {
                this.target.print("add i32 0,");
            }
            if (value instanceof ShortValue) {
                this.target.print("add i32 0,");
            }
            if (value instanceof ByteValue) {
                this.target.print("add i32 0,");
            }
            if (value instanceof LongValue) {
                this.target.print("add i64 0,");
            }
            if (value instanceof PHIValue) {
                switch (value.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fadd double 0.0,");
                        break;
                    }
                    case FLOAT: {
                        this.target.print("fadd float 0.0,");
                        break;
                    }
                    case LONG: {
                        this.target.print("add i64 0,");
                        break;
                    }
                    default: {
                        this.target.print("add i32 0,");
                    }
                }
            }
            this.write(value, true);
        }
        this.currentSubProgram.writeDebugSuffixFor(expression, this.target);
        this.target.println();
    }

    private void writeResolved(Value aValue) {
        if (aValue instanceof Expression && !(aValue instanceof ComputedMemoryLocationWriteExpression)) {
            this.target.write("%");
            this.target.write(this.toTempSymbol(aValue, "exp"));
        } else {
            this.write(aValue, true);
        }
    }

    private void write(Value aValue, boolean useDirectVarRef) {
        if (aValue instanceof Variable) {
            Variable v = (Variable)aValue;
            if (useDirectVarRef) {
                this.target.print("%");
            } else {
                switch (v.resolveType().resolve()) {
                    case FLOAT: 
                    case DOUBLE: {
                        this.target.print("fadd float 0,%");
                        break;
                    }
                    default: {
                        this.target.print("add i32 0,%");
                    }
                }
            }
            this.target.print(v.getName());
            this.target.print("_");
        } else if (aValue instanceof IntegerValue) {
            this.write((IntegerValue)aValue);
        } else if (aValue instanceof LongValue) {
            this.write((LongValue)aValue);
        } else if (aValue instanceof InvokeStaticMethodExpression) {
            this.write((InvokeStaticMethodExpression)aValue);
        } else if (aValue instanceof BinaryExpression) {
            this.write((BinaryExpression)aValue);
        } else if (aValue instanceof PHIValue) {
            this.write((PHIValue)aValue);
        } else if (aValue instanceof MemorySizeExpression) {
            this.write((MemorySizeExpression)aValue);
        } else if (aValue instanceof ComputedMemoryLocationWriteExpression) {
            this.write((ComputedMemoryLocationWriteExpression)aValue);
        } else if (aValue instanceof ComputedMemoryLocationReadExpression) {
            this.write((ComputedMemoryLocationReadExpression)aValue);
        } else if (aValue instanceof TypeConversionExpression) {
            this.write((TypeConversionExpression)aValue);
        } else if (aValue instanceof StackTopExpression) {
            this.write((StackTopExpression)aValue);
        } else if (aValue instanceof NewObjectAndConstructExpression) {
            this.write((NewObjectAndConstructExpression)aValue);
        } else if (aValue instanceof GetFieldExpression) {
            this.write((GetFieldExpression)aValue);
        } else if (aValue instanceof DirectInvokeMethodExpression) {
            this.write((DirectInvokeMethodExpression)aValue);
        } else if (aValue instanceof NullValue) {
            this.write((NullValue)aValue);
        } else if (aValue instanceof GetStaticExpression) {
            this.write((GetStaticExpression)aValue);
        } else if (aValue instanceof HeapBaseExpression) {
            this.write((HeapBaseExpression)aValue);
        } else if (aValue instanceof SystemHasStackExpression) {
            this.write((SystemHasStackExpression)aValue);
        } else if (aValue instanceof DataEndExpression) {
            this.write((DataEndExpression)aValue);
        } else if (aValue instanceof StringValue) {
            this.write((StringValue)aValue);
        } else if (aValue instanceof InvokeVirtualMethodExpression) {
            this.write((InvokeVirtualMethodExpression)aValue);
        } else if (aValue instanceof ClassReferenceValue) {
            this.write((ClassReferenceValue)aValue);
        } else if (aValue instanceof NewArrayExpression) {
            this.write((NewArrayExpression)aValue);
        } else if (aValue instanceof ArrayLengthExpression) {
            this.write((ArrayLengthExpression)aValue);
        } else if (aValue instanceof FixedBinaryExpression) {
            this.write((FixedBinaryExpression)aValue);
        } else if (aValue instanceof ArrayEntryExpression) {
            this.write((ArrayEntryExpression)aValue);
        } else if (aValue instanceof NewInstanceFromDefaultConstructorExpression) {
            this.write((NewInstanceFromDefaultConstructorExpression)aValue);
        } else if (aValue instanceof InstanceOfExpression) {
            this.write((InstanceOfExpression)aValue);
        } else if (aValue instanceof NewObjectExpression) {
            this.write((NewObjectExpression)aValue);
        } else if (aValue instanceof CompareExpression) {
            this.write((CompareExpression)aValue);
        } else if (aValue instanceof NegatedExpression) {
            this.write((NegatedExpression)aValue);
        } else if (aValue instanceof FloorExpression) {
            this.write((FloorExpression)aValue);
        } else if (aValue instanceof MinExpression) {
            this.write((MinExpression)aValue);
        } else if (aValue instanceof TypeOfExpression) {
            this.write((TypeOfExpression)aValue);
        } else if (aValue instanceof IsNaNExpression) {
            this.write((IsNaNExpression)aValue);
        } else if (aValue instanceof FloatValue) {
            this.write((FloatValue)aValue);
        } else if (aValue instanceof ByteValue) {
            this.write((ByteValue)aValue);
        } else if (aValue instanceof ResolveCallsiteObjectExpression) {
            this.write((ResolveCallsiteObjectExpression)aValue);
        } else if (aValue instanceof DoubleValue) {
            this.write((DoubleValue)aValue);
        } else if (aValue instanceof FloatingPointCeilExpression) {
            this.write((FloatingPointCeilExpression)aValue);
        } else if (aValue instanceof FloatingPointFloorExpression) {
            this.write((FloatingPointFloorExpression)aValue);
        } else if (aValue instanceof MaxExpression) {
            this.write((MaxExpression)aValue);
        } else if (aValue instanceof LambdaWithStaticImplExpression) {
            this.write((LambdaWithStaticImplExpression)aValue);
        } else if (aValue instanceof LambdaConstructorReferenceExpression) {
            this.write((LambdaConstructorReferenceExpression)aValue);
        } else if (aValue instanceof LambdaVirtualReferenceExpression) {
            this.write((LambdaVirtualReferenceExpression)aValue);
        } else if (aValue instanceof LambdaInterfaceReferenceExpression) {
            this.write((LambdaInterfaceReferenceExpression)aValue);
        } else if (aValue instanceof LambdaSpecialReferenceExpression) {
            this.write((LambdaSpecialReferenceExpression)aValue);
        } else if (aValue instanceof EnumConstantsExpression) {
            this.write((EnumConstantsExpression)aValue);
        } else if (aValue instanceof MethodTypeArgumentCheckExpression) {
            this.write((MethodTypeArgumentCheckExpression)aValue);
        } else if (aValue instanceof SqrtExpression) {
            this.write((SqrtExpression)aValue);
        } else if (aValue instanceof NewMultiArrayExpression) {
            this.write((NewMultiArrayExpression)aValue);
        } else if (aValue instanceof SuperTypeOfExpression) {
            this.write((SuperTypeOfExpression)aValue);
        } else if (aValue instanceof MethodHandlesGeneratedLookupExpression) {
            this.write((MethodHandlesGeneratedLookupExpression)aValue);
        } else if (aValue instanceof MethodTypeExpression) {
            this.write((MethodTypeExpression)aValue);
        } else if (aValue instanceof MethodHandleExpression) {
            this.write((MethodHandleExpression)aValue);
        } else if (aValue instanceof PtrOfExpression) {
            this.write((PtrOfExpression)aValue);
        } else {
            throw new IllegalStateException("Not implemented : " + aValue.getClass());
        }
    }

    private void write(PtrOfExpression aValue) {
        Value v = (Value)aValue.incomingDataFlows().get(0);
        if (v instanceof Variable) {
            this.writeSameAssignmentHack(v.resolveType(), v);
        } else {
            this.write(v, true);
        }
    }

    private void write(MethodHandleExpression aValue) {
        if (aValue.getAdapterAnnotation() == null) {
            this.target.print("ptrtoint ");
            this.target.print(LLVMWriterUtils.toSignature(aValue.getImplementationSignature()));
            String theMethodName = LLVMWriterUtils.toMethodName(aValue.getClassName(), aValue.getMethodName(), aValue.getImplementationSignature());
            this.target.print("* @");
            this.target.print(theMethodName);
            this.target.print(" to i32");
            return;
        }
        this.target.print("ptrtoint ");
        this.target.print(LLVMWriterUtils.toSignature(aValue.getAdapterAnnotation().getCaptureSignature()));
        String theMethodName = this.symbolResolver.methodHandleDelegateFor(aValue);
        this.target.print("* @");
        this.target.print(theMethodName);
        this.target.print(" to i32");
    }

    private void write(MethodTypeExpression e) {
        BytecodeMethodSignature theSignature = e.getSignature();
        this.target.print("call i32 @");
        this.target.print(this.symbolResolver.methodTypeFactoryNameFor(theSignature));
        this.target.print("()");
    }

    private void write(MethodHandlesGeneratedLookupExpression e) {
        this.target.print("add i32 0, 0");
    }

    private void write(SuperTypeOfExpression e) {
        this.target.print("call i32 @jlClass_jlClassgetSuperclass(i32 ");
        this.write((Value)e.incomingDataFlows().get(0), true);
        this.target.print(")");
    }

    private void write(NewMultiArrayExpression e) {
        String theMethodName;
        List theDimensions = e.incomingDataFlows();
        switch (theDimensions.size()) {
            case 1: {
                theMethodName = LLVMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
                break;
            }
            case 2: {
                theMethodName = LLVMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported number of dimensions : " + theDimensions.size());
            }
        }
        this.target.write("call i32 @");
        this.target.write(theMethodName);
        this.target.write("(i32 0");
        for (Value theDimension : theDimensions) {
            this.target.write(",i32 ");
            this.write(theDimension, true);
        }
        this.target.write(",i32 %");
        this.target.print(LLVMWriterUtils.runtimeClassVariableName(BytecodeObjectTypeRef.fromRuntimeClass(Array.class)));
        this.target.write(",i32 %");
        this.target.write(this.toTempSymbol(e, "vtable"));
        this.target.write(")");
        this.currentSubProgram.writeDebugSuffixFor(e, this.target);
    }

    private void write(SqrtExpression e) {
        if (e.resolveType().resolve() == TypeRef.Native.DOUBLE) {
            this.target.print("call double @llvm.sqrt.f64(double ");
            this.write((Value)e.incomingDataFlows().get(0), true);
            this.target.print(")");
        } else {
            this.target.print("call float @llvm.sqrt.f32(float ");
            this.write((Value)e.incomingDataFlows().get(0), true);
            this.target.print(")");
        }
    }

    private void write(MethodTypeArgumentCheckExpression e) {
        TypeRef.Native theExpectedType = e.getExpectedType();
        Value theMethodType = (Value)e.incomingDataFlows().get(0);
        Value theIndex = (Value)e.incomingDataFlows().get(1);
        this.target.print("call i32 @bytecoder.checkmethodtype(i32 ");
        this.write(theMethodType, true);
        this.target.print(", i32 ");
        this.write(theIndex, true);
        this.target.print(", i32 ");
        this.target.print(-theExpectedType.ordinal());
        this.target.print(")");
    }

    private void write(EnumConstantsExpression e) {
        this.target.print("load i32, i32* %");
        this.target.print(this.toTempSymbol(e, "ptr"));
    }

    private void write(LambdaWithStaticImplExpression e) {
        this.target.print("call i32 @bytecoder.newLambda(i32 ");
        this.write(e.getType(), true);
        this.target.print(",i32 ");
        this.write(e.getStaticRef(), true);
        this.target.print(",i32 ");
        this.write(e.getStaticArguments(), true);
        this.target.print(")");
    }

    private void write(LambdaConstructorReferenceExpression e) {
        this.target.print("call i32 @bytecoder.newLambda(i32 ");
        this.write(e.getType(), true);
        this.target.print(",i32 ");
        this.write(e.getConstructorRef(), true);
        this.target.print(",i32 ");
        this.write(e.getStaticArguments(), true);
        this.target.print(")");
    }

    private void write(LambdaInterfaceReferenceExpression e) {
        this.target.print("call i32 @bytecoder.newLambda(i32 ");
        this.write(e.getType(), true);
        this.target.print(",i32 ");
        this.write(e.getInterfaceRef(), true);
        this.target.print(",i32 ");
        this.write(e.getStaticArguments(), true);
        this.target.print(")");
    }

    private void write(LambdaVirtualReferenceExpression e) {
        this.target.print("call i32 @bytecoder.newLambda(i32 ");
        this.write(e.getType(), true);
        this.target.print(",i32 ");
        this.write(e.getVirtualRef(), true);
        this.target.print(",i32 ");
        this.write(e.getStaticArguments(), true);
        this.target.print(")");
    }

    private void write(LambdaSpecialReferenceExpression e) {
        this.target.print("call i32 @bytecoder.newLambda(i32 ");
        this.write(e.getType(), true);
        this.target.print(",i32 ");
        this.write(e.getSpecialRef(), true);
        this.target.print(",i32 ");
        this.write(e.getStaticArguments(), true);
        this.target.print(")");
    }

    private void write(MaxExpression e) {
        this.target.print("call ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        switch (e.resolveType().resolve()) {
            case DOUBLE: {
                this.target.print(" @llvm.maximum.f64");
                break;
            }
            case FLOAT: {
                this.target.print(" @llvm.maximum.f32");
                break;
            }
            case LONG: {
                this.target.print(" @bytecoder.maximum.i64");
                break;
            }
            default: {
                this.target.print(" @bytecoder.maximum.i32");
            }
        }
        this.target.print("(");
        this.target.print(LLVMWriterUtils.toType(((Value)e.incomingDataFlows().get(0)).resolveType()));
        this.target.print(" ");
        this.writeResolved((Value)e.incomingDataFlows().get(0));
        this.target.print(",");
        this.target.print(LLVMWriterUtils.toType(((Value)e.incomingDataFlows().get(1)).resolveType()));
        this.target.print(" ");
        this.writeResolved((Value)e.incomingDataFlows().get(1));
        this.target.print(")");
    }

    private void write(FloatingPointFloorExpression e) {
        if (e.resolveType().resolve() == TypeRef.Native.DOUBLE) {
            this.target.print("call double @llvm.floor.f64(double ");
            this.writeResolved((Value)e.incomingDataFlows().get(0));
            this.target.print(")");
        } else {
            this.target.print("call float @llvm.floor.f32(float ");
            this.writeResolved((Value)e.incomingDataFlows().get(0));
            this.target.print(")");
        }
    }

    private void write(FloatingPointCeilExpression e) {
        if (e.resolveType().resolve() == TypeRef.Native.DOUBLE) {
            this.target.print("call double @llvm.ceil.f64(double ");
            this.writeResolved((Value)e.incomingDataFlows().get(0));
            this.target.print(")");
        } else {
            this.target.print("call float @llvm.ceil.f32(float ");
            this.writeResolved((Value)e.incomingDataFlows().get(0));
            this.target.print(")");
        }
    }

    private void write(ResolveCallsiteObjectExpression e) {
        BytecodeLinkedClass theOwningClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(e.getOwningClass().getThisInfo().getConstant()));
        this.target.print("call i32 @");
        this.target.print(this.symbolResolver.resolveCallsiteBootstrapFor(theOwningClass, e.getCallsiteId(), e.getProgram(), e.getBootstrapMethod()));
        this.target.print("()");
    }

    private void write(ByteValue e) {
        this.target.print(e.getByteValue());
    }

    private void write(FloatValue e) {
        long doubleBits = Double.doubleToRawLongBits(e.getFloatValue());
        this.target.print(String.format("0x%X", doubleBits));
    }

    private void write(DoubleValue e) {
        long doubleBits = Double.doubleToRawLongBits((float)e.getDoubleValue());
        this.target.print(String.format("0x%X", doubleBits));
    }

    private void write(IsNaNExpression e) {
        Value theValue = (Value)e.incomingDataFlows().get(0);
        if (theValue.resolveType().resolve() == TypeRef.Native.DOUBLE) {
            this.target.print("call i32 @bytecoder.isnan.double(");
            this.target.print(LLVMWriterUtils.toType(theValue.resolveType()));
            this.target.print(" ");
            this.writeResolved(theValue);
            this.target.print(")");
        } else {
            this.target.print("call i32 @bytecoder.isnan.float(");
            this.target.print(LLVMWriterUtils.toType(theValue.resolveType()));
            this.target.print(" ");
            this.writeResolved(theValue);
            this.target.print(")");
        }
    }

    private void write(TypeOfExpression e) {
        this.target.print("load i32, i32* %");
        this.target.print(this.toTempSymbol(e, "ptr"));
    }

    private void write(MinExpression e) {
        this.target.print("call ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        switch (e.resolveType().resolve()) {
            case DOUBLE: {
                this.target.print(" @llvm.minimum.f64");
                break;
            }
            case FLOAT: {
                this.target.print(" @llvm.minimum.f32");
                break;
            }
            case LONG: {
                this.target.print(" @bytecoder.minimum.i64");
                break;
            }
            default: {
                this.target.print(" @bytecoder.minimum.i32");
            }
        }
        this.target.print("(");
        this.target.print(LLVMWriterUtils.toType(((Value)e.incomingDataFlows().get(0)).resolveType()));
        this.target.print(" ");
        this.writeResolved((Value)e.incomingDataFlows().get(0));
        this.target.print(",");
        this.target.print(LLVMWriterUtils.toType(((Value)e.incomingDataFlows().get(1)).resolveType()));
        this.target.print(" ");
        this.writeResolved((Value)e.incomingDataFlows().get(1));
        this.target.print(")");
    }

    private void write(FloorExpression e) {
        block0 : switch (((Value)e.incomingDataFlows().get(0)).resolveType().resolve()) {
            case DOUBLE: {
                this.target.print("fptosi double ");
                this.writeResolved((Value)e.incomingDataFlows().get(0));
                switch (e.resolveType().resolve()) {
                    case LONG: {
                        this.target.print(" to i64");
                        break block0;
                    }
                }
                this.target.print(" to i32");
                break;
            }
            case LONG: {
                this.target.print("fptosi double ");
                this.writeResolved((Value)e.incomingDataFlows().get(0));
                switch (e.resolveType().resolve()) {
                    case LONG: {
                        this.target.print(" to i64");
                        break block0;
                    }
                }
                this.target.print(" to i32");
                break;
            }
            default: {
                this.target.print("fptosi float ");
                this.writeResolved((Value)e.incomingDataFlows().get(0));
                switch (e.resolveType().resolve()) {
                    case LONG: {
                        this.target.print(" to i64");
                        break block0;
                    }
                }
                this.target.print(" to i32");
            }
        }
    }

    private void write(NegatedExpression e) {
        switch (e.resolveType().resolve()) {
            case FLOAT: 
            case DOUBLE: {
                this.target.print("fneg ");
                this.target.print(LLVMWriterUtils.toType(e.resolveType()));
                this.target.print(" ");
                this.writeResolved((Value)e.incomingDataFlows().get(0));
                break;
            }
            default: {
                this.target.print("mul ");
                this.target.print(LLVMWriterUtils.toType(e.resolveType()));
                this.target.print(" ");
                this.writeResolved((Value)e.incomingDataFlows().get(0));
                this.target.print(",-1");
            }
        }
    }

    private void write(CompareExpression e) {
        TypeRef.Native theValue2Type;
        Value theValue1 = (Value)e.incomingDataFlows().get(0);
        Value theValue2 = (Value)e.incomingDataFlows().get(1);
        TypeRef.Native theValue1Type = theValue1.resolveType().resolve();
        if (theValue1Type != (theValue2Type = theValue2.resolveType().resolve())) {
            throw new IllegalStateException("Does not support mixed types : " + theValue1Type + " -> " + theValue2Type);
        }
        switch (theValue1Type) {
            case FLOAT: 
            case DOUBLE: {
                this.target.print("call i32 @bytecoder.compare.float(");
                break;
            }
            default: {
                this.target.print("call i32 @bytecoder.compare.i32(");
            }
        }
        this.target.print(LLVMWriterUtils.toType(theValue1.resolveType()));
        this.target.print(" ");
        this.writeResolved(theValue1);
        this.target.print(",");
        this.target.print(LLVMWriterUtils.toType(theValue2.resolveType()));
        this.target.print(" ");
        this.writeResolved(theValue2);
        this.target.print(")");
    }

    private void write(NewObjectExpression e) {
        String theMethodName = LLVMWriterUtils.toMethodName(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class), "newObject", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        this.target.print("call i32 @");
        this.target.print(theMethodName);
        this.target.print("(i32 0,i32 ");
        NativeMemoryLayouter.MemoryLayout theLayout = this.memoryLayouter.layoutFor(BytecodeObjectTypeRef.fromUtf8Constant(e.getType().getConstant()));
        this.target.print(theLayout.instanceSize());
        this.target.print(",i32 %");
        this.target.print(LLVMWriterUtils.runtimeClassVariableName(BytecodeObjectTypeRef.fromUtf8Constant(e.getType().getConstant())));
        this.target.print(",i32 %");
        this.target.print(this.toTempSymbol(e, "vtable"));
        this.target.print(")");
        this.currentSubProgram.writeDebugSuffixFor(e, this.target);
    }

    private void write(InstanceOfExpression e) {
        this.target.print("call i32 @bytecoder.instanceof(i32 ");
        this.writeResolved((Value)e.incomingDataFlows().get(0));
        this.target.print(",i32 ");
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(e.getType().getConstant()));
        this.target.print(theLinkedClass.getUniqueId());
        this.target.print(")");
    }

    private void write(NewInstanceFromDefaultConstructorExpression e) {
        this.target.write("call i32 @");
        this.target.write(NEWINSTANCEHELPER);
        this.target.write("(i32 ");
        this.writeResolved((Value)e.incomingDataFlows().get(0));
        this.target.write(")");
    }

    private void write(ArrayEntryExpression e) {
        this.target.print("load ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        this.target.print(", ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        this.target.print("* %");
        this.target.print(this.toTempSymbol(e, "ptrptr"));
        this.target.println();
    }

    private void write(FixedBinaryExpression e) {
        switch (e.getOperator()) {
            case ISNULL: {
                this.target.print("icmp eq i32 ");
                this.writeResolved((Value)e.incomingDataFlows().get(0));
                this.target.print(",0");
                break;
            }
            case ISZERO: {
                this.target.print("icmp eq i32 ");
                this.writeResolved((Value)e.incomingDataFlows().get(0));
                this.target.print(",0");
                break;
            }
            case ISNONNULL: {
                this.target.print("icmp ne i32 ");
                this.writeResolved((Value)e.incomingDataFlows().get(0));
                this.target.print(",0");
                break;
            }
            default: {
                throw new IllegalStateException("Not implemented : " + (Object)((Object)e.getOperator()));
            }
        }
    }

    private void write(ArrayLengthExpression e) {
        this.target.print("load i32 ");
        this.target.print(",i32* %");
        this.target.print(this.toTempSymbol(e, "ptr"));
    }

    private void write(ClassReferenceValue e) {
        this.target.print("add i32 %");
        this.target.print(LLVMWriterUtils.runtimeClassVariableName(e.getType()));
        this.target.print(", 0");
    }

    private void write(StringValue e) {
        this.target.print("load i32, i32* @");
        this.target.print(this.symbolResolver.globalFromStringPool(e.getStringValue()));
    }

    private void write(SystemHasStackExpression e) {
        this.target.print("add i32 0, 0");
    }

    private void write(HeapBaseExpression e) {
        this.target.print("ptrtoint i32* @__heap_base to i32");
    }

    private void write(DataEndExpression e) {
        this.target.print("ptrtoint i32* @__data_end to i32");
    }

    private void write(GetStaticExpression e) {
        this.target.print("load ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        this.target.print(", ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        this.target.print("* %");
        this.target.print(this.toTempSymbol(e, "ptr"));
    }

    private void write(NullValue e) {
        this.target.print("add i32 0, 0");
    }

    private void write(GetFieldExpression e) {
        this.target.print("load ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        this.target.print(", ");
        this.target.print(LLVMWriterUtils.toType(e.resolveType()));
        this.target.print("* %");
        this.target.print(this.toTempSymbol(e, "ptr"));
    }

    private void write(NewObjectAndConstructExpression e) {
        if (e.isEscaping()) {
            int i;
            this.linkerContext.getStatistics().context("Codegenerator").counter("ObjectOnHeapAllocations").increment();
            this.target.print("call i32 (i32");
            for (i = 0; i < e.getSignature().getArguments().length; ++i) {
                this.target.print(",");
                this.target.print(LLVMWriterUtils.toType(TypeRef.toType(e.getSignature().getArguments()[i])));
            }
            this.target.print(") @");
            this.target.print(LLVMWriterUtils.toMethodName(e.getClazz(), NEWINSTANCE_METHOD_NAME, e.getSignature()));
            this.target.print("(i32 %");
            this.target.print(LLVMWriterUtils.runtimeClassVariableName(e.getClazz()));
            for (i = 0; i < e.incomingDataFlows().size(); ++i) {
                this.target.print(",");
                this.target.print(LLVMWriterUtils.toType(TypeRef.toType(e.getSignature().getArguments()[i])));
                this.target.print(" ");
                this.writeResolved((Value)e.incomingDataFlows().get(i));
            }
            this.target.println(")");
        } else {
            this.linkerContext.getStatistics().context("Codegenerator").counter("ObjectOnStackAllocations").increment();
            this.target.print("add i32 0, %");
            this.target.print(this.toTempSymbol(e, "alloc_int"));
            this.target.println(";; does not escape, please verify");
        }
    }

    private void write(StackTopExpression e) {
        this.target.print("load i32, i32* @stacktop");
    }

    private void writeSameAssignmentHack(TypeRef theType, Value aValue) {
        switch (theType.resolve()) {
            case FLOAT: {
                this.target.print("fadd float 0.0,");
                break;
            }
            case DOUBLE: {
                this.target.print("fadd double 0.0,");
                break;
            }
            case LONG: {
                this.target.print("add i64 0,");
                break;
            }
            default: {
                this.target.print("add i32 0,");
            }
        }
        this.writeResolved(aValue);
    }

    private void write(TypeConversionExpression e) {
        TypeRef theTargetType = e.resolveType();
        Value theSource = (Value)e.incomingDataFlows().get(0);
        if (Objects.equals(theTargetType.resolve(), theSource.resolveType().resolve())) {
            this.writeSameAssignmentHack(theTargetType, theSource);
            return;
        }
        switch (theSource.resolveType().resolve()) {
            case DOUBLE: {
                switch (e.resolveType().resolve()) {
                    case DOUBLE: {
                        this.writeSameAssignmentHack(theTargetType, theSource);
                        return;
                    }
                    case FLOAT: {
                        this.target.print("fptrunc double ");
                        this.writeResolved(theSource);
                        this.target.print(" to float");
                        return;
                    }
                    case LONG: {
                        this.target.print("call i64 @bytecoder.double.to.i64(double ");
                        this.writeResolved(theSource);
                        this.target.print(")");
                        return;
                    }
                    case INT: 
                    case SHORT: 
                    case BYTE: 
                    case CHAR: {
                        this.target.print("call i32 @bytecoder.double.to.i32(double ");
                        this.writeResolved(theSource);
                        this.target.print(")");
                        return;
                    }
                }
                throw new IllegalStateException("Coversion to " + e.resolveType() + " not supported!");
            }
            case FLOAT: {
                switch (e.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fpext float ");
                        this.writeResolved(theSource);
                        this.target.print(" to double");
                        return;
                    }
                    case FLOAT: {
                        this.writeSameAssignmentHack(theTargetType, theSource);
                        return;
                    }
                    case LONG: {
                        this.target.print("call i64 @bytecoder.float.to.i64(float ");
                        this.writeResolved(theSource);
                        this.target.print(")");
                        return;
                    }
                    case INT: 
                    case SHORT: 
                    case BYTE: 
                    case CHAR: {
                        this.target.print("call i32 @bytecoder.float.to.i32(float ");
                        this.writeResolved(theSource);
                        this.target.print(")");
                        return;
                    }
                }
                throw new IllegalStateException("Coversion to " + e.resolveType() + " not supported!");
            }
            case LONG: {
                switch (e.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("sitofp i64 ");
                        this.writeResolved(theSource);
                        this.target.print(" to double");
                        return;
                    }
                    case FLOAT: {
                        this.target.print("sitofp i64 ");
                        this.writeResolved(theSource);
                        this.target.print(" to float");
                        return;
                    }
                    case LONG: {
                        this.writeSameAssignmentHack(theTargetType, theSource);
                        return;
                    }
                    case INT: 
                    case SHORT: 
                    case BYTE: 
                    case CHAR: {
                        this.target.print("trunc i64 ");
                        this.writeResolved(theSource);
                        this.target.print(" to i32");
                        return;
                    }
                }
                throw new IllegalStateException("Coversion to " + e.resolveType() + " not supported!");
            }
            case INT: 
            case SHORT: 
            case BYTE: 
            case CHAR: {
                switch (e.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.write("sitofp i32 ");
                        this.writeResolved(theSource);
                        this.target.write(" to double");
                        return;
                    }
                    case FLOAT: {
                        this.target.write("sitofp i32 ");
                        this.writeResolved(theSource);
                        this.target.write(" to float");
                        return;
                    }
                    case LONG: {
                        this.target.write("sext i32 ");
                        this.writeResolved(theSource);
                        this.target.write(" to i64");
                        return;
                    }
                    case INT: 
                    case SHORT: 
                    case BYTE: 
                    case CHAR: {
                        this.writeSameAssignmentHack(theTargetType, theSource);
                        return;
                    }
                }
                throw new IllegalStateException("target type " + e.resolveType() + " not supported!");
            }
        }
        throw new IllegalStateException("Conversion to " + e.resolveType() + " not supported!");
    }

    private void write(ComputedMemoryLocationReadExpression e) {
        this.target.print("load i32, i32* %");
        this.target.print(this.toTempSymbol(e, "ptr"));
    }

    private void write(ComputedMemoryLocationWriteExpression e) {
        this.target.print("i32* %");
        this.target.print(this.toTempSymbol(e, "ptr"));
    }

    private void write(MemorySizeExpression aValue) {
        this.target.print("mul i32 %");
        this.target.print(this.toTempSymbol(aValue, "raw"));
        this.target.print(", 65536");
    }

    private void write(PHIValue aValue) {
        this.target.print("%");
        this.target.print(this.toTempSymbol(aValue, "phi"));
    }

    private void write(BinaryExpression aValue) {
        Value theValue1 = (Value)aValue.incomingDataFlows().get(0);
        block0 : switch (aValue.getOperator()) {
            case ADD: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fadd double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fadd float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("add i64");
                        break block0;
                    }
                }
                this.target.print("add i32");
                break;
            }
            case SUB: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fsub double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fsub float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("sub i64");
                        break block0;
                    }
                }
                this.target.print("sub i32");
                break;
            }
            case MUL: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fmul double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fmul float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("mul i64");
                        break block0;
                    }
                }
                this.target.print("mul i32");
                break;
            }
            case REMAINDER: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("frem double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("frem float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("srem i64");
                        break block0;
                    }
                }
                this.target.print("srem i32");
                break;
            }
            case GREATERTHAN: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fcmp ogt double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fcmp ogt float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("icmp sgt i64");
                        break block0;
                    }
                }
                this.target.print("icmp sgt i32");
                break;
            }
            case GREATEROREQUALS: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fcmp oge double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fcmp oge float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("icmp sge i64");
                        break block0;
                    }
                }
                this.target.print("icmp sge i32");
                break;
            }
            case LESSTHAN: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fcmp olt double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fcmp olt float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("icmp slt i64");
                        break block0;
                    }
                }
                this.target.print("icmp slt i32");
                break;
            }
            case LESSTHANOREQUALS: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fcmp ole double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fcmp ole float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("icmp sle i64");
                        break block0;
                    }
                }
                this.target.print("icmp sle i32");
                break;
            }
            case EQUALS: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fcmp oeq double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fcmp oeq float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("icmp eq i64");
                        break block0;
                    }
                }
                this.target.print("icmp eq i32");
                break;
            }
            case NOTEQUALS: {
                switch (theValue1.resolveType().resolve()) {
                    case DOUBLE: {
                        this.target.print("fcmp one double");
                        break block0;
                    }
                    case FLOAT: {
                        this.target.print("fcmp one float");
                        break block0;
                    }
                    case LONG: {
                        this.target.print("icmp ne i64");
                        break block0;
                    }
                }
                this.target.print("icmp ne i32");
                break;
            }
            case BINARYSHIFTLEFT: {
                switch (theValue1.resolveType().resolve()) {
                    case LONG: {
                        this.target.print("shl i64");
                        break block0;
                    }
                }
                this.target.print("shl i32");
                break;
            }
            case BINARYSHIFTRIGHT: {
                switch (theValue1.resolveType().resolve()) {
                    case LONG: {
                        this.target.print("ashr i64");
                        break block0;
                    }
                }
                this.target.print("ashr i32");
                break;
            }
            case BINARYUNSIGNEDSHIFTRIGHT: {
                switch (theValue1.resolveType().resolve()) {
                    case LONG: {
                        this.target.print("lshr i64");
                        break block0;
                    }
                }
                this.target.print("lshr i32");
                break;
            }
            case BINARYOR: {
                switch (theValue1.resolveType().resolve()) {
                    case LONG: {
                        this.target.print("or i64");
                        break block0;
                    }
                }
                this.target.print("or i32");
                break;
            }
            case BINARYXOR: {
                switch (theValue1.resolveType().resolve()) {
                    case LONG: {
                        this.target.print("xor i64");
                        break block0;
                    }
                }
                this.target.print("xor i32");
                break;
            }
            case BINARYAND: {
                switch (theValue1.resolveType().resolve()) {
                    case LONG: {
                        this.target.print("and i64");
                        break block0;
                    }
                }
                this.target.print("and i32");
                break;
            }
            case DIV: {
                this.writeDivExpression(aValue);
                return;
            }
            default: {
                throw new IllegalStateException("Not implemented : " + (Object)((Object)aValue.getOperator()));
            }
        }
        this.target.print(" ");
        List v = aValue.incomingDataFlows();
        for (int i = 0; i < v.size(); ++i) {
            Value value = (Value)v.get(i);
            if (i > 0) {
                this.target.print(",");
                switch (aValue.getOperator()) {
                    case BINARYSHIFTLEFT: 
                    case BINARYSHIFTRIGHT: 
                    case BINARYUNSIGNEDSHIFTRIGHT: {
                        if (((Value)v.get(0)).resolveType().resolve() == TypeRef.Native.LONG) {
                            this.target.print("%");
                            this.target.print(this.toTempSymbol(aValue, "v2_ext"));
                            break;
                        }
                        this.writeResolved(value);
                        break;
                    }
                    default: {
                        this.writeResolved(value);
                        break;
                    }
                }
                continue;
            }
            this.writeResolved(value);
        }
    }

    private void writeDivExpression(BinaryExpression e) {
        Value left = (Value)e.incomingDataFlows().get(0);
        Value right = (Value)e.incomingDataFlows().get(1);
        switch (left.resolveType().resolve()) {
            case DOUBLE: {
                this.target.print("fdiv double ");
                this.writeResolved(left);
                this.target.print(", ");
                this.writeResolved(right);
                return;
            }
            case FLOAT: {
                this.target.print("fdiv float ");
                this.writeResolved(left);
                this.target.print(", ");
                this.writeResolved(right);
                return;
            }
            case LONG: {
                this.target.print("fdiv double %");
                this.target.print(this.toTempSymbol(e, "v1"));
                this.target.print(", %");
                this.target.print(this.toTempSymbol(e, "v2"));
                break;
            }
            default: {
                this.target.print("fdiv float %");
                this.target.print(this.toTempSymbol(e, "v1"));
                this.target.print(", %");
                this.target.print(this.toTempSymbol(e, "v2"));
            }
        }
    }

    private void write(IntegerValue aValue) {
        this.target.print(aValue.getIntValue());
    }

    private void write(LongValue aValue) {
        this.target.print(aValue.getLongValue());
    }

    private void write(InvokeStaticMethodExpression aValue) {
        this.target.print("call ");
        this.target.print(LLVMWriterUtils.toSignature(aValue.getSignature()));
        this.target.print(" @");
        this.target.print(LLVMWriterUtils.toMethodName(aValue.getClassName(), aValue.getMethodName(), aValue.getSignature()));
        if (aValue.getClassName().name().equals(MemoryManager.class.getName())) {
            this.target.print("(i32 0");
        } else {
            this.target.print("(i32 %");
            this.target.print(LLVMWriterUtils.runtimeClassVariableName(aValue.getClassName()));
        }
        List args = aValue.incomingDataFlows();
        for (int i = 0; i < args.size(); ++i) {
            this.target.print(",");
            Value theValue = (Value)args.get(i);
            this.target.print(LLVMWriterUtils.toType(TypeRef.toType(aValue.getSignature().getArguments()[i])));
            this.target.print(" ");
            this.writeResolved(theValue);
        }
        this.target.print(")");
        this.currentSubProgram.writeDebugSuffixFor(aValue, this.target);
    }

    private static class PHIValuePair {
        private final String nodeLabel;
        private final Value phiValue;

        public PHIValuePair(String nodeLabel, Value phiValue) {
            this.nodeLabel = nodeLabel;
            this.phiValue = phiValue;
        }
    }

    static interface SymbolResolver {
        public String globalFromStringPool(String var1);

        public String resolveCallsiteBootstrapFor(BytecodeLinkedClass var1, String var2, Program var3, RegionNode var4);

        public String methodTypeFactoryNameFor(BytecodeMethodSignature var1);

        public BytecodeVTable vtableFor(BytecodeLinkedClass var1);

        public String methodHandleDelegateFor(MethodHandleExpression var1);
    }
}

