/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.llvm;

import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.ssa.DebugPosition;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.Program;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LLVMDebugInformation {
    private final Map<String, CompileUnit> compileUnits = new HashMap<String, CompileUnit>();
    private int elementCounter = 10;

    public CompileUnit compileUnitFor(Program program) {
        CompileUnit unit;
        String fileName = program.getDebugInformation().originalFileName();
        if (fileName == null) {
            fileName = "/unknown";
        }
        if ((unit = this.compileUnits.get(fileName)) == null) {
            CompileFile compileFile = new CompileFile(this.elementCounter++, fileName);
            unit = new CompileUnit(this.elementCounter++, compileFile);
            this.compileUnits.put(fileName, unit);
        }
        return unit;
    }

    public CompileUnit compileUnitFor(String fileName) {
        CompileUnit unit = this.compileUnits.get(fileName);
        if (unit == null) {
            CompileFile compileFile = new CompileFile(this.elementCounter++, fileName);
            unit = new CompileUnit(this.elementCounter++, compileFile);
            this.compileUnits.put(fileName, unit);
        }
        return unit;
    }

    public void writeHeaderTo(PrintWriter pw) {
        ArrayList<CompileUnit> theUnits = new ArrayList<CompileUnit>(this.compileUnits.values());
        for (CompileUnit compileUnit : theUnits) {
            CompileFile file = compileUnit.compileFile;
            String fileName = file.fileName;
            int p = fileName.lastIndexOf(47);
            pw.print("!");
            pw.print(file.id);
            pw.print("= !DIFile(filename:\"");
            pw.print(file.fileName.substring(p + 1));
            pw.print("\", directory:\"");
            pw.print(file.fileName.substring(0, p));
            pw.println("\")");
            pw.print("!");
            pw.print(compileUnit.id);
            pw.print("= distinct !DICompileUnit(language: DW_LANG_Java, file: !");
            pw.print(file.id);
            pw.println(", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !3)");
            for (SubProgram prog : compileUnit.programs) {
                pw.print("!");
                pw.print(prog.id);
                pw.print(" = distinct !DISubprogram(name: \"");
                pw.print(prog.name);
                pw.print("\", unit: !");
                pw.print(compileUnit.id);
                pw.print(", file: !");
                pw.print(file.id);
                pw.print(", scope: !");
                pw.print(file.id);
                pw.println(", isDefinition: true, type: !4, isLocal: false, isOptimized: true,  retainedNodes: !3)");
                for (Location l : prog.locations.values()) {
                    pw.print("!");
                    pw.print(l.id);
                    pw.print(" = !DILocation(line: ");
                    pw.print(l.lineNumber);
                    pw.print(", column: ");
                    pw.print(l.column);
                    pw.print(", scope: !");
                    pw.print(prog.id);
                    pw.println(")");
                }
            }
        }
        pw.print("!llvm.dbg.cu = !{");
        for (int i = 0; i < theUnits.size(); ++i) {
            if (i > 0) {
                pw.print(",");
            }
            pw.print("!");
            pw.print(((CompileUnit)theUnits.get((int)i)).id);
        }
        pw.println("}");
        pw.println("!0 = !{i32 2, !\"Dwarf Version\", i32 4}");
        pw.println("!1 = !{i32 2, !\"Debug Info Version\", i32 3}");
        pw.println("!2 = !{!\"Bytecoder\"}");
        pw.println("!3 = !{}");
        pw.println("!4 = !DISubroutineType(types: !5)");
        pw.println("!5 = !{null}");
        pw.println("!llvm.module.flags = !{!0, !1}");
        pw.println("!llvm.ident = !{!2}");
    }

    public class CompileUnit
    extends Metadata {
        private final CompileFile compileFile;
        private final List<SubProgram> programs;

        public CompileUnit(int id, CompileFile compileFile) {
            super(id);
            this.compileFile = compileFile;
            this.programs = new ArrayList<SubProgram>();
        }

        public SubProgram subProgram(Program p, String name, BytecodeMethodSignature signature) {
            SubProgram program = new SubProgram(LLVMDebugInformation.this.elementCounter++, p, name, signature);
            this.programs.add(program);
            return program;
        }
    }

    public static class Location
    extends Metadata {
        private final int lineNumber;
        private final int column;

        public Location(int id, int lineNumber, int column) {
            super(id);
            this.lineNumber = lineNumber;
            this.column = column;
        }
    }

    public class SubProgram
    extends Metadata {
        private final Program program;
        private final String name;
        private final BytecodeMethodSignature methodSignature;
        private DebugPosition lastDebugPosition;
        private final Map<Integer, Location> locations;

        public SubProgram(int id, Program p, String name, BytecodeMethodSignature methodSignature) {
            super(id);
            this.locations = new HashMap<Integer, Location>();
            this.program = p;
            this.name = name;
            this.methodSignature = methodSignature;
            this.lastDebugPosition = null;
        }

        public void writeDebugSuffixFor(Expression e, PrintWriter pw) {
            Location l;
            DebugPosition p = this.program.getDebugInformation().debugPositionFor(e.getAddress());
            if (p == null) {
                p = this.lastDebugPosition;
            }
            if (p == null) {
                p = new DebugPosition("unknown", 1);
            }
            if ((l = this.locations.get(p.getLineNumber())) == null) {
                l = new Location(LLVMDebugInformation.this.elementCounter++, p.getLineNumber(), 1);
                this.locations.put(p.getLineNumber(), l);
            }
            pw.print(", !dbg !");
            pw.print(l.id);
            this.lastDebugPosition = p;
        }
    }

    public static class CompileFile
    extends Metadata {
        private final String fileName;

        public CompileFile(int id, String fileName) {
            super(id);
            this.fileName = fileName;
        }
    }

    public static class Metadata {
        protected final int id;

        public Metadata(int id) {
            this.id = id;
        }

        public void writeDebugSuffixTo(PrintWriter pw) {
            pw.print("!dbg !");
            pw.print(this.id);
        }
    }
}

