/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.llvm;

import de.mirkosertic.bytecoder.api.EmulatedByRuntime;
import de.mirkosertic.bytecoder.api.Export;
import de.mirkosertic.bytecoder.api.OpaqueIndexed;
import de.mirkosertic.bytecoder.api.OpaqueMethod;
import de.mirkosertic.bytecoder.api.OpaqueProperty;
import de.mirkosertic.bytecoder.api.Substitutes;
import de.mirkosertic.bytecoder.backend.CompileBackend;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.CompileResult;
import de.mirkosertic.bytecoder.backend.NativeMemoryLayouter;
import de.mirkosertic.bytecoder.backend.llvm.LLVMCompileResult;
import de.mirkosertic.bytecoder.backend.llvm.LLVMDebugInformation;
import de.mirkosertic.bytecoder.backend.llvm.LLVMIntrinsics;
import de.mirkosertic.bytecoder.backend.llvm.LLVMWriter;
import de.mirkosertic.bytecoder.backend.llvm.LLVMWriterUtils;
import de.mirkosertic.bytecoder.classlib.Address;
import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.classlib.MemoryManager;
import de.mirkosertic.bytecoder.classlib.VM;
import de.mirkosertic.bytecoder.classlib.java.util.Quicksort;
import de.mirkosertic.bytecoder.core.BytecodeAccessFlags;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeImportedLink;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import de.mirkosertic.bytecoder.core.BytecodeResolvedMethods;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.core.BytecodeVTable;
import de.mirkosertic.bytecoder.core.BytecodeVirtualMethodIdentifier;
import de.mirkosertic.bytecoder.core.EscapeAnalysis;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.optimizer.KnownOptimizer;
import de.mirkosertic.bytecoder.ssa.MethodHandleExpression;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.ProgramGenerator;
import de.mirkosertic.bytecoder.ssa.ProgramGeneratorFactory;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class LLVMCompilerBackend
implements CompileBackend<LLVMCompileResult> {
    private final ProgramGeneratorFactory programGeneratorFactory;

    public LLVMCompilerBackend(ProgramGeneratorFactory aProgramGeneratorFactory) {
        this.programGeneratorFactory = aProgramGeneratorFactory;
    }

    @Override
    public LLVMCompileResult generateCodeFor(CompileOptions aOptions, BytecodeLinkerContext aLinkerContext, Class aEntryPointClass, String aEntryPointMethodName, BytecodeMethodSignature aEntryPointSignature) {
        BytecodeLinkedClass theArrayClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
        theArrayClass.resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
        BytecodeLinkedClass theMemoryManagerClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(MemoryManager.class));
        theMemoryManagerClass.resolveStaticMethod("freeMem", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[0]));
        theMemoryManagerClass.resolveStaticMethod("usedMem", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[0]));
        theMemoryManagerClass.resolveStaticMethod("free", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("malloc", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("newObject", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("newArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("initStackObject", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        theMemoryManagerClass.resolveStaticMethod("initStackArray", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        LLVMCompileResult theCompileResult = new LLVMCompileResult();
        ArrayList opaqueReferenceMethods = new ArrayList();
        final ArrayList compiledMethods = new ArrayList();
        try {
            Object theLLContent22;
            Object theProvider;
            final ArrayList stringPool = new ArrayList();
            final HashMap callsites = new HashMap();
            final ArrayList theMethodTypes = new ArrayList();
            final ArrayList methodHandles = new ArrayList();
            LLVMWriter.SymbolResolver theSymbolResolver = new LLVMWriter.SymbolResolver(){
                private final Map<BytecodeLinkedClass, BytecodeVTable> tablesCache = new HashMap<BytecodeLinkedClass, BytecodeVTable>();

                @Override
                public String globalFromStringPool(String aValue) {
                    int i = stringPool.indexOf(aValue);
                    if (i >= 0) {
                        return "strpool_" + i;
                    }
                    stringPool.add(aValue);
                    return "strpool_" + (stringPool.size() - 1);
                }

                @Override
                public String resolveCallsiteBootstrapFor(BytecodeLinkedClass owningClass, String callsiteId, Program program, RegionNode bootstrapMethod) {
                    CallSite callSite = (CallSite)callsites.get(callsiteId);
                    if (callSite == null) {
                        callSite = new CallSite(owningClass, program, bootstrapMethod);
                        callsites.put(callsiteId, callSite);
                    }
                    return "resolvecallsite" + System.identityHashCode(callSite);
                }

                @Override
                public String methodTypeFactoryNameFor(BytecodeMethodSignature aSignature) {
                    for (int i = 0; i < theMethodTypes.size(); ++i) {
                        if (!aSignature.matchesExactlyTo((BytecodeMethodSignature)theMethodTypes.get(0))) continue;
                        return "methodtypefactory" + i;
                    }
                    theMethodTypes.add(aSignature);
                    return "methodtypefactory" + (theMethodTypes.size() - 1);
                }

                @Override
                public BytecodeVTable vtableFor(BytecodeLinkedClass aClass) {
                    BytecodeVTable theTable = this.tablesCache.get(aClass);
                    if (theTable == null) {
                        theTable = aClass.resolveVTable();
                        this.tablesCache.put(aClass, theTable);
                    }
                    return theTable;
                }

                @Override
                public String methodHandleDelegateFor(MethodHandleExpression e) {
                    int pos = methodHandles.size();
                    methodHandles.add(e);
                    return "handle" + pos;
                }
            };
            LLVMDebugInformation debugInformation = new LLVMDebugInformation();
            NativeMemoryLayouter memoryLayouter = new NativeMemoryLayouter(aLinkerContext, 8);
            File theTempDirectory = new File(new File("."), ".llvm");
            aOptions.getLogger().info("Using directory {} for temporary LLVM files", new Object[]{theTempDirectory});
            if (!theTempDirectory.exists()) {
                theTempDirectory.mkdirs();
            }
            File theLLFile = new File(theTempDirectory, aEntryPointClass.getName() + aEntryPointMethodName + ".ll");
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(theLLFile), StandardCharsets.UTF_8));){
                int j;
                int i;
                Object methodName;
                Object ptr;
                pw.println("target triple = \"wasm32-unknown-unknown\"");
                pw.println("target datalayout = \"e-m:e-p:32:32-i64:64-n32:64-S128\"");
                pw.println();
                pw.println("@__heap_base = external global i32");
                pw.println("@__data_end = external global i32");
                pw.println("@__memory_base = external global i32");
                pw.println("@stacktop = global i32 0");
                pw.println();
                pw.println("declare i32 @llvm.wasm.memory.size.i32(i32) nounwind readonly");
                pw.println("declare void @llvm.trap() cold noreturn nounwind");
                pw.println("declare float @llvm.minimum.f32(float %Val0, float %Val1)");
                pw.println("declare double @llvm.minimum.f64(double %Val0, double %Val1)");
                pw.println("declare float @llvm.maximum.f32(float %Val0, float %Val1)");
                pw.println("declare double @llvm.maximum.f64(double %Val0, double %Val1)");
                pw.println("declare float @llvm.floor.f32(float %Val)");
                pw.println("declare double @llvm.floor.f64(double %Val)");
                pw.println("declare float @llvm.ceil.f32(float %Val)");
                pw.println("declare double @llvm.ceil.f64(double %Val)");
                pw.println("declare float @llvm.sqrt.f32(float %Val)");
                pw.println("declare double @llvm.sqrt.f64(double %Val)");
                pw.println();
                AtomicInteger attributeCounter = new AtomicInteger();
                aLinkerContext.linkedClasses().forEach(aEntry -> {
                    if (((BytecodeLinkedClass)aEntry.targetNode()).getBytecodeClass().getAccessFlags().isInterface() && !((BytecodeLinkedClass)aEntry.targetNode()).isOpaqueType()) {
                        return;
                    }
                    if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                        return;
                    }
                    if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(java.lang.reflect.Array.class))) {
                        return;
                    }
                    BytecodeResolvedMethods theMethodMap = ((BytecodeLinkedClass)aEntry.targetNode()).resolvedMethods();
                    theMethodMap.stream().forEach(aMethodMapEntry -> {
                        BytecodeLinkedClass theProvidingClass = aMethodMapEntry.getProvidingClass();
                        if (theProvidingClass != aEntry.targetNode()) {
                            return;
                        }
                        BytecodeMethod t = aMethodMapEntry.getValue();
                        BytecodeMethodSignature theSignature = t.getSignature();
                        if (t.getAccessFlags().isNative() || t.getAccessFlags().isAbstract() && theProvidingClass.isOpaqueType()) {
                            if (theProvidingClass.emulatedByRuntime()) {
                                return;
                            }
                            if (t.emulatedByRuntime()) {
                                return;
                            }
                            if (!t.getAccessFlags().isNative() && theProvidingClass.isOpaqueType()) {
                                opaqueReferenceMethods.add(new OpaqueReferenceMethod(theProvidingClass, t));
                            }
                            boolean needsAdapterMethod = false;
                            if (theSignature.getReturnType() == BytecodePrimitiveTypeRef.LONG) {
                                needsAdapterMethod = true;
                            }
                            for (BytecodeTypeRef theTypeRef : t.getSignature().getArguments()) {
                                if (theTypeRef != BytecodePrimitiveTypeRef.LONG) continue;
                                needsAdapterMethod = true;
                                aLinkerContext.getLogger().warn("Possible pecision impact on Long datatype when calling imported method {}.{} with signature {}", new Object[]{theProvidingClass.getClassName().name(), t.getName().stringValue(), t.getSignature()});
                            }
                            BytecodeImportedLink theLink = theProvidingClass.linkFor(t);
                            String methodName = LLVMWriterUtils.toMethodName(theProvidingClass.getClassName(), t.getName(), theSignature);
                            pw.print("attributes #");
                            pw.print(attributeCounter.get());
                            pw.print(" = {");
                            pw.print("\"wasm-import-module\"");
                            pw.print("=");
                            pw.print("\"");
                            pw.print(theLink.getModuleName());
                            pw.print("\" ");
                            pw.print("\"wasm-import-name\"");
                            pw.print("=");
                            pw.print("\"");
                            pw.print(theLink.getLinkName());
                            pw.println("\"}");
                            String returnType = LLVMWriterUtils.toType(TypeRef.toType(t.getSignature().getReturnType()));
                            if (needsAdapterMethod) {
                                BytecodeTypeRef theParamType;
                                int i;
                                pw.print("declare ");
                                if (t.getSignature().getReturnType() == BytecodePrimitiveTypeRef.LONG) {
                                    pw.print("double");
                                } else {
                                    pw.print(returnType);
                                }
                                pw.print(" @");
                                pw.print(methodName);
                                pw.print("_adapter(");
                                pw.print(LLVMWriterUtils.toType(TypeRef.Native.REFERENCE));
                                pw.print(" ");
                                pw.print("%thisRef");
                                for (i = 0; i < theSignature.getArguments().length; ++i) {
                                    theParamType = theSignature.getArguments()[i];
                                    if (theParamType == BytecodePrimitiveTypeRef.LONG) {
                                        pw.print(",double %p");
                                        pw.print(i + 1);
                                        continue;
                                    }
                                    String theTypeAsString = LLVMWriterUtils.toType(TypeRef.toType(theParamType));
                                    pw.print(",");
                                    pw.print(theTypeAsString);
                                    pw.print(" %p");
                                    pw.print(i + 1);
                                }
                                pw.print(")");
                                pw.print(" #");
                                pw.print(attributeCounter);
                                pw.println();
                                pw.println();
                                pw.print("define internal ");
                                pw.print(returnType);
                                pw.print(" @");
                                pw.print(methodName);
                                pw.print("(");
                                pw.print(LLVMWriterUtils.toType(TypeRef.Native.REFERENCE));
                                pw.print(" ");
                                pw.print("%thisRef");
                                for (i = 0; i < theSignature.getArguments().length; ++i) {
                                    theParamType = theSignature.getArguments()[i];
                                    pw.print(",");
                                    pw.print(LLVMWriterUtils.toType(TypeRef.toType(theParamType)));
                                    pw.print(" ");
                                    pw.print("%p");
                                    pw.print(i + 1);
                                }
                                pw.println(") inlinehint {");
                                StringBuilder theArguments = new StringBuilder("i32 %thisRef");
                                for (int i2 = 0; i2 < theSignature.getArguments().length; ++i2) {
                                    if (theSignature.getArguments()[i2] == BytecodePrimitiveTypeRef.LONG) {
                                        pw.print("    %p");
                                        pw.print(i2 + 1);
                                        pw.print("_converted = sitofp i64 %p");
                                        pw.print(i2 + 1);
                                        pw.println(" to double");
                                        theArguments.append(",double %p");
                                        theArguments.append(i2 + 1);
                                        theArguments.append("_converted");
                                        continue;
                                    }
                                    theArguments.append(",");
                                    theArguments.append(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getArguments()[i2])));
                                    theArguments.append(" %p");
                                    theArguments.append(i2 + 1);
                                }
                                if (theSignature.getReturnType() != BytecodePrimitiveTypeRef.VOID) {
                                    pw.print("    %temp = call ");
                                    if (theSignature.getReturnType() == BytecodePrimitiveTypeRef.LONG) {
                                        pw.print("double");
                                    } else {
                                        pw.print(returnType);
                                    }
                                    pw.print(" @");
                                    pw.print(methodName);
                                } else {
                                    pw.print("    call void @");
                                    pw.print(methodName);
                                }
                                pw.print("_adapter(");
                                pw.print(theArguments);
                                pw.println(")");
                                if (theSignature.getReturnType() != BytecodePrimitiveTypeRef.VOID) {
                                    if (theSignature.getReturnType() == BytecodePrimitiveTypeRef.LONG) {
                                        pw.print("    %conv = fptosi double %temp to ");
                                        pw.println(returnType);
                                        pw.print("    ret ");
                                        pw.print(returnType);
                                        pw.println(" %conv");
                                    } else {
                                        pw.print("    ret ");
                                        pw.print(returnType);
                                        pw.println(" %temp");
                                    }
                                } else {
                                    pw.println("    ret void");
                                }
                                pw.println("}");
                                pw.println();
                            } else {
                                pw.print("declare ");
                                pw.print(returnType);
                                pw.print(" @");
                                pw.print(methodName);
                                pw.print("(");
                                pw.print(LLVMWriterUtils.toType(TypeRef.Native.REFERENCE));
                                pw.print(" ");
                                pw.print("%thisRef");
                                for (int i = 0; i < theSignature.getArguments().length; ++i) {
                                    BytecodeTypeRef theParamType = theSignature.getArguments()[i];
                                    pw.print(",");
                                    pw.print(LLVMWriterUtils.toType(TypeRef.toType(theParamType)));
                                    pw.print(" ");
                                    pw.print("%p");
                                    pw.print(i + 1);
                                }
                                pw.print(")");
                                pw.print(" #");
                                pw.print(attributeCounter);
                                pw.println();
                                pw.println();
                            }
                            attributeCounter.incrementAndGet();
                        }
                    });
                });
                pw.println("define internal i32 @bytecoder.instanceof(i32 %object, i32 %typeid) inlinehint {");
                pw.println("entry:");
                pw.println("    %nulltest = icmp eq i32 %object, 0");
                pw.println("    br i1 %nulltest, label %isnull, label %notnull");
                pw.println("notnull:");
                pw.println("    %ptr = add i32 %object, 4");
                pw.println("    %ptr_ptr = inttoptr i32 %ptr to i32*");
                pw.println("    %ptr_loaded = load i32, i32* %ptr_ptr");
                pw.println("    %vtable = inttoptr i32 %ptr_loaded to i32*");
                pw.println("    %resolved_ptr = load i32, i32* %vtable");
                pw.println("    %resolved_ptr_ptr = inttoptr i32 %resolved_ptr to i32(i32,i32)*");
                pw.println("    %result = call i32 %resolved_ptr_ptr(i32 %object, i32 %typeid)");
                pw.println("    ret i32 %result");
                pw.println("isnull:");
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @jlClass_BOOLEANisAssignableFromjlClass(i32 %thisRef, i32 %otherType) {");
                pw.println("entry:");
                aLinkerContext.linkedClasses().forEach(aEntry -> {
                    BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
                    if (theLinkedClass.emulatedByRuntime()) {
                        return;
                    }
                    if (theLinkedClass.getClassName().equals(BytecodeObjectTypeRef.fromRuntimeClass(Class.class))) {
                        return;
                    }
                    pw.print("    %runtimeclass_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(" = call i32 @");
                    pw.print(LLVMWriterUtils.toClassName(theLinkedClass.getClassName()));
                    pw.print("__init");
                    pw.println("()");
                    pw.print("    %test");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(" = icmp eq i32 %otherType, %runtimeclass_");
                    pw.println(theLinkedClass.getUniqueId());
                    pw.print("    br i1 %test");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(", label %class");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(", label %notclass");
                    pw.println(theLinkedClass.getUniqueId());
                    pw.print("class");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.println(":");
                    for (BytecodeLinkedClass theImplType : theLinkedClass.getImplementingTypes()) {
                        pw.print("    %runtimeclass_");
                        pw.print(theLinkedClass.getUniqueId());
                        pw.print("_");
                        pw.print(theImplType.getUniqueId());
                        pw.print(" = call i32 @");
                        pw.print(LLVMWriterUtils.toClassName(theImplType.getClassName()));
                        pw.print("__init");
                        pw.println("()");
                        pw.print("    %test_");
                        pw.print(theLinkedClass.getUniqueId());
                        pw.print("_");
                        pw.print(theImplType.getUniqueId());
                        pw.print(" = icmp eq i32 %thisRef, %");
                        pw.print("runtimeclass_");
                        pw.print(theLinkedClass.getUniqueId());
                        pw.print("_");
                        pw.println(theImplType.getUniqueId());
                        pw.print("    br i1 %test_");
                        pw.print(theLinkedClass.getUniqueId());
                        pw.print("_");
                        pw.print(theImplType.getUniqueId());
                        pw.print(", label %assignable, label %test");
                        pw.print(theLinkedClass.getUniqueId());
                        pw.print("_");
                        pw.print(theImplType.getUniqueId());
                        pw.println("_notok");
                        pw.print("test");
                        pw.print(theLinkedClass.getUniqueId());
                        pw.print("_");
                        pw.print(theImplType.getUniqueId());
                        pw.println("_notok:");
                    }
                    pw.println("    ret i32 0");
                    pw.print("notclass");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.println(":");
                });
                pw.println("    ret i32 0");
                pw.println("assignable:");
                pw.println("    ret i32 1");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @jlClass_jlClassgetSuperclass(i32 %type) inlinehint {");
                pw.println("entry:");
                aLinkerContext.linkedClasses().forEach(aEntry -> {
                    BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
                    if (theLinkedClass.emulatedByRuntime()) {
                        return;
                    }
                    String prefix = "pre" + theLinkedClass.getUniqueId();
                    pw.print("    %");
                    pw.print(prefix);
                    pw.print("_runtimeclass = load i32, i32* @");
                    pw.print(LLVMWriterUtils.toClassName(theLinkedClass.getClassName()));
                    pw.println("__runtimeclass");
                    pw.print("    %");
                    pw.print(prefix);
                    pw.print("_check = icmp eq i32 %type, %");
                    pw.print(prefix);
                    pw.println("_runtimeclass");
                    pw.print("    br i1 %");
                    pw.print(prefix);
                    pw.print("_check");
                    pw.print(", label %");
                    pw.print(prefix);
                    pw.print("_ok");
                    pw.print(", label %");
                    pw.print(prefix);
                    pw.println("_notok");
                    pw.print(prefix);
                    pw.print("_ok");
                    pw.println(":");
                    if (!theLinkedClass.getClassName().name().equals(Object.class.getName())) {
                        pw.print("    %");
                        pw.print(prefix);
                        pw.print("_superclass = load i32, i32* @");
                        pw.print(LLVMWriterUtils.toClassName(theLinkedClass.getSuperClass().getClassName()));
                        pw.println("__runtimeclass");
                        pw.print("    ret i32 ");
                        pw.print("%");
                        pw.print(prefix);
                        pw.println("_superclass");
                    } else {
                        pw.println("    ret i32 0");
                    }
                    pw.print(prefix);
                    pw.print("_notok");
                    pw.println(":");
                });
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.isnan.float(float %value) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = fcmp oeq float %value, %value");
                pw.println("    br i1 %test, label %iseq, label %isnoteq");
                pw.println("iseq:");
                pw.println("    ret i32 0");
                pw.println("isnoteq:");
                pw.println("    ret i32 1");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.isnan.double(double %value) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = fcmp oeq double %value, %value");
                pw.println("    br i1 %test, label %iseq, label %isnoteq");
                pw.println("iseq:");
                pw.println("    ret i32 0");
                pw.println("isnoteq:");
                pw.println("    ret i32 1");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.float.to.i32(float %value) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = fcmp oeq float %value, %value");
                pw.println("    br i1 %test, label %iseq, label %isnoteq");
                pw.println("iseq:");
                pw.println("    %converted = fptosi float %value to i32");
                pw.println("    ret i32 %converted");
                pw.println("isnoteq:");
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i64 @bytecoder.float.to.i64(float %value) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = fcmp oeq float %value, %value");
                pw.println("    br i1 %test, label %iseq, label %isnoteq");
                pw.println("iseq:");
                pw.println("    %converted = fptosi float %value to i64");
                pw.println("    ret i64 %converted");
                pw.println("isnoteq:");
                pw.println("    ret i64 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.double.to.i32(double %value) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = fcmp oeq double %value, %value");
                pw.println("    br i1 %test, label %iseq, label %isnoteq");
                pw.println("iseq:");
                pw.println("    %converted = fptosi double %value to i32");
                pw.println("    ret i32 %converted");
                pw.println("isnoteq:");
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i64 @bytecoder.double.to.i64(double %value) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = fcmp oeq double %value, %value");
                pw.println("    br i1 %test, label %iseq, label %isnoteq");
                pw.println("iseq:");
                pw.println("    %converted = fptosi double %value to i64");
                pw.println("    ret i64 %converted");
                pw.println("isnoteq:");
                pw.println("    ret i64 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.compare.i32(i32 %v1, i32 %v2) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = icmp eq i32 %v1,%v2");
                pw.println("    br i1 %test, label %iseq, label %isnoteq");
                pw.println("iseq:");
                pw.println("    ret i32 0");
                pw.println("isnoteq:");
                pw.println("    %test2 = icmp sgt i32 %v1,%v2");
                pw.println("    br i1 %test2, label %isgreater, label %issmaller");
                pw.println("isgreater:");
                pw.println("    ret i32 1");
                pw.println("issmaller:");
                pw.println("    ret i32 -1");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.compare.float(float %v1, float %v2) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = fcmp oeq float %v1,%v2");
                pw.println("    br i1 %test, label %iseq, label %isnoteq");
                pw.println("iseq:");
                pw.println("    ret i32 0");
                pw.println("isnoteq:");
                pw.println("    %test2 = fcmp ogt float %v1,%v2");
                pw.println("    br i1 %test2, label %isgreater, label %issmaller");
                pw.println("isgreater:");
                pw.println("    ret i32 1");
                pw.println("issmaller:");
                pw.println("    ret i32 -1");
                pw.println("}");
                pw.println();
                pw.println("define internal i1 @bytecoder.exceedsrange(i32 %v, i32 %min, i32 %max) inlinehint {");
                pw.println("entry:");
                pw.println("    %test = icmp slt i32 %v, %min");
                pw.println("    br i1 %test, label %exceed, label %continue");
                pw.println("continue:");
                pw.println("    %test2 = icmp sgt i32 %v, %max");
                pw.println("    br i1 %test2, label %exceed, label %ok");
                pw.println("ok:");
                pw.println("    ret i1 false");
                pw.println("exceed:");
                pw.println("    ret i1 true");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.maximum.i32(i32 %a, i32 %b) inlinehint {");
                pw.println("entry:");
                pw.println("   %test = icmp sgt i32 %a, %b");
                pw.println("   br i1 %test, label %aisgreater, label %notgreater");
                pw.println("aisgreater:");
                pw.println("   ret i32 %a");
                pw.println("notgreater:");
                pw.println("   ret i32 %b");
                pw.println("}");
                pw.println();
                pw.println("define internal i64 @bytecoder.maximum.i64(i64 %a, i64 %b) inlinehint {");
                pw.println("entry:");
                pw.println("   %test = icmp sgt i64 %a, %b");
                pw.println("   br i1 %test, label %aisgreater, label %notgreater");
                pw.println("aisgreater:");
                pw.println("   ret i64 %a");
                pw.println("notgreater:");
                pw.println("   ret i64 %b");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.minimum.i32(i32 %a, i32 %b) inlinehint {");
                pw.println("entry:");
                pw.println("   %test = icmp slt i32 %a, %b");
                pw.println("   br i1 %test, label %aissmaller, label %notsmaller");
                pw.println("aissmaller:");
                pw.println("   ret i32 %a");
                pw.println("notsmaller:");
                pw.println("   ret i32 %b");
                pw.println("}");
                pw.println();
                pw.println("define internal i64 @bytecoder.minimum.i64(i64 %a, i64 %b) inlinehint {");
                pw.println("entry:");
                pw.println("   %test = icmp slt i64 %a, %b");
                pw.println("   br i1 %test, label %aissmaller, label %notsmaller");
                pw.println("aissmaller:");
                pw.println("   ret i64 %a");
                pw.println("notsmaller:");
                pw.println("   ret i64 %b");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.checkmethodtype(i32 %methodType, i32 %index, i32 %expectedType) inlinehint {");
                pw.println("entry:");
                pw.println("    %offset = mul i32 %index, 4");
                pw.println("    %ptr1 = add i32 %offset, 24");
                pw.println("    %ptr2 = add i32 %ptr1, %methodType");
                pw.println("    %ptr = inttoptr i32 %ptr2 to i32*");
                pw.println("    %type = load i32, i32* %ptr");
                pw.println("    %cmp = icmp eq i32 %type, %expectedType");
                pw.println("    br i1 %cmp, label %equals, label %notequals");
                pw.println("equals:");
                pw.println("    ret i32 1");
                pw.println("notequals:");
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.lambda__interfacedispatch(i32 %thisRef,i32 %methodId) {");
                pw.println("    %offset = add i32 %thisRef, 8");
                pw.println("    %offsetptr = inttoptr i32 %offset to i32*");
                pw.println("    %ptr = load i32, i32* %offsetptr");
                pw.println("    ret i32 %ptr");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.newLambda(i32 %methodType, i32 %implementationMethod, i32 %staticArguments) {");
                pw.println("entry:");
                pw.println("    %lambda_interface_dispatch = ptrtoint i32(i32,i32)* @bytecoder.lambda__interfacedispatch to i32");
                pw.println("    %type_offset = add i32 20, %methodType");
                pw.println("    %type_offset_ptr = inttoptr i32 %type_offset to i32*");
                pw.println("    %runtimeClass = load i32, i32* %type_offset_ptr");
                pw.println("    %vtable = call i32 @dynamicvtable(i32 %runtimeClass, i32 %implementationMethod,i32 %lambda_interface_dispatch)");
                pw.print("    %allocated = call i32 @");
                pw.print(LLVMWriterUtils.toClassName(theMemoryManagerClass.getClassName()));
                pw.println("_INTnewObjectINTINTINT(i32 0,i32 16,i32 %runtimeClass,i32 %vtable)");
                pw.println("    %offset1 = add i32 %allocated, 8");
                pw.println("    %offset1ptr = inttoptr i32 %offset1 to i32*");
                pw.println("    store i32 %implementationMethod, i32* %offset1ptr");
                pw.println("    %offset2 = add i32 %allocated, 12");
                pw.println("    %offset2ptr = inttoptr i32 %offset2 to i32*");
                pw.println("    store i32 %staticArguments, i32* %offset2ptr");
                pw.println("    ret i32 %allocated");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @jlObject_jlClassgetClassInternal(i32 %thisRef) {");
                pw.println("entry:");
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                BytecodeLinkedClass theClassLinkedCass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Class.class));
                BytecodeVTable theClassVTable = theSymbolResolver.vtableFor(theClassLinkedCass);
                List<BytecodeVTable.Slot> theClassSlots = theClassVTable.sortedSlots();
                pw.print("%");
                pw.print(LLVMWriterUtils.toClassName(theClassLinkedCass.getClassName()));
                pw.print("__vtable__type");
                pw.print(" = type {i1(i32,i32)*,i32(i32,i32)*");
                for (BytecodeVTable.Slot slot : theClassSlots) {
                    ptr = theClassVTable.slot(slot);
                    pw.print(",");
                    pw.print(LLVMWriterUtils.toSignature(((BytecodeVTable.VPtr)ptr).getSignature()));
                    pw.print("*");
                }
                pw.println("}");
                pw.println();
                pw.print("@");
                pw.print(LLVMWriterUtils.toClassName(theClassLinkedCass.getClassName()));
                pw.print("__vtable");
                pw.print(" = private global %");
                pw.print(LLVMWriterUtils.toClassName(theClassLinkedCass.getClassName()));
                pw.print("__vtable__type");
                pw.println(" {");
                pw.println("    i1(i32,i32)* undef,");
                pw.println("    i32(i32,i32)* undef");
                for (BytecodeVTable.Slot slot : theClassSlots) {
                    ptr = theClassVTable.slot(slot);
                    if (((BytecodeVTable.VPtr)ptr).getImplementingClass() != null) {
                        pw.println(",");
                        pw.print("    ");
                        pw.print(LLVMWriterUtils.toSignature(((BytecodeVTable.VPtr)ptr).getSignature()));
                        pw.print("* @");
                        pw.print(LLVMWriterUtils.toMethodName(((BytecodeVTable.VPtr)ptr).getImplementingClass(), ((BytecodeVTable.VPtr)ptr).getMethodName(), ((BytecodeVTable.VPtr)ptr).getSignature()));
                        continue;
                    }
                    pw.println(",");
                    pw.print("    ");
                    pw.print(LLVMWriterUtils.toSignature(((BytecodeVTable.VPtr)ptr).getSignature()));
                    pw.print("* undef");
                }
                pw.println();
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @jlClass_jlStringgetName(i32 %thisRef) {");
                pw.println("entry:");
                pw.println("    %offset = add i32 %thisRef, 16");
                pw.println("    %ptr = inttoptr i32 %offset to i32*");
                pw.println("    %classname_ptr = load i32, i32* %ptr");
                pw.println("    %classname_ptrptr = inttoptr i32 %classname_ptr to i32*");
                pw.println("    %classname = load i32, i32* %classname_ptrptr");
                pw.println("    ret i32 %classname");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @jlClass_BOOLEANdesiredAssertionStatus(i32 %thisRef) {");
                pw.println("entry:");
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @jlClass_A1jlObjectgetEnumConstants(i32 %thisRef) {");
                pw.println("entry:");
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @jlClass_jlClassLoadergetClassLoader(i32 %thisRef) {");
                pw.println("entry:");
                pw.println("    ret i32 0");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @jlClass_jlClassforNamejlStringBOOLEANjlClassLoader(i32 %thisRef, i32 %name, i32 %initialize, i32 %classloader) {");
                pw.println("entry:");
                aLinkerContext.linkedClasses().forEach(aEntry -> {
                    BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
                    if (theLinkedClass.getBytecodeClass().getAccessFlags().isInterface() || theLinkedClass.isOpaqueType()) {
                        return;
                    }
                    if (Objects.equals(theLinkedClass.getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                        return;
                    }
                    if (theLinkedClass.emulatedByRuntime()) {
                        return;
                    }
                    pw.print("    %class_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(" = load i32, i32* @");
                    pw.println(theSymbolResolver.globalFromStringPool(theLinkedClass.getClassName().name()));
                    pw.print("    %test_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(" = call i32 @jlString_BOOLEANequalsjlObject(i32 %class_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.println(",i32 %name)");
                    pw.print("    %check_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(" = icmp eq i32 1, %test_");
                    pw.println(theLinkedClass.getUniqueId());
                    pw.print("    br i1 %check_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(", label %check_ok_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(", label %check_notok_");
                    pw.println(theLinkedClass.getUniqueId());
                    pw.print("check_ok_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.println(":");
                    pw.print("    %init_");
                    pw.println(theLinkedClass.getUniqueId());
                    pw.print(" = call i32 @");
                    pw.print(LLVMWriterUtils.toClassName(theLinkedClass.getClassName()));
                    pw.print("__init");
                    pw.println("()");
                    pw.print("    ret i32 %init_");
                    pw.println(theLinkedClass.getUniqueId());
                    pw.print("check_notok_");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.println(":");
                });
                pw.println("    call void @llvm.trap()");
                pw.println("    unreachable");
                pw.println("}");
                pw.println();
                pw.println("define internal i32 @bytecoder.newRuntimeClass(i32 %type, i32 %staticSize, i32 %enumValuesOffset, i32 %nameStringPoolIndex) {");
                pw.println("entry:");
                pw.println("    %vtableptr = ptrtoint %jlClass__vtable__type* @jlClass__vtable to i32");
                pw.println("    %allocated = call i32 @dmbcMemoryManager_INTnewObjectINTINTINT(i32 0, i32 %staticSize, i32 -1, i32 %vtableptr)");
                pw.println("    %enumpos = add i32 %allocated, 12");
                pw.println("    %enumpos_ptr = inttoptr i32 %enumpos to i32*");
                pw.println("    store i32 %enumValuesOffset, i32* %enumpos_ptr");
                pw.println("    %namepos = add i32 %allocated, 16");
                pw.println("    %namepos_ptr = inttoptr i32 %namepos to i32*");
                pw.println("    store i32 %nameStringPoolIndex, i32* %namepos_ptr");
                pw.println("    %typepos = add i32 %allocated, 20");
                pw.println("    %typepos_ptr = inttoptr i32 %typepos to i32*");
                pw.println("    store i32 %type, i32* %typepos_ptr");
                pw.println("    ret i32 %allocated");
                pw.println("}");
                pw.println();
                aLinkerContext.linkedClasses().forEach(aEntry -> {
                    BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
                    if (!LLVMWriterUtils.filteredForTest(theLinkedClass)) {
                        return;
                    }
                    if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                        return;
                    }
                    if (theLinkedClass.emulatedByRuntime()) {
                        return;
                    }
                    BytecodeResolvedMethods theMethodMap = theLinkedClass.resolvedMethods();
                    String theClassName = LLVMWriterUtils.toClassName(theLinkedClass.getClassName());
                    pw.print("@");
                    pw.print(theClassName);
                    pw.print("__runtimeclass");
                    pw.println(" = private global i32 0");
                    pw.println();
                    pw.print("@");
                    pw.print(theClassName);
                    pw.print("__runtimeclassinitstatus");
                    pw.println(" = private global i32 0");
                    pw.println();
                    if (theLinkedClass != theClassLinkedCass) {
                        BytecodeVTable.VPtr ptr;
                        BytecodeVTable theVtable = theSymbolResolver.vtableFor(theLinkedClass);
                        List<BytecodeVTable.Slot> theSlots = theVtable.sortedSlots();
                        pw.print("%");
                        pw.print(LLVMWriterUtils.toClassName(theLinkedClass.getClassName()));
                        pw.print("__vtable__type");
                        pw.print(" = type {i1(i32,i32)*,i32(i32,i32)*");
                        for (BytecodeVTable.Slot slot : theSlots) {
                            ptr = theVtable.slot(slot);
                            pw.print(",");
                            pw.print(LLVMWriterUtils.toSignature(ptr.getSignature()));
                            pw.print("*");
                        }
                        pw.println("}");
                        pw.println();
                        pw.print("@");
                        pw.print(theClassName);
                        pw.print("__vtable");
                        pw.print(" = private global %");
                        pw.print(LLVMWriterUtils.toClassName(theLinkedClass.getClassName()));
                        pw.print("__vtable__type");
                        pw.println(" {");
                        if (!theLinkedClass.getBytecodeClass().getAccessFlags().isInterface() && !theLinkedClass.getBytecodeClass().getAccessFlags().isAbstract()) {
                            pw.print("    i1(i32,i32)* @");
                            pw.print(theClassName);
                            pw.print("__instanceof");
                            pw.println(",");
                            pw.print("    i32(i32,i32)* @");
                            pw.print(theClassName);
                            pw.print("__interfacedispatch");
                        } else {
                            pw.println("    i1(i32,i32)* undef,");
                            pw.print("    i32(i32,i32)* undef");
                        }
                        for (BytecodeVTable.Slot slot : theSlots) {
                            ptr = theVtable.slot(slot);
                            pw.println(",");
                            if (ptr.getImplementingClass() != null) {
                                pw.println("    ;;" + slot.getPos() + ", " + ptr.getMethodName() + "," + ptr.getSignature() + "," + ptr.getImplementingClass().name());
                            } else {
                                pw.println("    ;;" + slot.getPos() + ", " + ptr.getMethodName() + "," + ptr.getSignature() + ", abstract");
                            }
                            pw.print("    ");
                            pw.print(LLVMWriterUtils.toSignature(ptr.getSignature()));
                            pw.print("* ");
                            if (ptr.getImplementingClass() != null) {
                                BytecodeLinkedClass theSlotClass = aLinkerContext.resolveClass(ptr.getImplementingClass());
                                BytecodeMethod theMethod = theSlotClass.getBytecodeClass().methodByNameAndSignatureOrNull(ptr.getMethodName(), ptr.getSignature());
                                if (theMethod != null && !theMethod.getAccessFlags().isAbstract()) {
                                    pw.print("@");
                                    pw.print(LLVMWriterUtils.toMethodName(ptr.getImplementingClass(), ptr.getMethodName(), ptr.getSignature()));
                                    continue;
                                }
                                pw.print("undef");
                                continue;
                            }
                            pw.print("undef");
                        }
                        pw.println();
                        pw.println("}");
                        pw.println();
                    }
                    if (!Objects.equals(theLinkedClass.getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                        Object theSuper;
                        if (theLinkedClass.getClassName().name().equals(aEntryPointClass.getName())) {
                            pw.print("attributes #");
                            pw.print(attributeCounter.get());
                            pw.print(" = {");
                            pw.print("\"wasm-export-name\"");
                            pw.print("=");
                            pw.print("\"");
                            pw.print(theClassName);
                            pw.print("__init");
                            pw.println("\"}");
                            attributeCounter.incrementAndGet();
                            pw.print("define i32 @");
                        } else {
                            pw.print("define internal i32 @");
                        }
                        pw.print(theClassName);
                        pw.print("__init");
                        pw.println("() {");
                        pw.println("entry:");
                        pw.print("    %class = load i32, i32* @");
                        pw.print(theClassName);
                        pw.println("__runtimeclass");
                        pw.print("    %value = load i32, i32* @");
                        pw.print(theClassName);
                        pw.println("__runtimeclassinitstatus");
                        pw.println("    %initialized_compare = icmp eq i32 %value, 1");
                        pw.println("    br i1 %initialized_compare, label %done, label %unitialized");
                        pw.println("unitialized:");
                        pw.print("    store i32 1,i32* @");
                        pw.print(theClassName);
                        pw.println("__runtimeclassinitstatus");
                        if (!theLinkedClass.getClassName().name().equals(Object.class.getName()) && LLVMWriterUtils.filteredForTest((BytecodeLinkedClass)(theSuper = theLinkedClass.getSuperClass()))) {
                            String theSuperWASMName = LLVMWriterUtils.toClassName(((BytecodeLinkedClass)theSuper).getClassName());
                            pw.print("    call i32() @");
                            pw.print(theSuperWASMName);
                            pw.print("__init");
                            pw.println("()");
                        }
                        if (theLinkedClass.hasClassInitializer()) {
                            pw.print("    call void(i32) @");
                            pw.print(theClassName);
                            pw.println("_VOID$clinit$(i32 %class)");
                        }
                        pw.println("    br label %done");
                        pw.println("done:");
                        pw.println("    ret i32 %class");
                        pw.println("}");
                        pw.println();
                    }
                    if (!theLinkedClass.getBytecodeClass().getAccessFlags().isInterface() && !theLinkedClass.getBytecodeClass().getAccessFlags().isAbstract()) {
                        BytecodeVirtualMethodIdentifier theMethodIdentifier;
                        BytecodeMethod theMethod;
                        pw.print("define internal i1 @");
                        pw.print(theClassName);
                        pw.print("__instanceof");
                        pw.println("(i32 %thisRef,i32 %typeId) {");
                        pw.println("entry:");
                        pw.println("    switch i32 %typeId, label %default [");
                        for (BytecodeLinkedClass theType : theLinkedClass.getImplementingTypes()) {
                            pw.print("        i32 ");
                            pw.print(theType.getUniqueId());
                            pw.println(",label %true");
                        }
                        pw.println("    ]");
                        pw.println("default:");
                        pw.println("    ret i1 0");
                        pw.println("true:");
                        pw.println("    ret i1 1");
                        pw.println("}");
                        pw.println();
                        ArrayList<BytecodeResolvedMethods.MethodEntry> thevTable = new ArrayList<BytecodeResolvedMethods.MethodEntry>();
                        List theEntries = theMethodMap.stream().collect(Collectors.toList());
                        HashSet<BytecodeVirtualMethodIdentifier> theVisitedMethods = new HashSet<BytecodeVirtualMethodIdentifier>();
                        for (int i = theEntries.size() - 1; 0 <= i; --i) {
                            BytecodeResolvedMethods.MethodEntry aMethodMapEntry2 = (BytecodeResolvedMethods.MethodEntry)theEntries.get(i);
                            theMethod = aMethodMapEntry2.getValue();
                            if (theMethod.getAccessFlags().isStatic() || theMethod.isConstructor() || theMethod.getAccessFlags().isAbstract() || "desiredAssertionStatus".equals(theMethod.getName().stringValue()) || "getEnumConstants".equals(theMethod.getName().stringValue()) || theMethod.getAttributes().getAnnotationByType(Substitutes.class.getName()) != null || !theVisitedMethods.add(theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(theMethod))) continue;
                            thevTable.add(aMethodMapEntry2);
                        }
                        pw.print("define internal i32 @");
                        pw.print(theClassName);
                        pw.print("__interfacedispatch");
                        pw.println("(i32 %thisRef,i32 %methodId) {");
                        pw.println("entry:");
                        pw.println("    switch i32 %methodId, label %default [");
                        for (BytecodeResolvedMethods.MethodEntry entry : thevTable) {
                            theMethod = entry.getValue();
                            theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(theMethod);
                            if (!LLVMWriterUtils.filteredForTest(entry.getProvidingClass())) continue;
                            pw.print("        i32 ");
                            pw.print(theMethodIdentifier.getIdentifier());
                            pw.print(",label %v_table_");
                            pw.println(theMethodIdentifier.getIdentifier());
                        }
                        pw.println("    ]");
                        pw.println("default:");
                        pw.println("    call void @llvm.trap()");
                        pw.println("    unreachable");
                        for (BytecodeResolvedMethods.MethodEntry methodEntry : thevTable) {
                            theMethod = methodEntry.getValue();
                            theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(theMethod);
                            if (!LLVMWriterUtils.filteredForTest(methodEntry.getProvidingClass())) continue;
                            pw.print("v_table_");
                            pw.print(theMethodIdentifier.getIdentifier());
                            pw.println(":");
                            pw.print("    %ptr_");
                            pw.print(theMethodIdentifier.getIdentifier());
                            pw.print(" = ptrtoint ");
                            pw.print(LLVMWriterUtils.toSignature(theMethod.getSignature()));
                            pw.print("* @");
                            pw.print(LLVMWriterUtils.toMethodName(methodEntry.getProvidingClass().getClassName(), theMethod.getName(), theMethod.getSignature()));
                            pw.println(" to i32");
                            pw.print("    ret i32 %ptr_");
                            pw.print(theMethodIdentifier.getIdentifier());
                            pw.println();
                        }
                        pw.println("}");
                        pw.println();
                    }
                    theMethodMap.stream().forEach(aMethodMapEntry -> {
                        BytecodeMethod theMethod = aMethodMapEntry.getValue();
                        BytecodeMethodSignature theSignature = theMethod.getSignature();
                        if (null != theMethod.getAttributes().getAnnotationByType(EmulatedByRuntime.class.getName())) {
                            return;
                        }
                        if (theMethod.getAccessFlags().isAbstract()) {
                            return;
                        }
                        if (theMethod.getAccessFlags().isNative()) {
                            return;
                        }
                        if (aMethodMapEntry.getProvidingClass() != theLinkedClass) {
                            if (theMethod.getAccessFlags().isStatic() && !theMethod.isClassInitializer() && !theMethodMap.isImplementedBy(theMethod, theLinkedClass)) {
                                int i;
                                String theMethodName = LLVMWriterUtils.toMethodName(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), theMethod.getName().stringValue(), theMethod.getSignature());
                                pw.print("define internal ");
                                pw.print(LLVMWriterUtils.toType(TypeRef.toType(theMethod.getSignature().getReturnType())));
                                pw.print(" @");
                                pw.print(theMethodName);
                                pw.print("(i32 %runtimeClass");
                                for (i = 0; i < theMethod.getSignature().getArguments().length; ++i) {
                                    pw.print(",");
                                    pw.print(LLVMWriterUtils.toType(TypeRef.toType(theMethod.getSignature().getArguments()[i])));
                                    pw.print(" %p");
                                    pw.print(i);
                                }
                                pw.println(") {");
                                pw.println("entry:");
                                if (theMethod.getSignature().getReturnType().isVoid()) {
                                    pw.print("    call void @");
                                    pw.print(LLVMWriterUtils.toMethodName(aMethodMapEntry.getProvidingClass().getClassName(), theMethod.getName().stringValue(), theMethod.getSignature()));
                                    pw.print("(i32 %runtimeClass");
                                    for (i = 0; i < theMethod.getSignature().getArguments().length; ++i) {
                                        pw.print(",");
                                        pw.print(LLVMWriterUtils.toType(TypeRef.toType(theMethod.getSignature().getArguments()[i])));
                                        pw.print(" %p");
                                        pw.print(i);
                                    }
                                    pw.println(")");
                                    pw.println("    ret void");
                                } else {
                                    pw.print("    %temp = call ");
                                    pw.print(LLVMWriterUtils.toType(TypeRef.toType(theMethod.getSignature().getReturnType())));
                                    pw.print(" @");
                                    pw.print(LLVMWriterUtils.toMethodName(aMethodMapEntry.getProvidingClass().getClassName(), theMethod.getName().stringValue(), theMethod.getSignature()));
                                    pw.print("(i32 %runtimeClass");
                                    for (i = 0; i < theMethod.getSignature().getArguments().length; ++i) {
                                        pw.print(",");
                                        pw.print(LLVMWriterUtils.toType(TypeRef.toType(theMethod.getSignature().getArguments()[i])));
                                        pw.print(" %p");
                                        pw.print(i);
                                    }
                                    pw.println(")");
                                    pw.print("    ret ");
                                    pw.print(LLVMWriterUtils.toType(TypeRef.toType(theMethod.getSignature().getReturnType())));
                                    pw.println(" %temp");
                                }
                                pw.println("}");
                                pw.println();
                            }
                            return;
                        }
                        if (theMethod.isConstructor() && !theLinkedClass.getBytecodeClass().getAccessFlags().isAbstract() && !theLinkedClass.getBytecodeClass().getAccessFlags().isInterface()) {
                            if (theLinkedClass.getClassName().name().equals(aEntryPointClass.getName())) {
                                pw.print("attributes #");
                                pw.print(attributeCounter.get());
                                pw.print(" = {");
                                pw.print("\"wasm-export-name\"");
                                pw.print("=");
                                pw.print("\"");
                                pw.print(LLVMWriterUtils.toMethodName(theLinkedClass.getClassName(), "$newInstance", theMethod.getSignature()));
                                pw.println("\"}");
                                attributeCounter.incrementAndGet();
                                pw.print("define i32 @");
                            } else {
                                pw.print("define internal i32 @");
                            }
                            pw.print(LLVMWriterUtils.toMethodName(theLinkedClass.getClassName(), "$newInstance", theMethod.getSignature()));
                            pw.print("(i32 %class");
                            for (int i = 0; i < theMethod.getSignature().getArguments().length; ++i) {
                                pw.print(",");
                                pw.print(LLVMWriterUtils.toType(TypeRef.toType(theMethod.getSignature().getArguments()[i])));
                                pw.print(" %p");
                                pw.print(i);
                            }
                            pw.print(") #");
                            pw.print(attributeCounter.get());
                            attributeCounter.incrementAndGet();
                            pw.println(" {");
                            pw.println("entry:");
                            pw.print("    %vtableptr = ptrtoint %");
                            pw.print(theClassName);
                            pw.print("__vtable__type");
                            pw.print("* @");
                            pw.print(theClassName);
                            pw.print("__vtable");
                            pw.println(" to i32");
                            pw.print("    %allocated = call i32(i32,i32,i32,i32) @");
                            pw.print(LLVMWriterUtils.toMethodName(theMemoryManagerClass.getClassName(), "newObject", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT})));
                            pw.print("(");
                            pw.print("i32 0,");
                            NativeMemoryLayouter.MemoryLayout theLayout = memoryLayouter.layoutFor(theLinkedClass.getClassName());
                            pw.print("i32 ");
                            pw.print(theLayout.instanceSize());
                            pw.print(",");
                            pw.println("i32 %class ,i32 %vtableptr)");
                            pw.print("    call ");
                            pw.print(LLVMWriterUtils.toSignature(theMethod.getSignature()));
                            pw.print(" @");
                            pw.print(LLVMWriterUtils.toMethodName(theLinkedClass.getClassName(), theMethod.getName(), theMethod.getSignature()));
                            pw.print("(i32 %allocated");
                            for (int i = 0; i < theMethod.getSignature().getArguments().length; ++i) {
                                pw.print(",");
                                pw.print(LLVMWriterUtils.toType(TypeRef.toType(theMethod.getSignature().getArguments()[i])));
                                pw.print(" %p");
                                pw.print(i);
                            }
                            pw.println(")");
                            pw.println("    ret i32 %allocated");
                            pw.println("}");
                            pw.println();
                        }
                        ProgramGenerator theGenerator = this.programGeneratorFactory.createFor(aLinkerContext, new LLVMIntrinsics());
                        Program theSSAProgram = theGenerator.generateFrom(aMethodMapEntry.getProvidingClass().getBytecodeClass(), theMethod);
                        LLVMDebugInformation.CompileUnit compileUnit = debugInformation.compileUnitFor(theSSAProgram);
                        LLVMDebugInformation.SubProgram subProgram = compileUnit.subProgram(theSSAProgram, theMethod.getName().stringValue(), theSignature);
                        KnownOptimizer.LLVM.optimize(theSSAProgram.getControlFlowGraph(), aLinkerContext);
                        compiledMethods.add(new CompiledMethod(theLinkedClass, theMethod, theSSAProgram, subProgram));
                    });
                });
                pw.print("define internal i32 @");
                pw.print("bytecoder.newinstancehelper");
                pw.println("(i32 %runtimeclass) {");
                pw.println("entry:");
                aLinkerContext.linkedClasses().map(Edge::targetNode).forEach(search -> {
                    if (!LLVMWriterUtils.filteredForTest(search)) {
                        return;
                    }
                    if (!(search.getBytecodeClass().getAccessFlags().isAbstract() || search.getBytecodeClass().getAccessFlags().isInterface() || search.emulatedByRuntime())) {
                        String theClassName = LLVMWriterUtils.toClassName(search.getClassName());
                        BytecodeResolvedMethods theResolved = search.resolvedMethods();
                        theResolved.stream().filter(j -> j.getProvidingClass() == search).map(BytecodeResolvedMethods.MethodEntry::getValue).filter(j -> j.isConstructor() && j.getSignature().getArguments().length == 0).forEach(m -> {
                            pw.print("    %runtimeclass_");
                            pw.print(search.getUniqueId());
                            pw.print(" = load i32, i32* @");
                            pw.print(theClassName);
                            pw.println("__runtimeclass");
                            pw.print("    %runtimeclass_");
                            pw.print(search.getUniqueId());
                            pw.print("_check = icmp eq i32 %runtimeclass, %runtimeclass_");
                            pw.println(search.getUniqueId());
                            pw.print("    br i1 %runtimeclass_");
                            pw.print(search.getUniqueId());
                            pw.print("_check, label %checktrue_");
                            pw.print(search.getUniqueId());
                            pw.print(", label %checkfalse_");
                            pw.println(search.getUniqueId());
                            pw.print("checktrue_");
                            pw.print(search.getUniqueId());
                            pw.println(":");
                            pw.print("    %");
                            pw.print(LLVMWriterUtils.runtimeClassVariableName(search.getClassName()));
                            pw.print(" = call i32 @");
                            pw.print(LLVMWriterUtils.toClassName(search.getClassName()));
                            pw.print("__init");
                            pw.println("()");
                            pw.print("    %newinstance_");
                            pw.print(search.getUniqueId());
                            pw.print(" = call i32 @");
                            pw.print(LLVMWriterUtils.toMethodName(search.getClassName(), "$newInstance", m.getSignature()));
                            pw.print("(i32 %");
                            pw.print(LLVMWriterUtils.runtimeClassVariableName(search.getClassName()));
                            pw.println(")");
                            pw.print("    ret i32 %newinstance_");
                            pw.println(search.getUniqueId());
                            pw.print("checkfalse_");
                            pw.print(search.getUniqueId());
                            pw.println(":");
                        });
                    }
                });
                pw.println("    call void @llvm.trap()");
                pw.println("    unreachable");
                pw.println("}");
                pw.println();
                theProvider = new EscapeAnalysis.ProgramDescriptorProvider(){

                    @Override
                    public EscapeAnalysis.ProgramDescriptor resolveStaticInvocation(BytecodeObjectTypeRef aClass, String aMethodName, BytecodeMethodSignature aSignature) {
                        for (CompiledMethod theMethod : compiledMethods) {
                            if (!theMethod.linkedClass.getClassName().equals(aClass) || !theMethod.method.getName().stringValue().equals(aMethodName) || !theMethod.method.getSignature().matchesExactlyTo(aSignature)) continue;
                            return new EscapeAnalysis.ProgramDescriptor(theMethod.linkedClass, theMethod.method, theMethod.program);
                        }
                        return null;
                    }

                    @Override
                    public EscapeAnalysis.ProgramDescriptor resolveConstructorInvocation(BytecodeObjectTypeRef aClass, BytecodeMethodSignature aSignature) {
                        for (CompiledMethod theMethod : compiledMethods) {
                            if (!theMethod.linkedClass.getClassName().equals(aClass) || !theMethod.method.getName().stringValue().equals("<init>") || !theMethod.method.getSignature().matchesExactlyTo(aSignature)) continue;
                            return new EscapeAnalysis.ProgramDescriptor(theMethod.linkedClass, theMethod.method, theMethod.program);
                        }
                        throw new IllegalArgumentException("Cannot find " + aClass.name() + ".<init> " + aSignature);
                    }

                    @Override
                    public EscapeAnalysis.ProgramDescriptor resolveDirectInvocation(BytecodeObjectTypeRef aClass, String aMethodName, BytecodeMethodSignature aSignature) {
                        for (CompiledMethod theMethod : compiledMethods) {
                            if (!theMethod.linkedClass.getClassName().equals(aClass) || !theMethod.method.getName().stringValue().equals(aMethodName) || !theMethod.method.getSignature().matchesExactlyTo(aSignature)) continue;
                            return new EscapeAnalysis.ProgramDescriptor(theMethod.linkedClass, theMethod.method, theMethod.program);
                        }
                        return null;
                    }
                };
                aOptions.getLogger().info("Starting escape analysis", new Object[0]);
                EscapeAnalysis escapeAnalysis = new EscapeAnalysis((EscapeAnalysis.ProgramDescriptorProvider)theProvider, aLinkerContext.getStatistics());
                for (CompiledMethod compiledMethod : compiledMethods) {
                    escapeAnalysis.analyze(new EscapeAnalysis.ProgramDescriptor(compiledMethod.linkedClass, compiledMethod.method, compiledMethod.program));
                }
                aOptions.getLogger().info("Finished escape analysis", new Object[0]);
                for (CompiledMethod compiledMethod : compiledMethods) {
                    TypeRef theParamType;
                    Variable theArgument;
                    BytecodeLinkedClass theLinkedClass = compiledMethod.linkedClass;
                    BytecodeMethod theMethod = compiledMethod.method;
                    BytecodeMethodSignature theSignature2 = theMethod.getSignature();
                    Program theSSAProgram = compiledMethod.program;
                    LLVMDebugInformation.SubProgram subProgram = compiledMethod.debugInformationSubProgram;
                    methodName = LLVMWriterUtils.toMethodName(theLinkedClass.getClassName(), theMethod.getName(), theSignature2);
                    ArrayList<String> attributes = new ArrayList<String>();
                    BytecodeAnnotation theExport = theMethod.getAttributes().getAnnotationByType(Export.class.getName());
                    if (theExport != null) {
                        if (theMethod.getSignature().getReturnType() == BytecodePrimitiveTypeRef.LONG) {
                            throw new IllegalArgumentException("Cannot export method " + theMethod.getName().stringValue() + " in class " + theLinkedClass.getClassName().name() + " with signature " + theMethod.getSignature() + " : return type must not be Long");
                        }
                        for (BytecodeTypeRef theTypeRef : theMethod.getSignature().getArguments()) {
                            if (theTypeRef != BytecodePrimitiveTypeRef.LONG) continue;
                            throw new IllegalArgumentException("Cannot export method " + theMethod.getName().stringValue() + " in class " + theLinkedClass.getClassName().name() + " with signature " + theMethod.getSignature() + " : argument must not be Long");
                        }
                        pw.print("attributes #");
                        pw.print(attributeCounter.get());
                        pw.print(" = {");
                        pw.print("\"wasm-export-name\"");
                        pw.print("=");
                        pw.print("\"");
                        pw.print(theExport.getElementValueByName("value").stringValue());
                        pw.println("\"}");
                        int theAttribute = attributeCounter.getAndIncrement();
                        attributes.add("#" + theAttribute);
                    }
                    pw.print("define ");
                    if (attributes.isEmpty()) {
                        pw.print("internal ");
                    }
                    pw.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature2.getReturnType())));
                    pw.print(" @");
                    pw.print((String)methodName);
                    pw.print("(");
                    if (theMethod.getAccessFlags().isStatic()) {
                        pw.print(LLVMWriterUtils.toType(TypeRef.Native.REFERENCE));
                        pw.print(" ");
                        pw.print("%runtimeClass");
                    }
                    List<Variable> theArguments = theSSAProgram.getArguments();
                    for (int i3 = 0; i3 < theArguments.size(); ++i3) {
                        Variable theArgument2 = theArguments.get(i3);
                        TypeRef theParamType2 = theArgument2.resolveType();
                        if (i3 == 0 && theMethod.getAccessFlags().isStatic()) {
                            pw.print(",");
                        }
                        if (i3 > 0) {
                            pw.print(",");
                        }
                        pw.print(LLVMWriterUtils.toType(theParamType2));
                        pw.print(" ");
                        pw.print("%");
                        pw.print(theArgument2.getName());
                        pw.print("_");
                    }
                    if (!attributes.isEmpty()) {
                        pw.print(")");
                        Iterator i3 = attributes.iterator();
                        while (i3.hasNext()) {
                            String attr = (String)i3.next();
                            pw.print(" ");
                            pw.print(attr);
                        }
                        pw.print(" ");
                        subProgram.writeDebugSuffixTo(pw);
                        pw.println(" {");
                    } else {
                        pw.print(") ");
                        subProgram.writeDebugSuffixTo(pw);
                        pw.println(" {");
                    }
                    try (LLVMWriter theWriter = new LLVMWriter(pw, memoryLayouter, aLinkerContext, theSymbolResolver);){
                        theWriter.write(theLinkedClass, theSSAProgram, subProgram);
                    }
                    pw.println("}");
                    pw.println();
                    if (!theLinkedClass.getClassName().name().equals(aEntryPointClass.getName()) || !theMethod.getName().stringValue().equals(aEntryPointMethodName) || !theMethod.getSignature().matchesExactlyTo(aEntryPointSignature)) continue;
                    pw.print("attributes #");
                    pw.print(attributeCounter.get());
                    pw.print(" = {");
                    pw.print("\"wasm-export-name\"");
                    pw.print("=");
                    pw.println("\"main\"}");
                    int theAttribute = attributeCounter.getAndIncrement();
                    pw.print("define ");
                    pw.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature2.getReturnType())));
                    pw.print(" @");
                    pw.print((String)methodName);
                    pw.print("_export_delegate (");
                    if (theMethod.getAccessFlags().isStatic()) {
                        pw.print(LLVMWriterUtils.toType(TypeRef.Native.REFERENCE));
                        pw.print(" ");
                        pw.print("%runtimeClass");
                    }
                    for (int i2 = 0; i2 < theArguments.size(); ++i2) {
                        theArgument = theArguments.get(i2);
                        theParamType = theArgument.resolveType();
                        if (i2 == 0 && theMethod.getAccessFlags().isStatic()) {
                            pw.print(",");
                        }
                        if (i2 > 0) {
                            pw.print(",");
                        }
                        pw.print(LLVMWriterUtils.toType(theParamType));
                        pw.print(" ");
                        pw.print("%");
                        pw.print(theArgument.getName());
                        pw.print("_");
                    }
                    pw.print(") #");
                    pw.print(theAttribute);
                    pw.println(" {");
                    pw.println("entry:");
                    if (theMethod.getSignature().getReturnType().isVoid()) {
                        pw.print("    call ");
                    } else {
                        pw.print("    %value = call ");
                    }
                    pw.print(LLVMWriterUtils.toSignature(theSignature2));
                    pw.print(" @");
                    pw.print((String)methodName);
                    pw.print("(");
                    if (theMethod.getAccessFlags().isStatic()) {
                        pw.print(LLVMWriterUtils.toType(TypeRef.Native.REFERENCE));
                        pw.print(" ");
                        pw.print("%runtimeClass");
                    }
                    for (int i2 = 0; i2 < theArguments.size(); ++i2) {
                        theArgument = theArguments.get(i2);
                        theParamType = theArgument.resolveType();
                        if (i2 == 0 && theMethod.getAccessFlags().isStatic()) {
                            pw.print(",");
                        }
                        if (i2 > 0) {
                            pw.print(",");
                        }
                        pw.print(LLVMWriterUtils.toType(theParamType));
                        pw.print(" ");
                        pw.print("%");
                        pw.print(theArgument.getName());
                        pw.print("_");
                    }
                    pw.println(")");
                    if (theMethod.getSignature().getReturnType().isVoid()) {
                        pw.println("    ret void");
                    } else {
                        pw.print("    ret ");
                        pw.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature2.getReturnType())));
                        pw.println(" %value");
                    }
                    pw.println("}");
                    pw.println();
                }
                for (Map.Entry entry : callsites.entrySet()) {
                    CallSite callsite = (CallSite)entry.getValue();
                    pw.print("@");
                    pw.print("callsite");
                    pw.print(System.identityHashCode(callsite));
                    pw.println(" = private global i32 0");
                    Program theSSAProgram = ((CallSite)entry.getValue()).program;
                    LLVMDebugInformation.CompileUnit compileUnit = debugInformation.compileUnitFor("/resolvecallsite" + callsite);
                    LLVMDebugInformation.SubProgram subProgram = compileUnit.subProgram(theSSAProgram, "/resolvecallsite" + callsite, new BytecodeMethodSignature(BytecodePrimitiveTypeRef.INT, new BytecodeTypeRef[0]));
                    KnownOptimizer.LLVM.optimize(theSSAProgram.getControlFlowGraph(), aLinkerContext);
                    escapeAnalysis.analyze(new EscapeAnalysis.ProgramDescriptor(((CallSite)entry.getValue()).owningClass, new BytecodeMethod(new BytecodeAccessFlags(0), new BytecodeUtf8Constant("" + System.identityHashCode(callsite)), new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(java.lang.invoke.CallSite.class), new BytecodeTypeRef[0]), new BytecodeAttributeInfo[0]), theSSAProgram));
                    pw.print("define internal i32 @resolvecallsite");
                    pw.print(System.identityHashCode(callsite));
                    pw.println("() {");
                    pw.println("entry:");
                    pw.print("    %value = load i32, i32* @callsite");
                    pw.println(System.identityHashCode(callsite));
                    pw.println("    %test = icmp eq i32 %value, 0");
                    pw.println("    br i1 %test, label %notinitialized, label %initialized");
                    pw.println("notinitialized:");
                    pw.print("    %initstatus = call i32  @resolvecallsite");
                    pw.print(System.identityHashCode(callsite));
                    pw.println("_factory()");
                    pw.print("    store i32 %initstatus, i32* @callsite");
                    pw.println(System.identityHashCode(callsite));
                    pw.println("    ret i32 %initstatus");
                    pw.println("initialized:");
                    pw.println("    ret i32 %value");
                    pw.println("}");
                    pw.println();
                    pw.print("define internal i32 @resolvecallsite");
                    pw.print(System.identityHashCode(callsite));
                    pw.print("_factory() ");
                    subProgram.writeDebugSuffixTo(pw);
                    pw.println(" {");
                    LLVMWriter theWriter = new LLVMWriter(pw, memoryLayouter, aLinkerContext, theSymbolResolver);
                    methodName = null;
                    try {
                        theWriter.write(((CallSite)entry.getValue()).owningClass, ((CallSite)entry.getValue()).program, subProgram);
                    }
                    catch (Throwable attributes) {
                        methodName = attributes;
                        throw attributes;
                    }
                    finally {
                        if (theWriter != null) {
                            if (methodName != null) {
                                try {
                                    theWriter.close();
                                }
                                catch (Throwable attributes) {
                                    ((Throwable)methodName).addSuppressed(attributes);
                                }
                            } else {
                                theWriter.close();
                            }
                        }
                    }
                    pw.println("}");
                    pw.println();
                }
                attributeCounter.incrementAndGet();
                pw.print("attributes #");
                pw.print(attributeCounter.get());
                pw.println(" = { \"wasm-export-name\"=\"bootstrap\" }");
                pw.print("define void @bytecoder.bootstrap() #");
                pw.print(attributeCounter.get());
                pw.println(" {");
                pw.println("entry:");
                aLinkerContext.linkedClasses().forEach(aEntry -> {
                    BytecodeLinkedClass theLinkedClass = (BytecodeLinkedClass)aEntry.targetNode();
                    if (!LLVMWriterUtils.filteredForTest(theLinkedClass)) {
                        return;
                    }
                    if (Objects.equals(((BytecodeLinkedClass)aEntry.targetNode()).getClassName(), BytecodeObjectTypeRef.fromRuntimeClass(Address.class))) {
                        return;
                    }
                    if (theLinkedClass.emulatedByRuntime()) {
                        return;
                    }
                    String theClassName = LLVMWriterUtils.toClassName(theLinkedClass.getClassName());
                    NativeMemoryLayouter.MemoryLayout theMemoryLayout = memoryLayouter.layoutFor(theLinkedClass.getClassName());
                    pw.print("    %");
                    pw.print(theClassName);
                    pw.print("__runtimeclass");
                    pw.print("_classnameptr = ptrtoint i32* @");
                    pw.print(theSymbolResolver.globalFromStringPool(theLinkedClass.getClassName().name()));
                    pw.println(" to i32");
                    pw.print("    %");
                    pw.print(theClassName);
                    pw.print("__runtimeclass");
                    pw.print("_allocated = call i32(i32,i32,i32,i32) @bytecoder.newRuntimeClass(i32 ");
                    pw.print(theLinkedClass.getUniqueId());
                    pw.print(",i32 ");
                    pw.print(theMemoryLayout.classSize());
                    pw.print(",i32 ");
                    BytecodeResolvedFields theStaticFields = theLinkedClass.resolvedFields();
                    if (null != theStaticFields.fieldByName("$VALUES")) {
                        pw.print(theMemoryLayout.offsetForClassMember("$VALUES"));
                    } else {
                        pw.print("-1");
                    }
                    pw.print(",i32 %");
                    pw.print(theClassName);
                    pw.print("__runtimeclass");
                    pw.println("_classnameptr)");
                    pw.print("    store i32 %");
                    pw.print(theClassName);
                    pw.print("__runtimeclass");
                    pw.print("_allocated, i32* @");
                    pw.print(theClassName);
                    pw.println("__runtimeclass");
                });
                pw.println("    %arrayvtableptr = ptrtoint %dmbcArray__vtable__type* @dmbcArray__vtable to i32");
                pw.println("    %arrayclassinit = call i32 @dmbcArray__init()");
                pw.println("    %stringclassinit = call i32 @jlString__init()");
                for (i = 0; i < stringPool.size(); ++i) {
                    String string = (String)stringPool.get(i);
                    int l = string.length();
                    int[] theDataCharacters = new int[l];
                    for (int j2 = 0; j2 < l; ++j2) {
                        theDataCharacters[j2] = string.charAt(j2);
                    }
                    pw.print("    %allocated_");
                    pw.print(i);
                    pw.print(" = call i32 @dmbcMemoryManager_INTnewArrayINTINTINT(i32 0,i32 ");
                    pw.print(l);
                    pw.println(",i32 %arrayclassinit,i32 %arrayvtableptr)");
                    for (int j2 = 0; j2 < l; ++j2) {
                        pw.print("    %offset_" + i + "_" + j2);
                        pw.print(" = add i32 %allocated_");
                        pw.print(i);
                        pw.print(", ");
                        pw.println(20 + j2 * 8);
                        pw.print("    %offset_" + i + "_" + j2 + "_ptr");
                        pw.print(" = inttoptr i32 ");
                        pw.print("%offset_" + i + "_" + j2);
                        pw.println(" to i32 *");
                        pw.print("    store i32 ");
                        pw.print(theDataCharacters[j2]);
                        pw.print(", i32* ");
                        pw.println("%offset_" + i + "_" + j2 + "_ptr");
                    }
                    pw.print("    %string_");
                    pw.print(i);
                    pw.print(" = call i32 @jlString_VOID$newInstanceA1BYTEBYTE(i32 %stringclassinit,i32 ");
                    pw.print("%allocated_");
                    pw.print(i);
                    pw.println(", i32 0)");
                    pw.print("    store i32 %string_");
                    pw.print(i);
                    pw.print(", i32* @");
                    pw.print("strpool_");
                    pw.println(i);
                }
                aLinkerContext.linkedClasses().map(Edge::targetNode).filter(t -> t.getClassName().name().equals(VM.class.getName()) || t.getClassName().name().equals(Quicksort.class.getName())).forEach(theClass -> {
                    pw.print("    %");
                    pw.print(LLVMWriterUtils.runtimeClassVariableName(theClass.getClassName()));
                    pw.print(" = call i32 @");
                    pw.print(LLVMWriterUtils.toClassName(theClass.getClassName()));
                    pw.print("__init");
                    pw.println("()");
                });
                pw.println("    ret void");
                pw.println("}");
                pw.println();
                for (i = 0; i < stringPool.size(); ++i) {
                    pw.print("@");
                    pw.print("strpool_");
                    pw.print(i);
                    pw.println(" = private global i32 0");
                }
                pw.println();
                pw.println("define internal i32 @dynamicvtable(i32 %runtimeClass, i32 %implementationMethod, i32 %interfaceDispatch) {");
                pw.println("entry:");
                for (j = 0; j < theMethodTypes.size(); ++j) {
                    BytecodeObjectTypeRef theObjectTypeRef;
                    BytecodeLinkedClass theClass2;
                    BytecodeMethodSignature bytecodeMethodSignature = (BytecodeMethodSignature)theMethodTypes.get(j);
                    BytecodeTypeRef theReturnType = bytecodeMethodSignature.getReturnType();
                    if (theReturnType.isArray() || theReturnType.isVoid() || theReturnType.isPrimitive() || !(theClass2 = aLinkerContext.resolveClass(theObjectTypeRef = (BytecodeObjectTypeRef)theReturnType)).getBytecodeClass().getAccessFlags().isAbstract() && !theClass2.getBytecodeClass().getAccessFlags().isInterface()) continue;
                    pw.print("    %cl_");
                    pw.print(j);
                    pw.print(" = call i32 @");
                    pw.print(LLVMWriterUtils.toClassName(theObjectTypeRef));
                    pw.print("__init");
                    pw.println("()");
                    pw.print("    %te_");
                    pw.print(j);
                    pw.print(" = icmp eq i32 %runtimeClass, %cl_");
                    pw.print(j);
                    pw.println();
                    pw.print("    br i1 %te_");
                    pw.print(j);
                    pw.print(", label %te_");
                    pw.print(j);
                    pw.print("_ok, label %te_");
                    pw.print(j);
                    pw.println("_not_ok");
                    pw.print("te_");
                    pw.print(j);
                    pw.println("_ok:");
                    BytecodeVTable theTable = theSymbolResolver.vtableFor(theClass2);
                    List<BytecodeVTable.Slot> theSlots = theTable.sortedSlots();
                    int theNumberOfSlots = theTable.numberOfSlots();
                    pw.print("    %memory_");
                    pw.print(j);
                    pw.print(" = call i32 @dmbcMemoryManager_INTmallocINT(i32 undef,i32 ");
                    pw.print(8 + theNumberOfSlots * 4);
                    pw.println(")");
                    pw.print("    %te_");
                    pw.print(j);
                    pw.print("_0");
                    pw.print(" = inttoptr i32 %memory_");
                    pw.print(j);
                    pw.println(" to i32*");
                    pw.print("    store i32 undef, i32* %te_");
                    pw.print(j);
                    pw.println("_0");
                    pw.print("    %te_");
                    pw.print(j);
                    pw.print("_00_offset = add i32 4, %memory_");
                    pw.println(j);
                    pw.print("    %te_");
                    pw.print(j);
                    pw.print("_00");
                    pw.print(" = inttoptr i32 %te_");
                    pw.print(j);
                    pw.println("_00_offset to i32*");
                    pw.print("    store i32 %interfaceDispatch, i32* %te_");
                    pw.print(j);
                    pw.println("_00");
                    for (BytecodeVTable.Slot sl : theSlots) {
                        BytecodeVTable.VPtr ptr2 = theTable.slot(sl);
                        pw.println("    ;; slot " + sl.getPos() + ", " + ptr2.getMethodName() + ", " + ptr2.getSignature());
                        pw.print("    %te_");
                        pw.print(j);
                        pw.print("_offset_");
                        pw.print(1 + sl.getPos());
                        pw.print(" = add i32 %memory_");
                        pw.print(j);
                        pw.print(", ");
                        pw.println(8 + sl.getPos() * 4);
                        pw.print("    %te_");
                        pw.print(j);
                        pw.print("_ptr_");
                        pw.print(1 + sl.getPos());
                        pw.print(" = inttoptr i32 %te_");
                        pw.print(j);
                        pw.print("_offset_");
                        pw.print(1 + sl.getPos());
                        pw.println(" to i32*");
                        if (ptr2.getImplementingClass() != null) {
                            BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(ptr2.getImplementingClass());
                            BytecodeMethod theMethod = theLinkedClass.getBytecodeClass().methodByNameAndSignatureOrNull(ptr2.getMethodName(), ptr2.getSignature());
                            if (theMethod != null && !theMethod.getAccessFlags().isAbstract()) {
                                pw.print("    %te_");
                                pw.print(j);
                                pw.print("_impl_");
                                pw.print(1 + sl.getPos());
                                pw.print(" = ptrtoint ");
                                pw.print(LLVMWriterUtils.toSignature(ptr2.getSignature()));
                                pw.print("* @");
                                pw.print(LLVMWriterUtils.toMethodName(ptr2.getImplementingClass(), ptr2.getMethodName(), ptr2.getSignature()));
                                pw.println(" to i32");
                                pw.print("    store i32 %te_");
                                pw.print(j);
                                pw.print("_impl_");
                                pw.print(1 + sl.getPos());
                                pw.print(", i32* %te_");
                                pw.print(j);
                                pw.print("_ptr_");
                                pw.println(1 + sl.getPos());
                                continue;
                            }
                            pw.print("    store i32 %implementationMethod, i32* ");
                            pw.print("%te_");
                            pw.print(j);
                            pw.print("_ptr_");
                            pw.println(1 + sl.getPos());
                            continue;
                        }
                        pw.print("    store i32 %implementationMethod, i32* ");
                        pw.print("%te_");
                        pw.print(j);
                        pw.print("_ptr_");
                        pw.println(1 + sl.getPos());
                    }
                    pw.print("    ret i32 %memory_");
                    pw.println(j);
                    pw.print("te_");
                    pw.print(j);
                    pw.println("_not_ok:");
                }
                pw.println("    call void @llvm.trap()");
                pw.println("    unreachable");
                pw.println("}");
                pw.println();
                for (j = 0; j < theMethodTypes.size(); ++j) {
                    BytecodeMethodSignature bytecodeMethodSignature = (BytecodeMethodSignature)theMethodTypes.get(j);
                    pw.print("define internal i32 @methodtypefactory");
                    pw.print(j);
                    pw.println("() {");
                    pw.println("entry:");
                    pw.println("    %data_classinit = call i32 @dmbcArray__init()");
                    pw.println("    %data_vtable = ptrtoint %dmbcArray__vtable__type* @dmbcArray__vtable to i32");
                    pw.print("    %data = call i32 @dmbcMemoryManager_INTnewArrayINTINTINT(i32 0,i32 ");
                    pw.print(1 + bytecodeMethodSignature.getArguments().length);
                    pw.println(",i32 %data_classinit,i32 %data_vtable)");
                    BiFunction<BytecodeTypeRef, Integer, Void> theAdder = (aType, aIndex) -> {
                        int offset = 20 + aIndex * 4;
                        pw.print("    %data_");
                        pw.print(aIndex);
                        pw.print(" = add i32 %data, ");
                        pw.println(offset);
                        pw.print("    %data_");
                        pw.print(aIndex);
                        pw.print("_ptr = inttoptr i32 %data_");
                        pw.print(aIndex);
                        pw.println(" to i32*");
                        if (aType.isPrimitive()) {
                            TypeRef.Native theNativeType = (TypeRef.Native)TypeRef.toType(aType);
                            pw.print("    store i32 ");
                            pw.print(-theNativeType.ordinal());
                            pw.print(", i32* %data_");
                            pw.print(aIndex);
                            pw.println("_ptr");
                        } else if (aType.isArray()) {
                            BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
                            pw.print("    %status");
                            pw.print(aIndex);
                            pw.print(" = call i32 @");
                            pw.print(LLVMWriterUtils.toClassName(theLinkedClass.getClassName()));
                            pw.print("__init");
                            pw.println("()");
                            pw.print("    store i32 %status");
                            pw.print(aIndex);
                            pw.print(", i32* %data_");
                            pw.print(aIndex);
                            pw.println("_ptr");
                        } else {
                            BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass((BytecodeObjectTypeRef)aType);
                            pw.print("    %status");
                            pw.print(aIndex);
                            pw.print(" = call i32 @");
                            pw.print(LLVMWriterUtils.toClassName(theLinkedClass.getClassName()));
                            pw.print("__init");
                            pw.println("()");
                            pw.print("    store i32 %status");
                            pw.print(aIndex);
                            pw.print(", i32* %data_");
                            pw.print(aIndex);
                            pw.println("_ptr");
                        }
                        return null;
                    };
                    theAdder.apply(bytecodeMethodSignature.getReturnType(), 0);
                    for (int i4 = 0; i4 < bytecodeMethodSignature.getArguments().length; ++i4) {
                        BytecodeTypeRef theArgument = bytecodeMethodSignature.getArguments()[i4];
                        theAdder.apply(theArgument, i4 + 1);
                    }
                    pw.println("    ret i32 %data");
                    pw.println("}");
                    pw.println();
                }
                block109: for (i = 0; i < methodHandles.size(); ++i) {
                    MethodHandleExpression methodHandleExpression = (MethodHandleExpression)methodHandles.get(i);
                    String theDelegateMethodName = "handle" + i;
                    pw.println(";; refkind = " + (Object)((Object)methodHandleExpression.getReferenceKind()));
                    pw.println(";; linksignature = " + methodHandleExpression.getAdapterAnnotation().getLinkageSignature());
                    pw.println(";; capturesignature = " + methodHandleExpression.getAdapterAnnotation().getCaptureSignature());
                    pw.println(";; samsignature = " + methodHandleExpression.getAdapterAnnotation().getSamMethodType());
                    pw.println(";; implclass = " + methodHandleExpression.getClassName().name());
                    pw.println(";; implMethod = " + methodHandleExpression.getMethodName());
                    pw.println(";; implSig = " + methodHandleExpression.getImplementationSignature());
                    switch (methodHandleExpression.getReferenceKind()) {
                        case REF_invokeStatic: {
                            this.writeMethodHandleDelegateInvokeStatic(aLinkerContext, methodHandleExpression, theDelegateMethodName, pw);
                            continue block109;
                        }
                        case REF_invokeVirtual: {
                            this.writeMethodHandleDelegateInvokeVirtual(aLinkerContext, methodHandleExpression, theDelegateMethodName, pw);
                            continue block109;
                        }
                        case REF_invokeInterface: {
                            this.writeMethodHandleDelegateInvokeInterface(aLinkerContext, methodHandleExpression, theDelegateMethodName, pw);
                            continue block109;
                        }
                        case REF_invokeSpecial: {
                            this.writeMethodHandleDelegateInvokeSpecial(aLinkerContext, methodHandleExpression, theDelegateMethodName, pw);
                            continue block109;
                        }
                        case REF_newInvokeSpecial: {
                            this.writeMethodHandleDelegateNewInvokeSpecial(aLinkerContext, methodHandleExpression, theDelegateMethodName, pw);
                            continue block109;
                        }
                        default: {
                            throw new IllegalArgumentException("Not supported refkind for method handle " + (Object)((Object)methodHandleExpression.getReferenceKind()));
                        }
                    }
                }
                aLinkerContext.linkedClasses().map(Edge::targetNode).filter(t -> t.isCallback() && t.getBytecodeClass().getAccessFlags().isInterface()).forEach(t -> {
                    BytecodeResolvedMethods theMethods = t.resolvedMethods();
                    List availableCallbacks = theMethods.stream().filter(x -> !x.getValue().isConstructor() && !x.getValue().isClassInitializer() && x.getProvidingClass() == t).map(BytecodeResolvedMethods.MethodEntry::getValue).collect(Collectors.toList());
                    if (availableCallbacks.size() > 0) {
                        int i;
                        if (availableCallbacks.size() != 1) {
                            throw new IllegalStateException("Invalid number of callback methods available for type " + t.getClassName().name() + ", expected 1, got " + availableCallbacks.size());
                        }
                        BytecodeMethod theDelegateMethod = (BytecodeMethod)availableCallbacks.get(0);
                        BytecodeVTable theTable = theSymbolResolver.vtableFor((BytecodeLinkedClass)t);
                        BytecodeVTable.Slot sl = theTable.slotOf(theDelegateMethod.getName().stringValue(), theDelegateMethod.getSignature());
                        String theFunctionName = LLVMWriterUtils.toMethodName(t.getClassName(), theDelegateMethod.getName(), theDelegateMethod.getSignature());
                        attributeCounter.incrementAndGet();
                        pw.print("attributes #");
                        pw.print(attributeCounter.get());
                        pw.print(" = { \"wasm-export-name\"=\"");
                        pw.print(theFunctionName);
                        pw.println("\" }");
                        pw.print("define void @");
                        pw.print(theFunctionName);
                        pw.print("(i32 %target");
                        for (i = 0; i < theDelegateMethod.getSignature().getArguments().length; ++i) {
                            pw.print(",");
                            pw.print(LLVMWriterUtils.toType(TypeRef.toType(theDelegateMethod.getSignature().getArguments()[i])));
                            pw.print(" %param");
                            pw.print(i);
                        }
                        pw.print(") #");
                        pw.print(attributeCounter.get());
                        pw.println(" {");
                        pw.println("    %ptr = add i32 %target, 4");
                        pw.println("    %ptr_ptr = inttoptr i32 %ptr to i32*");
                        pw.println("    %ptr_loaded = load i32, i32* %ptr_ptr");
                        pw.print("    %vtable = add i32 %ptr_loaded, ");
                        pw.print(8 + sl.getPos() * 4);
                        pw.println("    %vtable_ptr = inttoptr i32 %vtable to i32*");
                        pw.println("    %resolved = load i32, i32* %vtable_ptr");
                        pw.print("    %resolved_ptr = inttoptr i32 %resolved to ");
                        pw.print(LLVMWriterUtils.toSignature(theDelegateMethod.getSignature()));
                        pw.println("*");
                        pw.print("    call ");
                        pw.print(LLVMWriterUtils.toSignature(theDelegateMethod.getSignature()));
                        pw.print(" %resolved_ptr (i32 %target");
                        for (i = 0; i < theDelegateMethod.getSignature().getArguments().length; ++i) {
                            pw.print(",");
                            pw.print(LLVMWriterUtils.toType(TypeRef.toType(theDelegateMethod.getSignature().getArguments()[i])));
                            pw.print(" %param");
                            pw.print(i);
                        }
                        pw.println(")");
                        pw.println("    ret void");
                        pw.println("}");
                    }
                });
                debugInformation.writeHeaderTo(pw);
            }
            var21_23 = null;
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(theLLFile));){
                theLLContent22 = IOUtils.toString((Reader)reader);
                theCompileResult.add(new CompileResult.StringContent(aOptions.getFilenamePrefix() + ".ll", (String)theLLContent22));
            }
            catch (Throwable theLLContent22) {
                var21_23 = theLLContent22;
                throw theLLContent22;
            }
            StringWriter theJSCode = new StringWriter();
            PrintWriter theWriter = new PrintWriter(theJSCode);
            theLLContent22 = null;
            try {
                theWriter.println("var bytecoder = {");
                theWriter.println();
                theWriter.println("     runningInstance: undefined,");
                theWriter.println("     runningInstanceMemory: undefined,");
                theWriter.println("     exports: undefined,");
                theWriter.println("     referenceTable: ['EMPTY'],");
                theWriter.println("     callbacks: [],");
                theWriter.println("     filehandles: [],");
                theWriter.println();
                theWriter.println("     openForRead: function(path) {");
                theWriter.println("         try {");
                theWriter.println("             var request = new XMLHttpRequest();");
                theWriter.println("             request.open('GET',path,false);");
                theWriter.println("             request.overrideMimeType('text\\/plain; charset=x-user-defined');");
                theWriter.println("             request.send(null);");
                theWriter.println("             if (request.status == 200) {");
                theWriter.println("                var length = request.getResponseHeader('content-length');");
                theWriter.println("                var responsetext = request.response;");
                theWriter.println("                var buf = new ArrayBuffer(responsetext.length);");
                theWriter.println("                var bufView = new Uint8Array(buf);");
                theWriter.println("                for (var i=0, strLen=responsetext.length; i<strLen; i++) {");
                theWriter.println("                    bufView[i] = responsetext.charCodeAt(i) & 0xff;");
                theWriter.println("                }");
                theWriter.println("                var handle = bytecoder.filehandles.length;");
                theWriter.println("                bytecoder.filehandles[handle] = {");
                theWriter.println("                    currentpos: 0,");
                theWriter.println("                    data: bufView,");
                theWriter.println("                    size: length,");
                theWriter.println("                    skip0INTINT: function(handle,amount) {");
                theWriter.println("                        var remaining = this.size - this.currentpos;");
                theWriter.println("                        var possible = Math.min(remaining, amount);");
                theWriter.println("                        this.currentpos+=possible;");
                theWriter.println("                        return possible;");
                theWriter.println("                    },");
                theWriter.println("                    available0INT: function(handle) {");
                theWriter.println("                        return this.size - this.currentpos;");
                theWriter.println("                    },");
                theWriter.println("                    read0INT: function(handle) {");
                theWriter.println("                        return this.data[this.currentpos++];");
                theWriter.println("                    },");
                theWriter.println("                    readBytesINTL1BYTEINTINT: function(handle,target,offset,length) {");
                theWriter.println("                        if (length === 0) {");
                theWriter.println("                            return 0;");
                theWriter.println("                        }");
                theWriter.println("                        var remaining = this.size - this.currentpos;");
                theWriter.println("                        var possible = Math.min(remaining, length);");
                theWriter.println("                        if (possible === 0) {");
                theWriter.println("                            return -1;");
                theWriter.println("                        }");
                theWriter.println("                        for (var j=0;j<possible;j++) {");
                theWriter.println("                            bytecoder.runningInstanceMemory[target + 20 + offset * 8]=this.data[this.currentpos++];");
                theWriter.println("                            offset++;");
                theWriter.println("                        }");
                theWriter.println("                        return possible;");
                theWriter.println("                    }");
                theWriter.println("                };");
                theWriter.println("                return handle;");
                theWriter.println("            }");
                theWriter.println("            return -1;");
                theWriter.println("         } catch(e) {");
                theWriter.println("             return -1;");
                theWriter.println("         }");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     init: function(instance) {");
                theWriter.println("         bytecoder.runningInstance = instance;");
                theWriter.println("         bytecoder.runningInstanceMemory = new Uint8Array(instance.exports.memory.buffer);");
                theWriter.println("         bytecoder.exports = instance.exports;");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     initializeFileIO: function() {");
                theWriter.println("         var stddin = {");
                theWriter.println("         };");
                theWriter.println("         var stdout = {");
                theWriter.println("             buffer: \"\",");
                theWriter.println("             writeBytesINTL1BYTEINTINT: function(handle, data, offset, length) {");
                theWriter.println("                 if (length > 0) {");
                theWriter.println("                     var array = new Uint8Array(length);");
                theWriter.println("                     data+=20;");
                theWriter.println("                     for (var i = 0; i < length; i++) {");
                theWriter.println("                         array[i] = bytecoder.intInMemory(data);");
                theWriter.println("                         data+=8;");
                theWriter.println("                     }");
                theWriter.println("                     var asstring = String.fromCharCode.apply(null, array);");
                theWriter.println("                     for (var i=0;i<asstring.length;i++) {");
                theWriter.println("                         var c = asstring.charAt(i);");
                theWriter.println("                         if (c == '\\n') {");
                theWriter.println("                             console.log(stdout.buffer);");
                theWriter.println("                             stdout.buffer=\"\";");
                theWriter.println("                         } else {");
                theWriter.println("                             stdout.buffer = stdout.buffer.concat(c);");
                theWriter.println("                         }");
                theWriter.println("                     }");
                theWriter.println("                 }");
                theWriter.println("             },");
                theWriter.println("             close0INT: function(handle) {");
                theWriter.println("             },");
                theWriter.println("             writeIntINTINT: function(handle,value) {");
                theWriter.println("                 var c = String.fromCharCode(value);");
                theWriter.println("                 if (c == '\\n') {");
                theWriter.println("                     console.log(stdout.buffer);");
                theWriter.println("                     stdout.buffer=\"\";");
                theWriter.println("                 } else {");
                theWriter.println("                     stdout.buffer = stdout.buffer.concat(c);");
                theWriter.println("                 }");
                theWriter.println("             }");
                theWriter.println("         };");
                theWriter.println("         bytecoder.filehandles[0] = stddin;");
                theWriter.println("         bytecoder.filehandles[1] = stdout;");
                theWriter.println("         bytecoder.filehandles[2] = stdout;");
                theWriter.println("         bytecoder.exports.initDefaultFileHandles(-1, 0,1,2);");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     intInMemory: function(value) {");
                theWriter.println("         return bytecoder.runningInstanceMemory[value]");
                theWriter.println("                + (bytecoder.runningInstanceMemory[value + 1] * 256)");
                theWriter.println("                + (bytecoder.runningInstanceMemory[value + 2] * 256 * 256)");
                theWriter.println("                + (bytecoder.runningInstanceMemory[value + 3] * 256 * 256 * 256);");
                theWriter.println("     },");
                BytecodeLinkedClass theStringClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(String.class));
                int theStringDataOffset = memoryLayouter.layoutFor(theStringClass.getClassName()).offsetForInstanceMember("value");
                theWriter.println();
                theWriter.println("     toJSString: function(value) {");
                theWriter.println("         var theByteArray = bytecoder.intInMemory(value + " + theStringDataOffset + ");");
                theWriter.println("         var theData = bytecoder.byteArraytoJSString(theByteArray);");
                theWriter.println("         return theData;");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     byteArraytoJSString: function(value) {");
                theWriter.println("         var theLength = bytecoder.intInMemory(value + 16);");
                theWriter.println("         var theData = '';");
                theWriter.println("         value = value + 20;");
                theWriter.println("         for (var i=0;i<theLength;i++) {");
                theWriter.println("             var theCharCode = bytecoder.intInMemory(value);");
                theWriter.println("             value = value + 8;");
                theWriter.println("             theData+= String.fromCharCode(theCharCode);");
                theWriter.println("         }");
                theWriter.println("         return theData;");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     toBytecoderReference: function(value) {");
                theWriter.println("         var index = bytecoder.referenceTable.indexOf(value);");
                theWriter.println("         if (index>=0) {");
                theWriter.println("             return index;");
                theWriter.println("         }");
                theWriter.println("         bytecoder.referenceTable.push(value);");
                theWriter.println("         return bytecoder.referenceTable.length - 1;");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     toJSReference: function(value) {");
                theWriter.println("         return bytecoder.referenceTable[value];");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     toBytecoderString: function(value) {");
                theWriter.println("         var newArray = bytecoder.exports.newByteArray(0, value.length);");
                theWriter.println("         for (var i=0;i<value.length;i++) {");
                theWriter.println("             bytecoder.exports.setByteArrayEntry(0,newArray,i,value.charCodeAt(i));");
                theWriter.println("         }");
                theWriter.println("         return bytecoder.exports.newStringUTF8(0, newArray);");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     registerCallback: function(ptr,callback) {");
                theWriter.println("         bytecoder.callbacks.push(ptr);");
                theWriter.println("         return callback;");
                theWriter.println("     },");
                theWriter.println();
                theWriter.println("     imports: {");
                theWriter.println("         stringutf16: {");
                theWriter.println("             isBigEndian: function() {return 1;},");
                theWriter.println("         },");
                theWriter.println("         env: {");
                theWriter.println("             fmodf: function(f1,f2) {return f1 % f2;},");
                theWriter.println("             fmod: function(f1,f2) {return f1 % f2;},");
                theWriter.println("             debug: function(thisref, f1) {console.log(f1);}");
                theWriter.println("         },");
                theWriter.println("         system: {");
                theWriter.println("             currentTimeMillis: function() {return Date.now();},");
                theWriter.println("             nanoTime: function() {return Date.now() * 1000000;},");
                theWriter.println("         },");
                theWriter.println("         vm: {");
                theWriter.println("             newLambdaStaticInvocationStringMethodTypeMethodHandleObject: function() {},");
                theWriter.println("             newLambdaConstructorInvocationMethodTypeMethodHandleObject: function() {},");
                theWriter.println("             newLambdaInterfaceInvocationMethodTypeMethodHandleObject: function() {},");
                theWriter.println("             newLambdaVirtualInvocationMethodTypeMethodHandleObject: function() {},");
                theWriter.println("             newLambdaSpecialInvocationMethodTypeMethodHandleObject: function() {},");
                theWriter.println("         },");
                theWriter.println("         memorymanager: {");
                theWriter.println("             isUsedAsCallbackINT : function(thisref, ptr) {");
                theWriter.println("                 return bytecoder.callbacks.includes(ptr);");
                theWriter.println("             },");
                theWriter.println("             printObjectDebugInternalObjectINTINTBOOLEANBOOLEAN: function(thisref, ptr, indexAlloc, indexFree, usedByStack, usedByHeap) {");
                theWriter.println("                 console.log('Memory debug for ' + ptr);");
                theWriter.println("                 var theAllocatedBlock = ptr - 12;");
                theWriter.println("                 var theSize = bytecoder.intInMemory(theAllocatedBlock);");
                theWriter.println("                 var theNext = bytecoder.intInMemory(theAllocatedBlock +  4);");
                theWriter.println("                 var theSurvivorCount = bytecoder.intInMemory(theAllocatedBlock +  8);");
                theWriter.println("                 console.log(' Allocation starts at '+ theAllocatedBlock);");
                theWriter.println("                 console.log(' Size = ' + theSize + ', Next = ' + theNext);");
                theWriter.println("                 console.log(' GC survivor count        : ' + theSurvivorCount);");
                theWriter.println("                 console.log(' Index in allocation list : ' + indexAlloc);");
                theWriter.println("                 console.log(' Index in free list       : ' + indexFree);");
                theWriter.println("                 console.log(' Used by STACK            : ' + usedByStack);");
                theWriter.println("                 console.log(' Used by HEAP             : ' + usedByHeap);");
                theWriter.println("                 for (var i=0;i<theSize;i+=4) {");
                theWriter.println("                     console.log(' Memory offset +' + i + ' = ' + bytecoder.intInMemory( theAllocatedBlock + i));");
                theWriter.println("                 }");
                theWriter.println("             }");
                theWriter.println("         },");
                theWriter.println("         opaquearrays : {");
                theWriter.println("             createIntArrayINT: function(thisref, p1) {");
                theWriter.println("                 return bytecoder.toBytecoderReference(new Int32Array(p1));");
                theWriter.println("             },");
                theWriter.println("             createFloatArrayINT: function(thisref, p1) {");
                theWriter.println("                 return bytecoder.toBytecoderReference(new Float32Array(p1));");
                theWriter.println("             },");
                theWriter.println("             createObjectArray: function(thisref) {");
                theWriter.println("                 return bytecoder.toBytecoderReference([]);");
                theWriter.println("             },");
                theWriter.println("             createInt8ArrayINT: function(thisref, p1) {");
                theWriter.println("                 return bytecoder.toBytecoderReference(new Int8Array(p1));");
                theWriter.println("             },");
                theWriter.println("         },");
                theWriter.println("         float : {");
                theWriter.println("             floatToRawIntBitsFLOAT : function(thisref,value) {");
                theWriter.println("                 var fl = new Float32Array(1);");
                theWriter.println("                 fl[0] = value;");
                theWriter.println("                 var br = new Int32Array(fl.buffer);");
                theWriter.println("                 return br[0];");
                theWriter.println("             },");
                theWriter.println("             intBitsToFloatINT : function(thisref,value) {");
                theWriter.println("                 var fl = new Int32Array(1);");
                theWriter.println("                 fl[0] = value;");
                theWriter.println("                 var br = new Float32Array(fl.buffer);");
                theWriter.println("                 return br[0];");
                theWriter.println("             },");
                theWriter.println("         },");
                theWriter.println("         double : {");
                theWriter.println("             doubleToRawLongBitsDOUBLE : function(thisref, value) {");
                theWriter.println("                 var fl = new Float64Array(1);");
                theWriter.println("                 fl[0] = value;");
                theWriter.println("                 var br = new BigInt64Array(fl.buffer);");
                theWriter.println("                 return br[0];");
                theWriter.println("             },");
                theWriter.println("             longBitsToDoubleLONG : function(thisref, value) {");
                theWriter.println("                 var fl = new BigInt64Array(1);");
                theWriter.println("                 fl[0] = value;");
                theWriter.println("                 var br = new Float64Array(fl.buffer);");
                theWriter.println("                 return br[0];");
                theWriter.println("             },");
                theWriter.println("         },");
                theWriter.println("         math: {");
                theWriter.println("             floorDOUBLE: function (thisref, p1) {return Math.floor(p1);},");
                theWriter.println("             ceilDOUBLE: function (thisref, p1) {return Math.ceil(p1);},");
                theWriter.println("             sinDOUBLE: function (thisref, p1) {return Math.sin(p1);},");
                theWriter.println("             cosDOUBLE: function  (thisref, p1) {return Math.cos(p1);},");
                theWriter.println("             tanDOUBLE: function  (thisref, p1) {return Math.tan(p1);},");
                theWriter.println("             roundDOUBLE: function  (thisref, p1) {return Math.round(p1);},");
                theWriter.println("             sqrtDOUBLE: function(thisref, p1) {return Math.sqrt(p1);},");
                theWriter.println("             cbrtDOUBLE: function(thisref, p1) {return Math.cbrt(p1);},");
                theWriter.println("             add: function(thisref, p1, p2) {return p1 + p2;},");
                theWriter.println("             maxLONGLONG: function(thisref, p1, p2) { return Math.max(p1, p2);},");
                theWriter.println("             maxDOUBLEDOUBLE: function(thisref, p1, p2) { return Math.max(p1, p2);},");
                theWriter.println("             maxINTINT: function(thisref, p1, p2) { return Math.max(p1, p2);},");
                theWriter.println("             maxFLOATFLOAT: function(thisref, p1, p2) { return Math.max(p1, p2);},");
                theWriter.println("             minFLOATFLOAT: function(thisref, p1, p2) { return Math.min(p1, p2);},");
                theWriter.println("             minINTINT: function(thisref, p1, p2) { return Math.min(p1, p2);},");
                theWriter.println("             minLONGLONG: function(thisref, p1, p2) { return Math.min(p1, p2);},");
                theWriter.println("             minDOUBLEDOUBLE: function(thisref, p1, p2) { return Math.min(p1, p2);},");
                theWriter.println("             toRadiansDOUBLE: function(thisref, p1) {");
                theWriter.println("                 return p1 * (Math.PI / 180);");
                theWriter.println("             },");
                theWriter.println("             toDegreesDOUBLE: function(thisref, p1) {");
                theWriter.println("                 return p1 * (180 / Math.PI);");
                theWriter.println("             },");
                theWriter.println("             random: function(thisref) { return Math.random();},");
                theWriter.println("             logDOUBLE: function (thisref, p1) {return Math.log(p1);},");
                theWriter.println("             powDOUBLEDOUBLE: function (thisref, p1, p2) {return Math.pow(p1, p2);},");
                theWriter.println("             acosDOUBLE: function (thisref, p1, p2) {return Math.acos(p1);},");
                theWriter.println("             atan2DOUBLE: function (thisref, p1, p2) {return Math.atan2(p1);},");
                theWriter.println("         },");
                theWriter.println("         strictmath: {");
                theWriter.println("             floorDOUBLE: function (thisref, p1) {return Math.floor(p1);},");
                theWriter.println("             ceilDOUBLE: function (thisref, p1) {return Math.ceil(p1);},");
                theWriter.println("             sinDOUBLE: function (thisref, p1) {return Math.sin(p1);},");
                theWriter.println("             cosDOUBLE: function  (thisref, p1) {return Math.cos(p1);},");
                theWriter.println("             roundFLOAT: function  (thisref, p1) {return Math.round(p1);},");
                theWriter.println("             sqrtDOUBLE: function(thisref, p1) {return Math.sqrt(p1);},");
                theWriter.println("             atan2DOUBLEDOUBLE: function(thisref, p1) {return Math.sqrt(p1);},");
                theWriter.println("         },");
                theWriter.println("         runtime: {");
                theWriter.println("             nativewindow: function(caller) {return bytecoder.toBytecoderReference(window);},");
                theWriter.println("             nativeconsole: function(caller) {return bytecoder.toBytecoderReference(console);},");
                theWriter.println("         },");
                theWriter.println("         unixfilesystem :{");
                theWriter.println("             getBooleanAttributes0String : function(thisref,path) {");
                theWriter.println("                 var jsPath = bytecoder.toJSString(path);");
                theWriter.println("                 try {");
                theWriter.println("                     var request = new XMLHttpRequest();");
                theWriter.println("                     request.open('HEAD',jsPath,false);");
                theWriter.println("                     request.send(null);");
                theWriter.println("                     if (request.status == 200) {");
                theWriter.println("                         var length = request.getResponseHeader('content-length');");
                theWriter.println("                         return 0x01;");
                theWriter.println("                     }");
                theWriter.println("                     return 0;");
                theWriter.println("                 } catch(e) {");
                theWriter.println("                     return 0;");
                theWriter.println("                 }");
                theWriter.println("             },");
                theWriter.println("         },");
                theWriter.println("         nullpointerexception : {");
                theWriter.println("             getExtendedNPEMessage : function(thisref) {");
                theWriter.println("                 return 0;");
                theWriter.println("             },");
                theWriter.println("         },");
                theWriter.println("         fileoutputstream : {");
                theWriter.println("             writeBytesINTL1BYTEINTINT : function(thisref, handle, data, offset, length) {");
                theWriter.println("                 bytecoder.filehandles[handle].writeBytesINTL1BYTEINTINT(handle,data,offset,length);");
                theWriter.println("             },");
                theWriter.println("             writeIntINTINT : function(thisref, handle, intvalue) {");
                theWriter.println("                 bytecoder.filehandles[handle].writeIntINTINT(handle,intvalue);");
                theWriter.println("             },");
                theWriter.println("             close0INT : function(thisref,handle) {");
                theWriter.println("                 bytecoder.filehandles[handle].close0INT(handle);");
                theWriter.println("             },");
                theWriter.println("         },");
                theWriter.println("         fileinputstream : {");
                theWriter.println("             open0String : function(thisref,name) {");
                theWriter.println("                 return bytecoder.openForRead(bytecoder.toJSString(name));");
                theWriter.println("             },");
                theWriter.println("             read0INT : function(thisref,handle) {");
                theWriter.println("                 return bytecoder.filehandles[handle].read0INT(handle);");
                theWriter.println("             },");
                theWriter.println("             readBytesINTL1BYTEINTINT : function(thisref,handle,data,offset,length) {");
                theWriter.println("                 return bytecoder.filehandles[handle].readBytesINTL1BYTEINTINT(handle,data,offset,length);");
                theWriter.println("             },");
                theWriter.println("             skip0INTINT : function(thisref,handle,amount) {");
                theWriter.println("                 return bytecoder.filehandles[handle].skip0INTINT(handle,amount);");
                theWriter.println("             },");
                theWriter.println("             available0INT : function(thisref,handle) {");
                theWriter.println("                 return bytecoder.filehandles[handle].available0INT(handle);");
                theWriter.println("             },");
                theWriter.println("             close0INT : function(thisref,handle) {");
                theWriter.println("                 bytecoder.filehandles[handle].close0INT(handle);");
                theWriter.println("             },");
                theWriter.println("         },");
                theWriter.println("         inflater : {");
                theWriter.println("             initIDs : function(thisref) {");
                theWriter.println("             },");
                theWriter.println("             initBOOLEAN : function(thisref,nowrap) {");
                theWriter.println("             },");
                theWriter.println("             inflateBytesBytesLONGL1BYTEINTINTL1BYTEINTINT : function(thisref,addr,inputArray,inputOff,inputLen,outputArray,outputOff,outputLen) {");
                theWriter.println("             },");
                theWriter.println("             inflateBufferBytesLONGLONGINTL1BYTEINTINT : function(thisref,addr,inputAddress,inputLen,outputArray,outputOff,outputLen) {");
                theWriter.println("             },");
                theWriter.println("             endLONG : function(thisref,addr) {");
                theWriter.println("             },");
                theWriter.println("         },");
                Map<String, List<OpaqueReferenceMethod>> theMethods = opaqueReferenceMethods.stream().collect(Collectors.groupingBy(opaqueReferenceMethod -> ((OpaqueReferenceMethod)opaqueReferenceMethod).linkedClass.linkFor(opaqueReferenceMethod.getMethod()).getModuleName()));
                for (Map.Entry entry : theMethods.entrySet()) {
                    theWriter.print("         ");
                    theWriter.print((String)entry.getKey());
                    theWriter.println(": {");
                    for (OpaqueReferenceMethod opaqueReferenceMethod2 : (List)entry.getValue()) {
                        BytecodeMethod theBytecdeMethod = opaqueReferenceMethod2.getMethod();
                        BytecodeImportedLink theImportedLink = opaqueReferenceMethod2.getLinkedClass().linkFor(theBytecdeMethod);
                        theWriter.print("             ");
                        theWriter.print(theImportedLink.getLinkName());
                        theWriter.print(": function(");
                        theWriter.print("target");
                        BytecodeMethodSignature theSignature = theBytecdeMethod.getSignature();
                        for (int i = 0; i < theSignature.getArguments().length; ++i) {
                            theWriter.print(",arg");
                            theWriter.print(i);
                        }
                        theWriter.println(") {");
                        String theMethodName = theBytecdeMethod.getName().stringValue();
                        BytecodeAnnotation theOpaqueProperty = theBytecdeMethod.getAttributes().getAnnotationByType(OpaqueProperty.class.getName());
                        BytecodeAnnotation theOpaqueIndex = theBytecdeMethod.getAttributes().getAnnotationByType(OpaqueIndexed.class.getName());
                        if (theOpaqueIndex != null) {
                            if (theSignature.getReturnType().isVoid()) {
                                theWriter.print("               ");
                                theWriter.print("bytecoder.referenceTable[target]");
                                theWriter.print("[arg0]");
                                String theConversionFunction = this.conversionFunctionToJSForOpaqueType(aLinkerContext, theSignature.getArguments()[1]);
                                if (theConversionFunction != null) {
                                    theWriter.print("=");
                                    theWriter.print(theConversionFunction);
                                    theWriter.println("(arg1);");
                                } else {
                                    theWriter.println("=arg1;");
                                }
                            } else {
                                theWriter.print("               return ");
                                boolean theWriteClosingBraces = false;
                                String theConversionFunction = this.conversionFunctionToWASMForOpaqueType(aLinkerContext, theSignature.getReturnType());
                                if (theConversionFunction != null) {
                                    theWriter.print(theConversionFunction);
                                    theWriter.print("(");
                                    theWriteClosingBraces = true;
                                }
                                theWriter.print("bytecoder.referenceTable[target][arg0]");
                                if (theWriteClosingBraces) {
                                    theWriter.print(")");
                                }
                                theWriter.println(";");
                            }
                        } else if (theOpaqueProperty != null) {
                            String theOpaquePropertyName;
                            BytecodeAnnotation.ElementValue theValue = theOpaqueProperty.getElementValueByName("value");
                            if (theValue == null) {
                                if (theMethodName.startsWith("get")) {
                                    theOpaquePropertyName = theMethodName.substring(3);
                                    theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                                } else if (theMethodName.startsWith("is")) {
                                    theOpaquePropertyName = theMethodName.substring(2);
                                    theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                                } else if (theMethodName.startsWith("set")) {
                                    theOpaquePropertyName = theMethodName.substring(3);
                                    theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                                } else {
                                    theOpaquePropertyName = theMethodName;
                                }
                            } else {
                                theOpaquePropertyName = theValue.stringValue();
                            }
                            if (theSignature.getReturnType().isVoid()) {
                                theWriter.print("               ");
                                theWriter.print("bytecoder.referenceTable[target].");
                                theWriter.print(theOpaquePropertyName);
                                String theConversionFunction = this.conversionFunctionToJSForOpaqueType(aLinkerContext, theSignature.getArguments()[0]);
                                if (theConversionFunction != null) {
                                    theWriter.print("=");
                                    theWriter.print(theConversionFunction);
                                    theWriter.println("(arg0);");
                                } else {
                                    theWriter.println("=arg0;");
                                }
                            } else {
                                theWriter.print("               return ");
                                boolean theWriteClosingBraces = false;
                                String theConversionFunction = this.conversionFunctionToWASMForOpaqueType(aLinkerContext, theSignature.getReturnType());
                                if (theConversionFunction != null) {
                                    theWriter.print(theConversionFunction);
                                    theWriter.print("(");
                                    theWriteClosingBraces = true;
                                }
                                theWriter.print("bytecoder.referenceTable[target].");
                                theWriter.print(theOpaquePropertyName);
                                if (theWriteClosingBraces) {
                                    theWriter.print(")");
                                }
                                theWriter.println(";");
                            }
                        } else {
                            BytecodeAnnotation theMethodAnnotation = theBytecdeMethod.getAttributes().getAnnotationByType(OpaqueMethod.class.getName());
                            if (theMethodAnnotation != null) {
                                theMethodName = theMethodAnnotation.getElementValueByName("value").stringValue();
                            }
                            boolean theWriteClosingBraces = false;
                            if (!theSignature.getReturnType().isVoid()) {
                                theWriter.print("               return ");
                                String theConversionFunction = this.conversionFunctionToWASMForOpaqueType(aLinkerContext, theSignature.getReturnType());
                                if (theConversionFunction != null) {
                                    theWriter.print(theConversionFunction);
                                    theWriter.print("(");
                                    theWriteClosingBraces = true;
                                }
                            } else {
                                theWriter.print("               ");
                            }
                            theWriter.print("bytecoder.referenceTable[target].");
                            theWriter.print(theMethodName);
                            theWriter.print("(");
                            for (int i = 0; i < theSignature.getArguments().length; ++i) {
                                BytecodeTypeRef theRef;
                                if (i > 0) {
                                    theWriter.print(",");
                                }
                                if ((theRef = theSignature.getArguments()[i]).isPrimitive()) {
                                    theWriter.print("arg");
                                    theWriter.print(i);
                                    continue;
                                }
                                if (theRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
                                    theWriter.print("bytecoder.toJSString(");
                                    theWriter.print("arg");
                                    theWriter.print(i);
                                    theWriter.print(")");
                                    continue;
                                }
                                BytecodeObjectTypeRef theObjectType = (BytecodeObjectTypeRef)theRef;
                                BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(theObjectType);
                                if (theLinkedClass.isOpaqueType()) {
                                    theWriter.print("bytecoder.toJSReference(");
                                    theWriter.print("arg");
                                    theWriter.print(i);
                                    theWriter.print(")");
                                    continue;
                                }
                                if (theLinkedClass.isCallback()) {
                                    int j;
                                    List theCallbackMethods = theLinkedClass.resolvedMethods().stream().filter(x -> x.getProvidingClass() == theLinkedClass).map(BytecodeResolvedMethods.MethodEntry::getValue).collect(Collectors.toList());
                                    if (theCallbackMethods.size() != 1) {
                                        throw new IllegalStateException("Wrong number of callback methods in " + theLinkedClass.getClassName().name() + ", expected 1, got " + theCallbackMethods.size());
                                    }
                                    BytecodeMethod theImpl = (BytecodeMethod)theCallbackMethods.get(0);
                                    theWriter.print("bytecoder.registerCallback(arg");
                                    theWriter.print(i);
                                    theWriter.print(",function (");
                                    for (int j3 = 0; j3 < theImpl.getSignature().getArguments().length; ++j3) {
                                        if (j3 > 0) {
                                            theWriter.print(",");
                                        }
                                        theWriter.print("farg");
                                        theWriter.print(j3);
                                    }
                                    theWriter.print(") {");
                                    for (int j3 = 0; j3 < theImpl.getSignature().getArguments().length; ++j3) {
                                        theWriter.print("var marg");
                                        theWriter.print(j3);
                                        theWriter.print("=");
                                        BytecodeTypeRef theTypeRef = theImpl.getSignature().getArguments()[j3];
                                        if (theTypeRef.isPrimitive()) {
                                            theWriter.print("farg");
                                            theWriter.print(j3);
                                        } else {
                                            if (theTypeRef.isArray()) {
                                                throw new IllegalStateException("Type conversion to " + theTypeRef.name() + " is not supported!");
                                            }
                                            if (theTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
                                                theWriter.print("bytecoder.toBytecoderString(");
                                                theWriter.print("farg");
                                                theWriter.print(j3);
                                                theWriter.print(")");
                                            } else {
                                                BytecodeObjectTypeRef theArgObjectType = (BytecodeObjectTypeRef)theTypeRef;
                                                BytecodeLinkedClass theArgLinkedClass = aLinkerContext.resolveClass(theArgObjectType);
                                                if (!theArgLinkedClass.isOpaqueType()) {
                                                    throw new IllegalStateException("Type conversion from " + theTypeRef.name() + " is not supported!");
                                                }
                                                theWriter.print("bytecoder.toBytecoderReference(");
                                                theWriter.print("farg");
                                                theWriter.print(j3);
                                                theWriter.print(")");
                                            }
                                        }
                                        theWriter.print(";");
                                    }
                                    String theCallbackMethod = LLVMWriterUtils.toMethodName(theLinkedClass.getClassName(), theImpl.getName(), theImpl.getSignature());
                                    theWriter.print("bytecoder.exports.");
                                    theWriter.print(theCallbackMethod);
                                    theWriter.print("(arg");
                                    theWriter.print(i);
                                    for (j = 0; j < theImpl.getSignature().getArguments().length; ++j) {
                                        theWriter.print(",");
                                        theWriter.print("marg");
                                        theWriter.print(j);
                                    }
                                    theWriter.print(");");
                                    for (j = 0; j < theImpl.getSignature().getArguments().length; ++j) {
                                        BytecodeLinkedClass theLinkedType;
                                        BytecodeTypeRef theTypeRef = theImpl.getSignature().getArguments()[j];
                                        if (theTypeRef.isPrimitive() || theTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class)) || !(theLinkedType = aLinkerContext.resolveClass((BytecodeObjectTypeRef)theTypeRef)).isEvent()) continue;
                                        theWriter.print("delete bytecoder.referenceTable[marg");
                                        theWriter.print(j);
                                        theWriter.print("];");
                                    }
                                    theWriter.print("})");
                                    continue;
                                }
                                throw new IllegalStateException("Type conversion from " + theRef.name() + " is not supported!");
                            }
                            if (theWriteClosingBraces) {
                                theWriter.print(")");
                            }
                            theWriter.println(");");
                        }
                        theWriter.println("             },");
                    }
                    theWriter.println("         },");
                }
                theWriter.println("     },");
                theWriter.println("};");
            }
            catch (Throwable theStringClass) {
                theLLContent22 = theStringClass;
                throw theStringClass;
            }
            finally {
                if (theWriter != null) {
                    if (theLLContent22 != null) {
                        try {
                            theWriter.close();
                        }
                        catch (Throwable theStringClass) {
                            ((Throwable)theLLContent22).addSuppressed(theStringClass);
                        }
                    } else {
                        theWriter.close();
                    }
                }
            }
            theCompileResult.add(new CompileResult.StringContent(aOptions.getFilenamePrefix() + ".js", theJSCode.toString()));
            ArrayList<String> theLLCommand = new ArrayList<String>();
            if ("\\".equals(File.separator)) {
                theLLCommand.add("wsl");
            }
            String theObjectFileName = theLLFile.getName() + ".o";
            theLLCommand.add("llc-10");
            theLLCommand.add("-" + aOptions.getLlvmOptimizationLevel().name());
            theLLCommand.add("-filetype=obj");
            theLLCommand.add(theLLFile.getName());
            theLLCommand.add("-o");
            theLLCommand.add(theObjectFileName);
            ProcessBuilder theLLCProcessBuilder = new ProcessBuilder(theLLCommand).directory(theLLFile.getParentFile()).inheritIO();
            aOptions.getLogger().info("LLVM compiler command is {}", new Object[]{theLLCProcessBuilder.command()});
            Process theLLCProcess = theLLCProcessBuilder.start();
            if (theLLCProcess.waitFor() != 0) {
                aOptions.getLogger().warn("llc returned with exit code {}", new Object[]{theLLCProcess.exitValue()});
                BufferedReader processOutput = new BufferedReader(new InputStreamReader(theLLCProcess.getErrorStream()));
                theProvider = null;
                try {
                    String string;
                    while ((string = processOutput.readLine()) != null) {
                        aOptions.getLogger().info(string, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    theProvider = throwable;
                    throw throwable;
                }
                finally {
                    if (processOutput != null) {
                        if (theProvider != null) {
                            try {
                                processOutput.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)theProvider).addSuppressed(throwable);
                            }
                        } else {
                            processOutput.close();
                        }
                    }
                }
                throw new RuntimeException("llc reported an error!");
            }
            File theObjectFile = new File(theLLFile.getParent(), theObjectFileName);
            theObjectFile.deleteOnExit();
            Throwable throwable = null;
            try (FileInputStream inputStream = new FileInputStream(theObjectFile);){
                theCompileResult.add(new CompileResult.BinaryContent(aOptions.getFilenamePrefix() + ".o", IOUtils.toByteArray((InputStream)inputStream)));
            }
            catch (Throwable i) {
                Throwable throwable2 = i;
                throw i;
            }
            theLLFile.delete();
            ArrayList<String> theLinkerCommand = new ArrayList<String>();
            if ("\\".equals(File.separator)) {
                theLinkerCommand.add("wsl");
            }
            String theWASMFileName = theLLFile.getName() + ".wasm";
            theLinkerCommand.add("wasm-ld-10");
            theLinkerCommand.add(theObjectFileName);
            theLinkerCommand.add("-o");
            theLinkerCommand.add(theWASMFileName);
            theLinkerCommand.add("-export-dynamic");
            theLinkerCommand.add("-allow-undefined");
            theLinkerCommand.add("--lto-" + aOptions.getLlvmOptimizationLevel().name());
            theLinkerCommand.add("--no-entry");
            if (aOptions.isDebugOutput()) {
                theLinkerCommand.add("--demangle");
            } else {
                theLinkerCommand.add("-s");
            }
            theLinkerCommand.add("--initial-memory=" + aOptions.getWasmMinimumPageSize() * 65536);
            theLinkerCommand.add("--max-memory=" + aOptions.getWasmMaximumPageSize() * 65536);
            ProcessBuilder processBuilder = new ProcessBuilder(theLinkerCommand).directory(theLLFile.getParentFile());
            aOptions.getLogger().info("LLVM linker command is {}", new Object[]{processBuilder.command()});
            Process theLinkerProcess = processBuilder.start();
            if (theLinkerProcess.waitFor() != 0) {
                aOptions.getLogger().warn("wasm-ld returned with exit code {} ", new Object[]{theLinkerProcess.exitValue()});
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(theLinkerProcess.getErrorStream()));){
                    String line3;
                    while ((line3 = bufferedReader.readLine()) != null) {
                        aOptions.getLogger().warn(line3, new Object[0]);
                    }
                }
                throw new RuntimeException("wasm-ld reported an error!");
            }
            File file = new File(theLLFile.getParent(), theWASMFileName);
            file.deleteOnExit();
            try (FileInputStream inputStream2 = new FileInputStream(file);){
                theCompileResult.add(new CompileResult.BinaryContent(aOptions.getFilenamePrefix() + ".wasm", IOUtils.toByteArray((InputStream)inputStream2)));
            }
            new File(theObjectFileName).delete();
            file.delete();
            return theCompileResult;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String conversionFunctionToJSForOpaqueType(BytecodeLinkerContext alinkerContext, BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            return null;
        }
        if (aTypeRef.isArray()) {
            throw new IllegalStateException("Type conversion to " + aTypeRef.name() + " is not supported!");
        }
        if (aTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
            return "bytecoder.toJSString";
        }
        BytecodeObjectTypeRef theObjectType = (BytecodeObjectTypeRef)aTypeRef;
        BytecodeLinkedClass theLinkedClass = alinkerContext.resolveClass(theObjectType);
        if (theLinkedClass.isOpaqueType()) {
            return "bytecoder.toJSReference";
        }
        throw new IllegalStateException("Type conversion from " + aTypeRef.name() + " is not supported!");
    }

    private String conversionFunctionToWASMForOpaqueType(BytecodeLinkerContext alinkerContext, BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            return null;
        }
        if (aTypeRef.isArray()) {
            throw new IllegalStateException("Type conversion to " + aTypeRef.name() + " is not supported!");
        }
        if (aTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
            return "bytecoder.toBytecoderString";
        }
        BytecodeObjectTypeRef theObjectType = (BytecodeObjectTypeRef)aTypeRef;
        BytecodeLinkedClass theLinkedClass = alinkerContext.resolveClass(theObjectType);
        if (theLinkedClass.isOpaqueType()) {
            return "bytecoder.toBytecoderReference";
        }
        throw new IllegalStateException("Type conversion from " + aTypeRef.name() + " is not supported!");
    }

    private void writeMethodHandleDelegateInvokeStatic(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, PrintWriter aWriter) {
        String theType;
        String theArgName;
        int k;
        String theType2;
        String theArgName2;
        int k2;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        if (theSignature.getReturnType().isVoid()) {
            aWriter.print("define internal void @");
            aWriter.print(aDelegateMethodName);
            aWriter.print("(i32 %lambdaRef");
        } else {
            aWriter.print("define internal ");
            aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
            aWriter.print(" @");
            aWriter.print(aDelegateMethodName);
            aWriter.print("(i32 %lambdaRef");
        }
        for (k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            theArgName2 = "captureArg" + k2;
            theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]));
            aWriter.print(",");
            aWriter.print(theType2);
            aWriter.print(" %");
            aWriter.print(theArgName2);
        }
        aWriter.println(") {");
        aWriter.println("entry:");
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            aWriter.println("    %staticoffset = add i32 %lambdaRef, 12");
            aWriter.println("    %staticdatalistptr = inttoptr i32 %staticoffset to i32*");
            aWriter.println("    %staticdata = load i32, i32* %staticdatalistptr");
            for (k2 = 0; k2 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k2) {
                theArgName2 = "linkArg" + k2;
                theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k2]));
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_offset = add i32 %staticdata, ");
                aWriter.println(20 + k2 * 8);
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_ptr = inttoptr i32 %");
                aWriter.print(theArgName2);
                aWriter.print("_offset to ");
                aWriter.print(theType2);
                aWriter.println("*");
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print(" = load ");
                aWriter.print(theType2);
                aWriter.print(",");
                aWriter.print(theType2);
                aWriter.print("* %");
                aWriter.print(theArgName2);
                aWriter.println("_ptr");
            }
        }
        if (!theSignature.getReturnType().isVoid()) {
            aWriter.print("    %ret = ");
        } else {
            aWriter.print("    ");
        }
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getLinkageSignature().getArguments()));
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getCaptureSignature().getArguments()));
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        aWriter.print("call ");
        aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
        aWriter.print(" @");
        aWriter.print(LLVMWriterUtils.toMethodName(aMethodHandle.getClassName(), aMethodHandle.getMethodName(), theEffectiveSignature));
        aWriter.print("(i32 undef");
        for (k = 0; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        aWriter.println(")");
        if (!theSignature.getReturnType().isVoid()) {
            aWriter.print("    ret ");
            aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
            aWriter.println(" %ret");
        } else {
            aWriter.println("    ret void");
        }
        aWriter.println("}");
        aWriter.println();
    }

    private void writeMethodHandleDelegateInvokeVirtual(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, PrintWriter aWriter) {
        String theType;
        String theArgName;
        int k;
        String theType2;
        String theArgName2;
        int k2;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        if (theSignature.getReturnType().isVoid()) {
            aWriter.print("define internal void @");
            aWriter.print(aDelegateMethodName);
            aWriter.print("(i32 %lambdaRef");
        } else {
            aWriter.print("define internal ");
            aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
            aWriter.print(" @");
            aWriter.print(aDelegateMethodName);
            aWriter.print("(i32 %lambdaRef");
        }
        for (k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            theArgName2 = "captureArg" + k2;
            theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]));
            aWriter.print(",");
            aWriter.print(theType2);
            aWriter.print(" %");
            aWriter.print(theArgName2);
        }
        aWriter.println(") {");
        aWriter.println("entry:");
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            aWriter.println("    %staticoffset = add i32 %lambdaRef, 12");
            aWriter.println("    %staticdatalistptr = inttoptr i32 %staticoffset to i32*");
            aWriter.println("    %staticdata = load i32, i32* %staticdatalistptr");
            for (k2 = 0; k2 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k2) {
                theArgName2 = "linkArg" + k2;
                theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k2]));
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_offset = add i32 %staticdata, ");
                aWriter.println(20 + k2 * 8);
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_ptr = inttoptr i32 %");
                aWriter.print(theArgName2);
                aWriter.print("_offset to ");
                aWriter.print(theType2);
                aWriter.println("*");
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print(" = load ");
                aWriter.print(theType2);
                aWriter.print(",");
                aWriter.print(theType2);
                aWriter.print("* %");
                aWriter.print(theArgName2);
                aWriter.println("_ptr");
            }
        }
        aWriter.println("    %vtable = add i32 %linkArg0, 4");
        aWriter.println("    %vtableptr = inttoptr i32 %vtable to i32*");
        aWriter.println("    %vtableref = load i32, i32* %vtableptr");
        aWriter.println("    %vtableref_offset = add i32 %vtableref, 4");
        aWriter.println("    %vtableref_offset_ptr = inttoptr i32 %vtableref_offset to i32*");
        aWriter.println("    %dispatcher = load i32, i32* %vtableref_offset_ptr");
        aWriter.println("    %dispatcher_ptr = inttoptr i32 %dispatcher to i32(i32,i32)*");
        aWriter.print("    %resolved = call i32(i32,i32) %dispatcher_ptr(i32 %linkArg0,");
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        for (int k3 = 1; k3 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k3) {
            theEffectiveSignatureArguments.add(theAdapterAnnotation.getLinkageSignature().getArguments()[k3]);
        }
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getCaptureSignature().getArguments()));
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        BytecodeVirtualMethodIdentifier theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(aMethodHandle.getMethodName(), theEffectiveSignature);
        aWriter.print("i32 ");
        aWriter.print(theMethodIdentifier.getIdentifier());
        aWriter.println(")");
        aWriter.print("    %resolved_ptr = inttoptr i32 %resolved to ");
        aWriter.print(LLVMWriterUtils.toSignature(theEffectiveSignature));
        aWriter.println("*");
        if (!theSignature.getReturnType().isVoid()) {
            aWriter.print("    %ret = ");
        } else {
            aWriter.print("    ");
        }
        aWriter.print("call ");
        aWriter.print(LLVMWriterUtils.toSignature(theEffectiveSignature));
        aWriter.print(" %resolved_ptr (i32 %linkArg0");
        for (k = 1; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        aWriter.println(")");
        if (!theSignature.getReturnType().isVoid()) {
            aWriter.print("    ret ");
            aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
            aWriter.println(" %ret");
        } else {
            aWriter.println("    ret void");
        }
        aWriter.println("}");
        aWriter.println();
    }

    private void writeMethodHandleDelegateNewInvokeSpecial(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, PrintWriter aWriter) {
        String theType;
        String theArgName;
        int k;
        String theType2;
        String theArgName2;
        int k2;
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        aWriter.print("define internal i32 ");
        aWriter.print(" @");
        aWriter.print(aDelegateMethodName);
        aWriter.print("(i32 %lambdaRef");
        for (k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            theArgName2 = "captureArg" + k2;
            theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]));
            aWriter.print(",");
            aWriter.print(theType2);
            aWriter.print(" %");
            aWriter.print(theArgName2);
        }
        aWriter.println(") {");
        aWriter.println("entry:");
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            aWriter.println("    %staticoffset = add i32 %lambdaRef, 12");
            aWriter.println("    %staticdatalistptr = inttoptr i32 %staticoffset to i32*");
            aWriter.println("    %staticdata = load i32, i32* %staticdatalistptr");
            for (k2 = 0; k2 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k2) {
                theArgName2 = "linkArg" + k2;
                theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k2]));
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_offset = add i32 %staticdata, ");
                aWriter.println(20 + k2 * 8);
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_ptr = inttoptr i32 %");
                aWriter.print(theArgName2);
                aWriter.print("_offset to ");
                aWriter.print(theType2);
                aWriter.println("*");
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print(" = load ");
                aWriter.print(theType2);
                aWriter.print(",");
                aWriter.print(theType2);
                aWriter.print("* %");
                aWriter.print(theArgName2);
                aWriter.println("_ptr");
            }
        }
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getLinkageSignature().getArguments()));
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getCaptureSignature().getArguments()));
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        aWriter.print("    %");
        aWriter.print(LLVMWriterUtils.runtimeClassVariableName(aMethodHandle.getClassName()));
        aWriter.print(" = call i32 @");
        aWriter.print(LLVMWriterUtils.toClassName(aMethodHandle.getClassName()));
        aWriter.print("__init");
        aWriter.println("()");
        aWriter.print("    %ret = call i32 @");
        aWriter.print(LLVMWriterUtils.toMethodName(aMethodHandle.getClassName(), "$newInstance", theEffectiveSignature));
        aWriter.print("(i32 %");
        aWriter.print(LLVMWriterUtils.runtimeClassVariableName(aMethodHandle.getClassName()));
        for (k = 0; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        aWriter.println(")");
        aWriter.println("    ret i32 %ret");
        aWriter.println("}");
        aWriter.println();
    }

    private void writeMethodHandleDelegateInvokeSpecial(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, PrintWriter aWriter) {
        String theType;
        String theArgName;
        int k;
        String theType2;
        String theArgName2;
        int k2;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        if (theSignature.getReturnType().isVoid()) {
            aWriter.print("define internal void @");
            aWriter.print(aDelegateMethodName);
            aWriter.print("(i32 %lambdaRef");
        } else {
            aWriter.print("define internal ");
            aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
            aWriter.print(" @");
            aWriter.print(aDelegateMethodName);
            aWriter.print("(i32 %lambdaRef");
        }
        for (k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            theArgName2 = "captureArg" + k2;
            theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]));
            aWriter.print(",");
            aWriter.print(theType2);
            aWriter.print(" %");
            aWriter.print(theArgName2);
        }
        aWriter.println(") {");
        aWriter.println("entry:");
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            aWriter.println("    %staticoffset = add i32 %lambdaRef, 12");
            aWriter.println("    %staticdatalistptr = inttoptr i32 %staticoffset to i32*");
            aWriter.println("    %staticdata = load i32, i32* %staticdatalistptr");
            for (k2 = 0; k2 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k2) {
                theArgName2 = "linkArg" + k2;
                theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k2]));
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_offset = add i32 %staticdata, ");
                aWriter.println(20 + k2 * 8);
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_ptr = inttoptr i32 %");
                aWriter.print(theArgName2);
                aWriter.print("_offset to ");
                aWriter.print(theType2);
                aWriter.println("*");
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print(" = load ");
                aWriter.print(theType2);
                aWriter.print(",");
                aWriter.print(theType2);
                aWriter.print("* %");
                aWriter.print(theArgName2);
                aWriter.println("_ptr");
            }
        }
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        for (int k3 = 1; k3 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k3) {
            theEffectiveSignatureArguments.add(theAdapterAnnotation.getLinkageSignature().getArguments()[k3]);
        }
        theEffectiveSignatureArguments.addAll(Arrays.asList(theAdapterAnnotation.getCaptureSignature().getArguments()));
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        if (!theSignature.getReturnType().isVoid()) {
            aWriter.print("    %ret = ");
        } else {
            aWriter.print("    ");
        }
        aWriter.print("call ");
        aWriter.print(LLVMWriterUtils.toSignature(theEffectiveSignature));
        aWriter.print(" @");
        aWriter.print(LLVMWriterUtils.toMethodName(aMethodHandle.getClassName(), aMethodHandle.getMethodName(), theEffectiveSignature));
        aWriter.print("(i32 %linkArg0");
        for (k = 1; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        aWriter.println(")");
        if (!theSignature.getReturnType().isVoid()) {
            aWriter.print("    ret ");
            aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
            aWriter.println(" %ret");
        } else {
            aWriter.println("    ret void");
        }
        aWriter.println("}");
        aWriter.println();
    }

    private void writeMethodHandleDelegateInvokeInterface(BytecodeLinkerContext aLinkerContext, MethodHandleExpression aMethodHandle, String aDelegateMethodName, PrintWriter aWriter) {
        String theType;
        String theArgName;
        int k;
        int k2;
        String theType2;
        String theArgName2;
        int k3;
        BytecodeMethodSignature theSignature = aMethodHandle.getImplementationSignature();
        MethodHandleExpression.AdapterAnnotation theAdapterAnnotation = aMethodHandle.getAdapterAnnotation();
        if (theSignature.getReturnType().isVoid()) {
            aWriter.print("define internal void @");
            aWriter.print(aDelegateMethodName);
            aWriter.print("(i32 %lambdaRef");
        } else {
            aWriter.print("define internal ");
            aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
            aWriter.print(" @");
            aWriter.print(aDelegateMethodName);
            aWriter.print("(i32 %lambdaRef");
        }
        for (k3 = 0; k3 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k3) {
            theArgName2 = "captureArg" + k3;
            theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k3]));
            aWriter.print(",");
            aWriter.print(theType2);
            aWriter.print(" %");
            aWriter.print(theArgName2);
        }
        aWriter.println(") {");
        aWriter.println("entry:");
        if (theAdapterAnnotation.getLinkageSignature().getArguments().length > 0) {
            aWriter.println("    %staticoffset = add i32 %lambdaRef, 12");
            aWriter.println("    %staticdatalistptr = inttoptr i32 %staticoffset to i32*");
            aWriter.println("    %staticdata = load i32, i32* %staticdatalistptr");
            for (k3 = 0; k3 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k3) {
                theArgName2 = "linkArg" + k3;
                theType2 = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k3]));
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_offset = add i32 %staticdata, ");
                aWriter.println(20 + k3 * 8);
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print("_ptr = inttoptr i32 %");
                aWriter.print(theArgName2);
                aWriter.print("_offset to ");
                aWriter.print(theType2);
                aWriter.println("*");
                aWriter.print("    %");
                aWriter.print(theArgName2);
                aWriter.print(" = load ");
                aWriter.print(theType2);
                aWriter.print(",");
                aWriter.print(theType2);
                aWriter.print("* %");
                aWriter.print(theArgName2);
                aWriter.println("_ptr");
            }
        }
        String theTarget = null;
        ArrayList<BytecodeTypeRef> theEffectiveSignatureArguments = new ArrayList<BytecodeTypeRef>();
        for (k2 = 0; k2 < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k2) {
            if (theTarget == null) {
                theTarget = "linkArg" + k2;
                continue;
            }
            theEffectiveSignatureArguments.add(theAdapterAnnotation.getLinkageSignature().getArguments()[k2]);
        }
        for (k2 = 0; k2 < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k2) {
            if (theTarget == null) {
                theTarget = "captureArg" + k2;
                continue;
            }
            theEffectiveSignatureArguments.add(theAdapterAnnotation.getCaptureSignature().getArguments()[k2]);
        }
        aWriter.print("    %vtable = add i32 %");
        aWriter.print(theTarget);
        aWriter.println(", 4");
        aWriter.println("    %vtableptr = inttoptr i32 %vtable to i32*");
        aWriter.println("    %vtableref = load i32, i32* %vtableptr");
        aWriter.println("    %vtableref_offset = add i32 %vtableref, 4");
        aWriter.println("    %vtableref_offset_ptr = inttoptr i32 %vtableref_offset to i32*");
        aWriter.println("    %dispatcher = load i32, i32* %vtableref_offset_ptr");
        aWriter.println("    %dispatcher_ptr = inttoptr i32 %dispatcher to i32(i32,i32)*");
        aWriter.print("    %resolved = call i32(i32,i32) %dispatcher_ptr(i32 %");
        aWriter.print(theTarget);
        aWriter.print(",");
        BytecodeMethodSignature theEffectiveSignature = new BytecodeMethodSignature(theSignature.getReturnType(), theEffectiveSignatureArguments.toArray(new BytecodeTypeRef[0]));
        BytecodeVirtualMethodIdentifier theMethodIdentifier = aLinkerContext.getMethodCollection().identifierFor(aMethodHandle.getMethodName(), theEffectiveSignature);
        aWriter.print("i32 ");
        aWriter.print(theMethodIdentifier.getIdentifier());
        aWriter.println(")");
        aWriter.print("    %resolved_ptr = inttoptr i32 %resolved to ");
        aWriter.print(LLVMWriterUtils.toSignature(theEffectiveSignature));
        aWriter.println("*");
        if (!theSignature.getReturnType().isVoid()) {
            aWriter.print("    %ret = ");
        } else {
            aWriter.print("    ");
        }
        aWriter.print("call ");
        aWriter.print(LLVMWriterUtils.toSignature(theEffectiveSignature));
        aWriter.print(" %resolved_ptr (i32 %");
        aWriter.print(theTarget);
        for (k = 0; k < theAdapterAnnotation.getLinkageSignature().getArguments().length; ++k) {
            theArgName = "linkArg" + k;
            if (theTarget.equals(theArgName)) continue;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getLinkageSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        for (k = 0; k < theAdapterAnnotation.getCaptureSignature().getArguments().length; ++k) {
            theArgName = "captureArg" + k;
            if (theTarget.equals(theArgName)) continue;
            theType = LLVMWriterUtils.toType(TypeRef.toType(theAdapterAnnotation.getCaptureSignature().getArguments()[k]));
            aWriter.print(",");
            aWriter.print(theType);
            aWriter.print(" %");
            aWriter.print(theArgName);
        }
        aWriter.println(")");
        if (!theSignature.getReturnType().isVoid()) {
            aWriter.print("    ret ");
            aWriter.print(LLVMWriterUtils.toType(TypeRef.toType(theSignature.getReturnType())));
            aWriter.println(" %ret");
        } else {
            aWriter.println("    ret void");
        }
        aWriter.println("}");
        aWriter.println();
    }

    private static class CompiledMethod {
        private final BytecodeLinkedClass linkedClass;
        private final BytecodeMethod method;
        private final Program program;
        private final LLVMDebugInformation.SubProgram debugInformationSubProgram;

        public CompiledMethod(BytecodeLinkedClass linkedClass, BytecodeMethod method, Program program, LLVMDebugInformation.SubProgram debugInformationSubProgram) {
            this.linkedClass = linkedClass;
            this.method = method;
            this.program = program;
            this.debugInformationSubProgram = debugInformationSubProgram;
        }
    }

    private static class OpaqueReferenceMethod {
        private final BytecodeLinkedClass linkedClass;
        private final BytecodeMethod method;

        public OpaqueReferenceMethod(BytecodeLinkedClass linkedClass, BytecodeMethod method) {
            this.linkedClass = linkedClass;
            this.method = method;
        }

        public BytecodeLinkedClass getLinkedClass() {
            return this.linkedClass;
        }

        public BytecodeMethod getMethod() {
            return this.method;
        }
    }

    private static class CallSite {
        private final BytecodeLinkedClass owningClass;
        private final Program program;
        private final RegionNode bootstrapMethod;

        private CallSite(BytecodeLinkedClass aOwningClass, Program aProgram, RegionNode aBootstrapMethod) {
            this.owningClass = aOwningClass;
            this.program = aProgram;
            this.bootstrapMethod = aBootstrapMethod;
        }
    }
}

