/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.js;

import de.mirkosertic.bytecoder.allocator.AbstractAllocator;
import de.mirkosertic.bytecoder.allocator.Register;
import de.mirkosertic.bytecoder.api.Import;
import de.mirkosertic.bytecoder.api.OpaqueIndexed;
import de.mirkosertic.bytecoder.api.OpaqueMethod;
import de.mirkosertic.bytecoder.api.OpaqueProperty;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.ConstantPool;
import de.mirkosertic.bytecoder.backend.js.JSMinifier;
import de.mirkosertic.bytecoder.backend.js.JSPrintWriter;
import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeFieldRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import de.mirkosertic.bytecoder.core.BytecodeResolvedMethods;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.relooper.Relooper;
import de.mirkosertic.bytecoder.ssa.ArrayEntryExpression;
import de.mirkosertic.bytecoder.ssa.ArrayLengthExpression;
import de.mirkosertic.bytecoder.ssa.ArrayStoreExpression;
import de.mirkosertic.bytecoder.ssa.BinaryExpression;
import de.mirkosertic.bytecoder.ssa.BreakExpression;
import de.mirkosertic.bytecoder.ssa.ByteValue;
import de.mirkosertic.bytecoder.ssa.CheckCastExpression;
import de.mirkosertic.bytecoder.ssa.ClassReferenceValue;
import de.mirkosertic.bytecoder.ssa.CompareExpression;
import de.mirkosertic.bytecoder.ssa.ComputedMemoryLocationReadExpression;
import de.mirkosertic.bytecoder.ssa.ComputedMemoryLocationWriteExpression;
import de.mirkosertic.bytecoder.ssa.ContinueExpression;
import de.mirkosertic.bytecoder.ssa.CurrentExceptionExpression;
import de.mirkosertic.bytecoder.ssa.DataEndExpression;
import de.mirkosertic.bytecoder.ssa.DebugPosition;
import de.mirkosertic.bytecoder.ssa.DirectInvokeMethodExpression;
import de.mirkosertic.bytecoder.ssa.DoubleValue;
import de.mirkosertic.bytecoder.ssa.EnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.FixedBinaryExpression;
import de.mirkosertic.bytecoder.ssa.FloatValue;
import de.mirkosertic.bytecoder.ssa.FloatingPointCeilExpression;
import de.mirkosertic.bytecoder.ssa.FloatingPointFloorExpression;
import de.mirkosertic.bytecoder.ssa.FloorExpression;
import de.mirkosertic.bytecoder.ssa.GetFieldExpression;
import de.mirkosertic.bytecoder.ssa.GetStaticExpression;
import de.mirkosertic.bytecoder.ssa.GotoExpression;
import de.mirkosertic.bytecoder.ssa.HeapBaseExpression;
import de.mirkosertic.bytecoder.ssa.IFElseExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.InstanceOfExpression;
import de.mirkosertic.bytecoder.ssa.IntegerValue;
import de.mirkosertic.bytecoder.ssa.InvokeStaticMethodExpression;
import de.mirkosertic.bytecoder.ssa.InvokeVirtualMethodExpression;
import de.mirkosertic.bytecoder.ssa.IsNaNExpression;
import de.mirkosertic.bytecoder.ssa.LambdaConstructorReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaInterfaceReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaSpecialReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaVirtualReferenceExpression;
import de.mirkosertic.bytecoder.ssa.LambdaWithStaticImplExpression;
import de.mirkosertic.bytecoder.ssa.LongValue;
import de.mirkosertic.bytecoder.ssa.LookupSwitchExpression;
import de.mirkosertic.bytecoder.ssa.MaxExpression;
import de.mirkosertic.bytecoder.ssa.MemorySizeExpression;
import de.mirkosertic.bytecoder.ssa.MethodHandleExpression;
import de.mirkosertic.bytecoder.ssa.MethodHandlesGeneratedLookupExpression;
import de.mirkosertic.bytecoder.ssa.MethodParameterValue;
import de.mirkosertic.bytecoder.ssa.MethodTypeArgumentCheckExpression;
import de.mirkosertic.bytecoder.ssa.MethodTypeExpression;
import de.mirkosertic.bytecoder.ssa.MinExpression;
import de.mirkosertic.bytecoder.ssa.NegatedExpression;
import de.mirkosertic.bytecoder.ssa.NewArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewInstanceFromDefaultConstructorExpression;
import de.mirkosertic.bytecoder.ssa.NewMultiArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectAndConstructExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectExpression;
import de.mirkosertic.bytecoder.ssa.NullValue;
import de.mirkosertic.bytecoder.ssa.PHIValue;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.PutFieldExpression;
import de.mirkosertic.bytecoder.ssa.PutStaticExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.ResolveCallsiteObjectExpression;
import de.mirkosertic.bytecoder.ssa.ReturnExpression;
import de.mirkosertic.bytecoder.ssa.ReturnValueExpression;
import de.mirkosertic.bytecoder.ssa.SelfReferenceParameterValue;
import de.mirkosertic.bytecoder.ssa.SetEnumConstantsExpression;
import de.mirkosertic.bytecoder.ssa.SetMemoryLocationExpression;
import de.mirkosertic.bytecoder.ssa.ShortValue;
import de.mirkosertic.bytecoder.ssa.SqrtExpression;
import de.mirkosertic.bytecoder.ssa.StackTopExpression;
import de.mirkosertic.bytecoder.ssa.StringValue;
import de.mirkosertic.bytecoder.ssa.SuperTypeOfExpression;
import de.mirkosertic.bytecoder.ssa.SystemHasStackExpression;
import de.mirkosertic.bytecoder.ssa.TableSwitchExpression;
import de.mirkosertic.bytecoder.ssa.ThrowExpression;
import de.mirkosertic.bytecoder.ssa.TypeConversionExpression;
import de.mirkosertic.bytecoder.ssa.TypeOfExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.UnreachableExpression;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import de.mirkosertic.bytecoder.stackifier.Block;
import de.mirkosertic.bytecoder.stackifier.Stackifier;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;

public class JSSSAWriter {
    protected final Program program;
    protected final BytecodeLinkerContext linkerContext;
    protected final JSPrintWriter writer;
    protected final CompileOptions options;
    private final ConstantPool constantPool;
    private boolean labelRequired;
    private final JSMinifier minifier;
    private final int indent;
    private final AbstractAllocator allocator;
    private final IDResolver idResolver;

    public JSSSAWriter(CompileOptions aOptions, Program aProgram, int aIndent, JSPrintWriter aWriter, BytecodeLinkerContext aLinkerContext, ConstantPool aConstantPool, boolean aLabelRequired, JSMinifier aMinifier, AbstractAllocator aAllocator, IDResolver aIdResolver) {
        this.program = aProgram;
        this.linkerContext = aLinkerContext;
        this.writer = aWriter;
        this.options = aOptions;
        this.constantPool = aConstantPool;
        this.labelRequired = aLabelRequired;
        this.minifier = aMinifier;
        this.indent = aIndent;
        this.allocator = aAllocator;
        this.idResolver = aIdResolver;
    }

    public JSSSAWriter withDeeperIndent() {
        return new JSSSAWriter(this.options, this.program, this.indent + 1, this.writer, this.linkerContext, this.constantPool, this.labelRequired, this.minifier, this.allocator, this.idResolver);
    }

    public JSPrintWriter startLine() {
        return this.writer.tab(this.indent);
    }

    public String toRegisterName(Register r) {
        return "r" + r.getNumber();
    }

    private void print(Value aValue) {
        if (aValue instanceof Expression) {
            this.writeExpressionSourcemapInfo((Expression)aValue);
        }
        if (aValue instanceof Variable) {
            this.printVariableName((Variable)aValue);
        } else if (aValue instanceof GetStaticExpression) {
            this.print((GetStaticExpression)aValue);
        } else if (aValue instanceof NullValue) {
            this.print((NullValue)aValue);
        } else if (aValue instanceof InvokeVirtualMethodExpression) {
            this.print((InvokeVirtualMethodExpression)aValue);
        } else if (aValue instanceof InvokeStaticMethodExpression) {
            this.print((InvokeStaticMethodExpression)aValue);
        } else if (aValue instanceof NewObjectExpression) {
            this.print((NewObjectExpression)aValue);
        } else if (aValue instanceof ByteValue) {
            this.print((ByteValue)aValue);
        } else if (aValue instanceof BinaryExpression) {
            this.print((BinaryExpression)aValue);
        } else if (aValue instanceof GetFieldExpression) {
            this.print((GetFieldExpression)aValue);
        } else if (aValue instanceof TypeConversionExpression) {
            this.print((TypeConversionExpression)aValue);
        } else if (aValue instanceof ArrayEntryExpression) {
            this.print((ArrayEntryExpression)aValue);
        } else if (aValue instanceof ArrayLengthExpression) {
            this.print((ArrayLengthExpression)aValue);
        } else if (aValue instanceof StringValue) {
            this.print((StringValue)aValue);
        } else if (aValue instanceof IntegerValue) {
            this.print((IntegerValue)aValue);
        } else if (aValue instanceof NewArrayExpression) {
            this.print((NewArrayExpression)aValue);
        } else if (aValue instanceof DirectInvokeMethodExpression) {
            this.print((DirectInvokeMethodExpression)aValue);
        } else if (aValue instanceof FloatValue) {
            this.print((FloatValue)aValue);
        } else if (aValue instanceof DoubleValue) {
            this.print((DoubleValue)aValue);
        } else if (aValue instanceof CompareExpression) {
            this.print((CompareExpression)aValue);
        } else if (aValue instanceof NegatedExpression) {
            this.print((NegatedExpression)aValue);
        } else if (aValue instanceof FixedBinaryExpression) {
            this.print((FixedBinaryExpression)aValue);
        } else if (aValue instanceof ShortValue) {
            this.print((ShortValue)aValue);
        } else if (aValue instanceof InstanceOfExpression) {
            this.print((InstanceOfExpression)aValue);
        } else if (aValue instanceof LongValue) {
            this.print((LongValue)aValue);
        } else if (aValue instanceof ClassReferenceValue) {
            this.print((ClassReferenceValue)aValue);
        } else if (aValue instanceof NewMultiArrayExpression) {
            this.print((NewMultiArrayExpression)aValue);
        } else if (aValue instanceof SelfReferenceParameterValue) {
            this.print((SelfReferenceParameterValue)aValue);
        } else if (aValue instanceof MethodParameterValue) {
            this.print((MethodParameterValue)aValue);
        } else if (aValue instanceof CurrentExceptionExpression) {
            this.print((CurrentExceptionExpression)aValue);
        } else if (aValue instanceof FloorExpression) {
            this.print((FloorExpression)aValue);
        } else if (aValue instanceof MethodHandleExpression) {
            this.print((MethodHandleExpression)aValue);
        } else if (aValue instanceof ComputedMemoryLocationReadExpression) {
            this.print((ComputedMemoryLocationReadExpression)aValue);
        } else if (aValue instanceof ComputedMemoryLocationWriteExpression) {
            this.print((ComputedMemoryLocationWriteExpression)aValue);
        } else if (aValue instanceof MethodHandlesGeneratedLookupExpression) {
            this.print((MethodHandlesGeneratedLookupExpression)aValue);
        } else if (aValue instanceof MethodTypeExpression) {
            this.print((MethodTypeExpression)aValue);
        } else if (aValue instanceof LambdaWithStaticImplExpression) {
            this.print((LambdaWithStaticImplExpression)aValue);
        } else if (aValue instanceof LambdaWithStaticImplExpression) {
            this.print((LambdaWithStaticImplExpression)aValue);
        } else if (aValue instanceof LambdaConstructorReferenceExpression) {
            this.print((LambdaConstructorReferenceExpression)aValue);
        } else if (aValue instanceof LambdaInterfaceReferenceExpression) {
            this.print((LambdaInterfaceReferenceExpression)aValue);
        } else if (aValue instanceof LambdaVirtualReferenceExpression) {
            this.print((LambdaVirtualReferenceExpression)aValue);
        } else if (aValue instanceof LambdaSpecialReferenceExpression) {
            this.print((LambdaSpecialReferenceExpression)aValue);
        } else if (aValue instanceof ResolveCallsiteObjectExpression) {
            this.print((ResolveCallsiteObjectExpression)aValue);
        } else if (aValue instanceof StackTopExpression) {
            this.print((StackTopExpression)aValue);
        } else if (aValue instanceof MemorySizeExpression) {
            this.print((MemorySizeExpression)aValue);
        } else if (aValue instanceof TypeOfExpression) {
            this.print((TypeOfExpression)aValue);
        } else if (aValue instanceof SqrtExpression) {
            this.print((SqrtExpression)aValue);
        } else if (aValue instanceof MaxExpression) {
            this.print((MaxExpression)aValue);
        } else if (aValue instanceof MinExpression) {
            this.print((MinExpression)aValue);
        } else if (aValue instanceof FloatingPointFloorExpression) {
            this.print((FloatingPointFloorExpression)aValue);
        } else if (aValue instanceof FloatingPointCeilExpression) {
            this.print((FloatingPointCeilExpression)aValue);
        } else if (aValue instanceof EnumConstantsExpression) {
            this.print((EnumConstantsExpression)aValue);
        } else if (aValue instanceof NewObjectAndConstructExpression) {
            this.print((NewObjectAndConstructExpression)aValue);
        } else if (aValue instanceof PHIValue) {
            this.print((PHIValue)aValue);
        } else if (aValue instanceof IsNaNExpression) {
            this.print((IsNaNExpression)aValue);
        } else if (aValue instanceof NewInstanceFromDefaultConstructorExpression) {
            this.print((NewInstanceFromDefaultConstructorExpression)aValue);
        } else if (aValue instanceof MethodTypeArgumentCheckExpression) {
            this.print((MethodTypeArgumentCheckExpression)aValue);
        } else if (aValue instanceof SuperTypeOfExpression) {
            this.print((SuperTypeOfExpression)aValue);
        } else if (aValue instanceof HeapBaseExpression) {
            this.print((HeapBaseExpression)aValue);
        } else if (aValue instanceof DataEndExpression) {
            this.print((DataEndExpression)aValue);
        } else if (aValue instanceof SystemHasStackExpression) {
            this.print((SystemHasStackExpression)aValue);
        } else {
            throw new IllegalStateException("Not implemented : " + aValue);
        }
    }

    private void print(SystemHasStackExpression aExpression) {
        this.writer.text("0");
    }

    private void print(HeapBaseExpression aExpression) {
        this.writer.text("0");
    }

    private void print(DataEndExpression aExpression) {
        this.writer.text("0");
    }

    private void print(SuperTypeOfExpression aExpression) {
        Value theValue = (Value)aExpression.incomingDataFlows().get(0);
        this.print(theValue);
        this.writer.text(".").text("superClass");
    }

    private void print(MethodTypeArgumentCheckExpression aExpression) {
        Value theValue = (Value)aExpression.incomingDataFlows().get(0);
        Value theIndex = (Value)aExpression.incomingDataFlows().get(1);
        TypeRef.Native theExpectedType = aExpression.getExpectedType();
        this.writer.text("(");
        this.print(theValue);
        this.writer.text(".arguments[");
        this.print(theIndex);
        this.writer.text("]");
        this.writer.text("==='");
        this.writer.text(theExpectedType.name());
        this.writer.text("')");
    }

    private void print(NewInstanceFromDefaultConstructorExpression aExpression) {
        Value theClass = (Value)aExpression.incomingDataFlows().get(0);
        this.print(theClass);
        this.writer.text(".");
        this.writer.text(this.minifier.toMethodName("$newInstance", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0])));
        this.writer.text("()");
    }

    private void print(IsNaNExpression aExpression) {
        this.writer.text("(!(");
        Value theIncoming = (Value)aExpression.incomingDataFlows().get(0);
        this.print(theIncoming);
        this.writer.text("==");
        this.print(theIncoming);
        this.writer.text("))");
    }

    private void print(PHIValue p) {
        Variable v = this.allocator.variableAssignmentFor(p);
        if (v.isSynthetic()) {
            this.printVariableName(v);
        } else {
            Register r = this.allocator.registerAssignmentFor(v);
            this.writer.text(this.toRegisterName(r));
        }
    }

    private void print(NewObjectAndConstructExpression aValue) {
        this.writer.text(this.minifier.toClassName(aValue.getClazz())).text(".").text(this.minifier.toSymbol("__runtimeclass")).text(".").text(this.minifier.toMethodName("$newInstance", aValue.getSignature())).text("(");
        List theArguments = aValue.incomingDataFlows();
        for (int i = 0; i < theArguments.size(); ++i) {
            if (i > 0) {
                this.writer.text(",");
            }
            this.print((Value)theArguments.get(i));
        }
        this.writer.text(")");
    }

    private void print(EnumConstantsExpression aValue) {
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(".");
        this.writer.text(this.minifier.toSymbol("$VALUES"));
    }

    private void print(MaxExpression aValue) {
        this.writer.text("Math.max(");
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(",");
        this.print((Value)aValue.incomingDataFlows().get(1));
        this.writer.text(")");
    }

    private void print(MinExpression aValue) {
        this.writer.text("Math.min(");
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(",");
        this.print((Value)aValue.incomingDataFlows().get(1));
        this.writer.text(")");
    }

    private void print(SqrtExpression aValue) {
        this.writer.text("Math.sqrt(");
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(")");
    }

    private void print(TypeOfExpression aValue) {
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(".").text("constructor");
        this.writer.text(".").text(this.minifier.toSymbol("__runtimeclass"));
    }

    private void print(StackTopExpression aValue) {
        this.writer.text("0");
    }

    private void print(MemorySizeExpression aValue) {
        this.writer.text("1000");
    }

    public void printRegisterDeclarations() {
        List<Register> theList = this.allocator.assignedRegister();
        theList.sort(Comparator.comparingLong(Register::getNumber));
        for (Register r : theList) {
            JSPrintWriter thePW = this.startLine().text("var ").text(this.toRegisterName(r)).assign().text("null;");
            if (this.options.isDebugOutput()) {
                thePW.text(" // type is ").text(r.getType().resolve().name());
            }
            thePW.newLine();
        }
    }

    private void print(ResolveCallsiteObjectExpression aValue) {
        this.writer.text("bytecoder.resolveStaticCallSiteObject(").text(this.minifier.toClassName(aValue.getOwningClass().getThisInfo())).text(",'").text(aValue.getCallsiteId()).text("', function() {").newLine();
        Program theProgram = aValue.getProgram();
        RegionNode theBootstrapCode = aValue.getBootstrapMethod();
        AbstractAllocator theAllocator = this.options.getAllocator().allocate(theProgram, Variable::resolveType, this.linkerContext);
        JSSSAWriter theNested = new JSSSAWriter(this.options, this.program, this.indent + 1, this.writer, this.linkerContext, this.constantPool, this.labelRequired, this.minifier, theAllocator, this.idResolver);
        theNested.printRegisterDeclarations();
        theNested.writeExpressions(theBootstrapCode.getExpressions());
        this.writer.text("})");
    }

    private void print(LambdaWithStaticImplExpression aValue) {
        this.writer.text("bytecoder.lambdaStaticRef(");
        this.print(aValue.getStaticRef());
        this.writer.text(",");
        this.print(aValue.getStaticArguments());
        this.writer.text(",");
        this.print(aValue.getName());
        this.writer.text(",");
        this.print(aValue.getType());
        this.writer.text(")");
    }

    private void print(LambdaConstructorReferenceExpression aValue) {
        this.writer.text("bytecoder.lambdaConstructorRef(");
        this.print(aValue.getType());
        this.writer.text(",");
        this.print(aValue.getConstructorRef());
        this.writer.text(",");
        this.print(aValue.getStaticArguments());
        this.writer.text(")");
    }

    private void print(LambdaInterfaceReferenceExpression aValue) {
        this.writer.text("bytecoder.lambdaInterfaceRef(");
        this.print(aValue.getType());
        this.writer.text(",");
        this.print(aValue.getInterfaceRef());
        this.writer.text(",");
        this.print(aValue.getStaticArguments());
        this.writer.text(")");
    }

    private void print(LambdaVirtualReferenceExpression aValue) {
        this.writer.text("bytecoder.lambdaVirtualRef(");
        this.print(aValue.getType());
        this.writer.text(",");
        this.print(aValue.getVirtualRef());
        this.writer.text(",");
        this.print(aValue.getStaticArguments());
        this.writer.text(")");
    }

    private void print(LambdaSpecialReferenceExpression aValue) {
        this.writer.text("bytecoder.lambdaSpecialRef(");
        this.print(aValue.getType());
        this.writer.text(",");
        this.print(aValue.getSpecialRef());
        this.writer.text(",");
        this.print(aValue.getStaticArguments());
        this.writer.text(")");
    }

    private void printTypeRef(BytecodeTypeRef typeRef) {
        if (typeRef.isVoid() || typeRef.isPrimitive() || typeRef.isArray()) {
            this.writer.text("'");
            this.writer.text(typeRef.name());
            this.writer.text("'");
        } else {
            this.writer.text(this.minifier.toClassName(new BytecodeObjectTypeRef(typeRef.name())));
        }
    }

    private void print(MethodTypeExpression aValue) {
        this.writer.text("bytecoder.methodType(");
        BytecodeMethodSignature theSignature = aValue.getSignature();
        this.printTypeRef(theSignature.getReturnType());
        this.writer.text(",[");
        for (int i = 0; i < theSignature.getArguments().length; ++i) {
            if (i > 0) {
                this.writer.text(",");
            }
            this.printTypeRef(theSignature.getArguments()[i]);
        }
        this.writer.text("])");
    }

    private void print(MethodHandlesGeneratedLookupExpression aValue) {
        this.writer.text("null");
    }

    private void print(ComputedMemoryLocationWriteExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        this.print((Value)theIncomingData.get(0));
        this.writer.space().text("+").space();
        this.print((Value)theIncomingData.get(1));
    }

    private void print(ComputedMemoryLocationReadExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        this.writer.text("bytecoder.memory[");
        this.print((Value)theIncomingData.get(0));
        this.writer.space().text("+").space();
        this.print((Value)theIncomingData.get(1));
        this.writer.text("]");
    }

    private void print(MethodHandleExpression aValue) {
        String theMethodName = aValue.getMethodName();
        BytecodeMethodSignature theImplementationSignature = aValue.getImplementationSignature();
        if (aValue.getAdapterAnnotation() == null) {
            this.writer.text(this.minifier.toClassName(aValue.getClassName())).text(".").text(this.minifier.toMethodName(theMethodName, theImplementationSignature));
        } else {
            this.writer.text("bytecoder.methodhandles.");
            this.writer.text(this.minifier.toSymbol(this.idResolver.methodHandleDelegateFor(aValue)));
        }
    }

    private void print(FloorExpression aValue) {
        this.writer.text("Math.trunc(");
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(")");
    }

    private void print(FloatingPointFloorExpression aValue) {
        this.writer.text("Math.floor(");
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(")");
    }

    private void print(FloatingPointCeilExpression aValue) {
        this.writer.text("Math.ceil(");
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(")");
    }

    private void print(CurrentExceptionExpression aValue) {
        this.writer.text("CURRENTEXCEPTION.exception");
    }

    private void print(MethodParameterValue aValue) {
        this.writer.text("p" + (aValue.getParameterIndex() + 1));
    }

    private void print(SelfReferenceParameterValue aValue) {
        this.writer.text("__tr");
    }

    private void print(NewMultiArrayExpression aValue) {
        BytecodeTypeRef theType = aValue.getType();
        Object theDefaultValue = theType.defaultValue();
        String theStrDefault = theDefaultValue != null ? theDefaultValue.toString() : "null";
        this.writer.text("bytecoder.newMultiArray([");
        List theDimensions = aValue.incomingDataFlows();
        for (int i = 0; i < theDimensions.size(); ++i) {
            if (i > 0) {
                this.writer.text(",");
            }
            this.print((Value)theDimensions.get(i));
        }
        this.writer.text("],").text(theStrDefault).text(")");
    }

    private void print(ClassReferenceValue aValue) {
        this.writer.text(this.minifier.toClassName(aValue.getType())).text(".").text(this.minifier.toSymbol("init")).text("()").text(".").text(this.minifier.toSymbol("__runtimeclass"));
    }

    private void print(InstanceOfExpression aValue) {
        Value theValue = (Value)aValue.incomingDataFlows().get(0);
        this.writer.text("(");
        this.print(theValue);
        this.writer.space().text("==").space().text("null").space().text("?").space().text("false").space().text(":");
        this.print(theValue);
        this.writer.text(".constructor.").text(this.minifier.toSymbol("__runtimeclass")).text(".iof(");
        BytecodeUtf8Constant theConstant = aValue.getType().getConstant();
        if (!theConstant.stringValue().startsWith("[")) {
            BytecodeLinkedClass theLinkedClass = this.linkerContext.isLinkedOrNull(aValue.getType().getConstant());
            this.writer.text(this.minifier.toClassName(theLinkedClass.getClassName()));
        } else {
            BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
            this.writer.text(this.minifier.toClassName(theLinkedClass.getClassName()));
        }
        this.writer.text("))");
    }

    private void print(LongValue aValue) {
        if (aValue.getLongValue() < 0L) {
            this.writer.text(" " + aValue.getLongValue());
        } else {
            this.writer.text("" + aValue.getLongValue());
        }
    }

    private void print(ShortValue aValue) {
        if (aValue.getShortValue() < 0) {
            this.writer.text(" " + aValue.getShortValue());
        } else {
            this.writer.text("" + aValue.getShortValue());
        }
    }

    private void print(NegatedExpression aValue) {
        Value theValue = (Value)aValue.incomingDataFlows().get(0);
        this.writer.text("(-");
        this.print(theValue);
        this.writer.text(")");
    }

    private void print(CompareExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        Value theVariable1 = (Value)theIncomingData.get(0);
        Value theVariable2 = (Value)theIncomingData.get(1);
        this.writer.text("(");
        this.print(theVariable1);
        this.writer.space().text(">").space();
        this.print(theVariable2);
        this.writer.space().text("?").space().text("1").space();
        this.writer.text(":").space().text("(");
        this.print(theVariable1);
        this.writer.space().text("<").space();
        this.print(theVariable2);
        this.writer.space().text("?").space().text("-1").space().text(":").space().text("0))");
    }

    private void print(NewArrayExpression aValue) {
        BytecodeTypeRef theType = aValue.getType();
        Value theLength = (Value)aValue.incomingDataFlows().get(0);
        Object theDefaultValue = theType.defaultValue();
        String theStrDefault = theDefaultValue != null ? theDefaultValue.toString() : "null";
        this.writer.text("bytecoder.newArray(");
        this.print(theLength);
        this.writer.text(",").text(theStrDefault).text(")");
    }

    private void print(IntegerValue aValue) {
        if (aValue.getIntValue() < 0) {
            this.writer.text(" " + aValue.getIntValue());
        } else {
            this.writer.text("" + aValue.getIntValue());
        }
    }

    private void print(FloatValue aValue) {
        this.writer.text("" + aValue.getFloatValue());
    }

    private void print(DoubleValue aValue) {
        this.writer.text("" + aValue.getDoubleValue());
    }

    private void print(StringValue aValue) {
        int theIndex = this.constantPool.register(aValue);
        this.writer.text("bytecoder.stringpool[").text("" + theIndex).text("]");
    }

    private void print(ArrayLengthExpression aValue) {
        this.print((Value)aValue.incomingDataFlows().get(0));
        this.writer.text(".data.length");
    }

    private void printArrayIndexReference(Value aValue) {
        this.writer.text(".data[");
        this.print(aValue);
        this.writer.text("]");
    }

    private void print(ArrayEntryExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        Value theArray = (Value)theIncomingData.get(0);
        Value theIndex = (Value)theIncomingData.get(1);
        this.print(theArray);
        this.printArrayIndexReference(theIndex);
    }

    private void print(TypeConversionExpression aValue) {
        TypeRef theTargetType = aValue.resolveType();
        Value theValue = (Value)aValue.incomingDataFlows().get(0);
        switch (theTargetType.resolve()) {
            case BYTE: {
                this.writer.text("((");
                this.print(theValue);
                this.writer.text(")");
                this.writer.space();
                this.writer.text("<<");
                this.writer.space();
                this.writer.text("24");
                this.writer.space();
                this.writer.text(">>");
                this.writer.space();
                this.writer.text("24)");
                break;
            }
            case FLOAT: {
                this.print(theValue);
                break;
            }
            case DOUBLE: {
                this.print(theValue);
                break;
            }
            default: {
                this.writer.text("Math.trunc(");
                this.print(theValue);
                this.writer.text(")");
            }
        }
    }

    private void print(GetFieldExpression aValue) {
        Value theTarget = (Value)aValue.incomingDataFlows().get(0);
        BytecodeFieldRefConstant theField = aValue.getField();
        this.print(theTarget);
        this.printInstanceFieldReference(theField);
    }

    private void print(BinaryExpression aValue) {
        List theIncomingData = aValue.incomingDataFlows();
        this.writer.text("(");
        this.print((Value)theIncomingData.get(0));
        switch (aValue.getOperator()) {
            case ADD: {
                this.writer.space().text("+").space();
                break;
            }
            case DIV: {
                this.writer.space().text("/").space();
                break;
            }
            case MUL: {
                this.writer.space().text("*").space();
                break;
            }
            case SUB: {
                this.writer.space().text("-").space();
                break;
            }
            case EQUALS: {
                this.writer.space().text("==").space();
                break;
            }
            case BINARYOR: {
                this.writer.space().text("|").space();
                break;
            }
            case LESSTHAN: {
                this.writer.space().text("<").space();
                break;
            }
            case BINARYAND: {
                this.writer.space().text("&").space();
                break;
            }
            case BINARYXOR: {
                this.writer.space().text("^").space();
                break;
            }
            case NOTEQUALS: {
                this.writer.space().text("!=").space();
                break;
            }
            case REMAINDER: {
                this.writer.space().text("%").space();
                break;
            }
            case GREATERTHAN: {
                this.writer.space().text(">").space();
                break;
            }
            case BINARYSHIFTLEFT: {
                this.writer.space().text("<<").space();
                break;
            }
            case GREATEROREQUALS: {
                this.writer.space().text(">=").space();
                break;
            }
            case BINARYSHIFTRIGHT: {
                this.writer.space().text(">>").space();
                break;
            }
            case LESSTHANOREQUALS: {
                this.writer.space().text("<=").space();
                break;
            }
            case BINARYUNSIGNEDSHIFTRIGHT: {
                this.writer.space().text(">>>").space();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operator : " + (Object)((Object)aValue.getOperator()));
            }
        }
        this.print((Value)theIncomingData.get(1));
        this.writer.text(")");
    }

    private void print(FixedBinaryExpression aValue) {
        Value theValue1 = (Value)aValue.incomingDataFlows().get(0);
        this.print(theValue1);
        switch (aValue.getOperator()) {
            case ISNONNULL: {
                this.writer.space().text("!=").space().text("null").space();
                break;
            }
            case ISZERO: {
                this.writer.space().text("==").space().text("0").space();
                break;
            }
            case ISNULL: {
                this.writer.space().text("==").space().text("null").space();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operator : " + (Object)((Object)aValue.getOperator()));
            }
        }
    }

    private void print(ByteValue aValue) {
        this.writer.text("" + aValue.getByteValue());
    }

    private void print(NewObjectExpression aValue) {
        this.writer.text(this.minifier.toClassName(aValue.getType())).text(".").text(this.minifier.toSymbol("newInstance")).text("()");
    }

    private String conversionFunctionToBytecoderForOpaqueType(BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            return null;
        }
        if (aTypeRef.isArray()) {
            throw new IllegalStateException("Type conversion to " + aTypeRef.name() + " is not supported!");
        }
        if (aTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
            return "bytecoder.toBytecoderString";
        }
        BytecodeObjectTypeRef theObjectType = (BytecodeObjectTypeRef)aTypeRef;
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(theObjectType);
        if (theLinkedClass.isOpaqueType()) {
            return null;
        }
        throw new IllegalStateException("Type conversion from " + aTypeRef.name() + " is not supported!");
    }

    private void printToJSConvertedValue(BytecodeTypeRef aTypeRef, Value aValue) {
        if (aTypeRef.isPrimitive()) {
            this.print(aValue);
        } else {
            if (aTypeRef.isArray()) {
                throw new IllegalStateException("Type conversion to " + aTypeRef.name() + " is not supported!");
            }
            if (aTypeRef.matchesExactlyTo(BytecodeObjectTypeRef.fromRuntimeClass(String.class))) {
                this.writer.text("bytecoder.toJSString(");
                this.print(aValue);
                this.writer.text(")");
            } else {
                BytecodeObjectTypeRef theObjectType = (BytecodeObjectTypeRef)aTypeRef;
                BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(theObjectType);
                if (theLinkedClass.isOpaqueType()) {
                    this.print(aValue);
                } else if (theLinkedClass.isCallback()) {
                    BytecodeResolvedMethods theMethods = theLinkedClass.resolvedMethods();
                    List availableCallbacks = theMethods.stream().filter(t -> !t.getValue().isConstructor() && !t.getValue().isClassInitializer() && !t.getProvidingClass().getClassName().name().equals(Object.class.getName())).map(BytecodeResolvedMethods.MethodEntry::getValue).collect(Collectors.toList());
                    if (availableCallbacks.size() != 1) {
                        throw new IllegalStateException("Invalid number of callback methods available for type " + theLinkedClass.getClassName().name() + ", expected 1, got " + availableCallbacks.size());
                    }
                    BytecodeMethod theCallbackMethod = (BytecodeMethod)availableCallbacks.get(0);
                    String theMethodName = this.minifier.toMethodName(theCallbackMethod.getName().stringValue(), theCallbackMethod.getSignature());
                    this.writer.text("function() {");
                    this.writer.text("var args = Array.prototype.slice.call(arguments);this").text(".").text(theMethodName).text(".call(this");
                    BytecodeTypeRef[] theArguments = theCallbackMethod.getSignature().getArguments();
                    for (int i = 0; i < theArguments.length; ++i) {
                        this.writer.text(",");
                        String theConversionFunction = this.conversionFunctionToBytecoderForOpaqueType(theArguments[i]);
                        if (theConversionFunction != null) {
                            this.writer.text(theConversionFunction).text("(").text("args[").text("" + i).text("])");
                            continue;
                        }
                        this.writer.text("args[").text("" + i).text("]");
                    }
                    this.writer.text(")");
                    this.writer.text("}.bind(");
                    this.print(aValue);
                    this.writer.text(")");
                } else {
                    throw new IllegalStateException("Type conversion to " + aTypeRef.name() + " is not supported!");
                }
            }
        }
    }

    private void print(InvokeStaticMethodExpression aValue) {
        BytecodeLinkedClass theClass = this.linkerContext.resolveClass(aValue.getClassName());
        String theMethodName = aValue.getMethodName();
        BytecodeMethodSignature theSignature = aValue.getSignature();
        if (theClass.isOpaqueType()) {
            BytecodeMethod theMethod = theClass.getBytecodeClass().methodByNameAndSignatureOrNull(theMethodName, theSignature);
            BytecodeAnnotation theImport = theMethod.getAttributes().getAnnotationByType(Import.class.getName());
            if (theImport != null) {
                String theModuleName = theImport.getElementValueByName("module").stringValue();
                String theObjectName = theImport.getElementValueByName("name").stringValue();
                if (theSignature.getReturnType().isVoid()) {
                    throw new IllegalStateException("Don't know how to handle imported method with return type void!");
                }
                String theReturnConvertFunction = this.conversionFunctionToBytecoderForOpaqueType(theSignature.getReturnType());
                if (theReturnConvertFunction != null) {
                    this.writer.text(theReturnConvertFunction).text("(");
                }
                this.writer.text("bytecoder.imports.").text(theModuleName).text(".").text(theObjectName).text("(");
                List theVariables = aValue.incomingDataFlows();
                for (int i = 0; i < theVariables.size(); ++i) {
                    if (i > 0) {
                        this.writer.text(",");
                    }
                    this.printToJSConvertedValue(theSignature.getArguments()[i], (Value)theVariables.get(i));
                }
                this.writer.text(")");
                if (theReturnConvertFunction != null) {
                    this.writer.text(")");
                }
            } else {
                this.writer.text(this.minifier.toClassName(aValue.getClassName())).text(".").text(this.minifier.toMethodName(theMethodName, theSignature)).text("(");
                List theVariables = aValue.incomingDataFlows();
                for (int i = 0; i < theVariables.size(); ++i) {
                    if (i > 0) {
                        this.writer.text(",");
                    }
                    this.print((Value)theVariables.get(i));
                }
                this.writer.text(")");
            }
        } else {
            this.writer.text(this.minifier.toClassName(aValue.getClassName())).text(".").text(this.minifier.toSymbol("init")).text("().").text(this.minifier.toMethodName(theMethodName, theSignature)).text("(");
            List theVariables = aValue.incomingDataFlows();
            for (int i = 0; i < theVariables.size(); ++i) {
                if (i > 0) {
                    this.writer.text(",");
                }
                this.print((Value)theVariables.get(i));
            }
            this.writer.text(")");
        }
    }

    private void print(DirectInvokeMethodExpression aValue) {
        BytecodeLinkedClass theTargetClass = this.linkerContext.resolveClass(aValue.getClazz());
        String theMethodName = aValue.getMethodName();
        BytecodeMethodSignature theSignature = aValue.getSignature();
        List theIncomingData = aValue.incomingDataFlows();
        Value theTarget = (Value)theIncomingData.get(0);
        List<Value> theArguments = theIncomingData.subList(1, theIncomingData.size());
        BytecodeMethod theMethod = theTargetClass.getBytecodeClass().methodByNameAndSignatureOrNull(theMethodName, theSignature);
        if (theTargetClass.isOpaqueType() && !"<init>".equals(theMethodName)) {
            this.writeOpaqueMethodInvocation(theSignature, theTarget, theArguments, theMethod);
        } else if ("<init>".equals(theMethodName)) {
            this.print(theTarget);
            this.writer.text(".").text("$").text(Integer.toString(theTargetClass.getUniqueId())).text(this.minifier.toMethodName(theMethodName, theSignature)).text("(");
            boolean first = true;
            for (Value theArgument : theArguments) {
                if (first) {
                    first = false;
                } else {
                    this.writer.text(",");
                }
                this.print(theArgument);
            }
            this.writer.text(")");
        } else {
            BytecodeResolvedMethods theResolvedMethods = theTargetClass.resolvedMethods();
            BytecodeResolvedMethods.MethodEntry theEntry = theResolvedMethods.implementingClassOf(theMethodName, theSignature);
            this.writer.text(this.minifier.toClassName(theEntry.getProvidingClass().getClassName()));
            this.writer.text(".").text(this.minifier.toMethodName(theMethodName, theSignature)).text(".call(");
            this.print(theTarget);
            for (Value theArgument : theArguments) {
                this.writer.text(",");
                this.print(theArgument);
            }
            this.writer.text(")");
        }
    }

    private void writeOpaqueMethodInvocation(BytecodeMethodSignature aMethodSignature, Value aInvocationTarget, List<Value> aMethodArguments, BytecodeMethod aMethodImplementation) {
        BytecodeAnnotation theSimpleProperty = aMethodImplementation.getAttributes().getAnnotationByType(OpaqueProperty.class.getName());
        BytecodeAnnotation theIndexedProperty = aMethodImplementation.getAttributes().getAnnotationByType(OpaqueIndexed.class.getName());
        if (theIndexedProperty != null) {
            if (aMethodSignature.getReturnType().isVoid()) {
                this.print(aInvocationTarget);
                this.writer.text("[");
                this.printToJSConvertedValue(aMethodSignature.getArguments()[0], aMethodArguments.get(0));
                this.writer.text("]=");
                this.printToJSConvertedValue(aMethodSignature.getArguments()[1], aMethodArguments.get(1));
            } else {
                String theReturnConvertFunction = this.conversionFunctionToBytecoderForOpaqueType(aMethodSignature.getReturnType());
                if (theReturnConvertFunction != null) {
                    this.writer.text(theReturnConvertFunction).text("(");
                }
                this.print(aInvocationTarget);
                this.writer.text("[");
                this.printToJSConvertedValue(aMethodSignature.getArguments()[0], aMethodArguments.get(0));
                this.writer.text("]");
                if (theReturnConvertFunction != null) {
                    this.writer.text(")");
                }
            }
        } else if (theSimpleProperty != null) {
            String theOpaquePropertyName;
            String theMethodName = aMethodImplementation.getName().stringValue();
            BytecodeAnnotation.ElementValue theValue = theSimpleProperty.getElementValueByName("value");
            if (theValue == null) {
                if (theMethodName.startsWith("get")) {
                    theOpaquePropertyName = theMethodName.substring(3);
                    theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                } else if (theMethodName.startsWith("is")) {
                    theOpaquePropertyName = theMethodName.substring(2);
                    theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                } else if (theMethodName.startsWith("set")) {
                    theOpaquePropertyName = theMethodName.substring(3);
                    theOpaquePropertyName = Character.toLowerCase(theOpaquePropertyName.charAt(0)) + theOpaquePropertyName.substring(1);
                } else {
                    theOpaquePropertyName = theMethodName;
                }
            } else {
                theOpaquePropertyName = theValue.stringValue();
            }
            if (aMethodSignature.getReturnType().isVoid()) {
                this.print(aInvocationTarget);
                this.writer.text(".").text(theOpaquePropertyName).text("=");
                this.printToJSConvertedValue(aMethodSignature.getArguments()[0], aMethodArguments.get(0));
            } else {
                String theReturnConvertFunction = this.conversionFunctionToBytecoderForOpaqueType(aMethodSignature.getReturnType());
                if (theReturnConvertFunction != null) {
                    this.writer.text(theReturnConvertFunction).text("(");
                }
                this.print(aInvocationTarget);
                this.writer.text(".").text(theOpaquePropertyName);
                if (theReturnConvertFunction != null) {
                    this.writer.text(")");
                }
            }
        } else {
            String theReturnConvertFunction = this.conversionFunctionToBytecoderForOpaqueType(aMethodSignature.getReturnType());
            if (theReturnConvertFunction != null) {
                this.writer.text(theReturnConvertFunction).text("(");
            }
            String theMethodName = aMethodImplementation.getName().stringValue();
            BytecodeAnnotation theMethod = aMethodImplementation.getAttributes().getAnnotationByType(OpaqueMethod.class.getName());
            if (theMethod != null) {
                theMethodName = theMethod.getElementValueByName("value").stringValue();
            }
            this.print(aInvocationTarget);
            this.writer.text(".").text(theMethodName).text("(");
            for (int i = 0; i < aMethodArguments.size(); ++i) {
                if (i > 0) {
                    this.writer.text(",");
                }
                this.printToJSConvertedValue(aMethodSignature.getArguments()[i], aMethodArguments.get(i));
            }
            this.writer.text(")");
            if (theReturnConvertFunction != null) {
                this.writer.text(")");
            }
        }
    }

    private void print(InvokeVirtualMethodExpression aValue) {
        BytecodeLinkedClass theInvokedClass;
        String theMethodName = aValue.getMethodName();
        BytecodeMethodSignature theSignature = aValue.getSignature();
        List theIncomingData = aValue.incomingDataFlows();
        Value theTarget = (Value)theIncomingData.get(0);
        List<Value> theArguments = theIncomingData.subList(1, theIncomingData.size());
        BytecodeTypeRef theInvokedClassName = aValue.getInvokedClass();
        if (!theInvokedClassName.isPrimitive() && !theInvokedClassName.isArray() && (theInvokedClass = this.linkerContext.resolveClass((BytecodeObjectTypeRef)theInvokedClassName)).isOpaqueType()) {
            BytecodeResolvedMethods theMethods = theInvokedClass.resolvedMethods();
            List theImplMethods = theMethods.stream().filter(t -> t.getValue().getName().stringValue().equals(theMethodName) && t.getValue().getSignature().matchesExactlyTo(theSignature)).collect(Collectors.toList());
            if (theImplMethods.size() != 1) {
                throw new IllegalStateException("Cannot find unique method " + theMethodName + " with signature " + theSignature + " in " + theInvokedClassName.name());
            }
            BytecodeLinkedClass theImplClass = ((BytecodeResolvedMethods.MethodEntry)theImplMethods.get(0)).getProvidingClass();
            BytecodeMethod theMethod = ((BytecodeResolvedMethods.MethodEntry)theImplMethods.get(0)).getValue();
            if (!theMethod.isConstructor()) {
                this.writeOpaqueMethodInvocation(theSignature, theTarget, theArguments, theMethod);
                return;
            }
        }
        if (Objects.equals(aValue.getMethodName(), "invokeWithMagicBehindTheScenes")) {
            this.writer.text("(");
        } else {
            this.print(theTarget);
            this.writer.text(".").text(this.minifier.toMethodName(theMethodName, theSignature)).text("(");
        }
        boolean first = true;
        for (Value theArgument : theArguments) {
            if (!first) {
                this.writer.text(",");
            } else {
                first = false;
            }
            this.print(theArgument);
        }
        this.writer.text(")");
    }

    private void print(NullValue aValue) {
        this.writer.text("null");
    }

    private void print(GetStaticExpression aValue) {
        this.printStaticFieldReference(aValue.getField(), this.program.getDebugInformation().debugPositionFor(aValue.getAddress()));
    }

    private void printVariableName(Variable aVariable) {
        if ("__tr".equals(aVariable.getName())) {
            this.writer.text("this");
        } else if (aVariable.isSynthetic()) {
            this.writer.text(this.minifier.toVariableName(aVariable.getName()));
        } else {
            Register r = this.allocator.registerAssignmentFor(aVariable);
            this.writer.text(this.toRegisterName(r));
        }
    }

    private void printStaticFieldReference(BytecodeFieldRefConstant aField, DebugPosition aPosition) {
        BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(aField.getClassIndex().getClassConstant().getConstant()));
        BytecodeResolvedFields theFields = theLinkedClass.resolvedFields();
        BytecodeResolvedFields.FieldEntry theField = theFields.fieldByName(aField.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
        this.writer.text(this.minifier.toClassName(theField.getProvidingClass().getClassName())).text(".").text(this.minifier.toSymbol("init")).text("().").text(this.minifier.toSymbol("__runtimeclass")).text(".").symbol(aField.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), aPosition);
    }

    private void printInstanceFieldReference(BytecodeFieldRefConstant aField) {
        this.writer.text(".").text(this.minifier.toSymbol(aField.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue()));
    }

    private void writeExpressionSourcemapInfo(Expression aExpression) {
        DebugPosition thePosition;
        BytecodeOpcodeAddress theExpressionAddress = aExpression.getAddress();
        if (theExpressionAddress != null && (thePosition = this.program.getDebugInformation().debugPositionFor(theExpressionAddress)) != null) {
            this.writer.assignPositionToSourceFile(thePosition);
        }
    }

    private void writeExpression(Expression aExpression) {
        Expression theE;
        String theComment;
        if (this.options.isDebugOutput() && (theComment = aExpression.getComment()) != null && !theComment.isEmpty()) {
            this.startLine().text("//").text(theComment).newLine();
        }
        this.writeExpressionSourcemapInfo(aExpression);
        if (aExpression instanceof ReturnExpression) {
            theE = (ReturnExpression)aExpression;
            this.startLine().text("return;").newLine();
        } else if (aExpression instanceof VariableAssignmentExpression) {
            theE = (VariableAssignmentExpression)aExpression;
            Variable theVariable = ((VariableAssignmentExpression)theE).getVariable();
            Value theValue = (Value)theE.incomingDataFlows().get(0);
            if (theValue instanceof ComputedMemoryLocationWriteExpression) {
                return;
            }
            JSPrintWriter theWriter = this.startLine();
            if (theVariable.isSynthetic()) {
                if (theVariable.resolveType().resolve() == TypeRef.Native.INT) {
                    if (!(theValue instanceof IntegerValue)) {
                        theWriter.text(this.minifier.toVariableName(theVariable.getName())).space().text("=").space().text("(");
                        this.print(theValue);
                        theWriter.text(") | 0");
                    } else {
                        theWriter.text(this.minifier.toVariableName(theVariable.getName())).space().text("=").space();
                        this.print(theValue);
                    }
                } else {
                    theWriter.text(this.minifier.toVariableName(theVariable.getName())).space().text("=").space();
                    this.print(theValue);
                }
                if (this.options.isDebugOutput()) {
                    theWriter.text("; // type is ").text(theVariable.resolveType().resolve().name()).newLine();
                } else {
                    theWriter.text(";").newLine();
                }
            } else {
                Register r = this.allocator.registerAssignmentFor(theVariable);
                if (r.getType().resolve() == TypeRef.Native.INT) {
                    if (!(theValue instanceof IntegerValue)) {
                        theWriter.text(this.toRegisterName(r)).space().text("=").space().text("(");
                        this.print(theValue);
                        theWriter.text(") | 0");
                    } else {
                        theWriter.text(this.toRegisterName(r)).space().text("=").space();
                        this.print(theValue);
                    }
                } else {
                    theWriter.text(this.toRegisterName(r)).space().text("=").space();
                    this.print(theValue);
                }
                if (this.options.isDebugOutput()) {
                    theWriter.text("; // type is ").text(r.getType().resolve().name()).newLine();
                } else {
                    theWriter.text(";").newLine();
                }
            }
        } else if (aExpression instanceof PutStaticExpression) {
            theE = (PutStaticExpression)aExpression;
            BytecodeFieldRefConstant theField = ((PutStaticExpression)theE).getField();
            Value theValue = (Value)theE.incomingDataFlows().get(0);
            this.startLine();
            this.printStaticFieldReference(theField, this.program.getDebugInformation().debugPositionFor(aExpression.getAddress()));
            this.writer.assign();
            this.print(theValue);
            this.writer.text(";").newLine();
        } else if (aExpression instanceof ReturnValueExpression) {
            theE = (ReturnValueExpression)aExpression;
            Value theValue = (Value)theE.incomingDataFlows().get(0);
            this.startLine().text("return ");
            this.print(theValue);
            this.writer.text(";").newLine();
        } else if (aExpression instanceof ThrowExpression) {
            theE = (ThrowExpression)aExpression;
            Value theValue = (Value)theE.incomingDataFlows().get(0);
            this.startLine().text("throw {exception :");
            this.print(theValue);
            this.writer.text(", stack : new Error().stack};").newLine();
        } else if (aExpression instanceof InvokeVirtualMethodExpression) {
            theE = (InvokeVirtualMethodExpression)aExpression;
            this.startLine();
            this.print((InvokeVirtualMethodExpression)theE);
            this.writer.text(";").newLine();
        } else if (aExpression instanceof DirectInvokeMethodExpression) {
            theE = (DirectInvokeMethodExpression)aExpression;
            this.startLine();
            this.print((DirectInvokeMethodExpression)theE);
            this.writer.text(";").newLine();
        } else if (aExpression instanceof InvokeStaticMethodExpression) {
            theE = (InvokeStaticMethodExpression)aExpression;
            this.startLine();
            this.print((InvokeStaticMethodExpression)theE);
            this.writer.text(";").newLine();
        } else if (aExpression instanceof PutFieldExpression) {
            theE = (PutFieldExpression)aExpression;
            List theIncomingData = theE.incomingDataFlows();
            Value theTarget = (Value)theIncomingData.get(0);
            BytecodeFieldRefConstant theField = ((PutFieldExpression)theE).getField();
            Value thevalue = (Value)theIncomingData.get(1);
            this.startLine();
            this.print(theTarget);
            this.printInstanceFieldReference(theField);
            this.writer.assign();
            this.print(thevalue);
            this.writer.text(";").newLine();
        } else if (aExpression instanceof IFExpression) {
            theE = (IFExpression)aExpression;
            this.startLine().text("if (");
            this.print((Value)theE.incomingDataFlows().get(0));
            this.writer.text(") {").newLine();
            this.withDeeperIndent().writeExpressions(((IFExpression)theE).getExpressions());
            this.startLine().text("}").newLine();
        } else {
            if (aExpression instanceof GotoExpression) {
                theE = (GotoExpression)aExpression;
                throw new IllegalStateException("JavaScript Backend does not support Goto-Expressions!");
            }
            if (aExpression instanceof ArrayStoreExpression) {
                theE = (ArrayStoreExpression)aExpression;
                List theIncomingData = theE.incomingDataFlows();
                Value theArray = (Value)theIncomingData.get(0);
                Value theIndex = (Value)theIncomingData.get(1);
                Value theValue = (Value)theIncomingData.get(2);
                this.startLine();
                this.print(theArray);
                this.printArrayIndexReference(theIndex);
                this.writer.assign();
                this.print(theValue);
                this.writer.text(";").newLine();
            } else if (aExpression instanceof CheckCastExpression) {
                theE = (CheckCastExpression)aExpression;
            } else if (aExpression instanceof TableSwitchExpression) {
                theE = (TableSwitchExpression)aExpression;
                Value theValue = (Value)theE.incomingDataFlows().get(0);
                this.startLine();
                this.writer.newLine().text("if (");
                this.print(theValue);
                this.writer.space().text("<").space().text("" + ((TableSwitchExpression)theE).getLowValue());
                this.writer.space().text("||").space();
                this.print(theValue);
                this.writer.space().text(">").space().text("" + ((TableSwitchExpression)theE).getHighValue());
                this.writer.text(") {").newLine();
                this.writeExpressions(((TableSwitchExpression)theE).getDefaultExpressions());
                this.writer.text("}").newLine();
                this.startLine().text("switch(");
                this.print(theValue);
                this.writer.space().text("-").space().text(" " + ((TableSwitchExpression)theE).getLowValue()).text(") {").newLine();
                for (Map.Entry<Long, ExpressionList> theEntry : ((TableSwitchExpression)theE).getOffsets().entrySet()) {
                    this.startLine().text(" case ").text("" + theEntry.getKey()).text(":").newLine();
                    this.withDeeperIndent().writeExpressions(theEntry.getValue());
                }
                this.writer.text("}").newLine();
                this.startLine().text("throw 'Illegal jump target!';").newLine();
            } else if (aExpression instanceof LookupSwitchExpression) {
                theE = (LookupSwitchExpression)aExpression;
                this.startLine().text("switch(");
                this.print((Value)theE.incomingDataFlows().get(0));
                this.writer.text(") {").newLine();
                for (Map.Entry<Long, ExpressionList> theEntry : ((LookupSwitchExpression)theE).getPairs().entrySet()) {
                    this.startLine().text(" case ").text("" + theEntry.getKey()).text(":").newLine();
                    this.withDeeperIndent().writeExpressions(theEntry.getValue());
                }
                this.writer.text("}").newLine();
                this.writeExpressions(((LookupSwitchExpression)theE).getDefaultExpressions());
            } else if (aExpression instanceof SetMemoryLocationExpression) {
                theE = (SetMemoryLocationExpression)aExpression;
                List theIncomingData = theE.incomingDataFlows();
                this.startLine().text("bytecoder.memory[");
                Value theValue = (Value)theIncomingData.get(0);
                this.print(theValue);
                this.writer.text("]=");
                this.print((Value)theIncomingData.get(1));
                this.writer.text(";").newLine();
            } else if (aExpression instanceof UnreachableExpression) {
                this.startLine().text("throw 'Unreachable';").newLine();
            } else if (aExpression instanceof BreakExpression) {
                BreakExpression theBreak = (BreakExpression)aExpression;
                if (theBreak.isSetLabelRequired() && this.labelRequired) {
                    this.startLine().text("__l").assign().text("" + theBreak.jumpTarget().getAddress()).text(";").newLine();
                }
                if (!theBreak.isSilent()) {
                    if (theBreak.isJumpLabelRequired()) {
                        this.startLine().text("break ").label(theBreak.blockToBreak()).text(";").newLine();
                    } else {
                        this.startLine().text("break;").newLine();
                    }
                }
            } else if (aExpression instanceof ContinueExpression) {
                ContinueExpression theContinue = (ContinueExpression)aExpression;
                if (this.labelRequired) {
                    this.startLine().text("__l").assign().text("" + theContinue.jumpTarget().getAddress()).text(";").newLine();
                }
                if (theContinue.isJumpLabelRequired()) {
                    this.startLine().text("continue ").label(theContinue.labelToReturnTo()).text(";").newLine();
                } else {
                    this.startLine().text("continue;").newLine();
                }
            } else if (aExpression instanceof SetEnumConstantsExpression) {
                SetEnumConstantsExpression theSet = (SetEnumConstantsExpression)aExpression;
                this.startLine();
                this.print((Value)theSet.incomingDataFlows().get(0));
                this.writer.print(".").text(this.minifier.toSymbol("$VALUES")).assign();
                this.print((Value)theSet.incomingDataFlows().get(1));
                this.writer.text(";").newLine();
            } else if (aExpression instanceof IFElseExpression) {
                theE = (IFElseExpression)aExpression;
                IFExpression wrapped = ((IFElseExpression)theE).getCondition();
                this.startLine().text("if (");
                this.print((Value)wrapped.incomingDataFlows().get(0));
                this.writer.text(") {").newLine();
                this.withDeeperIndent().writeExpressions(wrapped.getExpressions());
                this.startLine().text("} else {").newLine();
                this.withDeeperIndent().writeExpressions(((IFElseExpression)theE).getElsePart());
                this.startLine().text("}").newLine();
            } else if (aExpression instanceof NewObjectAndConstructExpression) {
                JSSSAWriter theDeeper = this.withDeeperIndent();
                theDeeper.print((NewObjectAndConstructExpression)aExpression);
                theDeeper.writer.text(";");
            } else {
                throw new IllegalStateException("Not implemented : " + aExpression);
            }
        }
    }

    public void writeExpressions(ExpressionList aExpressions) {
        for (Expression theExpression : aExpressions.toList()) {
            this.writeExpression(theExpression);
        }
    }

    public void printRelooped(Relooper.Block aBlock) {
        this.labelRequired = aBlock.containsMultipleBlock();
        if (this.labelRequired) {
            this.startLine().text("var __l").assign().text("null;").newLine();
        }
        this.print(aBlock);
    }

    private void print(Relooper.Block aBlock) {
        if (aBlock == null) {
            return;
        }
        if (aBlock instanceof Relooper.SimpleBlock) {
            this.print((Relooper.SimpleBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.LoopBlock) {
            this.print((Relooper.LoopBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.MultipleBlock) {
            this.print((Relooper.MultipleBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.TryBlock) {
            this.print((Relooper.TryBlock)aBlock);
            return;
        }
        if (aBlock instanceof Relooper.IFThenElseBlock) {
            this.print((Relooper.IFThenElseBlock)aBlock);
            return;
        }
        throw new IllegalStateException("Not implemented : " + aBlock);
    }

    private void print(Relooper.IFThenElseBlock aIfThenElseBlock) {
        JSSSAWriter theWriter = this;
        theWriter.writeExpressions(aIfThenElseBlock.getPrelude());
        if (aIfThenElseBlock.isLabelRequired()) {
            theWriter.startLine().label(aIfThenElseBlock.label()).colon().text("{").newLine();
            theWriter = theWriter.withDeeperIndent();
        }
        theWriter.startLine().text("if").space().text("(");
        theWriter.print(aIfThenElseBlock.getCondition());
        theWriter.writer.text(")").space().text("{").newLine();
        theWriter.withDeeperIndent().print(aIfThenElseBlock.getTrueBlock());
        theWriter.startLine().text("}").space().text("else").space().text("{").newLine();
        theWriter.withDeeperIndent().print(aIfThenElseBlock.getFalseBlock());
        theWriter.startLine().text("}").newLine();
        if (aIfThenElseBlock.isLabelRequired()) {
            this.startLine().text("}").newLine();
        }
        this.print(aIfThenElseBlock.next());
    }

    private void print(Relooper.SimpleBlock aSimpleBlock) {
        JSSSAWriter theWriter = this;
        if (aSimpleBlock.isLabelRequired()) {
            this.startLine().label(aSimpleBlock.label()).colon().text("{").newLine();
            if (this.options.isDebugOutput()) {
                this.startLine().text("// ").text(aSimpleBlock.internalLabel().getType().toString()).newLine();
            }
            theWriter = theWriter.withDeeperIndent();
        }
        theWriter.writeExpressions(aSimpleBlock.expressions());
        if (aSimpleBlock.isLabelRequired()) {
            this.startLine().text("}").newLine();
        }
        this.print(aSimpleBlock.next());
    }

    private void print(Relooper.LoopBlock aLoopBlock) {
        if (aLoopBlock.isLabelRequired()) {
            this.startLine().label(aLoopBlock.label()).colon().text("for").space().text("(;;)").space().text("{").newLine();
        } else {
            this.startLine().text("for").space().text("(;;)").space().text("{").newLine();
        }
        this.withDeeperIndent().print(aLoopBlock.inner());
        this.startLine().text("}").newLine();
        this.print(aLoopBlock.next());
    }

    private void print(Relooper.MultipleBlock aMultiple) {
        if (aMultiple.isLabelRequired()) {
            this.startLine().label(aMultiple.label()).colon().text("for(;;)").space().text("switch").space().text("(__l) {").newLine();
        } else {
            this.startLine().text("for(;;)").space().text("switch").space().text("(__l) {").newLine();
        }
        for (Relooper.Block theHandler : aMultiple.handlers()) {
            for (RegionNode theEntry : theHandler.entries()) {
                this.startLine().space().text("case ").text("" + theEntry.getStartAddress().getAddress()).colon().newLine();
                if (this.options.isDebugOutput()) {
                    this.startLine().text(" // ").text(theEntry.getType().toString()).newLine();
                }
                this.withDeeperIndent().print(theHandler);
            }
        }
        this.startLine().text("}").newLine();
        this.print(aMultiple.next());
    }

    private void print(Relooper.TryBlock aTryBlock) {
        if (aTryBlock.isLabelRequired()) {
            this.startLine().label(aTryBlock.label()).colon().text("try").space().text("{").newLine();
        } else {
            this.startLine().text("try").space().text("{").newLine();
        }
        this.withDeeperIndent().print(aTryBlock.inner());
        this.startLine().text("} catch (CURRENTEXCEPTION) {").newLine();
        JSSSAWriter theHandler = this.withDeeperIndent();
        Relooper.Block theFinally = aTryBlock.getFinallyBlock();
        JSSSAWriter theGuard = theHandler;
        if (theFinally != null) {
            theGuard.startLine().text("try {").newLine();
            theGuard = theHandler.withDeeperIndent();
        }
        for (Relooper.TryBlock.CatchBlock theCatch : aTryBlock.getCatchBlocks()) {
            theGuard.startLine().text("if (");
            boolean first = true;
            for (BytecodeUtf8Constant theInstanceCheck : theCatch.getCaughtExceptions()) {
                if (!first) {
                    theGuard.writer.space().text("||").space();
                }
                BytecodeLinkedClass theLinkedClass = this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theInstanceCheck));
                theGuard.writer.text("CURRENTEXCEPTION.exception.constructor.").text(this.minifier.toSymbol("__runtimeclass")).text(".iof(").text(this.minifier.toClassName(theLinkedClass.getClassName())).text(")");
                first = false;
            }
            theGuard.writer.text(") {").newLine();
            theGuard.withDeeperIndent().print(theCatch.getHandler());
            theGuard.startLine().text("}").newLine();
        }
        theGuard.startLine().text("throw CURRENTEXCEPTION;").newLine();
        if (theFinally != null) {
            theHandler.startLine().text("} catch (CURRENTEXCEPTION) {").newLine();
            JSSSAWriter theFinallyDeeper = theHandler.withDeeperIndent();
            theFinallyDeeper.print(theFinally);
            theFinallyDeeper.startLine().text("throw CURRENTEXCEPTION;").newLine();
            theHandler.startLine().text("}").newLine();
        }
        this.startLine().text("}").newLine();
        this.print(aTryBlock.next());
    }

    public void printStackified(Stackifier stackifier) {
        final Stack<JSSSAWriter> writerStack = new Stack<JSSSAWriter>();
        writerStack.push(this);
        Stackifier.StackifierStructuredControlFlowWriter writer = new Stackifier.StackifierStructuredControlFlowWriter(stackifier){

            @Override
            public void beginLoopFor(Block<RegionNode> block) {
                super.beginLoopFor(block);
                JSSSAWriter current = (JSSSAWriter)writerStack.peek();
                current.startLine().label(block.getLabel()).text(":").space().text("for(;;)").space().text("{").newLine();
                JSSSAWriter newLoopBlock = current.withDeeperIndent();
                writerStack.push(newLoopBlock);
            }

            @Override
            public void beginBlockFor(Block<RegionNode> block) {
                super.beginBlockFor(block);
                JSSSAWriter current = (JSSSAWriter)writerStack.peek();
                current.startLine().label(block.getLabel()).text(":").space().text("{").newLine();
                JSSSAWriter newSimpleBlock = current.withDeeperIndent();
                writerStack.push(newSimpleBlock);
            }

            @Override
            public void writeExpression(RegionNode currentNode, Expression e) {
                ((JSSSAWriter)writerStack.peek()).writeExpression(e);
            }

            @Override
            public void closeBlock() {
                writerStack.pop();
                ((JSSSAWriter)writerStack.peek()).startLine().text("}").newLine();
                super.closeBlock();
            }
        };
        stackifier.writeStructuredControlFlow(writer);
    }

    static interface IDResolver {
        public String methodHandleDelegateFor(MethodHandleExpression var1);
    }
}

