/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.js;

import de.mirkosertic.bytecoder.backend.SourceMapWriter;
import de.mirkosertic.bytecoder.backend.js.JSMinifier;
import de.mirkosertic.bytecoder.ssa.DebugPosition;
import de.mirkosertic.bytecoder.ssa.Label;
import java.io.IOException;
import java.io.Writer;

public class JSPrintWriter {
    private final JSMinifier minifier;
    private final Writer out;
    private int lineCounter;
    private int columnCounter;
    private final SourceMapWriter sourceMapWriter;

    public JSPrintWriter(Writer out, JSMinifier minifier, SourceMapWriter sourceMapWriter) {
        this.out = out;
        this.minifier = minifier;
        this.lineCounter = 0;
        this.columnCounter = 0;
        this.sourceMapWriter = sourceMapWriter;
    }

    public JSPrintWriter print(String aText) {
        try {
            this.out.write(aText);
            this.columnCounter += aText.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JSPrintWriter tab() {
        this.print(this.minifier.tab());
        return this;
    }

    public JSPrintWriter tab(int num) {
        for (int i = 0; i < num; ++i) {
            this.print(this.minifier.tab());
        }
        return this;
    }

    public JSPrintWriter space() {
        this.print(this.minifier.space());
        return this;
    }

    public JSPrintWriter text(String aText) {
        this.print(aText);
        return this;
    }

    public JSPrintWriter symbol(String aSymbol, DebugPosition aPositionl) {
        this.sourceMapWriter.assignName(this.lineCounter, this.columnCounter, aSymbol, aPositionl);
        this.print(this.minifier.toSymbol(aSymbol));
        return this;
    }

    public void assignPositionToSourceFile(DebugPosition aPosition) {
        this.sourceMapWriter.assignDebugPosition(this.lineCounter, this.columnCounter, aPosition);
    }

    public void assignSymbolToSourceFile(String aSymbol, DebugPosition aPosition) {
        this.sourceMapWriter.assignName(this.lineCounter, this.columnCounter, aSymbol, aPosition);
    }

    public JSPrintWriter newLine() {
        String theNewLine = this.minifier.newLine();
        if (theNewLine.length() != 0) {
            this.print(theNewLine);
            ++this.lineCounter;
            this.columnCounter = 0;
        }
        return this;
    }

    public JSPrintWriter colon() {
        return this.space().text(":").space();
    }

    public JSPrintWriter assign() {
        return this.space().text("=").space();
    }

    public JSPrintWriter label(Label label) {
        return this.text("$").text(this.minifier.toSymbol(label.name()));
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

