/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.js;

import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.Minifier;
import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import java.util.HashMap;
import java.util.Map;

public class JSMinifier
implements Minifier {
    private final CompileOptions options;
    private final Map<String, String> minifyTable;

    public JSMinifier(CompileOptions options) {
        this.options = options;
        this.minifyTable = new HashMap<String, String>();
    }

    public String toSymbol(String aValue) {
        return this.minifyOrNot(aValue);
    }

    private String minifyOrNot(String aValue) {
        if (this.options.isMinify() && aValue.length() > 3) {
            String theMin = this.minifyTable.get(aValue);
            if (theMin != null) {
                return theMin;
            }
            String theKey = "s" + this.minifyTable.size();
            this.minifyTable.put(aValue, theKey);
            return theKey;
        }
        return aValue;
    }

    @Override
    public String toClassName(BytecodeObjectTypeRef aTypeRef) {
        if (aTypeRef.name().endsWith(";")) {
            return this.toClassName(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
        }
        return this.minifyOrNot(this.toClassNameInternal(aTypeRef.name()));
    }

    @Override
    public String toClassName(BytecodeClassinfoConstant aTypeRef) {
        return this.minifyOrNot(this.toClassNameInternal(aTypeRef.getConstant().stringValue().replace("/", ".")));
    }

    private String toClassNameInternal(String aClassName) {
        int p = aClassName.lastIndexOf(".");
        String theSimpleName = aClassName.substring(p + 1);
        String thePackageName = aClassName.substring(0, p);
        StringBuilder theResult = new StringBuilder();
        while (thePackageName.length() > 0) {
            theResult.append(Character.toLowerCase(thePackageName.charAt(0)));
            int j = thePackageName.indexOf(".");
            if (j >= 0) {
                thePackageName = thePackageName.substring(j + 1);
                continue;
            }
            thePackageName = "";
        }
        return theResult.append(theSimpleName).toString();
    }

    @Override
    public String toMethodName(String aMethodName, BytecodeMethodSignature aSignature) {
        String theName = this.typeRefToString(aSignature.getReturnType());
        theName = theName + aMethodName.replace("<", "").replace(">", "");
        for (BytecodeTypeRef theTypeRef : aSignature.getArguments()) {
            theName = theName + this.typeRefToString(theTypeRef);
        }
        return this.minifyOrNot(theName);
    }

    @Override
    public String typeRefToString(BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isPrimitive()) {
            BytecodePrimitiveTypeRef thePrimitive = (BytecodePrimitiveTypeRef)aTypeRef;
            return this.minifyOrNot(thePrimitive.name());
        }
        if (aTypeRef.isArray()) {
            BytecodeArrayTypeRef theRef = (BytecodeArrayTypeRef)aTypeRef;
            return this.minifyOrNot("A" + theRef.getDepth() + this.typeRefToString(theRef.getType()));
        }
        BytecodeObjectTypeRef theObjectRef = (BytecodeObjectTypeRef)aTypeRef;
        return this.toClassName(theObjectRef);
    }

    @Override
    public String toVariableName(String aVariable) {
        return this.minifyOrNot(aVariable);
    }

    public String tab() {
        if (this.options.isMinify()) {
            return "";
        }
        return "    ";
    }

    public String space() {
        if (this.options.isMinify()) {
            return "";
        }
        return " ";
    }

    public String newLine() {
        if (this.options.isMinify()) {
            return "";
        }
        return System.lineSeparator();
    }
}

