/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend;

import java.util.ArrayList;

public class VLQ {
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    private VLQ() {
    }

    public static int[] decode(String aData) {
        ArrayList<Integer> theResult = new ArrayList<Integer>();
        int theShift = 0;
        int theValue = 0;
        for (int i = 0; i < aData.length(); ++i) {
            int theInteger = CHARACTERS.indexOf(aData.charAt(i));
            int hasContinuationBit = theInteger & 0x20;
            theValue += (theInteger &= 0x1F) << theShift;
            if (hasContinuationBit > 0) {
                theShift += 5;
                continue;
            }
            int shouldNegate = theValue & 1;
            theResult.add(shouldNegate > 0 ? -theValue : (theValue >>= 1));
            theShift = 0;
            theValue = 0;
        }
        int[] theResultArray = new int[theResult.size()];
        for (int i = 0; i < theResult.size(); ++i) {
            theResultArray[i] = (Integer)theResult.get(i);
        }
        return theResultArray;
    }

    public static String encode(int[] aData) {
        StringBuilder theResult = new StringBuilder();
        for (int i = 0; i < aData.length; ++i) {
            theResult.append(VLQ.encodeInteger(aData[i]));
        }
        return theResult.toString();
    }

    private static String encodeInteger(int aNumber) {
        StringBuilder theResult = new StringBuilder();
        aNumber = aNumber < 0 ? -aNumber << 1 | 1 : (aNumber <<= 1);
        do {
            int theClamped = aNumber & 0x1F;
            if ((aNumber >>= 5) > 0) {
                theClamped |= 0x20;
            }
            theResult.append(CHARACTERS.charAt(theClamped));
        } while (aNumber > 0);
        return theResult.toString();
    }
}

