/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.mirkosertic.bytecoder.backend.VLQ;
import de.mirkosertic.bytecoder.ssa.DebugPosition;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class SourceMapWriter {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final List<String> sources = new ArrayList<String>();
    private final List<String> names = new ArrayList<String>();
    private final StringBuilder mappings = new StringBuilder();
    private int currentLine = 1;
    private boolean firstSegment = true;
    private int fieldCurrentColumn = -1;
    private int fieldSourceIndex = -1;
    private int fieldOriginalLine = -1;
    private int fieldOriginalColumn = -1;
    private int fieldNamesIndex = -1;

    private void seekToLine(int aLineCounter) {
        while (this.currentLine < aLineCounter) {
            ++this.currentLine;
            this.fieldCurrentColumn = -1;
            this.mappings.append(";");
        }
    }

    private void addSegment(int[] aData) {
        if (this.firstSegment) {
            this.firstSegment = false;
        } else {
            this.mappings.append(",");
        }
        this.mappings.append(VLQ.encode(aData));
    }

    public void assignName(int aLineCounter, int aColumnCounter, String aSymbol, DebugPosition aPosition) {
        if (aPosition != null) {
            String theFileName = aPosition.getFileName();
            if (!this.sources.contains(theFileName)) {
                this.sources.add(theFileName);
            }
            if (!this.names.contains(aSymbol)) {
                this.names.add(aSymbol);
            }
            this.seekToLine(aLineCounter);
            int theSourcesIndex = this.sources.indexOf(theFileName);
            int theNamesIndex = this.names.indexOf(aSymbol);
            int theColumn = this.fieldCurrentColumn == -1 ? aColumnCounter : aColumnCounter - this.fieldCurrentColumn;
            int theSources = this.fieldSourceIndex == -1 ? theSourcesIndex : theSourcesIndex - this.fieldSourceIndex;
            int theOriginalLine = this.fieldOriginalLine == -1 ? aPosition.getLineNumber() : aPosition.getLineNumber() - this.fieldOriginalLine;
            boolean theOriginalColumn = false;
            int theOriginalSymbol = this.fieldNamesIndex == -1 ? theNamesIndex : theNamesIndex - this.fieldNamesIndex;
            this.addSegment(new int[]{theColumn, theSources, theOriginalLine, 0, theOriginalSymbol});
            this.fieldCurrentColumn = aColumnCounter;
            this.fieldSourceIndex = theSourcesIndex;
            this.fieldOriginalLine = aPosition.getLineNumber();
            this.fieldOriginalColumn = 0;
            this.fieldNamesIndex = theNamesIndex;
        }
    }

    public void assignDebugPosition(int aLineCounter, int aColumnCounter, DebugPosition aPosition) {
        if (aPosition != null) {
            String theFileName = aPosition.getFileName();
            if (!this.sources.contains(theFileName)) {
                this.sources.add(theFileName);
            }
            this.seekToLine(aLineCounter);
            int theSourcesIndex = this.sources.indexOf(theFileName);
            int theColumn = this.fieldCurrentColumn == -1 ? aColumnCounter : aColumnCounter - this.fieldCurrentColumn;
            int theSources = this.fieldSourceIndex == -1 ? theSourcesIndex : theSourcesIndex - this.fieldSourceIndex;
            int theOriginalLine = this.fieldOriginalLine == -1 ? aPosition.getLineNumber() : aPosition.getLineNumber() - this.fieldOriginalLine;
            boolean theOriginalColumn = false;
            this.addSegment(new int[]{theColumn, theSources, theOriginalLine, 0});
            this.fieldCurrentColumn = aColumnCounter;
            this.fieldSourceIndex = theSourcesIndex;
            this.fieldOriginalLine = aPosition.getLineNumber();
            this.fieldOriginalColumn = 0;
        }
    }

    public String toSourceMap(String aJSFileName) {
        SourceMap theResult = new SourceMap();
        theResult.version = 3;
        theResult.file = aJSFileName;
        theResult.sourceRoot = "";
        theResult.sources = this.sources;
        theResult.names = this.names;
        theResult.mappings = this.mappings.toString();
        try {
            StringWriter theOut = new StringWriter();
            MAPPER.writeValue((Writer)theOut, (Object)theResult);
            return theOut.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class SourceMap {
        private int version;
        private String file;
        private String sourceRoot;
        private List<String> names;
        private List<String> sources;
        private String mappings;

        public int getVersion() {
            return this.version;
        }

        public String getFile() {
            return this.file;
        }

        public String getSourceRoot() {
            return this.sourceRoot;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<String> getSources() {
            return this.sources;
        }

        public String getMappings() {
            return this.mappings;
        }
    }
}

