/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend;

import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class NativeMemoryLayouter {
    public static final int CLASS_HEADER_SIZE = 24;
    public static final int OBJECT_HEADER_SIZE = 8;
    private final Map<BytecodeObjectTypeRef, BytecodeResolvedFields> fields = new HashMap<BytecodeObjectTypeRef, BytecodeResolvedFields>();
    private final int fieldSize;

    public NativeMemoryLayouter(BytecodeLinkerContext aLinkerContext, int aFieldSize) {
        this.fieldSize = aFieldSize;
        aLinkerContext.linkedClasses().forEach(aEntry -> this.registerClass((BytecodeLinkedClass)aEntry.targetNode()));
    }

    private void registerClass(BytecodeLinkedClass aClass) {
        this.fields.put(aClass.getClassName(), aClass.resolvedFields());
    }

    public MemoryLayout layoutFor(final BytecodeObjectTypeRef aType) {
        if (!this.fields.containsKey(aType)) {
            throw new IllegalArgumentException("No field information found for " + aType.name());
        }
        return new MemoryLayout(){

            @Override
            public int instanceSize() {
                BytecodeResolvedFields theInstanceFields = (BytecodeResolvedFields)NativeMemoryLayouter.this.fields.get(aType);
                return 8 + NativeMemoryLayouter.this.fieldSize * (int)theInstanceFields.streamForInstanceFields().count();
            }

            @Override
            public int classSize() {
                BytecodeResolvedFields theClassFields = (BytecodeResolvedFields)NativeMemoryLayouter.this.fields.get(aType);
                return 24 + NativeMemoryLayouter.this.fieldSize * (int)theClassFields.streamForStaticFields().count();
            }

            @Override
            public int offsetForInstanceMember(String aName) {
                BytecodeResolvedFields theInstanceFields = (BytecodeResolvedFields)NativeMemoryLayouter.this.fields.get(aType);
                List theFields = theInstanceFields.streamForInstanceFields().collect(Collectors.toList());
                int theOffset = 8;
                for (BytecodeResolvedFields.FieldEntry theField : theFields) {
                    if (Objects.equals(aName, theField.getValue().getName().stringValue())) {
                        return theOffset;
                    }
                    theOffset += NativeMemoryLayouter.this.fieldSize;
                }
                throw new IllegalArgumentException("Member field " + aName + " not found for type " + aType.name());
            }

            @Override
            public int offsetForClassMember(String aName) {
                BytecodeResolvedFields theInstanceFields = (BytecodeResolvedFields)NativeMemoryLayouter.this.fields.get(aType);
                List theFields = theInstanceFields.streamForStaticFields().collect(Collectors.toList());
                int theOffset = 24;
                for (BytecodeResolvedFields.FieldEntry theField : theFields) {
                    if (Objects.equals(aName, theField.getValue().getName().stringValue())) {
                        return theOffset;
                    }
                    theOffset += NativeMemoryLayouter.this.fieldSize;
                }
                throw new IllegalArgumentException("Static field " + aName + " not found for type " + aType.name());
            }
        };
    }

    public static interface MemoryLayout {
        public int offsetForInstanceMember(String var1);

        public int offsetForClassMember(String var1);

        public int instanceSize();

        public int classSize();
    }
}

