/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend;

import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.ssa.Program;
import java.io.PrintWriter;

public class IndentSSAWriter<T extends PrintWriter> {
    protected final Program program;
    protected final BytecodeLinkerContext linkerContext;
    protected final String indent;
    protected final T writer;
    private boolean newLine;
    protected final CompileOptions options;

    public IndentSSAWriter(CompileOptions aOptions, Program aProgram, String aIndent, T aWriter, BytecodeLinkerContext aLinkerContext) {
        this.writer = aWriter;
        this.indent = aIndent;
        this.program = aProgram;
        this.linkerContext = aLinkerContext;
        this.newLine = true;
        this.options = aOptions;
    }

    private void checkNewLine() {
        if (this.newLine) {
            ((PrintWriter)this.writer).print(this.indent);
            this.newLine = false;
        }
    }

    public void print(String s) {
        this.checkNewLine();
        ((PrintWriter)this.writer).print(s);
    }

    public void println() {
        this.checkNewLine();
        ((PrintWriter)this.writer).println();
        this.newLine = true;
    }

    public void println(String s) {
        this.checkNewLine();
        ((PrintWriter)this.writer).println(s);
        this.newLine = true;
    }

    public void print(byte b) {
        this.checkNewLine();
        ((PrintWriter)this.writer).print(b);
    }

    public void print(short s) {
        this.checkNewLine();
        ((PrintWriter)this.writer).print(s);
    }

    public void print(int i) {
        this.checkNewLine();
        ((PrintWriter)this.writer).print(i);
    }

    public void print(long l) {
        this.checkNewLine();
        ((PrintWriter)this.writer).print(l);
    }

    public void print(float f) {
        this.checkNewLine();
        ((PrintWriter)this.writer).print(f);
    }

    public void print(double d) {
        this.checkNewLine();
        ((PrintWriter)this.writer).print(d);
    }
}

