/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend;

import de.mirkosertic.bytecoder.api.ClassLibProvider;
import de.mirkosertic.bytecoder.backend.CompileBackend;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.CompileResult;
import de.mirkosertic.bytecoder.backend.js.JSSSACompilerBackend;
import de.mirkosertic.bytecoder.backend.llvm.LLVMCompilerBackend;
import de.mirkosertic.bytecoder.backend.wasm.WASMSSAASTCompilerBackend;
import de.mirkosertic.bytecoder.classlib.VM;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeLoader;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.ssa.NaiveProgramGenerator;
import java.io.FileDescriptor;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class CompileTarget {
    private final CompileBackend backend;
    private final BytecodeLoader bytecodeLoader;
    private final ClassLoader classLoader;

    public CompileTarget(ClassLoader aClassLoader, BackendType aType) {
        this.backend = aType.createBackend();
        this.bytecodeLoader = new BytecodeLoader(aClassLoader);
        this.classLoader = aClassLoader;
    }

    public CompileResult compile(CompileOptions aOptions, Class aClass, String aMethodName, BytecodeMethodSignature aSignature) {
        BytecodeLinkerContext theLinkerContext = new BytecodeLinkerContext(this.bytecodeLoader, aOptions.getLogger());
        BytecodeLinkedClass theClassLinkedCass = theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Class.class));
        theClassLinkedCass.resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
        BytecodeLinkedClass theCallsite = theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(CallSite.class));
        theCallsite.resolveVirtualMethod("invokeExact", new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(Object.class), new BytecodeTypeRef[]{new BytecodeArrayTypeRef(BytecodeObjectTypeRef.fromRuntimeClass(Object.class), 1)}));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(VM.LambdaStaticImplCallsite.class)).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(String.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(VM.LambdaConstructorRefCallsite.class)).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(VM.InvokeInterfaceCallsite.class)).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(VM.InvokeVirtualCallsite.class)).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(VM.InvokeSpecialCallsite.class)).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(new BytecodeUtf8Constant("sun/nio/cs/UTF_8"))).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(new BytecodeUtf8Constant("sun/nio/cs/UTF_16"))).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(new BytecodeUtf8Constant("sun/nio/cs/ISO_8859_1"))).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(new BytecodeUtf8Constant("sun/nio/cs/US_ASCII"))).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(new BytecodeUtf8Constant("java/lang/CharacterDataLatin1"))).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
        if (aOptions.getAdditionalClassesToLink() != null) {
            for (String theClassname : aOptions.getAdditionalClassesToLink()) {
                theLinkerContext.resolveClass(new BytecodeObjectTypeRef(theClassname)).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]));
            }
        }
        BytecodeObjectTypeRef theTypeRef = BytecodeObjectTypeRef.fromRuntimeClass(aClass);
        theLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(FileDescriptor.class)).resolveStaticMethod("initDefaultFileHandles", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT, BytecodePrimitiveTypeRef.INT}));
        BytecodeLinkedClass theClass = theLinkerContext.resolveClass(theTypeRef);
        BytecodeMethod theMethod = theClass.getBytecodeClass().methodByNameAndSignatureOrNull(aMethodName, aSignature);
        if (theMethod == null) {
            throw new IllegalStateException("No method named " + aMethodName + " with signature " + aSignature + "found in " + theClass.getClassName().name());
        }
        if (theMethod.getAccessFlags().isStatic()) {
            theClass.resolveStaticMethod(aMethodName, aSignature);
        } else {
            theClass.resolveVirtualMethod(aMethodName, aSignature);
        }
        aOptions.getLogger().info("Resolving abstract method hierarchy", new Object[0]);
        theLinkerContext.resolveAbstractMethodsInSubclasses();
        boolean somethingAdded = true;
        HashSet<BytecodeLinkedClass> theAlreadySeen = new HashSet<BytecodeLinkedClass>();
        while (somethingAdded) {
            somethingAdded = false;
            List theLinkedClasses = theLinkerContext.linkedClasses().map(Edge::targetNode).collect(Collectors.toList());
            for (BytecodeLinkedClass theLinkedClass : theLinkedClasses) {
                if (!theLinkedClass.isCallback() || !theAlreadySeen.add(theLinkedClass)) continue;
                somethingAdded = true;
                BytecodeClass theBytecodeClass = theLinkedClass.getBytecodeClass();
                aOptions.getLogger().info("Resolving callback {}", new Object[]{theBytecodeClass.getThisInfo().getConstant().stringValue()});
                for (BytecodeMethod theCallbackMethod : theBytecodeClass.getMethods()) {
                    if (theCallbackMethod.isConstructor() || theCallbackMethod.isClassInitializer()) continue;
                    aOptions.getLogger().info("Resolving callback method {} {}", new Object[]{theCallbackMethod.getName().stringValue(), theCallbackMethod.getSignature().toString()});
                    theLinkedClass.resolveVirtualMethod(theCallbackMethod.getName().stringValue(), theCallbackMethod.getSignature());
                }
            }
            aOptions.getLogger().info("Resolving abstract method hierarchy", new Object[0]);
            theLinkerContext.resolveAbstractMethodsInSubclasses();
        }
        Object theResult = this.backend.generateCodeFor(aOptions, theLinkerContext, aClass, aMethodName, aSignature);
        theLinkerContext.getStatistics().writeTo(aOptions.getLogger());
        ArrayList resourcesToInclude = new ArrayList();
        for (ClassLibProvider provider : ClassLibProvider.availableProviders()) {
            Collections.addAll(resourcesToInclude, provider.additionalResources());
        }
        Collections.addAll(resourcesToInclude, aOptions.getAdditionalResources());
        for (String theResource : resourcesToInclude) {
            URL theUrl = this.classLoader.getResource(theResource);
            if (theUrl != null) {
                aOptions.getLogger().info("Including resource {}", new Object[]{theResource});
                ((CompileResult)theResult).add(new CompileResult.URLContent(theResource, theUrl));
                continue;
            }
            aOptions.getLogger().warn("Cannot find resource {}", new Object[]{theResource});
        }
        return theResult;
    }

    public BytecodeMethodSignature toMethodSignature(Method aMethod) {
        return this.bytecodeLoader.getSignatureParser().toMethodSignature(aMethod);
    }

    public static enum BackendType {
        js{

            @Override
            public CompileBackend createBackend() {
                return new JSSSACompilerBackend(NaiveProgramGenerator.FACTORY);
            }
        }
        ,
        wasm{

            @Override
            public CompileBackend createBackend() {
                return new WASMSSAASTCompilerBackend(NaiveProgramGenerator.FACTORY);
            }
        }
        ,
        wasm_llvm{

            @Override
            public CompileBackend createBackend() {
                return new LLVMCompilerBackend(NaiveProgramGenerator.FACTORY);
            }
        };


        public abstract CompileBackend createBackend();
    }
}

