/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.WriterOutputStream;

public abstract class CompileResult<T> {
    private final List<Content> content = new ArrayList<Content>();

    public void add(Content aContent) {
        this.content.add(aContent);
    }

    public Content[] getContent() {
        return this.content.toArray(new Content[0]);
    }

    public static class BinaryContent
    implements Content {
        private final String fileName;
        private final byte[] data;

        public BinaryContent(String fileName, byte[] data) {
            this.fileName = fileName;
            this.data = data;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void writeTo(OutputStream stream) throws IOException {
            stream.write(this.data);
        }

        @Override
        public String asString() {
            throw new IllegalStateException("Not implemented!");
        }
    }

    public static class StringContent
    implements Content {
        private final String fileName;
        private final String data;

        public StringContent(String fileName, String data) {
            this.fileName = fileName;
            this.data = data;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void writeTo(OutputStream stream) {
            try (PrintStream ps = new PrintStream(stream);){
                ps.print(this.data);
            }
        }
    }

    public static class URLContent
    implements Content {
        private final String fileName;
        private final URL url;

        public URLContent(String fileName, URL url) {
            this.fileName = fileName;
            this.url = url;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void writeTo(OutputStream stream) throws IOException {
            try (InputStream is = this.url.openStream();){
                IOUtils.copy((InputStream)is, (OutputStream)stream);
            }
        }

        @Override
        public String asString() {
            throw new IllegalStateException("Not implemented!");
        }
    }

    public static interface Content {
        public String getFileName();

        public void writeTo(OutputStream var1) throws IOException;

        default public String asString() throws IOException {
            StringWriter strData = new StringWriter();
            try (WriterOutputStream wos = new WriterOutputStream((Writer)strData, Charset.defaultCharset());){
                this.writeTo((OutputStream)wos);
            }
            return strData.toString();
        }
    }
}

