/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend;

import de.mirkosertic.bytecoder.allocator.Allocator;
import de.mirkosertic.bytecoder.api.Logger;
import de.mirkosertic.bytecoder.backend.LLVMOptimizationLevel;
import de.mirkosertic.bytecoder.optimizer.Optimizer;

public class CompileOptions {
    private final Logger logger;
    private final boolean debugOutput;
    private final Optimizer optimizer;
    private final boolean enableExceptions;
    private final String filenamePrefix;
    private final int wasmMinimumPageSize;
    private final int wasmMaximumPageSize;
    private final boolean minify;
    private final boolean preferStackifier;
    private final Allocator allocator;
    private final String[] additionalClassesToLink;
    private final String[] additionalResources;
    private final LLVMOptimizationLevel llvmOptimizationLevel;

    public CompileOptions(Logger aLogger, boolean aDebugOutput, Optimizer aOptimizer, boolean aEnableExceptions, String aFilenamePrefix, int aWasmMinimumPageSize, int aWasmMaximumPageSize, boolean aMinify, boolean aPreferStackifier, Allocator aAllocator, String[] aAdditionalClassesToLink, String[] aAdditionalResources, LLVMOptimizationLevel aLlvmOptimizationLevel) {
        this.logger = aLogger;
        this.debugOutput = aDebugOutput;
        this.optimizer = aOptimizer;
        this.enableExceptions = aEnableExceptions;
        this.filenamePrefix = aFilenamePrefix;
        this.wasmMinimumPageSize = aWasmMinimumPageSize;
        this.wasmMaximumPageSize = aWasmMaximumPageSize;
        this.minify = aMinify;
        this.preferStackifier = aPreferStackifier;
        this.allocator = aAllocator;
        this.additionalClassesToLink = aAdditionalClassesToLink;
        this.additionalResources = aAdditionalResources;
        this.llvmOptimizationLevel = aLlvmOptimizationLevel;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isDebugOutput() {
        return this.debugOutput && !this.minify;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public boolean isEnableExceptions() {
        return this.enableExceptions;
    }

    public String getFilenamePrefix() {
        return this.filenamePrefix;
    }

    public int getWasmMinimumPageSize() {
        return this.wasmMinimumPageSize;
    }

    public int getWasmMaximumPageSize() {
        return this.wasmMaximumPageSize;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public boolean isPreferStackifier() {
        return this.preferStackifier;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }

    public String[] getAdditionalClassesToLink() {
        return this.additionalClassesToLink;
    }

    public String[] getAdditionalResources() {
        return this.additionalResources;
    }

    public LLVMOptimizationLevel getLlvmOptimizationLevel() {
        return this.llvmOptimizationLevel;
    }
}

