/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.allocator;

import de.mirkosertic.bytecoder.allocator.AbstractAllocator;
import de.mirkosertic.bytecoder.allocator.Register;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class LinearRegisterAllocator
extends AbstractAllocator {
    public LinearRegisterAllocator(Program aProgram, Function<Variable, TypeRef> aTypeConverter, BytecodeLinkerContext aLinkerContext) {
        super(aTypeConverter, aLinkerContext);
        List<Variable> theVariables = this.computeSSAReadyVariablesFor(aProgram);
        HashMap<Long, List> theDefinitionPointsToDefition = new HashMap<Long, List>();
        HashSet<Long> foundDefinitionPoints = new HashSet<Long>();
        for (Variable v : theVariables) {
            if (v.isSynthetic()) continue;
            long theDefinition = v.liveRange().getDefinedAt();
            foundDefinitionPoints.add(theDefinition);
            List theDefList = theDefinitionPointsToDefition.computeIfAbsent(theDefinition, k -> new ArrayList());
            theDefList.add(v);
        }
        ArrayList theDefinitionPoints = new ArrayList(foundDefinitionPoints);
        Collections.sort(theDefinitionPoints);
        long registerCount = 0L;
        ArrayList<Variable> currentlyActive = new ArrayList<Variable>();
        Iterator iterator = theDefinitionPoints.iterator();
        while (iterator.hasNext()) {
            long theDefinition = (Long)iterator.next();
            ArrayList<Variable> theNoLongerActive = new ArrayList<Variable>();
            for (Variable v : currentlyActive) {
                if (v.liveRange().getLastUsedAt() >= theDefinition) continue;
                theNoLongerActive.add(v);
            }
            currentlyActive.removeAll(theNoLongerActive);
            List activeFromHere = (List)theDefinitionPointsToDefition.get(theDefinition);
            for (Variable v : activeFromHere) {
                TypeRef theType = aTypeConverter.apply(v);
                List theKnownRegistersOfThisType = (List)this.knownRegisters.get(theType);
                if (theKnownRegistersOfThisType != null) {
                    ArrayList theAvailableRegisters = new ArrayList(theKnownRegistersOfThisType);
                    for (Variable a : currentlyActive) {
                        TypeRef theOtherType = aTypeConverter.apply(a);
                        if (theOtherType != theType) continue;
                        theAvailableRegisters.remove(this.registerAssignments.get(a));
                    }
                    if (theAvailableRegisters.isEmpty()) {
                        Register theNewRegister = new Register(registerCount++, theType);
                        ((List)this.knownRegisters.get(theType)).add(theNewRegister);
                        this.registerAssignments.put(v, theNewRegister);
                    } else {
                        this.registerAssignments.put(v, theAvailableRegisters.iterator().next());
                    }
                } else {
                    Register theNewRegister = new Register(registerCount++, theType);
                    ArrayList<Register> theRegisterList = new ArrayList<Register>();
                    theRegisterList.add(theNewRegister);
                    this.knownRegisters.put(theType, theRegisterList);
                    this.registerAssignments.put(v, theNewRegister);
                }
                currentlyActive.add(v);
            }
        }
    }
}

