/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.allocator;

import de.mirkosertic.bytecoder.allocator.Register;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.graph.EdgeType;
import de.mirkosertic.bytecoder.graph.Node;
import de.mirkosertic.bytecoder.graph.Partitioning;
import de.mirkosertic.bytecoder.ssa.PHIValue;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractAllocator {
    protected final Map<Variable, Register> registerAssignments = new HashMap<Variable, Register>();
    protected final Map<TypeRef, List<Register>> knownRegisters = new HashMap<TypeRef, List<Register>>();
    protected final Function<Variable, TypeRef> typeConverter;
    protected final Map<PHIValue, Variable> phis;
    protected final Map<Variable, Variable> aliases;
    protected final BytecodeLinkerContext linkerContext;

    public AbstractAllocator(Function<Variable, TypeRef> aTypeConverter, BytecodeLinkerContext aLinkerContext) {
        this.typeConverter = aTypeConverter;
        this.phis = new HashMap<PHIValue, Variable>();
        this.aliases = new HashMap<Variable, Variable>();
        this.linkerContext = aLinkerContext;
    }

    public List<Register> assignedRegister() {
        ArrayList<Register> theList = new ArrayList<Register>(new HashSet<Register>(this.registerAssignments.values()));
        theList.sort(Comparator.comparingLong(Register::getNumber));
        return theList;
    }

    public Set<TypeRef> usedRegisterTypes() {
        return this.knownRegisters.keySet();
    }

    public List<Register> registersOfType(TypeRef aType) {
        return this.knownRegisters.get(aType);
    }

    public Register registerAssignmentFor(Variable v) {
        Variable theAlias = this.aliases.get(v);
        if (theAlias != null) {
            Register theAliasAssignment = this.registerAssignments.get(theAlias);
            if (theAliasAssignment == null) {
                throw new IllegalStateException("Cannot find assigned register for alias " + theAlias);
            }
            return theAliasAssignment;
        }
        Register theRegularAssignment = this.registerAssignments.get(v);
        if (theRegularAssignment == null) {
            throw new IllegalStateException("Cannot find regular assigned register for " + v);
        }
        return theRegularAssignment;
    }

    public Variable variableAssignmentFor(PHIValue p) {
        Variable thePHIVariable = this.phis.get(p);
        if (thePHIVariable == null) {
            throw new IllegalStateException("Cannot find variable for phi " + p);
        }
        return thePHIVariable;
    }

    protected List<Variable> computeSSAReadyVariablesFor(Program prog) {
        HashMap<PHIValue, Set> thePHIs = new HashMap<PHIValue, Set>();
        for (RegionNode theNode : prog.getControlFlowGraph().dominators().getPreOrder()) {
            theNode.liveIn().getPorts().forEach((d, v) -> {
                if (v instanceof PHIValue) {
                    PHIValue p = (PHIValue)v;
                    HashSet<Value> theIncomingValues = new HashSet<Value>();
                    for (RegionNode thePred : theNode.getPredecessors()) {
                        Value theIncomingValue = thePred.liveOut().getPorts().get(d);
                        if (theIncomingValue == p) continue;
                        theIncomingValues.add(theIncomingValue);
                    }
                    if (!theIncomingValues.isEmpty()) {
                        if (thePHIs.containsKey(p)) {
                            throw new IllegalStateException();
                        }
                        thePHIs.put(p, theIncomingValues);
                    }
                }
            });
        }
        HashSet alreadyMappped = new HashSet();
        thePHIs.forEach((phi, values) -> {
            Variable var;
            Value v;
            HashSet theEffective = new HashSet(values);
            boolean modified = true;
            HashSet<PHIValue> theSeen = new HashSet<PHIValue>();
            block0: while (modified) {
                modified = false;
                for (Value v2 : theEffective) {
                    if (!(v2 instanceof PHIValue) || v2 == phi || !theSeen.add((PHIValue)v2)) continue;
                    Set thePHIValues = (Set)thePHIs.get((PHIValue)v2);
                    thePHIValues.removeAll(theSeen);
                    if (thePHIValues.isEmpty()) continue;
                    theEffective.addAll(thePHIValues);
                    theEffective.remove(v2);
                    modified = true;
                    continue block0;
                }
            }
            if (theEffective.size() == 1 && (v = (Value)theEffective.iterator().next()) instanceof Variable && (var = (Variable)v).isSynthetic()) {
                this.phis.put((PHIValue)phi, var);
                alreadyMappped.add(phi);
            }
        });
        HashMap theValueToNodes = new HashMap();
        thePHIs.forEach((phi, values) -> {
            if (!alreadyMappped.contains(phi)) {
                ValueNode thePhiNode = theValueToNodes.computeIfAbsent(phi, ValueNode::new);
                for (Value thePhiValue : values) {
                    if (alreadyMappped.contains(thePhiValue)) continue;
                    if (thePhiValue instanceof Variable) {
                        Variable var = (Variable)thePhiValue;
                        if (var.isSynthetic()) continue;
                        ValueNode theValueNode = theValueToNodes.computeIfAbsent(var, ValueNode::new);
                        thePhiNode.addEdgeTo(EdgeTypes.dependson, theValueNode);
                        continue;
                    }
                    ValueNode theValueNode = theValueToNodes.computeIfAbsent(thePhiValue, ValueNode::new);
                    thePhiNode.addEdgeTo(EdgeTypes.dependson, theValueNode);
                }
            }
        });
        Partitioning thePartitioning = new Partitioning(new HashSet(theValueToNodes.values()), t -> true);
        List thePartitions = thePartitioning.partitions();
        List<Variable> theVariables = prog.getVariables();
        for (int i = 0; i < thePartitions.size(); ++i) {
            Set thePartition = thePartitions.get(i);
            HashSet<Value> thePartitionValues = new HashSet<Value>();
            thePartition.forEach(t -> {
                Value theValue = ((ValueNode)t).value;
                thePartitionValues.add(theValue);
                if (theValue instanceof PHIValue) {
                    thePartitionValues.addAll((Collection)thePHIs.get(theValue));
                }
            });
            TypeRef theWidestType = Value.widestTypeOf(thePartitionValues, this.linkerContext);
            Variable theNewPhiVar = prog.createVariable("phi" + i, theWidestType);
            for (Value thePartitionValue : thePartitionValues) {
                if (thePartitionValue instanceof PHIValue) {
                    this.phis.put((PHIValue)thePartitionValue, theNewPhiVar);
                    continue;
                }
                if (!(thePartitionValue instanceof Variable)) continue;
                Variable v2 = (Variable)thePartitionValue;
                this.aliases.put(v2, theNewPhiVar);
                theVariables.remove(v2);
                theNewPhiVar.liveRange().usedAt(v2.liveRange().getDefinedAt());
                theNewPhiVar.liveRange().usedAt(v2.liveRange().getLastUsedAt());
            }
        }
        if (this.phis.keySet().size() != thePHIs.keySet().size()) {
            throw new IllegalStateException("Some phis where not correctly processed!");
        }
        return theVariables;
    }

    private static class ValueNode
    extends Node<ValueNode, EdgeTypes> {
        private final Value value;

        public ValueNode(Value value) {
            this.value = value;
        }
    }

    public static enum EdgeTypes implements EdgeType
    {
        dependson;

    }
}

