/*
 * Decompiled with CFR 0.152.
 */
package de.mindpipe.android.logging.log4j;

import de.mindpipe.android.logging.log4j.LogCatAppender;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class LogConfigurator {
    private Level level = Level.DEBUG;
    private String filePattern = "%d - [%p::%c::%C] - %m%n";
    private String logCatPattern = "%m%n";
    private String fileName = "android-log4j.log";
    private int maxBackupSize = 5;
    private long maxFileSize = 524288L;
    private boolean immediateFlush = false;
    private boolean useLogCatAppender = true;
    private boolean useFileAppender = true;

    public LogConfigurator() {
    }

    public LogConfigurator(String fileName) {
        this.setFileName(fileName);
    }

    public LogConfigurator(String fileName, Level level) {
        this(fileName);
        this.setLevel(level);
    }

    public LogConfigurator(String fileName, Level level, String pattern) {
        this(fileName);
        this.setLevel(level);
        this.setFilePattern(pattern);
    }

    public LogConfigurator(String fileName, int maxBackupSize, long maxFileSize, String pattern, Level level) {
        this(fileName, level, pattern);
        this.setMaxBackupSize(maxBackupSize);
        this.setMaxFileSize(maxFileSize);
    }

    public void configure() {
        Logger root = Logger.getRootLogger();
        if (this.isUseFileAppender()) {
            this.configureFileAppender();
        }
        if (this.isUseLogCatAppender()) {
            this.configureLogCatAppender();
        }
        root.setLevel(this.getLevel());
    }

    private void configureFileAppender() {
        RollingFileAppender rollingFileAppender;
        Logger root = Logger.getRootLogger();
        PatternLayout fileLayout = new PatternLayout(this.getFilePattern());
        try {
            rollingFileAppender = new RollingFileAppender((Layout)fileLayout, this.getFileName());
        }
        catch (IOException e) {
            throw new RuntimeException("Exception configuring log system", e);
        }
        rollingFileAppender.setMaxBackupIndex(this.getMaxBackupSize());
        rollingFileAppender.setMaximumFileSize(this.getMaxFileSize());
        rollingFileAppender.setImmediateFlush(this.isImmediateFlush());
        root.addAppender((Appender)rollingFileAppender);
        root.setLevel(this.getLevel());
    }

    private void configureLogCatAppender() {
        Logger root = Logger.getRootLogger();
        PatternLayout logCatLayout = new PatternLayout(this.getLogCatPattern());
        LogCatAppender logCatAppender = new LogCatAppender((Layout)logCatLayout);
        root.addAppender((Appender)logCatAppender);
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getLogCatPattern() {
        return this.logCatPattern;
    }

    public void setLogCatPattern(String logCatPattern) {
        this.logCatPattern = logCatPattern;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getMaxBackupSize() {
        return this.maxBackupSize;
    }

    public void setMaxBackupSize(int maxBackupSize) {
        this.maxBackupSize = maxBackupSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public boolean isUseFileAppender() {
        return this.useFileAppender;
    }

    public void setUseFileAppender(boolean useFileAppender) {
        this.useFileAppender = useFileAppender;
    }

    public boolean isUseLogCatAppender() {
        return this.useLogCatAppender;
    }

    public void setUseLogCatAppender(boolean useLogCatAppender) {
        this.useLogCatAppender = useLogCatAppender;
    }
}

