/*
 * Decompiled with CFR 0.152.
 */
package de.mibos.commons.crypt;

import de.mibos.commons.crypt.CryptoInitializationProblem;
import javax.annotation.Nonnull;

public enum Padding {
    PKCS5_PADDING("PKCS5Padding"),
    NO_PADDING("NoPadding");

    public static final Padding DEFAULT_PADDING_ALGORITHM;
    private final String shortcut;

    private Padding(String shortcut) {
        this.shortcut = shortcut;
    }

    @Nonnull
    public String getShortcut() {
        return this.shortcut;
    }

    @Nonnull
    public static Padding forShortcut(@Nonnull String shortcut) {
        for (Padding padding : Padding.values()) {
            if (!padding.getShortcut().equalsIgnoreCase(shortcut)) continue;
            return padding;
        }
        throw new CryptoInitializationProblem("Unsupported padding " + shortcut);
    }

    static {
        DEFAULT_PADDING_ALGORITHM = PKCS5_PADDING;
    }
}

