/*
 * Decompiled with CFR 0.152.
 */
package de.mibos.commons.crypt;

import de.mibos.commons.crypt.Crypt;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

@ThreadSafe
public class CryptOutputStream
extends FilterOutputStream {
    public CryptOutputStream(@Nonnull Crypt crypt, @Nonnull OutputStream output, @Nonnull CharSequence password) throws IOException {
        super(null);
        byte[] passwordBytes = crypt.getHashedEncryptionKey(password);
        this.initCipher(crypt, output, passwordBytes);
        crypt.resetPasswordBytes(passwordBytes);
    }

    public CryptOutputStream(@Nonnull Crypt crypt, @Nonnull OutputStream output, @Nonnull byte[] passwordBytes) throws IOException {
        super(null);
        this.initCipher(crypt, output, passwordBytes);
    }

    private void initCipher(@Nonnull Crypt crypt, @Nonnull OutputStream output, @Nonnull byte[] passwordBytes) throws IOException {
        Cipher cipher = crypt.getEncryptionCipher(passwordBytes);
        byte[] iv = cipher.getIV();
        output.write(iv);
        this.out = new CipherOutputStream(output, cipher);
    }
}

