/*
 * Decompiled with CFR 0.152.
 */
package de.mibos.commons.crypt;

import de.mibos.commons.crypt.Crypt;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

@ThreadSafe
public class CryptInputStream
extends FilterInputStream {
    public CryptInputStream(@Nonnull Crypt crypt, @Nonnull InputStream input, @Nonnull CharSequence password) throws IOException {
        super(null);
        byte[] passwordBytes = crypt.getHashedEncryptionKey(password);
        this.initCipher(crypt, input, passwordBytes);
        crypt.resetPasswordBytes(passwordBytes);
    }

    public CryptInputStream(@Nonnull Crypt crypt, @Nonnull InputStream input, @Nonnull byte[] passwordBytes) throws IOException {
        super(null);
        this.initCipher(crypt, input, passwordBytes);
    }

    private void initCipher(@Nonnull Crypt crypt, @Nonnull InputStream input, @Nonnull byte[] passwordBytes) throws IOException {
        byte[] iv = crypt.getIV(input);
        Cipher cipher = crypt.getDecryptionCipher(passwordBytes, iv);
        this.in = new CipherInputStream(input, cipher);
    }
}

