/*
 * Decompiled with CFR 0.152.
 */
package de.mibos.commons.crypt;

import de.mibos.commons.crypt.BlockMode;
import de.mibos.commons.crypt.CryptInputStream;
import de.mibos.commons.crypt.CryptOutputStream;
import de.mibos.commons.crypt.CryptoBufferOverflowException;
import de.mibos.commons.crypt.CryptoInitializationProblem;
import de.mibos.commons.crypt.CryptoInvalidCipherTextException;
import de.mibos.commons.crypt.Padding;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;

@ThreadSafe
@Immutable
public class Crypt
implements Serializable {
    private static final long serialVersionUID = 2372422428972070135L;
    public static final Crypt AES256 = new Crypt("AES", 256, 128);
    public static final Crypt AES192 = new Crypt("AES", 192, 128);
    public static final Crypt AES128 = new Crypt("AES", 128, 128);
    public static final Crypt Blowfish256 = new Crypt("Blowfish", 256, 64);
    public static final Crypt Blowfish192 = new Crypt("Blowfish", 192, 64);
    public static final Crypt Blowfish128 = new Crypt("Blowfish", 128, 64);
    public static final Crypt DES64 = new Crypt("DES", 64, 64);
    public static final Crypt DES192 = new Crypt("DESede", 192, 64);
    public static final String DEFAULT_PASSWORD_HASHING_ALGORITHM = "SHA-256";
    public static final String DEFAULT_BLOCK_CHAIN_MODE = BlockMode.DEFAULT_BLOCK_CHAIN_MODE.getShortcut();
    public static final String DEFAULT_PADDING_ALGORITHM = Padding.DEFAULT_PADDING_ALGORITHM.getShortcut();
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    @Nonnull
    private final String encryptionAlgorithm;
    @Nonnull
    private final String passwordHashingAlgorithm;
    @Nonnull
    private final BlockMode blockMode;
    @Nonnull
    private final Padding padding;
    private final int keySizeInBytes;
    private final int blockSizeInBytes;
    private final int bufferSize;

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull String passwordHashingAlgorithm, @Nonnull String blockMode, @Nonnull String padding, int bufferSize) {
        this(encryptionAlgorithm, keySize, blockSize, passwordHashingAlgorithm, BlockMode.forShortcut(blockMode), Padding.forShortcut(padding), bufferSize);
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull String passwordHashingAlgorithm, @Nonnull BlockMode blockMode, @Nonnull Padding padding, int bufferSize) {
        assert (encryptionAlgorithm != null) : "encryptionAlgorithm must be not null";
        assert (keySize > 0) : "keySize must be greater than null";
        assert (blockSize > 0) : "blockSize must be greater than null";
        assert (passwordHashingAlgorithm != null) : "passwordHashingAlgorithm must be not null";
        assert (blockMode != null) : "blockMode must be not null";
        assert (padding != null) : "padding must be not null";
        assert (bufferSize > 0) : "bufferSize must be greater than null";
        if (blockMode == BlockMode.CIPHER_BLOCK_CHAIN_MODE) {
            if (padding != Padding.PKCS5_PADDING) {
                throw new CryptoInitializationProblem("Block mode CBC is only supported in combination with PKCS5 padding");
            }
        } else if (blockMode == BlockMode.CIPHER_FEEDBACK_MODE || blockMode == BlockMode.OUTPUT_FEEDBACK_MODE) {
            if (padding != Padding.NO_PADDING) {
                throw new CryptoInitializationProblem("Block modes CFB and OFB are only supported in combination with no padding");
            }
        } else {
            throw new CryptoInitializationProblem("Unsupported block mode " + (Object)((Object)blockMode));
        }
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.keySizeInBytes = keySize / 8;
        this.blockSizeInBytes = blockSize / 8;
        this.passwordHashingAlgorithm = passwordHashingAlgorithm;
        this.blockMode = blockMode;
        this.padding = padding;
        this.bufferSize = bufferSize;
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull String passwordHashingAlgorithm, @Nonnull String blockMode, @Nonnull String padding) {
        this(encryptionAlgorithm, keySize, blockSize, passwordHashingAlgorithm, BlockMode.forShortcut(blockMode), Padding.forShortcut(padding), 4096);
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull String passwordHashingAlgorithm, @Nonnull BlockMode blockMode, @Nonnull Padding padding) {
        this(encryptionAlgorithm, keySize, blockSize, passwordHashingAlgorithm, blockMode, padding, 4096);
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull String blockMode, @Nonnull String padding) {
        this(encryptionAlgorithm, keySize, blockSize, DEFAULT_PASSWORD_HASHING_ALGORITHM, BlockMode.forShortcut(blockMode), Padding.forShortcut(padding), 4096);
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull BlockMode blockMode, @Nonnull Padding padding) {
        this(encryptionAlgorithm, keySize, blockSize, DEFAULT_PASSWORD_HASHING_ALGORITHM, blockMode, padding, 4096);
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull String passwordHashingAlgorithm) {
        this(encryptionAlgorithm, keySize, blockSize, passwordHashingAlgorithm, BlockMode.DEFAULT_BLOCK_CHAIN_MODE, Padding.DEFAULT_PADDING_ALGORITHM);
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize) {
        this(encryptionAlgorithm, keySize, blockSize, DEFAULT_PASSWORD_HASHING_ALGORITHM);
    }

    public int getKeySize() {
        return this.keySizeInBytes * 8;
    }

    public int getBlockSize() {
        return this.blockSizeInBytes * 8;
    }

    @Nonnull
    public String getEncryptionMethod() {
        return this.encryptionAlgorithm + "/" + this.blockMode.getShortcut() + "/" + this.padding.getShortcut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long encrypt(@Nonnull @WillClose InputStream input, @Nonnull @WillClose OutputStream output, @Nonnull CharSequence password) throws IOException {
        byte[] passwordBytes;
        assert (password != null) : "password must be not null";
        try {
            passwordBytes = this.getHashedEncryptionKey(password);
        }
        catch (RuntimeException e) {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
            throw e;
        }
        try {
            long l = this.internalEncrypt(passwordBytes, input, output);
            return l;
        }
        finally {
            this.resetPasswordBytes(passwordBytes);
        }
    }

    public long encrypt(@Nonnull @WillClose InputStream input, @Nonnull @WillClose OutputStream output, @Nonnull byte[] passwordBytes) throws IOException {
        assert (input != null) : "input must be not null";
        assert (output != null) : "output must be not null";
        assert (passwordBytes != null) : "passwordBytes must be not null";
        return this.internalEncrypt(passwordBytes, input, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public byte[] encrypt(@Nonnull byte[] input, @Nonnull CharSequence password) {
        assert (password != null) : "password must be not null";
        byte[] passwordBytes = this.getHashedEncryptionKey(password);
        try {
            byte[] byArray = this.encrypt(input, passwordBytes);
            return byArray;
        }
        finally {
            this.resetPasswordBytes(passwordBytes);
        }
    }

    @Nonnull
    public byte[] encrypt(@Nonnull byte[] input, @Nonnull byte[] passwordBytes) {
        assert (input != null) : "input must be not null";
        assert (passwordBytes != null) : "passwordBytes must be not null";
        byte[] output = new byte[(int)this.getMaximumCipherTextLength(input.length)];
        int outputSize = this.internalEncrypt(passwordBytes, input, 0, input.length, output, 0);
        assert (outputSize == output.length) : "must not happen for standard algorithms";
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long encrypt(@Nonnull ByteBuffer input, @Nonnull ByteBuffer output, @Nonnull CharSequence password) {
        assert (password != null) : "password must be not null";
        byte[] passwordBytes = this.getHashedEncryptionKey(password);
        try {
            long l = this.encrypt(input, output, passwordBytes);
            return l;
        }
        finally {
            this.resetPasswordBytes(passwordBytes);
        }
    }

    public long encrypt(@Nonnull ByteBuffer input, @Nonnull ByteBuffer output, @Nonnull byte[] passwordBytes) {
        assert (input != null) : "input must be not null";
        assert (output != null) : "output must be not null";
        assert (passwordBytes != null) : "passwordBytes must be not null";
        return this.internalEncrypt(passwordBytes, input, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrypt(@Nonnull @WillClose InputStream input, @Nonnull @WillClose OutputStream output, @Nonnull CharSequence password) throws IOException {
        byte[] passwordBytes;
        assert (password != null) : "password must be not null";
        try {
            passwordBytes = this.getHashedEncryptionKey(password);
        }
        catch (RuntimeException e) {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
            throw e;
        }
        try {
            long l = this.internalDecrypt(passwordBytes, input, output);
            return l;
        }
        finally {
            this.resetPasswordBytes(passwordBytes);
        }
    }

    public long decrypt(@Nonnull @WillClose InputStream input, @Nonnull @WillClose OutputStream output, @Nonnull byte[] passwordBytes) throws IOException {
        assert (input != null) : "input must be not null";
        assert (output != null) : "output must be not null";
        assert (passwordBytes != null) : "passwordBytes must be not null";
        return this.internalDecrypt(passwordBytes, input, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public byte[] decrypt(@Nonnull byte[] input, @Nonnull CharSequence password) {
        assert (password != null) : "password must be not null";
        byte[] passwordBytes = this.getHashedEncryptionKey(password);
        try {
            byte[] byArray = this.decrypt(input, passwordBytes);
            return byArray;
        }
        finally {
            this.resetPasswordBytes(passwordBytes);
        }
    }

    @Nonnull
    public byte[] decrypt(@Nonnull byte[] input, @Nonnull byte[] passwordBytes) {
        assert (input != null) : "input must be not null";
        assert (passwordBytes != null) : "passwordBytes must be not null";
        byte[] output = new byte[(int)this.getMaximumPlainTextLength(input.length)];
        int outputSize = this.internalDecrypt(passwordBytes, input, 0, input.length, output, 0);
        if (outputSize < output.length) {
            byte[] result = new byte[outputSize];
            System.arraycopy(output, 0, result, 0, outputSize);
            return result;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrypt(@Nonnull ByteBuffer input, @Nonnull ByteBuffer output, @Nonnull CharSequence password) {
        assert (password != null) : "password must be not null";
        byte[] passwordBytes = this.getHashedEncryptionKey(password);
        try {
            long l = this.decrypt(input, output, passwordBytes);
            return l;
        }
        finally {
            this.resetPasswordBytes(passwordBytes);
        }
    }

    public long decrypt(@Nonnull ByteBuffer input, @Nonnull ByteBuffer output, @Nonnull byte[] passwordBytes) {
        assert (input != null) : "input must be not null";
        assert (output != null) : "output must be not null";
        assert (passwordBytes != null) : "passwordBytes must be not null";
        return this.internalDecrypt(passwordBytes, input, output);
    }

    public CryptInputStream getInputStream(@Nonnull InputStream input, @Nonnull CharSequence password) throws IOException {
        return new CryptInputStream(this, input, password);
    }

    public CryptInputStream getInputStream(@Nonnull InputStream input, @Nonnull byte[] passwordBytes) throws IOException {
        return new CryptInputStream(this, input, passwordBytes);
    }

    public CryptOutputStream getOutputStream(@Nonnull OutputStream output, @Nonnull CharSequence password) throws IOException {
        return new CryptOutputStream(this, output, password);
    }

    public CryptOutputStream getOutputStream(@Nonnull OutputStream output, @Nonnull byte[] passwordBytes) throws IOException {
        return new CryptOutputStream(this, output, passwordBytes);
    }

    public long getMaximumCipherTextLength(long plainTextLength) {
        if (this.padding == Padding.NO_PADDING) {
            return plainTextLength + (long)this.blockSizeInBytes;
        }
        return plainTextLength + (long)(2 * this.blockSizeInBytes) - plainTextLength % (long)this.blockSizeInBytes;
    }

    public long getMaximumPlainTextLength(long cipherTextLength) {
        return Math.max(cipherTextLength - (long)this.blockSizeInBytes, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long internalEncrypt(@Nonnull byte[] passwordBytes, @Nonnull @WillClose InputStream input, @Nonnull @WillClose OutputStream output) throws IOException {
        byte[] iv;
        Cipher cipher;
        try {
            cipher = this.getEncryptionCipher(passwordBytes);
            iv = cipher.getIV();
        }
        catch (RuntimeException e) {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
            throw e;
        }
        CountingOutputStream countingOutputStream = new CountingOutputStream(output);
        CipherOutputStream cipherOutputStream = new CipherOutputStream((OutputStream)countingOutputStream, cipher);
        try {
            countingOutputStream.write(iv);
            IOUtils.copyLarge((InputStream)input, (OutputStream)cipherOutputStream, (byte[])new byte[this.bufferSize]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)cipherOutputStream);
        }
        return countingOutputStream.getByteCount();
    }

    private int internalEncrypt(@Nonnull byte[] passwordBytes, @Nonnull byte[] input, int inputOffset, int inputLength, @Nonnull byte[] output, int outputOffset) {
        try {
            Cipher cipher = this.getEncryptionCipher(passwordBytes);
            byte[] iv = cipher.getIV();
            System.arraycopy(iv, 0, output, outputOffset, iv.length);
            return iv.length + cipher.doFinal(input, inputOffset, inputLength, output, outputOffset + iv.length);
        }
        catch (ShortBufferException e) {
            throw new CryptoBufferOverflowException("output buffer too small", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new CryptoInitializationProblem(this.getEncryptionMethod() + " encryption or padding not available on encrypt?", e);
        }
    }

    private long internalEncrypt(@Nonnull byte[] passwordBytes, @Nonnull ByteBuffer input, @Nonnull ByteBuffer output) {
        try {
            Cipher cipher = this.getEncryptionCipher(passwordBytes);
            byte[] iv = cipher.getIV();
            output.put(iv);
            return iv.length + cipher.doFinal(input, output);
        }
        catch (ShortBufferException e) {
            throw new CryptoBufferOverflowException("output buffer too small", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new CryptoInitializationProblem(this.getEncryptionMethod() + " encryption or padding not available on encrypt?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long internalDecrypt(@Nonnull byte[] passwordBytes, @Nonnull @WillClose InputStream input, @Nonnull @WillClose OutputStream output) throws IOException {
        Cipher cipher;
        try {
            byte[] iv = this.getIV(input);
            cipher = this.getDecryptionCipher(passwordBytes, iv);
        }
        catch (IOException | RuntimeException e) {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
            throw e;
        }
        CipherInputStream cipherInputStream = new CipherInputStream(input, cipher);
        CountingOutputStream countingOutputStream = new CountingOutputStream(output);
        try {
            IOUtils.copyLarge((InputStream)cipherInputStream, (OutputStream)countingOutputStream, (byte[])new byte[this.bufferSize]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)cipherInputStream);
            IOUtils.closeQuietly((OutputStream)countingOutputStream);
        }
        return countingOutputStream.getByteCount();
    }

    private int internalDecrypt(@Nonnull byte[] passwordBytes, @Nonnull byte[] input, int inputOffset, int inputLength, @Nonnull byte[] output, int outputOffset) {
        try {
            byte[] iv = this.getIV(input, inputOffset);
            Cipher cipher = this.getDecryptionCipher(passwordBytes, iv);
            return cipher.doFinal(input, inputOffset + iv.length, inputLength - iv.length, output, outputOffset);
        }
        catch (ShortBufferException e) {
            throw new CryptoBufferOverflowException("output buffer too small", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoInvalidCipherTextException("input must be a multiple of the block size", e);
        }
        catch (BadPaddingException e) {
            throw new CryptoInvalidCipherTextException("invalid padding", e);
        }
    }

    private long internalDecrypt(@Nonnull byte[] passwordBytes, @Nonnull ByteBuffer input, @Nonnull ByteBuffer output) {
        try {
            byte[] iv = this.getIV(input);
            Cipher cipher = this.getDecryptionCipher(passwordBytes, iv);
            return cipher.doFinal(input, output);
        }
        catch (ShortBufferException e) {
            throw new CryptoBufferOverflowException("output buffer too small", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoInvalidCipherTextException("input must be a multiple of the block size", e);
        }
        catch (BadPaddingException e) {
            throw new CryptoInvalidCipherTextException("invalid padding", e);
        }
    }

    @Nonnull
    Cipher getEncryptionCipher(@Nonnull byte[] passwordBytes) {
        Cipher cipher = this.getCipher();
        this.initCipher(cipher, passwordBytes, 1, null);
        return cipher;
    }

    @Nonnull
    Cipher getDecryptionCipher(@Nonnull byte[] passwordBytes, @Nonnull byte[] iv) {
        Cipher cipher = this.getCipher();
        this.initCipher(cipher, passwordBytes, 2, iv);
        return cipher;
    }

    byte[] getIV(@Nonnull @WillNotClose InputStream input) throws IOException {
        try {
            byte[] iv = new byte[this.blockSizeInBytes];
            IOUtils.readFully((InputStream)input, (byte[])iv);
            return iv;
        }
        catch (EOFException e) {
            throw new CryptoInvalidCipherTextException("not enough bytes for initialization vector", e);
        }
    }

    private byte[] getIV(@Nonnull ByteBuffer input) {
        try {
            byte[] iv = new byte[this.blockSizeInBytes];
            input.get(iv);
            return iv;
        }
        catch (BufferUnderflowException e) {
            throw new CryptoInvalidCipherTextException("not enough bytes for initialization vector", e);
        }
    }

    private byte[] getIV(@Nonnull byte[] input, int offset) {
        try {
            byte[] iv = new byte[this.blockSizeInBytes];
            System.arraycopy(input, offset, iv, 0, this.blockSizeInBytes);
            return iv;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CryptoInvalidCipherTextException("not enough bytes for initialization vector", e);
        }
    }

    @Nonnull
    private Cipher getCipher() {
        try {
            return Cipher.getInstance(this.getEncryptionMethod());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoInitializationProblem(this.getEncryptionMethod() + " encryption or padding not available", e);
        }
    }

    private void initCipher(@Nonnull Cipher cipher, @Nonnull byte[] passwordBytes, int mode, @CheckForNull byte[] iv) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(passwordBytes, this.encryptionAlgorithm);
            if (iv != null) {
                cipher.init(mode, (Key)keySpec, new IvParameterSpec(iv));
            } else {
                cipher.init(mode, keySpec);
            }
            if (cipher.getBlockSize() != this.blockSizeInBytes) {
                throw new CryptoInitializationProblem(this.getEncryptionMethod() + " calculated block size " + cipher.getBlockSize() + " does not match expected blocksize " + this.blockSizeInBytes);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoInitializationProblem(this.getEncryptionMethod() + " initialization vector not allowed?", e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoInitializationProblem(this.getEncryptionMethod() + " invalid key size, you probably need to replace the security policies in $JAVA_HOME/jre/lib/security, " + "see here http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html", e);
        }
    }

    @Nonnull
    public byte[] getHashedEncryptionKey(@Nonnull CharSequence password) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.passwordHashingAlgorithm);
            if (password instanceof CharBuffer) {
                md.update(StandardCharsets.UTF_8.encode((CharBuffer)password));
            } else {
                md.update(StandardCharsets.UTF_8.encode(password.toString()));
            }
            byte[] digest = md.digest();
            md.reset();
            if (digest.length == this.keySizeInBytes) {
                return digest;
            }
            if (digest.length > this.keySizeInBytes) {
                byte[] passwordBytes = new byte[this.keySizeInBytes];
                System.arraycopy(digest, 0, passwordBytes, 0, this.keySizeInBytes);
                this.resetPasswordBytes(digest);
                return passwordBytes;
            }
            throw new CryptoInitializationProblem("Hashing algorithm " + this.passwordHashingAlgorithm + " produces not enough bytes for key, required " + this.keySizeInBytes * 8 + " bits, provided only " + digest.length * 8 + " bits");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoInitializationProblem("Hashing algorithm " + this.passwordHashingAlgorithm + " not available", e);
        }
    }

    void resetPasswordBytes(@Nonnull byte[] passwordBytes) {
        Arrays.fill(passwordBytes, (byte)0);
    }

    public String toString() {
        return "Crypt{encryptionAlgorithm='" + this.encryptionAlgorithm + '\'' + ", passwordHashingAlgorithm='" + this.passwordHashingAlgorithm + '\'' + ", blockMode=" + (Object)((Object)this.blockMode) + ", padding=" + (Object)((Object)this.padding) + ", keySize=" + this.keySizeInBytes * 8 + ", blockSize=" + this.blockSizeInBytes * 8 + ", bufferSize=" + this.bufferSize + '}';
    }

    public boolean equals(@CheckForNull Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Crypt crypt = (Crypt)o;
        if (this.blockSizeInBytes != crypt.blockSizeInBytes) {
            return false;
        }
        if (this.bufferSize != crypt.bufferSize) {
            return false;
        }
        if (this.keySizeInBytes != crypt.keySizeInBytes) {
            return false;
        }
        if (this.blockMode != crypt.blockMode) {
            return false;
        }
        if (this.padding != crypt.padding) {
            return false;
        }
        if (!this.encryptionAlgorithm.equalsIgnoreCase(crypt.encryptionAlgorithm)) {
            return false;
        }
        return this.passwordHashingAlgorithm.equalsIgnoreCase(crypt.passwordHashingAlgorithm);
    }

    public int hashCode() {
        int result = this.encryptionAlgorithm.hashCode();
        result = 31 * result + this.passwordHashingAlgorithm.hashCode();
        result = 31 * result + this.blockMode.hashCode();
        result = 31 * result + this.padding.hashCode();
        result = 31 * result + this.keySizeInBytes;
        result = 31 * result + this.blockSizeInBytes;
        result = 31 * result + this.bufferSize;
        return result;
    }

    @Nonnull
    private Object readResolve() throws ObjectStreamException {
        Field[] fields;
        for (Field field : fields = this.getClass().getFields()) {
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !this.equals(field.get(null))) continue;
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new InvalidObjectException(e.getMessage());
            }
        }
        return this;
    }

    @Nonnull
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Nonnull
    public String getPasswordHashingAlgorithm() {
        return this.passwordHashingAlgorithm;
    }

    @Nonnull
    public BlockMode getBlockMode() {
        return this.blockMode;
    }

    @Nonnull
    public Padding getPadding() {
        return this.padding;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

