/*
 * Decompiled with CFR 0.152.
 */
package de.mibos.commons.crypt;

import de.mibos.commons.crypt.CryptoInitializationProblem;
import javax.annotation.Nonnull;

public enum BlockMode {
    ELECTRONIC_CODE_BOOK_MODE("ECB"),
    CIPHER_BLOCK_CHAIN_MODE("CBC"),
    CIPHER_FEEDBACK_MODE("CFB"),
    OUTPUT_FEEDBACK_MODE("OFB");

    public static final BlockMode DEFAULT_BLOCK_CHAIN_MODE;
    private final String shortcut;

    private BlockMode(String shortcut) {
        this.shortcut = shortcut;
    }

    @Nonnull
    public String getShortcut() {
        return this.shortcut;
    }

    @Nonnull
    public static BlockMode forShortcut(@Nonnull String shortcut) {
        for (BlockMode blockMode : BlockMode.values()) {
            if (!blockMode.getShortcut().equalsIgnoreCase(shortcut)) continue;
            return blockMode;
        }
        throw new CryptoInitializationProblem("Unsupported block mode " + shortcut);
    }

    static {
        DEFAULT_BLOCK_CHAIN_MODE = CIPHER_BLOCK_CHAIN_MODE;
    }
}

