/*
 * Decompiled with CFR 0.152.
 */
package de.mibos.commons.crypt;

import de.mibos.commons.crypt.CryptoInitializationProblem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;

@ThreadSafe
@Immutable
public class Crypt {
    @Nonnull
    private final String encryptionAlgorithm;
    @Nonnull
    private final String passwordHashingAlgorithm;
    @Nonnull
    private final String encryptionMethod;
    private final int keySizeInBytes;
    private final int blockSizeInBytes;
    public static final Crypt AES256 = new Crypt("AES", 256, 128);
    public static final Crypt AES192 = new Crypt("AES", 192, 128);
    public static final Crypt AES128 = new Crypt("AES", 128, 128);
    public static final Crypt Blowfish256 = new Crypt("Blowfish", 256, 64);
    public static final Crypt Blowfish192 = new Crypt("Blowfish", 192, 64);
    public static final Crypt Blowfish128 = new Crypt("Blowfish", 128, 64);
    public static final Crypt DES64 = new Crypt("DES", 64, 64);
    public static final Crypt DES192 = new Crypt("DESede", 192, 64);

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull String passwordHashingAlgorithm, @Nonnull String blockMode, @Nonnull String padding) {
        assert (encryptionAlgorithm != null);
        assert (passwordHashingAlgorithm != null);
        assert (blockMode != null);
        assert (encryptionAlgorithm != null);
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.keySizeInBytes = keySize / 8;
        this.blockSizeInBytes = blockSize / 8;
        this.passwordHashingAlgorithm = passwordHashingAlgorithm;
        this.encryptionMethod = encryptionAlgorithm + "/" + blockMode + "/" + padding;
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize, @Nonnull String passwordHashingAlgorithm) {
        this(encryptionAlgorithm, keySize, blockSize, passwordHashingAlgorithm, "CBC", "PKCS5Padding");
    }

    public Crypt(@Nonnull String encryptionAlgorithm, int keySize, int blockSize) {
        this(encryptionAlgorithm, keySize, blockSize, "SHA-256");
    }

    public int getKeySize() {
        return this.keySizeInBytes * 8;
    }

    public int getBlockSize() {
        return this.blockSizeInBytes * 8;
    }

    public long encrypt(@Nonnull @WillNotClose InputStream input, @Nonnull @WillClose OutputStream output, @Nonnull String password) throws IOException {
        assert (input != null);
        assert (output != null);
        assert (password != null);
        byte[] passwordBytes = this.getHashedEncryptionKey(password);
        return this.internalEncrypt(passwordBytes, input, output);
    }

    public long encrypt(@Nonnull @WillNotClose InputStream input, @Nonnull @WillClose OutputStream output, @Nonnull byte[] passwordBytes) throws IOException {
        assert (input != null);
        assert (output != null);
        assert (passwordBytes != null);
        return this.internalEncrypt(passwordBytes, input, output);
    }

    public long decrypt(@Nonnull @WillNotClose InputStream input, @Nonnull @WillClose OutputStream output, @Nonnull String password) throws IOException {
        assert (input != null);
        assert (output != null);
        assert (password != null);
        byte[] passwordBytes = this.getHashedEncryptionKey(password);
        return this.internalDecrypt(passwordBytes, input, output);
    }

    public long decrypt(@Nonnull @WillNotClose InputStream input, @Nonnull @WillClose OutputStream output, @Nonnull byte[] passwordBytes) throws IOException {
        assert (input != null);
        assert (output != null);
        assert (passwordBytes != null);
        return this.internalDecrypt(passwordBytes, input, output);
    }

    @Nonnull
    public byte[] encrypt(@Nonnull byte[] input, @Nonnull String password) {
        assert (input != null);
        assert (password != null);
        byte[] passwordBytes = this.getHashedEncryptionKey(password);
        return this.encrypt(input, passwordBytes);
    }

    @Nonnull
    public byte[] encrypt(@Nonnull byte[] input, @Nonnull byte[] passwordBytes) {
        assert (input != null);
        assert (passwordBytes != null);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(input.length + this.blockSizeInBytes * 2);
            this.internalEncrypt(passwordBytes, inputStream, outputStream);
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException not expected on ByteArray*Streams", e);
        }
    }

    @Nonnull
    public byte[] decrypt(@Nonnull byte[] input, @Nonnull String password) {
        assert (input != null);
        assert (password != null);
        byte[] passwordBytes = this.getHashedEncryptionKey(password);
        return this.decrypt(input, passwordBytes);
    }

    @Nonnull
    public byte[] decrypt(@Nonnull byte[] input, @Nonnull byte[] passwordBytes) {
        assert (input != null);
        assert (passwordBytes != null);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(input.length);
            this.internalDecrypt(passwordBytes, inputStream, outputStream);
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException not expected on ByteArray*Streams", e);
        }
    }

    private long internalEncrypt(@Nonnull byte[] passwordBytes, @Nonnull @WillNotClose InputStream input, @Nonnull @WillClose OutputStream output) throws IOException {
        Cipher cipher = this.getCipher();
        this.initCipher(cipher, passwordBytes, 1, null);
        byte[] iv = cipher.getIV();
        CountingOutputStream countingOutputStream = new CountingOutputStream(output);
        CipherOutputStream cipherOutputStream = new CipherOutputStream((OutputStream)countingOutputStream, cipher);
        countingOutputStream.write(iv);
        IOUtils.copyLarge((InputStream)input, (OutputStream)cipherOutputStream);
        IOUtils.closeQuietly((OutputStream)cipherOutputStream);
        return countingOutputStream.getByteCount();
    }

    private long internalDecrypt(@Nonnull byte[] passwordBytes, @Nonnull @WillNotClose InputStream input, @Nonnull @WillClose OutputStream output) throws IOException {
        Cipher cipher = this.getCipher();
        byte[] iv = new byte[this.blockSizeInBytes];
        IOUtils.readFully((InputStream)input, (byte[])iv);
        this.initCipher(cipher, passwordBytes, 2, iv);
        CipherInputStream cipherInputStream = new CipherInputStream(input, cipher);
        CountingOutputStream countingOutputStream = new CountingOutputStream(output);
        IOUtils.copyLarge((InputStream)cipherInputStream, (OutputStream)countingOutputStream);
        IOUtils.closeQuietly((OutputStream)countingOutputStream);
        return countingOutputStream.getByteCount();
    }

    @Nonnull
    private Cipher getCipher() {
        try {
            return Cipher.getInstance(this.encryptionMethod);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoInitializationProblem(this.encryptionMethod + " encryption not available", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoInitializationProblem(this.encryptionMethod + " padding not available", e);
        }
    }

    private void initCipher(@Nonnull Cipher cipher, @Nonnull byte[] passwordBytes, int mode, @CheckForNull byte[] iv) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(passwordBytes, this.encryptionAlgorithm);
            if (iv != null) {
                cipher.init(mode, (Key)keySpec, new IvParameterSpec(iv));
            } else {
                cipher.init(mode, keySpec);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoInitializationProblem(this.encryptionMethod + " initialization vector not allowed?", e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoInitializationProblem(this.encryptionMethod + " invalid key size, you probably need to replace the security policies in $JAVA_HOME/jre/lib/security, " + "see here http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html", e);
        }
    }

    @Nonnull
    public byte[] getHashedEncryptionKey(@Nonnull String password) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.passwordHashingAlgorithm);
            md.update(password.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            if (digest.length == this.keySizeInBytes) {
                return digest;
            }
            if (digest.length > this.keySizeInBytes) {
                byte[] passwordBytes = new byte[this.keySizeInBytes];
                System.arraycopy(digest, 0, passwordBytes, 0, this.keySizeInBytes);
                return passwordBytes;
            }
            throw new CryptoInitializationProblem("Hashing algorithm " + this.passwordHashingAlgorithm + " produces not enough bytes for key, required " + this.keySizeInBytes * 8 + " bits ");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoInitializationProblem("Hashing algorithm " + this.passwordHashingAlgorithm + " not available", e);
        }
    }
}

