/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.streamhtmlparser.util;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableSortedSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HtmlUtils {
    private static final String META_REDIRECT_REGEX = "^\\s*\\d*\\s*;\\s*URL\\s*=\\s*['\"]?";
    private static final Pattern META_REDIRECT_PATTERN = Pattern.compile("^\\s*\\d*\\s*;\\s*URL\\s*=\\s*['\"]?", 2);
    private static final Set<String> REGEXP_TOKEN_PREFIXS = ImmutableSortedSet.of((Comparable)((Object)"abstract"), (Comparable)((Object)"break"), (Comparable)((Object)"case"), (Comparable)((Object)"catch"), (Comparable)((Object)"class"), (Comparable)((Object)"const"), (Comparable[])new String[]{"continue", "debugger", "default", "delete", "do", "else", "enum", "eval", "export", "extends", "field", "final", "finally", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "native", "new", "package", "private", "protected", "public", "return", "static", "switch", "synchronized", "throw", "throws", "transient", "try", "typeof", "var", "void", "volatile", "while", "with"});
    private static final Set<String> ATTRIBUTE_EXPECTS_URI = ImmutableSortedSet.of((Comparable)((Object)"action"), (Comparable)((Object)"archive"), (Comparable)((Object)"background"), (Comparable)((Object)"cite"), (Comparable)((Object)"classid"), (Comparable)((Object)"codebase"), (Comparable[])new String[]{"data", "dynsrc", "href", "longdesc", "src", "usemap"});
    private static final Set<Character> JAVASCRIPT_WHITESPACE = ImmutableSortedSet.of((Comparable)Character.valueOf('\t'), (Comparable)Character.valueOf('\n'), (Comparable)Character.valueOf('\u000b'), (Comparable)Character.valueOf('\f'), (Comparable)Character.valueOf('\r'), (Comparable)Character.valueOf(' '), (Comparable[])new Character[]{Character.valueOf('\u00a0'), Character.valueOf('\u2028'), Character.valueOf('\u2029')});
    private static final Set<Character> HTML_WHITESPACE = ImmutableSortedSet.of(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\u200b'));

    private HtmlUtils() {
    }

    public static boolean isAttributeJavascript(String attribute) {
        return attribute != null && attribute.startsWith("on");
    }

    public static boolean isAttributeStyle(String attribute) {
        return "style".equals(attribute);
    }

    public static boolean isAttributeUri(String attribute) {
        return ATTRIBUTE_EXPECTS_URI.contains(attribute);
    }

    public static boolean isHtmlSpace(char chr) {
        return HTML_WHITESPACE.contains(Character.valueOf(chr));
    }

    public static boolean isJavascriptWhitespace(char chr) {
        return JAVASCRIPT_WHITESPACE.contains(Character.valueOf(chr));
    }

    public static boolean isJavascriptIdentifier(char chr) {
        return chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z' || chr >= '0' && chr <= '9' || chr == '_' || chr == '$';
    }

    public static boolean isJavascriptRegexpPrefix(String input) {
        return REGEXP_TOKEN_PREFIXS.contains(input);
    }

    public static String encodeCharForAscii(char chr) {
        if (chr == '\'') {
            return "\\'";
        }
        if (chr == '\\') {
            return "\\\\";
        }
        if (chr >= ' ' && chr <= '~') {
            return String.format("%c", Character.valueOf(chr));
        }
        if (chr == '\n') {
            return "\\n";
        }
        if (chr == '\r') {
            return "\\r";
        }
        if (chr == '\t') {
            return "\\t";
        }
        return String.format("\\u%04x", chr);
    }

    public static META_REDIRECT_TYPE parseContentAttributeForUrl(String value) {
        if (value == null) {
            return META_REDIRECT_TYPE.NONE;
        }
        Matcher matcher = META_REDIRECT_PATTERN.matcher(value);
        if (!matcher.find()) {
            return META_REDIRECT_TYPE.NONE;
        }
        if (value.length() > matcher.end()) {
            return META_REDIRECT_TYPE.URL;
        }
        return META_REDIRECT_TYPE.URL_START;
    }

    public static enum META_REDIRECT_TYPE {
        NONE,
        URL_START,
        URL;

    }
}

