/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.response;

import de.otto.flummi.response.AggregationResult;
import de.otto.flummi.response.SearchHits;
import de.otto.flummi.response.SimpleSearchHits;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SearchResponse {
    private final long tookInMillis;
    private final String scrollId;
    private final SearchHits hits;
    private final Map<String, AggregationResult> aggregations;

    public SearchResponse(long tookInMillis, String scrollId, SearchHits hits, Map<String, AggregationResult> aggregations) {
        this.tookInMillis = tookInMillis;
        this.scrollId = scrollId;
        this.hits = hits;
        this.aggregations = aggregations;
    }

    public SearchHits getHits() {
        return this.hits;
    }

    public Map<String, AggregationResult> getAggregations() {
        return this.aggregations;
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SearchResponse emptyResponse() {
        return new SearchResponse(0L, null, new SimpleSearchHits(0L, Float.valueOf(0.0f), Collections.emptyList()), Collections.emptyMap());
    }

    public static final class Builder {
        private long tookInMillis;
        private String scrollId;
        private SearchHits hits;
        private Map<String, AggregationResult> aggregations = new HashMap<String, AggregationResult>();

        public Builder setTookInMillis(long tookInMillis) {
            this.tookInMillis = tookInMillis;
            return this;
        }

        public Builder setScrollId(String scrollId) {
            this.scrollId = scrollId;
            return this;
        }

        public Builder setHits(SearchHits hits) {
            this.hits = hits;
            return this;
        }

        public Builder addAggregation(String name, AggregationResult value) {
            this.aggregations.put(name, value);
            return this;
        }

        public SearchResponse build() {
            return new SearchResponse(this.tookInMillis, this.scrollId, this.hits, this.aggregations);
        }
    }
}

