/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ning.http.client.Response;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.GsonHelper;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.request.SearchRequestBuilder;
import de.otto.flummi.response.SearchResponse;
import de.otto.flummi.util.HttpClientWrapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;

public class SearchScrollRequestBuilder
implements RequestBuilder<SearchResponse> {
    private final Gson gson;
    private HttpClientWrapper httpClient;
    private String scrollId;
    private String scroll;

    public SearchScrollRequestBuilder(HttpClientWrapper httpClient) {
        this.httpClient = httpClient;
        this.gson = new Gson();
    }

    public SearchScrollRequestBuilder setScrollId(String scrollId) {
        this.scrollId = scrollId;
        return this;
    }

    public SearchScrollRequestBuilder setScroll(String scroll) {
        this.scroll = scroll;
        return this;
    }

    @Override
    public SearchResponse execute() {
        JsonObject requestBody = GsonHelper.object("scroll_id", this.scrollId, "scroll", this.scroll);
        try {
            Response response = (Response)this.httpClient.preparePost("/_search/scroll").setBody(this.gson.toJson(requestBody)).execute().get();
            if (response.getStatusCode() == 404) {
                return SearchResponse.emptyResponse();
            }
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            JsonObject jsonResponse = this.gson.fromJson(response.getResponseBody(), JsonObject.class);
            SearchResponse.Builder searchResponse = SearchRequestBuilder.parseResponse(jsonResponse, null, null);
            return searchResponse.build();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

