/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ning.http.client.Response;
import de.mhus.lib.core.logging.Log;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.SortOrder;
import de.otto.flummi.aggregations.AggregationBuilder;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.query.sort.SortBuilder;
import de.otto.flummi.request.HttpRequestBuilder;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.response.AggregationResult;
import de.otto.flummi.response.ScrollingSearchHits;
import de.otto.flummi.response.SearchHit;
import de.otto.flummi.response.SearchResponse;
import de.otto.flummi.response.SimpleSearchHits;
import de.otto.flummi.util.HttpClientWrapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class SearchRequestBuilder
implements RequestBuilder<SearchResponse> {
    private static final JsonObject EMPTY_JSON_OBJECT = new JsonObject();
    private HttpClientWrapper httpClient;
    private final String[] indices;
    private final Gson gson;
    private String[] types;
    private JsonObject query;
    private Integer from;
    private Integer size;
    private Integer timeoutMillis;
    private JsonArray sorts;
    private JsonArray fields;
    private String scroll;
    private QueryBuilder postFilter;
    private List<AggregationBuilder> aggregations;
    private Boolean explain;
    public static final Log LOG = Log.getLog(SearchRequestBuilder.class);

    public SearchRequestBuilder(HttpClientWrapper httpClient, String ... indices) {
        this.httpClient = httpClient;
        this.indices = indices;
        this.gson = new Gson();
    }

    public SearchRequestBuilder setScroll(String scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequestBuilder setTypes(String ... types) {
        this.types = types;
        return this;
    }

    public SearchRequestBuilder setQuery(JsonObject query) {
        this.query = query;
        return this;
    }

    public SearchRequestBuilder addAggregation(AggregationBuilder aggregationBuilder) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<AggregationBuilder>();
        }
        this.aggregations.add(aggregationBuilder);
        return this;
    }

    public SearchRequestBuilder addSort(String key, SortOrder order) {
        if (this.sorts == null) {
            this.sorts = new JsonArray();
        }
        JsonObject element = new JsonObject();
        JsonObject orderObj = new JsonObject();
        element.add(key, orderObj);
        orderObj.add("order", new JsonPrimitive(order.toString()));
        this.sorts.add(element);
        return this;
    }

    public SearchRequestBuilder addSort(SortBuilder builder) {
        if (this.sorts == null) {
            this.sorts = new JsonArray();
        }
        this.sorts.add(builder.build());
        return this;
    }

    public SearchRequestBuilder setFrom(int from) {
        this.from = from;
        return this;
    }

    public SearchRequestBuilder setSize(int size) {
        this.size = size;
        return this;
    }

    public SearchRequestBuilder addField(String fieldName) {
        if (this.fields == null) {
            this.fields = new JsonArray();
        }
        if (fieldName != null) {
            this.fields.add(new JsonPrimitive(fieldName));
        }
        return this;
    }

    public SearchRequestBuilder setFields(String ... fieldNames) {
        this.fields = new JsonArray();
        for (String fieldName : fieldNames) {
            if (fieldName == null) continue;
            this.fields.add(new JsonPrimitive(fieldName));
        }
        return this;
    }

    public SearchRequestBuilder setTimeoutMillis(Integer timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    @Override
    public SearchResponse execute() {
        try {
            Response response;
            String url = RequestBuilderUtil.buildUrl(this.indices, this.types, "_search");
            JsonObject body = new JsonObject();
            if (this.query != null) {
                body.add("query", this.query);
            }
            if (this.fields != null) {
                body.add("fields", this.fields);
            }
            if (this.from != null) {
                body.add("from", new JsonPrimitive(this.from));
            }
            if (this.size != null) {
                body.add("size", new JsonPrimitive(this.size));
            }
            if (this.explain != null) {
                body.add("explain", new JsonPrimitive(this.explain));
            }
            if (this.sorts != null) {
                body.add("sort", this.sorts);
            }
            if (this.postFilter != null) {
                body.add("post_filter", this.postFilter.build());
            }
            if (this.aggregations != null) {
                JsonObject jsonObject = new JsonObject();
                this.aggregations.stream().forEach(a -> jsonObject.add(a.getName(), a.build()));
                body.add("aggregations", jsonObject);
            }
            HttpRequestBuilder boundRequestBuilder = this.httpClient.preparePost(url).setBodyEncoding("UTF-8");
            if (this.timeoutMillis != null) {
                boundRequestBuilder.setRequestTimeout(this.timeoutMillis);
            }
            if (this.scroll != null) {
                boundRequestBuilder.addQueryParam("scroll", this.scroll);
            }
            if ((response = (Response)boundRequestBuilder.setBody(this.gson.toJson(body)).execute().get()).getStatusCode() == 404) {
                return SearchResponse.emptyResponse();
            }
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            JsonObject jsonResponse = this.gson.fromJson(response.getResponseBody(), JsonObject.class);
            SearchResponse.Builder searchResponse = SearchRequestBuilder.parseResponse(jsonResponse, this.scroll, this.httpClient);
            JsonElement aggregationsJsonElement = jsonResponse.get("aggregations");
            if (aggregationsJsonElement != null) {
                JsonObject aggregationsJsonObject = aggregationsJsonElement.getAsJsonObject();
                this.aggregations.forEach(a -> {
                    JsonElement aggreagationElement = aggregationsJsonObject.get(a.getName());
                    if (aggreagationElement != null) {
                        AggregationResult aggregation = a.parseResponse(aggreagationElement.getAsJsonObject());
                        searchResponse.addAggregation(a.getName(), aggregation);
                    }
                });
            }
            return searchResponse.build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static SearchResponse.Builder parseResponse(JsonObject jsonObject, String scroll, HttpClientWrapper client) {
        SearchResponse.Builder searchResponse = SearchResponse.builder();
        searchResponse.setTookInMillis(jsonObject.get("took").getAsLong());
        JsonObject hits = jsonObject.get("hits").getAsJsonObject();
        long totalHits = hits.get("total").getAsLong();
        JsonElement max_score = hits.get("max_score");
        Float maxScore = max_score.isJsonPrimitive() ? Float.valueOf(max_score.getAsFloat()) : null;
        JsonElement scroll_id = jsonObject.get("_scroll_id");
        if (scroll_id != null) {
            searchResponse.setScrollId(scroll_id.getAsString());
        }
        JsonArray hitsArray = hits.get("hits").getAsJsonArray();
        ArrayList<SearchHit> searchHitsCurrentPage = new ArrayList<SearchHit>();
        for (JsonElement element : hitsArray) {
            JsonObject asJsonObject = element.getAsJsonObject();
            JsonElement scoreElem = asJsonObject.get("_score");
            Float score = scoreElem.isJsonNull() ? null : Float.valueOf(scoreElem.getAsFloat());
            String id = asJsonObject.get("_id").getAsString();
            String type = asJsonObject.get("_type").getAsString();
            String index = asJsonObject.get("_index").getAsString();
            JsonElement source = asJsonObject.get("_source");
            JsonElement hitFields = asJsonObject.get("fields");
            SearchHit hit = new SearchHit(id, source != null ? source.getAsJsonObject() : null, hitFields != null ? hitFields.getAsJsonObject() : EMPTY_JSON_OBJECT, score, type, index);
            searchHitsCurrentPage.add(hit);
        }
        if (scroll != null) {
            searchResponse.setHits(new ScrollingSearchHits(totalHits, maxScore, scroll_id.getAsString(), scroll, searchHitsCurrentPage, client));
        } else {
            searchResponse.setHits(new SimpleSearchHits(totalHits, maxScore, searchHitsCurrentPage));
        }
        return searchResponse;
    }

    public SearchRequestBuilder setPostFilter(QueryBuilder postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public Boolean isExplain() {
        return this.explain;
    }

    public SearchRequestBuilder setExplain(Boolean explain) {
        this.explain = explain;
        return this;
    }
}

