/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ning.http.client.Response;
import de.mhus.lib.core.logging.Log;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.HttpRequestBuilder;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.ExecutionException;

public class IndexRequestBuilder
implements RequestBuilder<Void> {
    private final Gson gson;
    private JsonPrimitive id;
    private String indexName;
    private String documentType;
    private JsonObject source;
    private String parent;
    public static final Log LOG = Log.getLog(IndexRequestBuilder.class);
    private HttpClientWrapper httpClient;

    public IndexRequestBuilder(HttpClientWrapper httpClient) {
        this.httpClient = httpClient;
        this.gson = new Gson();
    }

    public IndexRequestBuilder setId(String id) {
        this.id = new JsonPrimitive(id);
        return this;
    }

    public IndexRequestBuilder setId(int id) {
        this.id = new JsonPrimitive(id);
        return this;
    }

    public IndexRequestBuilder setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public IndexRequestBuilder setDocumentType(String documentType) {
        this.documentType = documentType;
        return this;
    }

    public IndexRequestBuilder setSource(JsonObject source) {
        this.source = source;
        return this;
    }

    public IndexRequestBuilder setParent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Void execute() {
        try {
            Response response;
            HttpRequestBuilder reqBuilder;
            String url;
            if (this.id != null) {
                url = RequestBuilderUtil.buildUrl(this.indexName, this.documentType, URLEncoder.encode(this.id.getAsString(), "UTF-8"));
                reqBuilder = this.httpClient.preparePut(url);
            } else {
                url = RequestBuilderUtil.buildUrl(this.indexName, this.documentType);
                reqBuilder = this.httpClient.preparePost(url);
            }
            if (this.parent != null) {
                reqBuilder.addQueryParam("parent", this.parent);
            }
            if ((response = (Response)reqBuilder.setBody(this.gson.toJson(this.source)).setBodyEncoding("UTF-8").execute().get()).getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

