/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionPoolPartitioning;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.NameResolver;
import com.ning.http.client.Param;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.uri.Uri;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class HttpRequestBuilder
extends MLog {
    private AsyncHttpClient.BoundRequestBuilder instance;

    public HttpRequestBuilder(AsyncHttpClient.BoundRequestBuilder boundRequestBuilder) {
        this.instance = boundRequestBuilder;
    }

    public int hashCode() {
        return this.instance.hashCode();
    }

    public boolean equals(Object obj) {
        return this.instance.equals(obj);
    }

    public String toString() {
        return this.instance.toString();
    }

    public <T> ListenableFuture<T> execute(AsyncHandler<T> handler) throws InterruptedException, ExecutionException {
        ListenableFuture ret = this.instance.execute(handler);
        if (this.log().isLevelEnabled(Log.LEVEL.DEBUG)) {
            this.log().d(new Object[]{"result", ret.get()});
        }
        return ret;
    }

    public ListenableFuture<Response> execute() throws InterruptedException, ExecutionException {
        ListenableFuture ret = this.instance.execute();
        if (this.log().isLevelEnabled(Log.LEVEL.DEBUG)) {
            try {
                Response resp = (Response)ret.get();
                if (resp.getStatusCode() != 200) {
                    this.log().d(new Object[]{"result", resp.getStatusCode(), resp.getStatusText()});
                } else {
                    this.log().d(new Object[]{"result", resp.getResponseBody()});
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    public HttpRequestBuilder addBodyPart(Part part) {
        this.instance.addBodyPart(part);
        return this;
    }

    public HttpRequestBuilder addCookie(Cookie cookie) {
        this.instance.addCookie(cookie);
        return this;
    }

    public HttpRequestBuilder addHeader(String name, String value) {
        this.instance.addHeader(name, value);
        return this;
    }

    public HttpRequestBuilder setUri(Uri uri) {
        this.instance.setUri(uri);
        return this;
    }

    public HttpRequestBuilder addFormParam(String key, String value) {
        this.instance.addFormParam(key, value);
        return this;
    }

    public HttpRequestBuilder setInetAddress(InetAddress address) {
        this.instance.setInetAddress(address);
        return this;
    }

    public HttpRequestBuilder setLocalInetAddress(InetAddress address) {
        this.instance.setLocalInetAddress(address);
        return this;
    }

    public HttpRequestBuilder addQueryParam(String name, String value) {
        this.instance.addQueryParam(name, value);
        return this;
    }

    public Request build() {
        return this.instance.build();
    }

    public HttpRequestBuilder setBody(byte[] data) {
        this.log().d(new Object[]{"request", data});
        this.instance.setBody(data);
        return this;
    }

    public HttpRequestBuilder setBody(InputStream stream) {
        this.log().d(new Object[]{"request is stream"});
        this.instance.setBody(stream);
        return this;
    }

    public HttpRequestBuilder setBody(String data) {
        this.log().d(new Object[]{"request", data});
        this.instance.setBody(data);
        return this;
    }

    public HttpRequestBuilder setHeader(String name, String value) {
        this.instance.setHeader(name, value);
        return this;
    }

    public HttpRequestBuilder setHeaders(FluentCaseInsensitiveStringsMap headers) {
        this.instance.setHeaders(headers);
        return this;
    }

    public HttpRequestBuilder setHeaders(Map<String, Collection<String>> headers) {
        this.instance.setHeaders(headers);
        return this;
    }

    public HttpRequestBuilder setFormParams(Map<String, List<String>> params) {
        this.instance.setFormParams(params);
        return this;
    }

    public HttpRequestBuilder setContentLength(int length) {
        this.instance.setContentLength(length);
        return this;
    }

    public HttpRequestBuilder setFormParams(List<Param> params) {
        this.instance.setFormParams(params);
        return this;
    }

    public HttpRequestBuilder setCookies(Collection<Cookie> cookies) {
        this.instance.setCookies(cookies);
        return this;
    }

    public HttpRequestBuilder setUrl(String url) {
        this.instance.setUrl(url);
        return this;
    }

    public HttpRequestBuilder setVirtualHost(String virtualHost) {
        this.instance.setVirtualHost(virtualHost);
        return this;
    }

    public HttpRequestBuilder addOrReplaceCookie(Cookie cookie) {
        this.instance.addOrReplaceCookie(cookie);
        return this;
    }

    public HttpRequestBuilder setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.instance.setSignatureCalculator(signatureCalculator);
        return this;
    }

    public void resetCookies() {
        this.instance.resetCookies();
    }

    public void resetQuery() {
        this.instance.resetQuery();
    }

    public void resetFormParams() {
        this.instance.resetFormParams();
    }

    public void resetNonMultipartData() {
        this.instance.resetNonMultipartData();
    }

    public void resetMultipartData() {
        this.instance.resetMultipartData();
    }

    public HttpRequestBuilder setBody(File file) {
        this.instance.setBody(file);
        return this;
    }

    public HttpRequestBuilder setBody(List<byte[]> data) {
        this.instance.setBody(data);
        return this;
    }

    public HttpRequestBuilder setBody(BodyGenerator bodyGenerator) {
        this.instance.setBody(bodyGenerator);
        return this;
    }

    public HttpRequestBuilder addQueryParams(List<Param> params) {
        this.instance.addQueryParams(params);
        return this;
    }

    public HttpRequestBuilder setQueryParams(Map<String, List<String>> map) {
        this.instance.setQueryParams(map);
        return this;
    }

    public HttpRequestBuilder setQueryParams(List<Param> params) {
        this.instance.setQueryParams(params);
        return this;
    }

    public HttpRequestBuilder setProxyServer(ProxyServer proxyServer) {
        this.instance.setProxyServer(proxyServer);
        return this;
    }

    public HttpRequestBuilder setRealm(Realm realm) {
        this.instance.setRealm(realm);
        return this;
    }

    public HttpRequestBuilder setFollowRedirects(boolean followRedirects) {
        this.instance.setFollowRedirects(followRedirects);
        return this;
    }

    public HttpRequestBuilder setRequestTimeout(int requestTimeout) {
        this.instance.setRequestTimeout(requestTimeout);
        return this;
    }

    public HttpRequestBuilder setRangeOffset(long rangeOffset) {
        this.instance.setRangeOffset(rangeOffset);
        return this;
    }

    public HttpRequestBuilder setMethod(String method) {
        this.instance.setMethod(method);
        return this;
    }

    public HttpRequestBuilder setBodyEncoding(String charset) {
        this.instance.setBodyEncoding(charset);
        return this;
    }

    public HttpRequestBuilder setConnectionPoolKeyStrategy(ConnectionPoolPartitioning connectionPoolKeyStrategy) {
        this.instance.setConnectionPoolKeyStrategy(connectionPoolKeyStrategy);
        return this;
    }

    public HttpRequestBuilder setNameResolver(NameResolver nameResolver) {
        this.instance.setNameResolver(nameResolver);
        return this;
    }
}

