/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ning.http.client.Response;
import de.mhus.lib.core.logging.Log;
import de.otto.flummi.ClusterHealthResponse;
import de.otto.flummi.ClusterHealthStatus;
import de.otto.flummi.InvalidElasticsearchResponseException;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.HttpRequestBuilder;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class ClusterHealthRequestBuilder
implements RequestBuilder<ClusterHealthResponse> {
    private final String[] indexNames;
    private final Gson gson;
    private boolean waitForYellowStatus;
    private Long timeout;
    public static final Log LOG = Log.getLog(ClusterHealthRequestBuilder.class);
    private HttpClientWrapper httpClient;

    public ClusterHealthRequestBuilder(HttpClientWrapper httpClient, String ... indexNames) {
        this.httpClient = httpClient;
        this.indexNames = indexNames;
        this.gson = new Gson();
    }

    public ClusterHealthRequestBuilder setWaitForYellowStatus() {
        this.waitForYellowStatus = true;
        return this;
    }

    @Override
    public ClusterHealthResponse execute() {
        try {
            Response response;
            StringBuilder url = new StringBuilder("/_cluster/health");
            if (this.indexNames != null) {
                url.append("/").append(String.join((CharSequence)",", this.indexNames));
            }
            HttpRequestBuilder requestBuilder = this.httpClient.prepareGet(url.toString());
            if (this.waitForYellowStatus) {
                requestBuilder.addQueryParam("wait_for_status", "yellow");
            }
            if (this.timeout != null) {
                requestBuilder.addQueryParam("timeout", this.timeout + "ms");
            }
            if ((response = (Response)requestBuilder.execute().get()).getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            JsonObject jsonResponse = this.gson.fromJson(response.getResponseBody(), JsonObject.class);
            if (jsonResponse.get("status") == null) {
                throw new InvalidElasticsearchResponseException("Missing response field: status");
            }
            if (jsonResponse.get("cluster_name") == null) {
                throw new InvalidElasticsearchResponseException("Missing response field: cluster_name");
            }
            if (jsonResponse.get("timed_out") == null) {
                throw new InvalidElasticsearchResponseException("Missing response field: timed_out");
            }
            ClusterHealthResponse clusterHealthResponse = new ClusterHealthResponse(ClusterHealthStatus.valueOf(jsonResponse.get("status").getAsString().toUpperCase()), jsonResponse.get("cluster_name").getAsString(), jsonResponse.get("timed_out").getAsBoolean());
            if (clusterHealthResponse.isTimedOut()) {
                throw new InvalidElasticsearchResponseException("Timed out waiting for yellow cluster status");
            }
            return clusterHealthResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ClusterHealthRequestBuilder setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }
}

