/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query.sort;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.SortOrder;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.query.sort.SortBuilder;
import de.otto.flummi.query.sort.SortMode;
import de.otto.flummi.request.GsonHelper;

public class FieldSortBuilder
implements SortBuilder {
    private final String fieldName;
    private SortOrder order;
    private SortMode sortMode;
    private QueryBuilder nestedFilter;
    private String nestedPath;

    public FieldSortBuilder(String fieldName) {
        this.fieldName = fieldName;
    }

    public FieldSortBuilder setOrder(SortOrder order) {
        this.order = order;
        return this;
    }

    public FieldSortBuilder setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
        return this;
    }

    public FieldSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        this.nestedFilter = nestedFilter;
        return this;
    }

    public FieldSortBuilder setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
        return this;
    }

    @Override
    public JsonObject build() {
        JsonObject sortObject = GsonHelper.object("order", this.order.toString(), "mode", this.sortMode.key());
        if (this.nestedFilter != null) {
            sortObject.add("nested_filter", this.nestedFilter.build());
        }
        if (this.nestedPath != null) {
            sortObject.add("nested_path", new JsonPrimitive(this.nestedPath));
        }
        return GsonHelper.object(this.fieldName, sortObject);
    }
}

