/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.query.QueryBuilder;

public class NumberRangeQueryBuilder
implements QueryBuilder {
    private boolean includeUpper;
    private Number to;
    private boolean includeLower;
    private Number from;
    private String fieldName;

    public NumberRangeQueryBuilder(String fieldName) {
        this.fieldName = fieldName;
    }

    public NumberRangeQueryBuilder lt(Number to) {
        this.includeUpper = false;
        this.to = to;
        return this;
    }

    public NumberRangeQueryBuilder lte(Number to) {
        this.includeUpper = true;
        this.to = to;
        return this;
    }

    public NumberRangeQueryBuilder gt(Number from) {
        this.includeLower = false;
        this.from = from;
        return this;
    }

    public NumberRangeQueryBuilder gte(Number from) {
        this.includeLower = true;
        this.from = from;
        return this;
    }

    @Override
    public JsonObject build() {
        if (this.from == null && this.to == null) {
            throw new RuntimeException("from and to fields are missing");
        }
        if (this.fieldName == null || this.fieldName.isEmpty()) {
            throw new RuntimeException("fieldName is missing");
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject rangeObject = new JsonObject();
        jsonObject.add("range", rangeObject);
        JsonObject rangeParameters = new JsonObject();
        rangeObject.add(this.fieldName, rangeParameters);
        if (this.to != null) {
            rangeParameters.add(this.includeUpper ? "lte" : "lt", new JsonPrimitive(this.to));
        }
        if (this.from != null) {
            rangeParameters.add(this.includeLower ? "gte" : "gt", new JsonPrimitive(this.from));
        }
        return jsonObject;
    }
}

