/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.query.FieldValueFactorBuilder;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.request.GsonHelper;

public class FunctionScoreQueryBuilder
implements QueryBuilder {
    private QueryBuilder innerQuery;
    private String scoreMode;
    private FieldValueFactorBuilder scoreFunction;

    public FunctionScoreQueryBuilder(QueryBuilder innerQuery) {
        this.innerQuery = innerQuery;
    }

    public FunctionScoreQueryBuilder add(FieldValueFactorBuilder scoreFunction) {
        this.scoreFunction = scoreFunction;
        return this;
    }

    public FunctionScoreQueryBuilder setScoreMode(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    @Override
    public JsonObject build() {
        JsonObject functionScore = new JsonObject();
        functionScore.add("query", this.innerQuery.build());
        if (this.scoreMode != null) {
            functionScore.add("score_mode", new JsonPrimitive(this.scoreMode));
        }
        if (this.scoreFunction != null) {
            JsonArray array = new JsonArray();
            array.add(this.scoreFunction.build());
            functionScore.add("functions", array);
        }
        JsonObject result = GsonHelper.object("function_score", functionScore);
        return result;
    }
}

