/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.query.QueryBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class DateRangeQueryBuilder
implements QueryBuilder {
    private boolean includeUpper;
    private OffsetDateTime toDateTime;
    private LocalDate toDate;
    private boolean includeLower;
    private OffsetDateTime fromDateTime;
    private LocalDate fromDate;
    private String fieldName;

    public DateRangeQueryBuilder(String fieldName) {
        this.fieldName = fieldName;
    }

    public DateRangeQueryBuilder lt(LocalDate to) {
        this.includeUpper = false;
        this.toDate = to;
        this.toDateTime = null;
        return this;
    }

    public DateRangeQueryBuilder lte(LocalDate to) {
        this.includeUpper = true;
        this.toDate = to;
        this.toDateTime = null;
        return this;
    }

    public DateRangeQueryBuilder gt(LocalDate from) {
        this.includeLower = false;
        this.fromDate = from;
        this.fromDateTime = null;
        return this;
    }

    public DateRangeQueryBuilder gte(LocalDate from) {
        this.includeLower = true;
        this.fromDate = from;
        this.fromDateTime = null;
        return this;
    }

    public DateRangeQueryBuilder lt(OffsetDateTime to) {
        this.includeUpper = false;
        this.toDateTime = to;
        this.toDate = null;
        return this;
    }

    public DateRangeQueryBuilder lte(OffsetDateTime to) {
        this.includeUpper = true;
        this.toDateTime = to;
        this.toDate = null;
        return this;
    }

    public DateRangeQueryBuilder gt(OffsetDateTime from) {
        this.includeLower = false;
        this.fromDateTime = from;
        this.fromDate = null;
        return this;
    }

    public DateRangeQueryBuilder gte(OffsetDateTime from) {
        this.includeLower = true;
        this.fromDateTime = from;
        this.fromDate = null;
        return this;
    }

    @Override
    public JsonObject build() {
        if (this.toDate == null && this.toDateTime == null && this.fromDate == null && this.fromDateTime == null) {
            throw new RuntimeException("from and to fields are missing");
        }
        if (this.fieldName == null || this.fieldName.isEmpty()) {
            throw new RuntimeException("fieldName is missing");
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject rangeObject = new JsonObject();
        jsonObject.add("range", rangeObject);
        JsonObject rangeParameters = new JsonObject();
        rangeObject.add(this.fieldName, rangeParameters);
        if (this.toDate != null) {
            rangeParameters.add(this.includeUpper ? "lte" : "lt", new JsonPrimitive(this.toDate.format(DateTimeFormatter.ISO_DATE)));
        }
        if (this.toDateTime != null) {
            rangeParameters.add(this.includeUpper ? "lte" : "lt", new JsonPrimitive(this.toDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        }
        if (this.fromDate != null) {
            rangeParameters.add(this.includeLower ? "gte" : "gt", new JsonPrimitive(this.fromDate.format(DateTimeFormatter.ISO_DATE)));
        }
        if (this.fromDateTime != null) {
            rangeParameters.add(this.includeLower ? "gte" : "gt", new JsonPrimitive(this.fromDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        }
        return jsonObject;
    }
}

