/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.otto.flummi.query.QueryBuilder;

public class BoolQueryBuilder
implements QueryBuilder {
    private JsonArray mustFilter = new JsonArray();
    private JsonArray mustNotFilter = new JsonArray();

    @Override
    public JsonObject build() {
        if (this.mustFilter.size() == 0 && this.mustNotFilter.size() == 0) {
            throw new RuntimeException("mustFilter and mustNotFilter are empty");
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject boolObject = new JsonObject();
        jsonObject.add("bool", boolObject);
        if (this.mustFilter.size() > 0) {
            if (this.mustFilter.size() == 1) {
                boolObject.add("must", this.mustFilter.get(0));
            } else {
                boolObject.add("must", this.mustFilter);
            }
        }
        if (this.mustNotFilter.size() > 0) {
            if (this.mustNotFilter.size() == 1) {
                boolObject.add("must_not", this.mustNotFilter.get(0));
            } else {
                boolObject.add("must_not", this.mustNotFilter);
            }
        }
        return jsonObject;
    }

    public boolean isEmpty() {
        return this.mustFilter.size() == 0 && this.mustNotFilter.size() == 0;
    }

    public BoolQueryBuilder must(JsonObject filter) {
        this.mustFilter.add(filter);
        return this;
    }

    public BoolQueryBuilder mustNot(JsonObject filter) {
        this.mustNotFilter.add(filter);
        return this;
    }

    public BoolQueryBuilder must(QueryBuilder queryBuilder) {
        this.must(queryBuilder.build());
        return this;
    }

    public void mustNot(QueryBuilder queryBuilder) {
        this.mustNot(queryBuilder.build());
    }
}

